/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.view;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.ScreenshotResultView;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001:\u0001=B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u00103\u001a\u000204H\u0007J\b\u00105\u001a\u000206H\u0007J\u000e\u00107\u001a\u0002062\u0006\u00108\u001a\u00020-J \u00109\u001a\u0002062\u0006\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020!H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\fR\u001c\u0010\u0010\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0003\u001a\u0004\b\u0012\u0010\fR\u001c\u0010\u0013\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0003\u001a\u0004\b\u0015\u0010\fR\u001c\u0010\u0016\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0003\u001a\u0004\b\u0018\u0010\fR\u001c\u0010\u0019\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0003\u001a\u0004\b\u001b\u0010\fR\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\u001a\u0010)\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u000e\u00102\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView;", "", "<init>", "()V", "myView", "Ljavax/swing/JPanel;", "getMyView", "()Ljavax/swing/JPanel;", "newImagePanel", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel;", "getNewImagePanel$annotations", "getNewImagePanel", "()Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel;", "diffImagePanel", "getDiffImagePanel$annotations", "getDiffImagePanel", "refImagePanel", "getRefImagePanel$annotations", "getRefImagePanel", "newImagePanelSingle", "getNewImagePanelSingle$annotations", "getNewImagePanelSingle", "diffImagePanelSingle", "getDiffImagePanelSingle$annotations", "getDiffImagePanelSingle", "refImagePanelSingle", "getRefImagePanelSingle$annotations", "getRefImagePanelSingle", "contentPanel", "tabBar", "tabGroup", "Ljavax/swing/ButtonGroup;", "newImagePath", "", "getNewImagePath", "()Ljava/lang/String;", "setNewImagePath", "(Ljava/lang/String;)V", "refImagePath", "getRefImagePath", "setRefImagePath", "diffImagePath", "getDiffImagePath", "setDiffImagePath", "testFailed", "", "getTestFailed", "()Z", "setTestFailed", "(Z)V", "areScrollbarsLinked", "getComponent", "Ljavax/swing/JComponent;", "updateView", "", "setScrollbarLinking", "link", "loadImageAsync", "filePath", "targetPanel", "placeholder", "ImageWithToolbarPanel", "intellij.android.testartifacts"})
@StabilityInferred(parameters=0)
public final class ScreenshotResultView {
    @NotNull
    private final JPanel myView = new JPanel(new BorderLayout());
    @NotNull
    private final ImageWithToolbarPanel newImagePanel = new ImageWithToolbarPanel("New", this, true);
    @NotNull
    private final ImageWithToolbarPanel diffImagePanel = new ImageWithToolbarPanel("Diff", this, true);
    @NotNull
    private final ImageWithToolbarPanel refImagePanel = new ImageWithToolbarPanel("Reference", this, true);
    @NotNull
    private final ImageWithToolbarPanel newImagePanelSingle = new ImageWithToolbarPanel("New", this, false);
    @NotNull
    private final ImageWithToolbarPanel diffImagePanelSingle = new ImageWithToolbarPanel("Diff", this, false);
    @NotNull
    private final ImageWithToolbarPanel refImagePanelSingle = new ImageWithToolbarPanel("Reference", this, false);
    @NotNull
    private final JPanel contentPanel = new JPanel(new CardLayout());
    @NotNull
    private final JPanel tabBar = new JPanel(new FlowLayout(1, 0, 0));
    @NotNull
    private final ButtonGroup tabGroup = new ButtonGroup();
    @NotNull
    private String newImagePath = "";
    @NotNull
    private String refImagePath = "";
    @NotNull
    private String diffImagePath = "";
    private boolean testFailed;
    private boolean areScrollbarsLinked;
    public static final int $stable = 8;

    public ScreenshotResultView() {
        OnePixelSplitter onePixelSplitter;
        OnePixelSplitter onePixelSplitter2;
        OnePixelSplitter $this$_init__u24lambda_u240 = onePixelSplitter2 = new OnePixelSplitter(false, 0.5f);
        boolean bl = false;
        $this$_init__u24lambda_u240.setFirstComponent((JComponent)this.diffImagePanel);
        $this$_init__u24lambda_u240.setSecondComponent((JComponent)this.refImagePanel);
        OnePixelSplitter rightSplit = onePixelSplitter2;
        OnePixelSplitter $this$_init__u24lambda_u241 = onePixelSplitter = new OnePixelSplitter(false, 0.33f);
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setFirstComponent((JComponent)this.newImagePanel);
        $this$_init__u24lambda_u241.setSecondComponent((JComponent)rightSplit);
        OnePixelSplitter mainSplit = onePixelSplitter;
        ScreenshotResultView._init_$addTab(this, "All", (JComponent)mainSplit);
        ScreenshotResultView._init_$addTab(this, "New", this.newImagePanelSingle);
        ScreenshotResultView._init_$addTab(this, "Diff", this.diffImagePanelSingle);
        ScreenshotResultView._init_$addTab(this, "Reference", this.refImagePanelSingle);
        Component[] componentArray = this.tabBar.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object object = ArraysKt.firstOrNull((Object[])componentArray);
        JToggleButton jToggleButton = object instanceof JToggleButton ? (JToggleButton)object : null;
        if (jToggleButton != null) {
            jToggleButton.setSelected(true);
        }
        this.myView.add((Component)this.contentPanel, "Center");
        this.myView.add((Component)this.tabBar, "South");
    }

    @NotNull
    public final JPanel getMyView() {
        return this.myView;
    }

    @NotNull
    public final ImageWithToolbarPanel getNewImagePanel() {
        return this.newImagePanel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getNewImagePanel$annotations() {
    }

    @NotNull
    public final ImageWithToolbarPanel getDiffImagePanel() {
        return this.diffImagePanel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDiffImagePanel$annotations() {
    }

    @NotNull
    public final ImageWithToolbarPanel getRefImagePanel() {
        return this.refImagePanel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getRefImagePanel$annotations() {
    }

    @NotNull
    public final ImageWithToolbarPanel getNewImagePanelSingle() {
        return this.newImagePanelSingle;
    }

    @VisibleForTesting
    public static /* synthetic */ void getNewImagePanelSingle$annotations() {
    }

    @NotNull
    public final ImageWithToolbarPanel getDiffImagePanelSingle() {
        return this.diffImagePanelSingle;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDiffImagePanelSingle$annotations() {
    }

    @NotNull
    public final ImageWithToolbarPanel getRefImagePanelSingle() {
        return this.refImagePanelSingle;
    }

    @VisibleForTesting
    public static /* synthetic */ void getRefImagePanelSingle$annotations() {
    }

    @NotNull
    public final String getNewImagePath() {
        return this.newImagePath;
    }

    public final void setNewImagePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.newImagePath = string;
    }

    @NotNull
    public final String getRefImagePath() {
        return this.refImagePath;
    }

    public final void setRefImagePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.refImagePath = string;
    }

    @NotNull
    public final String getDiffImagePath() {
        return this.diffImagePath;
    }

    public final void setDiffImagePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.diffImagePath = string;
    }

    public final boolean getTestFailed() {
        return this.testFailed;
    }

    public final void setTestFailed(boolean bl) {
        this.testFailed = bl;
    }

    @UiThread
    @NotNull
    public final JComponent getComponent() {
        return this.myView;
    }

    @UiThread
    public final void updateView() {
        this.loadImageAsync(this.newImagePath, this.newImagePanel, "No Preview Image");
        this.loadImageAsync(this.diffImagePath, this.diffImagePanel, "No Diff Image");
        this.loadImageAsync(this.refImagePath, this.refImagePanel, "No Reference Image");
        this.loadImageAsync(this.newImagePath, this.newImagePanelSingle, "No Preview Image");
        this.loadImageAsync(this.diffImagePath, this.diffImagePanelSingle, "No Diff Image");
        this.loadImageAsync(this.refImagePath, this.refImagePanelSingle, "No Reference Image");
        this.myView.revalidate();
        this.myView.repaint();
    }

    public final void setScrollbarLinking(boolean link2) {
        if (link2 == this.areScrollbarsLinked) {
            return;
        }
        this.areScrollbarsLinked = link2;
        if (link2) {
            this.diffImagePanel.linkScrollbars(this.newImagePanel);
            this.refImagePanel.linkScrollbars(this.newImagePanel);
        } else {
            this.diffImagePanel.unlinkScrollbars();
            this.refImagePanel.unlinkScrollbars();
        }
        this.newImagePanel.updateToolbar();
        this.diffImagePanel.updateToolbar();
        this.refImagePanel.updateToolbar();
    }

    private final void loadImageAsync(String filePath, ImageWithToolbarPanel targetPanel, String placeholder) {
        targetPanel.setPlaceholder(placeholder);
        AppExecutorUtil.getAppExecutorService().submit(() -> ScreenshotResultView.loadImageAsync$lambda$5(filePath, targetPanel));
    }

    private static final void addTab$lambda$3$lambda$2(CardLayout $cardLayout, ScreenshotResultView this$0, String $title, JToggleButton $this_apply, Border $selectedBorder, JBEmptyBorder $unselectedBorder, ItemEvent e) {
        if (e.getStateChange() == 1) {
            $cardLayout.show(this$0.contentPanel, $title);
            $this_apply.setFont($this_apply.getFont().deriveFont(1));
            $this_apply.setBorder($selectedBorder);
        } else if (e.getStateChange() == 2) {
            $this_apply.setFont($this_apply.getFont().deriveFont(0));
            $this_apply.setBorder((Border)$unselectedBorder);
        }
    }

    private static final void _init_$addTab(ScreenshotResultView this$0, String title2, JComponent component) {
        JToggleButton jToggleButton;
        LayoutManager layoutManager = this$0.contentPanel.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
        CardLayout cardLayout = (CardLayout)layoutManager;
        this$0.contentPanel.add((Component)component, title2);
        Border border = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Focus.focusColor(), (int)0, (int)0, (int)3, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"customLine(...)");
        Border selectedBorder = border;
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.emptyBottom((int)3);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"emptyBottom(...)");
        JBEmptyBorder unselectedBorder = jBEmptyBorder;
        JToggleButton $this$addTab_u24lambda_u243 = jToggleButton = new JToggleButton(title2);
        boolean bl = false;
        $this$addTab_u24lambda_u243.setFocusable(false);
        $this$addTab_u24lambda_u243.setContentAreaFilled(false);
        $this$addTab_u24lambda_u243.setBorder((Border)unselectedBorder);
        $this$addTab_u24lambda_u243.setFont($this$addTab_u24lambda_u243.getFont().deriveFont(0));
        $this$addTab_u24lambda_u243.addItemListener(arg_0 -> ScreenshotResultView.addTab$lambda$3$lambda$2(cardLayout, this$0, title2, $this$addTab_u24lambda_u243, selectedBorder, unselectedBorder, arg_0));
        JToggleButton tabButton = jToggleButton;
        this$0.tabGroup.add(tabButton);
        this$0.tabBar.add(tabButton);
    }

    private static final void loadImageAsync$lambda$5$lambda$4(ImageWithToolbarPanel $targetPanel, BufferedImage $image) {
        $targetPanel.setImage($image);
    }

    private static final void loadImageAsync$lambda$5(String $filePath, ImageWithToolbarPanel $targetPanel) {
        BufferedImage bufferedImage;
        try {
            File file = new File($filePath);
            bufferedImage = file.exists() ? ImageIO.read(file) : null;
        }
        catch (Exception e) {
            bufferedImage = null;
        }
        BufferedImage image = bufferedImage;
        UIUtil.invokeLaterIfNeeded(() -> ScreenshotResultView.loadImageAsync$lambda$5$lambda$4($targetPanel, image));
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000W\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011*\u0001\u000b\b\u0007\u0018\u0000 '2\u00020\u0001:\u0007'()*+,-B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0007J\u0012\u0010\u001f\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u0015H\u0007J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0000J\u0006\u0010#\u001a\u00020\u001dJ\u0006\u0010$\u001a\u00020\u001dJ\b\u0010%\u001a\u00020\u001dH\u0003J\b\u0010&\u001a\u00020\u001dH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel;", "Ljavax/swing/JPanel;", "title", "", "parentView", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView;", "showSyncPanAction", "", "<init>", "(Ljava/lang/String;Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView;Z)V", "imageLabel", "com/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel$imageLabel$1", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel$imageLabel$1;", "placeholderLabel", "Lcom/intellij/ui/components/JBLabel;", "scrollPane", "Ljavax/swing/JScrollPane;", "imageWrapperPanel", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "originalImage", "Ljava/awt/image/BufferedImage;", "currentScale", "", "isAutoFitting", "originalHorizontalModel", "Ljavax/swing/BoundedRangeModel;", "originalVerticalModel", "setPlaceholder", "", "text", "setImage", "image", "linkScrollbars", "other", "unlinkScrollbars", "updateToolbar", "fitToWidth", "updateImage", "Companion", "ZoomInAction", "ZoomOutAction", "OneToOneAction", "FitToWidthAction", "ToggleGridViewAction", "SynchronizedPanAction", "intellij.android.testartifacts"})
    @StabilityInferred(parameters=0)
    public static final class ImageWithToolbarPanel
    extends JPanel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ScreenshotResultView parentView;
        private final boolean showSyncPanAction;
        @NotNull
        private final imageLabel.1 imageLabel;
        @NotNull
        private final JBLabel placeholderLabel;
        @NotNull
        private final JScrollPane scrollPane;
        @NotNull
        private final JPanel imageWrapperPanel;
        @NotNull
        private final ActionToolbar toolbar;
        @Nullable
        private BufferedImage originalImage;
        private double currentScale;
        private boolean isAutoFitting;
        @NotNull
        private final BoundedRangeModel originalHorizontalModel;
        @NotNull
        private final BoundedRangeModel originalVerticalModel;
        public static final int $stable = 8;
        private static final double MIN_SCALE = 0.1;
        private static final double MAX_SCALE = 1.8;
        private static final double ZOOM_FACTOR = 1.2;
        private static final int SINGLE_TAB_MAX_IMAGE_WIDTH = 500;

        /*
         * WARNING - void declaration
         */
        public ImageWithToolbarPanel(@NotNull String title2, @NotNull ScreenshotResultView parentView, boolean showSyncPanAction) {
            void $this$_init__u24lambda_u243;
            DefaultActionGroup defaultActionGroup;
            void $this$placeholderLabel_u24lambda_u241;
            JBLabel $this$imageLabel_u24lambda_u240;
            JBLabel jBLabel;
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
            super(new BorderLayout(0, 4));
            this.parentView = parentView;
            this.showSyncPanAction = showSyncPanAction;
            JBLabel jBLabel2 = jBLabel = new JBLabel(this){
                private boolean gridVisible;
                final /* synthetic */ ImageWithToolbarPanel this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void setGridVisible(boolean visible) {
                    if (this.gridVisible != visible) {
                        this.gridVisible = visible;
                        this.repaint();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void paintComponent(Graphics g) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    super.paintComponent(g);
                    if (this.gridVisible && this.getIcon() != null) {
                        Graphics graphics = g.create();
                        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                        Graphics2D g2d = (Graphics2D)graphics;
                        try {
                            g2d.setColor(new Color(128, 128, 128, 128));
                            int gridSize = RangesKt.coerceAtLeast((int)((int)((double)20 * ImageWithToolbarPanel.access$getCurrentScale$p(this.this$0))), (int)1);
                            int iconX = (this.getWidth() - this.getIcon().getIconWidth()) / 2;
                            int iconY = (this.getHeight() - this.getIcon().getIconHeight()) / 2;
                            g2d.translate(iconX, iconY);
                            int n = this.getIcon().getIconWidth();
                            if (gridSize <= 0) {
                                throw new IllegalArgumentException("Step must be positive, was: " + gridSize + ".");
                            }
                            int x = 0;
                            int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)gridSize);
                            if (x <= n2) {
                                while (true) {
                                    g2d.drawLine(x, 0, x, this.getIcon().getIconHeight());
                                    if (x == n2) break;
                                    x += gridSize;
                                }
                            }
                            n = this.getIcon().getIconHeight();
                            if (gridSize <= 0) {
                                throw new IllegalArgumentException("Step must be positive, was: " + gridSize + ".");
                            }
                            int y = 0;
                            n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)gridSize);
                            if (y <= n2) {
                                while (true) {
                                    g2d.drawLine(0, y, this.getIcon().getIconWidth(), y);
                                    if (y != n2) {
                                        y += gridSize;
                                        continue;
                                    }
                                    break;
                                }
                            }
                        }
                        finally {
                            g2d.dispose();
                        }
                    }
                }
            };
            ImageWithToolbarPanel imageWithToolbarPanel = this;
            boolean bl = false;
            $this$imageLabel_u24lambda_u240.setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground()));
            imageWithToolbarPanel.imageLabel = jBLabel;
            $this$imageLabel_u24lambda_u240 = jBLabel = new JBLabel();
            imageWithToolbarPanel = this;
            boolean bl2 = false;
            $this$placeholderLabel_u24lambda_u241.setHorizontalAlignment(0);
            $this$placeholderLabel_u24lambda_u241.setVerticalAlignment(0);
            imageWithToolbarPanel.placeholderLabel = jBLabel;
            this.scrollPane = new JScrollPane();
            this.imageWrapperPanel = new JPanel(new GridBagLayout());
            this.currentScale = 1.0;
            BoundedRangeModel boundedRangeModel = this.scrollPane.getHorizontalScrollBar().getModel();
            Intrinsics.checkNotNullExpressionValue((Object)boundedRangeModel, (String)"getModel(...)");
            this.originalHorizontalModel = boundedRangeModel;
            BoundedRangeModel boundedRangeModel2 = this.scrollPane.getVerticalScrollBar().getModel();
            Intrinsics.checkNotNullExpressionValue((Object)boundedRangeModel2, (String)"getModel(...)");
            this.originalVerticalModel = boundedRangeModel2;
            this.setBorder(JBUI.Borders.empty((int)10));
            JPanel headerPanel2 = new JPanel(new BorderLayout(0, 4));
            JBLabel titleLabel = new JBLabel(title2, UIUtil.ComponentStyle.LARGE);
            titleLabel.setHorizontalAlignment(2);
            headerPanel2.add((Component)titleLabel, "North");
            DefaultActionGroup $this$_init__u24lambda_u242 = defaultActionGroup = new DefaultActionGroup();
            boolean bl3 = false;
            $this$_init__u24lambda_u242.add((AnAction)new ZoomInAction());
            $this$_init__u24lambda_u242.add((AnAction)new ZoomOutAction());
            $this$_init__u24lambda_u242.add((AnAction)new OneToOneAction());
            $this$_init__u24lambda_u242.add((AnAction)new FitToWidthAction());
            $this$_init__u24lambda_u242.addSeparator();
            $this$_init__u24lambda_u242.add((AnAction)new ToggleGridViewAction());
            if (this.showSyncPanAction) {
                $this$_init__u24lambda_u242.add((AnAction)new SynchronizedPanAction());
            }
            DefaultActionGroup actionGroup2 = defaultActionGroup;
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ScreenshotImageToolbar", (ActionGroup)actionGroup2, true);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
            $this$_init__u24lambda_u242 = defaultActionGroup = actionToolbar;
            imageWithToolbarPanel = this;
            boolean bl4 = false;
            $this$_init__u24lambda_u243.setTargetComponent((JComponent)this);
            imageWithToolbarPanel.toolbar = defaultActionGroup;
            JPanel toolbarWrapper = new JPanel(new FlowLayout(0, 0, 0));
            toolbarWrapper.add(this.toolbar.getComponent());
            headerPanel2.add((Component)toolbarWrapper, "Center");
            this.add((Component)headerPanel2, "North");
            this.imageWrapperPanel.setBackground(this.scrollPane.getViewport().getBackground());
            this.imageWrapperPanel.add((Component)((Object)this.imageLabel));
            this.add((Component)this.scrollPane, "Center");
            this.scrollPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (isAutoFitting) {
                        this.fitToWidth();
                    }
                }
            });
        }

        @UiThread
        public final void setPlaceholder(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.placeholderLabel.setText(text2);
        }

        @UiThread
        public final void setImage(@Nullable BufferedImage image) {
            this.originalImage = image;
            if (image == null) {
                this.imageLabel.setIcon(null);
                this.scrollPane.setViewportView((Component)this.placeholderLabel);
            } else {
                this.scrollPane.setViewportView(this.imageWrapperPanel);
                this.isAutoFitting = true;
                this.fitToWidth();
            }
            this.revalidate();
            this.repaint();
        }

        public final void linkScrollbars(@NotNull ImageWithToolbarPanel other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.scrollPane.getVerticalScrollBar().setModel(other.scrollPane.getVerticalScrollBar().getModel());
            this.scrollPane.getHorizontalScrollBar().setModel(other.scrollPane.getHorizontalScrollBar().getModel());
        }

        public final void unlinkScrollbars() {
            this.scrollPane.getVerticalScrollBar().setModel(this.originalVerticalModel);
            this.scrollPane.getHorizontalScrollBar().setModel(this.originalHorizontalModel);
        }

        public final void updateToolbar() {
            this.toolbar.updateActionsImmediately();
        }

        @UiThread
        private final void fitToWidth() {
            double d;
            BufferedImage bufferedImage = this.originalImage;
            if (bufferedImage == null) {
                return;
            }
            BufferedImage image = bufferedImage;
            Dimension viewSize = this.scrollPane.getViewport().getExtentSize();
            if (viewSize.width <= 0 || viewSize.height <= 0 || image.getWidth() <= 0) {
                return;
            }
            if (this.showSyncPanAction) {
                d = (double)viewSize.width / (double)image.getWidth();
            } else {
                int targetWidth = Math.min(viewSize.width, 500);
                d = Math.min(1.0, (double)targetWidth / (double)image.getWidth());
            }
            double scale = d;
            this.currentScale = RangesKt.coerceIn((double)scale, (double)0.1, (double)1.8);
            this.updateImage();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @UiThread
        private final void updateImage() {
            BufferedImage bufferedImage = this.originalImage;
            if (bufferedImage == null) {
                return;
            }
            BufferedImage image = bufferedImage;
            int newWidth = (int)((double)image.getWidth() * this.currentScale);
            int newHeight = (int)((double)image.getHeight() * this.currentScale);
            if (newWidth > 0 && newHeight > 0) {
                int imageType = image.getType() == 0 ? 2 : image.getType();
                BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, imageType);
                Graphics2D g2d = scaledImage.createGraphics();
                try {
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2d.drawImage(image, 0, 0, newWidth, newHeight, null);
                }
                finally {
                    g2d.dispose();
                }
                this.imageLabel.setIcon(new ImageIcon(scaledImage));
            }
            this.toolbar.updateActionsImmediately();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel$Companion;", "", "<init>", "()V", "MIN_SCALE", "", "MAX_SCALE", "ZOOM_FACTOR", "SINGLE_TAB_MAX_IMAGE_WIDTH", "", "intellij.android.testartifacts"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel$FitToWidthAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.testartifacts"})
        private final class FitToWidthAction
        extends AnAction {
            public FitToWidthAction() {
                super("Fit to Width", "Fit image to panel width", AllIcons.General.FitContent);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ImageWithToolbarPanel.this.isAutoFitting = true;
                ImageWithToolbarPanel.this.fitToWidth();
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(ImageWithToolbarPanel.this.originalImage != null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel$OneToOneAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.testartifacts"})
        private final class OneToOneAction
        extends AnAction {
            public OneToOneAction() {
                super("1:1", "Actual Size", AllIcons.General.ActualZoom);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ImageWithToolbarPanel.this.isAutoFitting = false;
                ImageWithToolbarPanel.this.currentScale = 1.0;
                ImageWithToolbarPanel.this.updateImage();
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(ImageWithToolbarPanel.this.originalImage != null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel$SynchronizedPanAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel;)V", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.android.testartifacts"})
        private final class SynchronizedPanAction
        extends ToggleAction {
            public SynchronizedPanAction() {
                super("Sync Pan", "Synchronize Scrolling", AllIcons.Actions.SyncPanels);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return ImageWithToolbarPanel.this.parentView.areScrollbarsLinked;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state2) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ImageWithToolbarPanel.this.parentView.setScrollbarLinking(state2);
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(ImageWithToolbarPanel.this.originalImage != null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel$ToggleGridViewAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel;)V", "selected", "", "isSelected", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.android.testartifacts"})
        private final class ToggleGridViewAction
        extends ToggleAction {
            private boolean selected;

            public ToggleGridViewAction() {
                super("Grid", "Toggle Grid Overlay", AllIcons.Graph.Grid);
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return this.selected;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state2) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.selected = state2;
                ImageWithToolbarPanel.this.imageLabel.setGridVisible(state2);
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(ImageWithToolbarPanel.this.originalImage != null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel$ZoomInAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.testartifacts"})
        private final class ZoomInAction
        extends AnAction {
            public ZoomInAction() {
                super("Zoom In", null, AllIcons.General.ZoomIn);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ImageWithToolbarPanel.this.isAutoFitting = false;
                ImageWithToolbarPanel.this.currentScale = RangesKt.coerceAtMost((double)(ImageWithToolbarPanel.this.currentScale * 1.2), (double)1.8);
                ImageWithToolbarPanel.this.updateImage();
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(ImageWithToolbarPanel.this.originalImage != null && ImageWithToolbarPanel.this.currentScale < 1.8);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel$ZoomOutAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/ScreenshotResultView$ImageWithToolbarPanel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.testartifacts"})
        private final class ZoomOutAction
        extends AnAction {
            public ZoomOutAction() {
                super("Zoom Out", null, AllIcons.General.ZoomOut);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ImageWithToolbarPanel.this.isAutoFitting = false;
                ImageWithToolbarPanel.this.currentScale = RangesKt.coerceAtLeast((double)(ImageWithToolbarPanel.this.currentScale / 1.2), (double)0.1);
                ImageWithToolbarPanel.this.updateImage();
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(ImageWithToolbarPanel.this.originalImage != null && ImageWithToolbarPanel.this.currentScale > 0.1);
            }
        }
    }
}

