/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.export;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultStats;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResults;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultsTreeNode;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDeviceKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuiteResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.benchmark.BenchmarkLine;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.TestStepRow;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.application.ApplicationNamesInfo;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u001a\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c*\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u000e*\u00020\u001fH\u0002J6\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u000e2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u001d2\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00120$H\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u0012H\u0002J\b\u0010(\u001a\u00020\u0012H\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/export/AndroidTestResultsXmlFormatter;", "", "executionDuration", "Ljava/time/Duration;", "rootResultsNode", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultsTreeNode;", "devices", "", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "resultHandler", "Lorg/xml/sax/ContentHandler;", "fileGenerationDateText", "", "<init>", "(Ljava/time/Duration;Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultsTreeNode;Ljava/util/List;Lcom/intellij/execution/configurations/RunConfiguration;Lorg/xml/sax/ContentHandler;Ljava/lang/String;)V", "execute", "", "addTestSuiteElementForDevice", "device", "addNodeAsTestSuite", "node", "addNodeAsTestCase", "addOutputElement", "type", "content", "toAttributes", "Lorg/xml/sax/Attributes;", "", "toXmlStatusCode", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCaseResult;", "addElement", "name", "attributeMap", "innerElements", "Lkotlin/Function0;", "element", "Lorg/jdom/Element;", "addRunConfigElement", "addAndroidTestMatrixElement", "getTestCaseNodesForAndroidTestMatrixExport", "isTestSuiteNode", "", "intellij.android.testartifacts"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAndroidTestResultsXmlFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTestResultsXmlFormatter.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/export/AndroidTestResultsXmlFormatter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,318:1\n1317#2,2:319\n1317#2,2:328\n1797#3,3:321\n1863#3,2:324\n1863#3,2:326\n1863#3,2:336\n1863#3,2:338\n1863#3,2:340\n216#4,2:330\n216#4,2:332\n216#4,2:334\n*S KotlinDebug\n*F\n+ 1 AndroidTestResultsXmlFormatter.kt\ncom/android/tools/idea/testartifacts/instrumented/testsuite/export/AndroidTestResultsXmlFormatter\n*L\n114#1:319,2\n134#1:328,2\n193#1:321,3\n199#1:324,2\n93#1:326,2\n242#1:336,2\n216#1:338,2\n228#1:340,2\n223#1:330,2\n287#1:332,2\n262#1:334,2\n*E\n"})
public final class AndroidTestResultsXmlFormatter {
    @NotNull
    private final Duration executionDuration;
    @NotNull
    private final AndroidTestResultsTreeNode rootResultsNode;
    @NotNull
    private final List<AndroidDevice> devices;
    @NotNull
    private final RunConfiguration runConfiguration;
    @NotNull
    private final ContentHandler resultHandler;
    @NotNull
    private final String fileGenerationDateText;
    public static final int $stable = 8;

    public AndroidTestResultsXmlFormatter(@NotNull Duration executionDuration, @NotNull AndroidTestResultsTreeNode rootResultsNode, @NotNull List<AndroidDevice> devices2, @NotNull RunConfiguration runConfiguration, @NotNull ContentHandler resultHandler, @NotNull String fileGenerationDateText) {
        Intrinsics.checkNotNullParameter((Object)executionDuration, (String)"executionDuration");
        Intrinsics.checkNotNullParameter((Object)rootResultsNode, (String)"rootResultsNode");
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)resultHandler, (String)"resultHandler");
        Intrinsics.checkNotNullParameter((Object)fileGenerationDateText, (String)"fileGenerationDateText");
        this.executionDuration = executionDuration;
        this.rootResultsNode = rootResultsNode;
        this.devices = devices2;
        this.runConfiguration = runConfiguration;
        this.resultHandler = resultHandler;
        this.fileGenerationDateText = fileGenerationDateText;
    }

    public /* synthetic */ AndroidTestResultsXmlFormatter(Duration duration, AndroidTestResultsTreeNode androidTestResultsTreeNode, List list, RunConfiguration runConfiguration, ContentHandler contentHandler, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            String string2 = new SimpleDateFormat("", Locale.US).format(new Date());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            string = string2;
        }
        this(duration, androidTestResultsTreeNode, list, runConfiguration, contentHandler, string);
    }

    public final void execute() {
        this.resultHandler.startDocument();
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"duration", (Object)String.valueOf(this.rootResultsNode.getResults().getTotalDuration().toMillis()));
        Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), this.fileGenerationDateText};
        pairArray[1] = TuplesKt.to((Object)"footerText", (Object)ExecutionBundle.message((String)"export.test.results.footer", (Object[])objectArray));
        pairArray[2] = TuplesKt.to((Object)"name", (Object)this.runConfiguration.getName());
        this.addElement("testrun", MapsKt.mapOf((Pair[])pairArray), (Function0<Unit>)((Function0)() -> AndroidTestResultsXmlFormatter.execute$lambda$2(this)));
        this.resultHandler.endDocument();
    }

    private final void addTestSuiteElementForDevice(AndroidDevice device2) {
        Sequence<AndroidTestResultsTreeNode> $this$forEach$iv = this.rootResultsNode.getChildResults();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidTestResultsTreeNode node = (AndroidTestResultsTreeNode)element$iv;
            boolean bl = false;
            if (this.isTestSuiteNode(node)) {
                this.addNodeAsTestSuite(node, device2);
                continue;
            }
            this.addNodeAsTestCase(node, device2);
        }
    }

    private final void addNodeAsTestSuite(AndroidTestResultsTreeNode node, AndroidDevice device2) {
        Duration duration = node.getResults().getDuration(device2);
        if (duration == null) {
            return;
        }
        long duration2 = duration.toMillis();
        Object object = node.getResults().getTestCaseResult(device2);
        if (object == null || (object = this.toXmlStatusCode((AndroidTestCaseResult)((Object)object))) == null) {
            return;
        }
        Object status2 = object;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)AndroidTestResultsKt.getFullTestClassName(node.getResults())), TuplesKt.to((Object)"duration", (Object)String.valueOf(duration2)), TuplesKt.to((Object)"status", (Object)status2)};
        this.addElement("suite", MapsKt.mapOf((Pair[])pairArray), (Function0<Unit>)((Function0)() -> AndroidTestResultsXmlFormatter.addNodeAsTestSuite$lambda$5(node, this, device2)));
    }

    private final void addNodeAsTestCase(AndroidTestResultsTreeNode node, AndroidDevice device2) {
        Duration duration = node.getResults().getDuration(device2);
        if (duration == null) {
            return;
        }
        long duration2 = duration.toMillis();
        Object object = node.getResults().getTestCaseResult(device2);
        if (object == null || (object = this.toXmlStatusCode((AndroidTestCaseResult)((Object)object))) == null) {
            return;
        }
        Object status2 = object;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)node.getResults().getMethodName()), TuplesKt.to((Object)"duration", (Object)String.valueOf(duration2)), TuplesKt.to((Object)"status", (Object)status2)};
        this.addElement("test", MapsKt.mapOf((Pair[])pairArray), (Function0<Unit>)((Function0)() -> AndroidTestResultsXmlFormatter.addNodeAsTestCase$lambda$7(this, node, device2)));
    }

    private final void addOutputElement(String type, String content2) {
        CharSequence charSequence = content2;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return;
        }
        this.addElement("output", MapsKt.mapOf((Pair)TuplesKt.to((Object)"type", (Object)type)), (Function0<Unit>)((Function0)() -> AndroidTestResultsXmlFormatter.addOutputElement$lambda$8(content2, this)));
    }

    private final Attributes toAttributes(Map<String, String> $this$toAttributes) {
        AttributesImpl attributes = new AttributesImpl();
        $this$toAttributes.forEach((arg_0, arg_1) -> AndroidTestResultsXmlFormatter.toAttributes$lambda$10((arg_0, arg_1) -> AndroidTestResultsXmlFormatter.toAttributes$lambda$9(attributes, arg_0, arg_1), arg_0, arg_1));
        return attributes;
    }

    private final String toXmlStatusCode(AndroidTestCaseResult $this$toXmlStatusCode) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toXmlStatusCode.ordinal()]) {
            case 1 -> "failed";
            case 2 -> "passed";
            case 3 -> "ignored";
            case 4 -> "skipped";
            case 5 -> "skipped";
            case 6 -> "skipped";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void addElement(String name2, Map<String, String> attributeMap, Function0<Unit> innerElements) {
        this.resultHandler.startElement("", name2, name2, this.toAttributes(attributeMap));
        innerElements.invoke();
        this.resultHandler.endElement("", name2, name2);
    }

    static /* synthetic */ void addElement$default(AndroidTestResultsXmlFormatter androidTestResultsXmlFormatter, String string, Map map2, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            function0 = AndroidTestResultsXmlFormatter::addElement$lambda$11;
        }
        androidTestResultsXmlFormatter.addElement(string, map2, (Function0<Unit>)function0);
    }

    /*
     * WARNING - void declaration
     */
    private final void addElement(Element element) {
        void $this$fold$iv;
        List list = element.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttributes(...)");
        Iterable iterable = list;
        AttributesImpl initial$iv = new AttributesImpl();
        boolean $i$f$fold = false;
        AttributesImpl accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void attr;
            AttributesImpl attributesImpl;
            Attribute attribute2 = (Attribute)element$iv;
            AttributesImpl acc = accumulator$iv;
            boolean bl = false;
            AttributesImpl $this$addElement_u24lambda_u2413_u24lambda_u2412 = attributesImpl = acc;
            boolean bl2 = false;
            $this$addElement_u24lambda_u2413_u24lambda_u2412.addAttribute("", attr.getName(), attr.getName(), "CDATA", attr.getValue());
            accumulator$iv = attributesImpl;
        }
        AttributesImpl attributes = accumulator$iv;
        this.resultHandler.startElement("", element.getName(), element.getName(), attributes);
        List list2 = element.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element p0 = (Element)element$iv;
            boolean bl = false;
            this.addElement(p0);
        }
        this.resultHandler.endElement("", element.getName(), element.getName());
    }

    /*
     * WARNING - void declaration
     */
    private final void addRunConfigElement() {
        void $this$addRunConfigElement_u24lambda_u2414;
        Element element;
        Element element2 = element = new Element("config");
        AndroidTestResultsXmlFormatter androidTestResultsXmlFormatter = this;
        boolean bl = false;
        this.runConfiguration.writeExternal((Element)$this$addRunConfigElement_u24lambda_u2414);
        $this$addRunConfigElement_u24lambda_u2414.setAttribute("configId", this.runConfiguration.getType().getId());
        $this$addRunConfigElement_u24lambda_u2414.setAttribute("name", this.runConfiguration.getName());
        androidTestResultsXmlFormatter.addElement(element);
    }

    private final void addAndroidTestMatrixElement() {
        this.addElement("androidTestMatrix", MapsKt.mapOf((Pair)TuplesKt.to((Object)"executionDuration", (Object)String.valueOf(this.executionDuration.toMillis()))), (Function0<Unit>)((Function0)() -> AndroidTestResultsXmlFormatter.addAndroidTestMatrixElement$lambda$26(this)));
    }

    private final List<AndroidTestResultsTreeNode> getTestCaseNodesForAndroidTestMatrixExport(AndroidDevice device2) {
        return SequencesKt.toList((Sequence)SequencesKt.flatMap(this.rootResultsNode.getChildResults(), arg_0 -> AndroidTestResultsXmlFormatter.getTestCaseNodesForAndroidTestMatrixExport$lambda$28(this, device2, arg_0)));
    }

    private final boolean isTestSuiteNode(AndroidTestResultsTreeNode node) {
        List childResults = SequencesKt.toList(node.getChildResults());
        return !((Collection)childResults).isEmpty() && !(((AndroidTestResultsTreeNode)CollectionsKt.first((List)childResults)).getResults() instanceof TestStepRow);
    }

    private static final Unit execute$lambda$2$lambda$1$lambda$0(AndroidTestResultsXmlFormatter this$0, AndroidDevice $device) {
        this$0.addTestSuiteElementForDevice($device);
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$2(AndroidTestResultsXmlFormatter this$0) {
        AndroidTestResultStats stats = this$0.rootResultsNode.getResults().getResultStats();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"total"), TuplesKt.to((Object)"value", (Object)String.valueOf(stats.getTotal()))};
        AndroidTestResultsXmlFormatter.addElement$default(this$0, "count", MapsKt.mapOf((Pair[])pairArray), null, 4, null);
        if (stats.getFailed() > 0) {
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"failed"), TuplesKt.to((Object)"value", (Object)String.valueOf(stats.getFailed()))};
            AndroidTestResultsXmlFormatter.addElement$default(this$0, "count", MapsKt.mapOf((Pair[])pairArray), null, 4, null);
        }
        if (stats.getSkipped() > 0) {
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"ignored"), TuplesKt.to((Object)"value", (Object)String.valueOf(stats.getSkipped()))};
            AndroidTestResultsXmlFormatter.addElement$default(this$0, "count", MapsKt.mapOf((Pair[])pairArray), null, 4, null);
        }
        if (stats.getCancelled() > 0) {
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"skipped"), TuplesKt.to((Object)"value", (Object)String.valueOf(stats.getCancelled()))};
            AndroidTestResultsXmlFormatter.addElement$default(this$0, "count", MapsKt.mapOf((Pair[])pairArray), null, 4, null);
        }
        if (stats.getPassed() > 0) {
            pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"passed"), TuplesKt.to((Object)"value", (Object)String.valueOf(stats.getPassed()))};
            AndroidTestResultsXmlFormatter.addElement$default(this$0, "count", MapsKt.mapOf((Pair[])pairArray), null, 4, null);
        }
        this$0.addRunConfigElement();
        if (this$0.devices.size() == 1) {
            this$0.addTestSuiteElementForDevice((AndroidDevice)CollectionsKt.first(this$0.devices));
        } else {
            Iterable $this$forEach$iv = this$0.devices;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AndroidDevice device2 = (AndroidDevice)element$iv;
                boolean bl = false;
                Duration duration = this$0.rootResultsNode.getResults().getDuration(device2);
                if (duration == null) {
                    continue;
                }
                long duration2 = duration.toMillis();
                Object object = this$0.rootResultsNode.getResults().getTestCaseResult(device2);
                if (object == null || (object = this$0.toXmlStatusCode((AndroidTestCaseResult)((Object)object))) == null) continue;
                Object status2 = object;
                Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"name", (Object)AndroidDeviceKt.getName(device2)), TuplesKt.to((Object)"duration", (Object)String.valueOf(duration2)), TuplesKt.to((Object)"status", (Object)status2)};
                this$0.addElement("suite", MapsKt.mapOf((Pair[])pairArray2), (Function0<Unit>)((Function0)() -> AndroidTestResultsXmlFormatter.execute$lambda$2$lambda$1$lambda$0(this$0, device2)));
            }
        }
        this$0.addAndroidTestMatrixElement();
        return Unit.INSTANCE;
    }

    private static final Unit addNodeAsTestSuite$lambda$5(AndroidTestResultsTreeNode $node, AndroidTestResultsXmlFormatter this$0, AndroidDevice $device) {
        Sequence<AndroidTestResultsTreeNode> $this$forEach$iv = $node.getChildResults();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidTestResultsTreeNode testCase = (AndroidTestResultsTreeNode)element$iv;
            boolean bl = false;
            this$0.addNodeAsTestCase(testCase, $device);
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence addNodeAsTestCase$lambda$7$lambda$6(BenchmarkLine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRawText();
    }

    private static final Unit addNodeAsTestCase$lambda$7(AndroidTestResultsXmlFormatter this$0, AndroidTestResultsTreeNode $node, AndroidDevice $device) {
        this$0.addOutputElement("stderr", $node.getResults().getErrorStackTrace($device));
        this$0.addOutputElement("stdout", CollectionsKt.joinToString$default((Iterable)$node.getResults().getBenchmark($device).getLines(), (CharSequence)"\n", null, null, (int)0, null, AndroidTestResultsXmlFormatter::addNodeAsTestCase$lambda$7$lambda$6, (int)30, null));
        this$0.addOutputElement("stdout", $node.getResults().getLogcat($device));
        return Unit.INSTANCE;
    }

    private static final Unit addOutputElement$lambda$8(String $content, AndroidTestResultsXmlFormatter this$0) {
        char[] cArray = $content.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] chars = cArray;
        this$0.resultHandler.characters(chars, 0, chars.length);
        return Unit.INSTANCE;
    }

    private static final Unit toAttributes$lambda$9(AttributesImpl $attributes, String key, String value2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        $attributes.addAttribute("", key, key, "CDATA", value2);
        return Unit.INSTANCE;
    }

    private static final void toAttributes$lambda$10(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Unit addElement$lambda$11() {
        return Unit.INSTANCE;
    }

    private static final Unit addAndroidTestMatrixElement$lambda$26$lambda$17$lambda$16(AndroidDevice $device, AndroidTestResultsXmlFormatter this$0) {
        Map<String, String> $this$forEach$iv = $device.getAdditionalInfo();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            String key = entry.getKey();
            String value2 = entry.getValue();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"key", (Object)key), TuplesKt.to((Object)"value", (Object)value2)};
            AndroidTestResultsXmlFormatter.addElement$default(this$0, "additionalInfo", MapsKt.mapOf((Pair[])pairArray), null, 4, null);
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence addAndroidTestMatrixElement$lambda$26$lambda$25$lambda$24$lambda$23$lambda$18(BenchmarkLine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it.getRawText());
    }

    private static final Unit addAndroidTestMatrixElement$lambda$26$lambda$25$lambda$24$lambda$23$lambda$22$lambda$21(AndroidTestResults $stepResults, AndroidDevice $device, AndroidTestResultsXmlFormatter this$0) {
        Map<String, String> $this$forEach$iv = ((TestStepRow)$stepResults).getAdditionalTestArtifacts($device);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            String key = entry.getKey();
            String value2 = entry.getValue();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"key", (Object)key), TuplesKt.to((Object)"value", (Object)value2)};
            AndroidTestResultsXmlFormatter.addElement$default(this$0, "additionalTestStepArtifact", MapsKt.mapOf((Pair[])pairArray), null, 4, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addAndroidTestMatrixElement$lambda$26$lambda$25$lambda$24$lambda$23$lambda$22(AndroidTestResults $testCase, AndroidDevice $device, AndroidTestResultsTreeNode $testCaseNode, AndroidTestResultsXmlFormatter this$0) {
        Pair[] pairArray;
        Map<String, String> $this$forEach$iv = $testCase.getAdditionalTestArtifacts($device);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            String key = entry.getKey();
            String value2 = entry.getValue();
            pairArray = new Pair[]{TuplesKt.to((Object)"key", (Object)key), TuplesKt.to((Object)"value", (Object)value2)};
            AndroidTestResultsXmlFormatter.addElement$default(this$0, "additionalTestCaseArtifact", MapsKt.mapOf((Pair[])pairArray), null, 4, null);
        }
        for (AndroidTestResultsTreeNode step2 : $testCaseNode.getChildResults()) {
            AndroidTestCaseResult result2;
            AndroidTestResults stepResults = step2.getResults();
            if (stepResults.getTestCaseResult($device) == null) continue;
            Long l = stepResults.getStartTime($device);
            long startTime = l != null ? l : 0L;
            Duration duration = stepResults.getDuration($device);
            long endTime = startTime + (duration != null ? duration.toMillis() : 0L);
            if (!(stepResults instanceof TestStepRow)) continue;
            pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)((TestStepRow)stepResults).getTestStep().getId()), TuplesKt.to((Object)"name", (Object)((TestStepRow)stepResults).getTestStep().getName()), TuplesKt.to((Object)"index", (Object)String.valueOf(((TestStepRow)stepResults).getTestStep().getIndex())), TuplesKt.to((Object)"result", (Object)result2.toString()), TuplesKt.to((Object)"logcat", (Object)((TestStepRow)stepResults).getLogcat($device)), TuplesKt.to((Object)"errorStackTrace", (Object)((TestStepRow)stepResults).getErrorStackTrace($device)), TuplesKt.to((Object)"startTimestampMillis", (Object)String.valueOf(startTime)), TuplesKt.to((Object)"endTimestampMillis", (Object)String.valueOf(endTime))};
            this$0.addElement("testStep", MapsKt.mapOf((Pair[])pairArray), (Function0<Unit>)((Function0)() -> AndroidTestResultsXmlFormatter.addAndroidTestMatrixElement$lambda$26$lambda$25$lambda$24$lambda$23$lambda$22$lambda$21(stepResults, $device, this$0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addAndroidTestMatrixElement$lambda$26$lambda$25$lambda$24(List $testCaseNodesForDevice, AndroidDevice $device, AndroidTestResultsXmlFormatter this$0) {
        Iterable $this$forEach$iv = $testCaseNodesForDevice;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidTestCaseResult result2;
            AndroidTestResultsTreeNode testCaseNode = (AndroidTestResultsTreeNode)element$iv;
            boolean bl = false;
            AndroidTestResults testCase = testCaseNode.getResults();
            if (testCase.getTestCaseResult($device) == null) continue;
            Long l = testCase.getStartTime($device);
            long startTime = l != null ? l : 0L;
            Duration duration = testCase.getDuration($device);
            long endTime = startTime + (duration != null ? duration.toMillis() : 0L);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)AndroidTestResultsKt.getFullTestCaseName(testCase)), TuplesKt.to((Object)"methodName", (Object)testCase.getMethodName()), TuplesKt.to((Object)"className", (Object)testCase.getClassName()), TuplesKt.to((Object)"packageName", (Object)testCase.getPackageName()), TuplesKt.to((Object)"result", (Object)result2.toString()), TuplesKt.to((Object)"logcat", (Object)testCase.getLogcat($device)), TuplesKt.to((Object)"errorStackTrace", (Object)testCase.getErrorStackTrace($device)), TuplesKt.to((Object)"startTimestampMillis", (Object)String.valueOf(startTime)), TuplesKt.to((Object)"endTimestampMillis", (Object)String.valueOf(endTime)), TuplesKt.to((Object)"benchmark", (Object)CollectionsKt.joinToString$default((Iterable)testCase.getBenchmark($device).getLines(), (CharSequence)"\n", null, null, (int)0, null, AndroidTestResultsXmlFormatter::addAndroidTestMatrixElement$lambda$26$lambda$25$lambda$24$lambda$23$lambda$18, (int)30, null))};
            this$0.addElement("testcase", MapsKt.mapOf((Pair[])pairArray), (Function0<Unit>)((Function0)() -> AndroidTestResultsXmlFormatter.addAndroidTestMatrixElement$lambda$26$lambda$25$lambda$24$lambda$23$lambda$22(testCase, $device, testCaseNode, this$0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addAndroidTestMatrixElement$lambda$26(AndroidTestResultsXmlFormatter this$0) {
        AndroidDevice device2;
        Iterable $this$forEach$iv = this$0.devices;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            device2 = (AndroidDevice)element$iv;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)device2.getId()), TuplesKt.to((Object)"deviceName", (Object)device2.getDeviceName()), TuplesKt.to((Object)"deviceType", (Object)device2.getDeviceType().toString()), TuplesKt.to((Object)"version", (Object)String.valueOf(device2.getVersion().getApiLevel()))};
            this$0.addElement("device", MapsKt.mapOf((Pair[])pairArray), (Function0<Unit>)((Function0)() -> AndroidTestResultsXmlFormatter.addAndroidTestMatrixElement$lambda$26$lambda$17$lambda$16(device2, this$0)));
        }
        $this$forEach$iv = this$0.devices;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            device2 = (AndroidDevice)element$iv;
            boolean bl = false;
            List<AndroidTestResultsTreeNode> testCaseNodesForDevice = this$0.getTestCaseNodesForAndroidTestMatrixExport(device2);
            AndroidTestCaseResult androidTestCaseResult = this$0.rootResultsNode.getResults().getTestCaseResult(device2);
            AndroidTestSuiteResult androidTestSuiteResult = switch (androidTestCaseResult == null ? -1 : WhenMappings.$EnumSwitchMapping$0[androidTestCaseResult.ordinal()]) {
                case -1 -> null;
                case 1 -> AndroidTestSuiteResult.FAILED;
                case 5 -> AndroidTestSuiteResult.CANCELLED;
                default -> AndroidTestSuiteResult.PASSED;
            };
            if (androidTestSuiteResult == null) continue;
            AndroidTestSuiteResult testSuiteResult = androidTestSuiteResult;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"deviceId", (Object)device2.getId()), TuplesKt.to((Object)"testCount", (Object)String.valueOf(testCaseNodesForDevice.size())), TuplesKt.to((Object)"result", (Object)testSuiteResult.toString())};
            this$0.addElement("testsuite", MapsKt.mapOf((Pair[])pairArray), (Function0<Unit>)((Function0)() -> AndroidTestResultsXmlFormatter.addAndroidTestMatrixElement$lambda$26$lambda$25$lambda$24(testCaseNodesForDevice, device2, this$0)));
        }
        return Unit.INSTANCE;
    }

    private static final boolean getTestCaseNodesForAndroidTestMatrixExport$lambda$28$lambda$27(AndroidDevice $device, AndroidTestResultsTreeNode testCases) {
        Intrinsics.checkNotNullParameter((Object)testCases, (String)"testCases");
        AndroidTestCaseResult androidTestCaseResult = testCases.getResults().getTestCaseResult($device);
        return androidTestCaseResult != null ? androidTestCaseResult.isTerminalState() : false;
    }

    private static final Sequence getTestCaseNodesForAndroidTestMatrixExport$lambda$28(AndroidTestResultsXmlFormatter this$0, AndroidDevice $device, AndroidTestResultsTreeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this$0.isTestSuiteNode(node)) {
            return SequencesKt.filter(node.getChildResults(), arg_0 -> AndroidTestResultsXmlFormatter.getTestCaseNodesForAndroidTestMatrixExport$lambda$28$lambda$27($device, arg_0));
        }
        return CollectionsKt.asSequence((Iterable)CollectionsKt.listOf((Object)node));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidTestCaseResult.values().length];
            try {
                nArray[AndroidTestCaseResult.FAILED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestCaseResult.PASSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestCaseResult.SKIPPED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestCaseResult.IN_PROGRESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestCaseResult.CANCELLED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidTestCaseResult.SCHEDULED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

