/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.android.tools.idea.execution.common.AndroidConfigurationExecutor;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.TestExecutionOption;
import com.android.tools.idea.model.TestOptions;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidRunConfigurationEditor;
import com.android.tools.idea.run.editor.AndroidTestExtraParam;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.TestRunParameters;
import com.android.tools.idea.testartifacts.instrumented.AndroidRunConfigurationToken;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfigurationExecutor;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationQuickFix;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.SlowOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Icon;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.android.dom.manifest.Instrumentation;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestRunConfiguration
extends AndroidRunConfigurationBase
implements RefactoringListenerProvider {
    public static final int CURRENT_SCHEMA_VERSION = 1;
    public int ANDROID_TEST_RUN_CONFIGURATION_SCHEMA_VERSION = 1;
    public static final int TEST_ALL_IN_MODULE = 0;
    public static final int TEST_ALL_IN_PACKAGE = 1;
    public static final int TEST_CLASS = 2;
    public static final int TEST_METHOD = 3;
    public static final String DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS = "android.test.InstrumentationTestRunner";
    public int TESTING_TYPE = 0;
    @NotNull
    public String METHOD_NAME = "";
    @NotNull
    public String CLASS_NAME = "";
    @NotNull
    public String PACKAGE_NAME = "";
    @NotNull
    public String TEST_NAME_REGEX = "";
    @NotNull
    public String INSTRUMENTATION_RUNNER_CLASS = "";
    @NotNull
    public String EXTRA_OPTIONS = "";

    public AndroidTestRunConfiguration(Project project, ConfigurationFactory factory2) {
        super(project, factory2, true);
    }

    @Override
    @NotNull
    public List<DeployTargetProvider> getApplicableDeployTargetProviders() {
        return this.getDeployTargetContext().getApplicableDeployTargetProviders(true);
    }

    @Override
    protected AndroidConfigurationExecutor getExecutor(ExecutionEnvironment env, AndroidFacet facet, DeviceFutures deviceFutures) throws ExecutionException {
        return new AndroidTestRunConfigurationExecutor(env, deviceFutures);
    }

    @Override
    protected Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet facet) {
        if (!AndroidModel.isRequired(facet)) {
            return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
        }
        AndroidModel androidModel = AndroidModel.get(facet);
        if (androidModel == null) {
            return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
        }
        return new Pair((Object)Boolean.TRUE, null);
    }

    public boolean isGeneratedName() {
        return Objects.equals(this.getName(), this.suggestedName());
    }

    public String suggestedName() {
        if (this.TESTING_TYPE == 1) {
            return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{this.PACKAGE_NAME});
        }
        if (this.TESTING_TYPE == 2) {
            return JavaExecutionUtil.getShortClassName((String)this.CLASS_NAME);
        }
        if (this.TESTING_TYPE == 3) {
            return this.METHOD_NAME + "()";
        }
        if (this.TESTING_TYPE == 0 && StringUtil.isNotEmpty((String)this.TEST_NAME_REGEX)) {
            if (StringUtil.isNotEmpty((String)this.METHOD_NAME)) {
                return this.METHOD_NAME + "()";
            }
            return this.TEST_NAME_REGEX;
        }
        return TestRunnerBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet) {
        int count;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Module module = facet.getModule();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        switch (this.TESTING_TYPE) {
            case 1: {
                PsiPackage testPackage = facade.findPackage(this.PACKAGE_NAME);
                if (testPackage != null) break;
                errors.add(ValidationError.warning(JUnitBundle.message((String)"package.does.not.exist.error.message", (Object[])new Object[]{this.PACKAGE_NAME})));
                break;
            }
            case 2: {
                PsiClass testClass = null;
                try {
                    testClass = ((AndroidRunConfigurationModule)this.getConfigurationModule()).checkModuleAndClassName(this.CLASS_NAME, JUnitBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
                }
                catch (RuntimeConfigurationException e) {
                    errors.add(ValidationError.fromException(e));
                }
                if (testClass == null || JUnitUtil.isTestClass((PsiClass)testClass)) break;
                errors.add(ValidationError.warning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{this.CLASS_NAME})));
                break;
            }
            case 3: {
                AccessToken ignore = SlowOperations.knownIssue((String)"b/391098349");
                try {
                    errors.addAll(this.checkTestMethod());
                    if (ignore == null) break;
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore.close();
                break;
            }
        }
        AndroidFacetConfiguration configuration2 = (AndroidFacetConfiguration)facet.getConfiguration();
        if (!AndroidModel.isRequired(facet) && !configuration2.getState().PACK_TEST_CODE && (count = AndroidTestRunConfiguration.getTestSourceRootCount(module)) > 0) {
            String shortMessage = "Test code not included into APK";
            String fixMessage = "Code and resources under test source " + (count > 1 ? "roots" : "root") + " aren't included into debug APK.\nWould you like to include them and recompile " + module.getName() + " module?\n(You may change this option in Android facet settings later)";
            ConfigurationQuickFix quickFix = dataContext -> {
                int result2 = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)fixMessage, (String)"Test code not included into APK", (Icon)Messages.getQuestionIcon());
                if (result2 == 0) {
                    configuration2.getState().PACK_TEST_CODE = true;
                }
            };
            errors.add(ValidationError.fatal("Test code not included into APK", quickFix));
        }
        return errors;
    }

    private List<ValidationError> checkTestMethod() {
        Module moduleForAndroidTest;
        PsiClass testClass;
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            testClass = configurationModule.checkModuleAndClassName(this.CLASS_NAME, JUnitBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
            Module module = configurationModule.getModule();
            if (module == null) {
                throw new IllegalStateException("Test module not specified and not caught in checkModuleAndClassName");
            }
            Module androidTestModule = AndroidRunConfigurationToken.getModuleForAndroidTestRunConfiguration(module);
            if (androidTestModule == null) {
                String name2 = module.getName();
                throw new RuntimeConfigurationException("Cannot find android tests for module '" + name2 + "'");
            }
            moduleForAndroidTest = androidTestModule;
        }
        catch (RuntimeConfigurationException e) {
            return ImmutableList.of((Object)ValidationError.fromException(e));
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (!JUnitUtil.isTestClass((PsiClass)testClass)) {
            errors.add(ValidationError.warning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{this.CLASS_NAME})));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.METHOD_NAME)) {
            errors.add(ValidationError.fatal(JUnitBundle.message((String)"method.name.not.specified.error.message", (Object[])new Object[0])));
        }
        JUnitUtil.TestMethodFilter filter2 = new JUnitUtil.TestMethodFilter(testClass);
        boolean found = false;
        boolean testAnnotated = false;
        for (PsiMethod method2 : testClass.findMethodsByName(this.METHOD_NAME, true)) {
            if (filter2.value(method2)) {
                found = true;
            }
            if (!JUnitUtil.isTestAnnotated((PsiMethod)method2)) continue;
            testAnnotated = true;
        }
        if (!found) {
            errors.add(ValidationError.warning(JUnitBundle.message((String)"test.method.doesnt.exist.error.message", (Object[])new Object[]{this.METHOD_NAME})));
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)testClass, (String)"org.junit.runner.RunWith", (int)1) && !testAnnotated) {
            try {
                PsiClass testCaseClass = JUnitUtil.getTestCaseClass((Module)moduleForAndroidTest);
                if (!testClass.isInheritor(testCaseClass, true)) {
                    errors.add(ValidationError.fatal(JUnitBundle.message((String)"class.isnt.inheritor.of.testcase.error.message", (Object[])new Object[]{this.CLASS_NAME})));
                }
            }
            catch (JUnitUtil.NoJUnitException e) {
                errors.add(ValidationError.warning(ExecutionBundle.message((String)AndroidBundle.message("cannot.find.testcase.error", new Object[0]), (Object[])new Object[0])));
            }
        }
        return errors;
    }

    public Module @NotNull [] getModules() {
        Module module = ((AndroidRunConfigurationModule)this.getConfigurationModule()).getAndroidTestModule();
        return new Module[]{module};
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new AndroidRunConfigurationEditor<AndroidTestRunConfiguration>(this.getProject(), (Predicate<Module>)((Predicate)module -> {
            if (module == null) {
                return false;
            }
            AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module);
            return moduleSystem.isValidForAndroidTestRunConfiguration();
        }), this, false, true, moduleSelector2 -> new TestRunParameters(this.getProject(), (ConfigurationModuleSelector)moduleSelector2));
    }

    @Override
    public void readExternal(@NotNull Element element) {
        super.readExternal(element);
        boolean schemaVersionAbsent = element.getChildren("option").stream().noneMatch(it -> "ANDROID_TEST_RUN_CONFIGURATION_SCHEMA_VERSION".equals(it.getAttributeValue("name")));
        if (schemaVersionAbsent) {
            this.ANDROID_TEST_RUN_CONFIGURATION_SCHEMA_VERSION = 0;
        }
        if (this.ANDROID_TEST_RUN_CONFIGURATION_SCHEMA_VERSION < 1) {
            String moduleName = ((AndroidRunConfigurationModule)this.getConfigurationModule()).getModuleName();
            if (moduleName.endsWith(".main")) {
                this.setModuleName(moduleName.substring(0, moduleName.length() - ".main".length()));
            } else if (moduleName.endsWith(".androidTest")) {
                this.setModuleName(moduleName.substring(0, moduleName.length() - ".androidTest".length()));
            }
        }
    }

    @NotNull
    public String getExtraInstrumentationOptions(@Nullable AndroidFacet facet) {
        List extraParams = SequencesKt.toList(AndroidTestExtraParam.parseFromString(this.EXTRA_OPTIONS));
        return extraParams.stream().map(param -> "-e " + param.getNAME() + " " + param.getVALUE()).collect(Collectors.joining(" "));
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (element instanceof PsiPackage) {
            String pkgName = ((PsiPackage)element).getQualifiedName();
            if (this.TESTING_TYPE == 1 && !Objects.equals(pkgName, this.PACKAGE_NAME)) {
                return null;
            }
            if (this.TESTING_TYPE != 1 && !Objects.equals(pkgName, StringUtil.getPackageName((String)this.CLASS_NAME))) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement instanceof PsiPackage) {
                        String newPkgName = ((PsiPackage)newElement).getQualifiedName();
                        if (AndroidTestRunConfiguration.this.TESTING_TYPE == 1) {
                            AndroidTestRunConfiguration.this.PACKAGE_NAME = newPkgName;
                        } else {
                            AndroidTestRunConfiguration.this.CLASS_NAME = AndroidTestRunConfiguration.this.CLASS_NAME.replace(StringUtil.getPackageName((String)AndroidTestRunConfiguration.this.CLASS_NAME), newPkgName);
                        }
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement instanceof PsiPackage) {
                        if (AndroidTestRunConfiguration.this.TESTING_TYPE == 1) {
                            AndroidTestRunConfiguration.this.PACKAGE_NAME = oldQualifiedName;
                        } else {
                            AndroidTestRunConfiguration.this.CLASS_NAME = AndroidTestRunConfiguration.this.CLASS_NAME.replace(StringUtil.getPackageName((String)AndroidTestRunConfiguration.this.CLASS_NAME), oldQualifiedName);
                        }
                    }
                }
            };
        }
        if ((this.TESTING_TYPE == 2 || this.TESTING_TYPE == 3) && element instanceof PsiClass) {
            if (!StringUtil.equals((CharSequence)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)element)), (CharSequence)this.CLASS_NAME)) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement instanceof PsiClass) {
                        AndroidTestRunConfiguration.this.CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)newElement));
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement instanceof PsiClass) {
                        AndroidTestRunConfiguration.this.CLASS_NAME = oldQualifiedName;
                    }
                }
            };
        }
        if (this.TESTING_TYPE == 3 && element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            if (!StringUtil.equals((CharSequence)psiMethod.getName(), (CharSequence)this.METHOD_NAME)) {
                return null;
            }
            PsiClass psiClass = psiMethod.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            String fqName = psiClass.getQualifiedName();
            if (fqName != null && !StringUtil.equals((CharSequence)fqName, (CharSequence)this.CLASS_NAME)) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement instanceof PsiMethod) {
                        AndroidTestRunConfiguration.this.METHOD_NAME = ((PsiMethod)newElement).getName();
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement instanceof PsiMethod) {
                        AndroidTestRunConfiguration.this.METHOD_NAME = oldQualifiedName;
                    }
                }
            };
        }
        return null;
    }

    public TestExecutionOption getTestExecutionOption(@Nullable AndroidFacet facet) {
        return Optional.ofNullable(facet).map(AndroidModel::get).map(AndroidModel::getTestOptions).map(TestOptions::getExecutionOption).orElse(TestExecutionOption.HOST);
    }

    private static int getTestSourceRootCount(@NotNull Module module) {
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        return manager.getSourceRoots(true).length - manager.getSourceRoots(false).length;
    }

    @NotNull
    public static String getDefaultInstrumentationRunner(@Nullable AndroidFacet facet) {
        if (facet == null) {
            return DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS;
        }
        AndroidModel androidModel = AndroidModel.get(facet);
        if (androidModel != null) {
            String runner2 = androidModel.getTestOptions().getInstrumentationRunner();
            if (StringUtil.isEmptyOrSpaces((String)runner2)) {
                return DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS;
            }
            return runner2;
        }
        return (String)DumbService.getInstance((Project)facet.getModule().getProject()).runReadActionInSmartMode(() -> {
            Manifest manifest = Manifest.getMainManifest(facet);
            if (manifest == null) {
                return DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS;
            }
            for (Instrumentation instrumentation : manifest.getInstrumentations()) {
                PsiClass instrumentationClass;
                if (instrumentation == null || (instrumentationClass = (PsiClass)instrumentation.getInstrumentationClass().getValue()) == null) continue;
                return instrumentationClass.getQualifiedName();
            }
            return DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS;
        });
    }
}

