/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.configuration.execution.ExecutionUtils;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.ui.ConsoleView;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AndroidTestListener
implements ITestRunListener {
    private static final String DISPLAY_PREFIX = "android.studio.display.";
    @NotNull
    private final ConsoleView myConsole;
    private long myTestStartingTime;
    private long myTestSuiteStartingTime;
    private String myTestClassName = null;

    public AndroidTestListener(@NotNull ConsoleView consoleView) {
        this.myConsole = consoleView;
    }

    public void testRunStopped(long elapsedTime) {
        ExecutionUtils.printlnError(this.myConsole, "Test run stopped.\n");
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        if (this.myTestClassName != null) {
            this.testSuiteFinished();
        }
        ExecutionUtils.println(this.myConsole, "Tests ran to completion.");
    }

    public void testRunFailed(String errorMessage) {
        ExecutionUtils.printlnError(this.myConsole, "Test running failed: " + errorMessage);
    }

    public void testRunStarted(String runName, int testCount) {
        ExecutionUtils.println(this.myConsole, "Started running tests");
        ServiceMessageBuilder builder = new ServiceMessageBuilder("enteredTheMatrix");
        ExecutionUtils.println(this.myConsole, builder.toString());
    }

    public void testStarted(TestIdentifier test) {
        if (!Objects.equals(test.getClassName(), this.myTestClassName)) {
            if (this.myTestClassName != null) {
                this.testSuiteFinished();
            }
            this.myTestClassName = test.getClassName();
            this.testSuiteStarted();
        }
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testStarted");
        builder.addAttribute("name", test.getTestName());
        builder.addAttribute("locationHint", "android://" + test.getClassName() + "." + test.getTestName() + "()");
        ExecutionUtils.println(this.myConsole, builder.toString());
        this.myTestStartingTime = System.currentTimeMillis();
    }

    private void testSuiteStarted() {
        this.myTestSuiteStartingTime = System.currentTimeMillis();
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testSuiteStarted");
        builder.addAttribute("name", this.myTestClassName);
        builder.addAttribute("locationHint", "android://" + this.myTestClassName);
        ExecutionUtils.println(this.myConsole, builder.toString());
    }

    private void testSuiteFinished() {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testSuiteFinished");
        builder.addAttribute("name", this.myTestClassName);
        builder.addAttribute("duration", Long.toString(System.currentTimeMillis() - this.myTestSuiteStartingTime));
        ExecutionUtils.println(this.myConsole, builder.toString());
        this.myTestClassName = null;
    }

    public void testFailed(TestIdentifier test, String stackTrace) {
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testFailed");
        builder.addAttribute("name", test.getTestName());
        builder.addAttribute("message", "");
        builder.addAttribute("details", stackTrace);
        builder.addAttribute("error", "true");
        ExecutionUtils.println(this.myConsole, builder.toString());
    }

    public void testAssumptionFailure(TestIdentifier test, String trace) {
        ServiceMessageBuilder builder = ServiceMessageBuilder.testIgnored((String)test.getTestName());
        builder.addAttribute("message", "Test ignored. Assumption Failed:");
        builder.addAttribute("details", trace);
        ExecutionUtils.println(this.myConsole, builder.toString());
    }

    public void testIgnored(TestIdentifier test) {
        ServiceMessageBuilder builder = ServiceMessageBuilder.testIgnored((String)test.getTestName());
        ExecutionUtils.println(this.myConsole, builder.toString());
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        if (((Boolean)StudioFlags.PRINT_INSTRUMENTATION_STATUS.get()).booleanValue()) {
            for (Map.Entry<String, String> entry : testMetrics.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(DISPLAY_PREFIX)) continue;
                ExecutionUtils.println(this.myConsole, key.substring(DISPLAY_PREFIX.length()) + ": " + entry.getValue());
            }
        }
        ServiceMessageBuilder builder = new ServiceMessageBuilder("testFinished");
        builder.addAttribute("name", test.getTestName());
        builder.addAttribute("duration", Long.toString(System.currentTimeMillis() - this.myTestStartingTime));
        ExecutionUtils.println(this.myConsole, builder.toString());
    }
}

