/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a&\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e\u001a>\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u001a2\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\u001aH\u0002\u001a\u0018\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "MERGE_ATTR_STRATEGY", "", "MERGE_ATTR_STRATEGY_REPLACE", "MERGE_ATTR_STRATEGY_PRESERVE", "mergeXml", "context", "Lcom/android/tools/idea/templates/recipe/RenderingContext;", "sourceXml", "targetXml", "targetFile", "Ljava/io/File;", "mergeResourceFile", "project", "Lcom/intellij/openapi/project/Project;", "warningsToAdd", "", "fileName", "folderType", "Lcom/android/resources/ResourceFolderType;", "areXmlTagsEquivalent", "", "element1", "Lcom/intellij/psi/xml/XmlTag;", "element2", "mergeManifest", "Lcom/android/manifmerger/MergingReport;", "namespace", "moduleRoot", "targetManifest", "mergeText", "getResourceId", "tag", "wrapWithMergeConflict", "original", "added", "intellij.android.templates"})
@JvmName(name="RecipeMergeUtils")
@SourceDebugExtension(value={"SMAP\nRecipeMergeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipeMergeUtils.kt\ncom/android/tools/idea/templates/RecipeMergeUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,261:1\n3829#2:262\n4344#2,2:263\n4135#2,11:267\n8634#2,2:280\n8894#2,4:282\n6479#2:288\n6479#2:289\n1863#3,2:265\n1863#3,2:278\n1863#3,2:286\n*S KotlinDebug\n*F\n+ 1 RecipeMergeUtils.kt\ncom/android/tools/idea/templates/RecipeMergeUtils\n*L\n120#1:262\n120#1:263,2\n124#1:267,11\n133#1:280,2\n133#1:282,4\n207#1:288\n208#1:289\n120#1:265,2\n124#1:278,2\n156#1:286,2\n*E\n"})
public final class RecipeMergeUtils {
    @NotNull
    private static final String MERGE_ATTR_STRATEGY = "templateMergeStrategy";
    @NotNull
    private static final String MERGE_ATTR_STRATEGY_REPLACE = "replace";
    @NotNull
    private static final String MERGE_ATTR_STRATEGY_PRESERVE = "preserve";

    private static final Logger getLOG() {
        Logger logger = Logger.getInstance((String)"RecipeMergeUtils.kt");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @NotNull
    public static final String mergeXml(@NotNull RenderingContext context, @NotNull String sourceXml, @NotNull String targetXml, @NotNull File targetFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sourceXml, (String)"sourceXml");
        Intrinsics.checkNotNullParameter((Object)targetXml, (String)"targetXml");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        String fileName = targetFile.getName();
        Ref.ObjectRef errors = new Ref.ObjectRef();
        String string = Intrinsics.areEqual((Object)fileName, (Object)"AndroidManifest.xml") ? RecipeMergeUtils.mergeXml$mergeManifest(targetXml, sourceXml, context, targetFile, (Ref.ObjectRef<String>)errors) : RecipeMergeUtils.mergeXml$mergePlainXml(targetFile, context, targetXml, sourceXml, fileName);
        if (string == null) {
            String string2;
            String it = string2 = RecipeMergeUtils.wrapWithMergeConflict(targetXml, sourceXml);
            boolean bl = false;
            context.getWarnings().add("Merge conflict for: " + targetFile.getName() + "\nThis file must be fixed by hand. Errors encountered during the merge:\n\n" + errors.element);
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String mergeResourceFile(@NotNull Project project, @NotNull Collection<String> warningsToAdd, @NotNull String targetXml, @NotNull String sourceXml, @NotNull String fileName, @Nullable ResourceFolderType folderType) {
        void $this$associateByTo$iv$iv;
        void $this$forEach$iv;
        Object[] $this$filterTo$iv$iv;
        XmlAttribute[] attributes;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(warningsToAdd, (String)"warningsToAdd");
        Intrinsics.checkNotNullParameter((Object)targetXml, (String)"targetXml");
        Intrinsics.checkNotNullParameter((Object)sourceXml, (String)"sourceXml");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("targetFile", (Language)XMLLanguage.INSTANCE, (CharSequence)StringUtil.convertLineSeparators((String)targetXml), false, true);
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        XmlFile targetPsiFile = (XmlFile)psiFile;
        PsiFile psiFile2 = PsiFileFactory.getInstance((Project)project).createFileFromText("sourceFile", (Language)XMLLanguage.INSTANCE, (CharSequence)StringUtil.convertLineSeparators((String)sourceXml), false, true);
        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        XmlFile sourcePsiFile = (XmlFile)psiFile2;
        XmlDocument xmlDocument = targetPsiFile.getDocument();
        Intrinsics.checkNotNull((Object)xmlDocument);
        XmlTag xmlTag = xmlDocument.getRootTag();
        if (xmlTag == null) {
            throw new IllegalStateException(("Cannot find XML root in target: " + targetXml).toString());
        }
        XmlTag root = xmlTag;
        XmlTag xmlTag2 = sourcePsiFile.getRootTag();
        Intrinsics.checkNotNull((Object)xmlTag2);
        XmlAttribute[] xmlAttributeArray = xmlTag2.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"getAttributes(...)");
        Object $this$filter$iv = attributes = xmlAttributeArray;
        boolean $i$f$filter = false;
        XmlAttribute[] xmlAttributeArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            int n2 = 0;
            if (!Intrinsics.areEqual((Object)it.getNamespacePrefix(), (Object)"xmlns:")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XmlAttribute it = (XmlAttribute)element$iv;
            int n3 = 0;
            root.setAttribute(it.getName(), it.getValue());
        }
        if (folderType != ResourceFolderType.VALUES) {
            Iterator $this$filterIsInstanceTo$iv$iv;
            XmlTag xmlTag3 = sourcePsiFile.getRootTag();
            Intrinsics.checkNotNull((Object)xmlTag3);
            PsiElement[] psiElementArray = xmlTag3.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object $this$filterIsInstance$iv = psiElementArray;
            boolean $i$f$filterIsInstance = false;
            $this$filterTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof XmlTag)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XmlTag it = (XmlTag)element$iv;
                boolean bl = false;
                root.addSubTag(it, false);
            }
            String string = targetPsiFile.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }
        ArrayList prependElements = Lists.newArrayList();
        XmlText indent = null;
        XmlTag[] xmlTagArray = root.getSubTags();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"getSubTags(...)");
        Object[] $this$associateBy$iv = xmlTagArray;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        Object[] objectArray = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (void element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            XmlTag xmlTag4 = (XmlTag)element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            map2.put(RecipeMergeUtils.getResourceId((XmlTag)it), element$iv$iv);
        }
        Map old = destination$iv$iv2;
        XmlTag xmlTag5 = sourcePsiFile.getRootTag();
        Intrinsics.checkNotNull((Object)xmlTag5);
        for (PsiElement psiElement : xmlTag5.getChildren()) {
            XmlTag replace;
            String name2;
            PsiElement child;
            Intrinsics.checkNotNull((Object)psiElement);
            psiElement = child = psiElement;
            if (psiElement instanceof XmlComment) {
                if (indent != null) {
                    prependElements.add(indent);
                }
                prependElements.add((XmlTagChild)child);
                continue;
            }
            if (psiElement instanceof XmlText) {
                indent = (XmlText)child;
                continue;
            }
            if (!(psiElement instanceof XmlTag)) continue;
            PsiElement subTag = null;
            subTag = child;
            String mergeStrategy = ((XmlTag)subTag).getAttributeValue(MERGE_ATTR_STRATEGY);
            ((XmlTag)subTag).setAttribute(MERGE_ATTR_STRATEGY, null);
            CodeStyleManager.getInstance((Project)project).reformat(subTag);
            String string = name2 = RecipeMergeUtils.getResourceId((XmlTag)subTag);
            XmlTag xmlTag6 = replace = string == null ? null : (XmlTag)old.get(string);
            if (replace == null) {
                if (indent != null) {
                    prependElements.add(indent);
                }
                XmlTag xmlTag7 = root.addSubTag((XmlTag)subTag, false);
                Intrinsics.checkNotNullExpressionValue((Object)xmlTag7, (String)"addSubTag(...)");
                subTag = xmlTag7;
                Intrinsics.checkNotNull((Object)prependElements);
                Iterable $this$forEach$iv2 = prependElements;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    XmlTagChild it = (XmlTagChild)element$iv;
                    boolean bl = false;
                    root.addBefore((PsiElement)it, subTag);
                }
                prependElements.clear();
                continue;
            }
            if (Intrinsics.areEqual((Object)MERGE_ATTR_STRATEGY_REPLACE, (Object)mergeStrategy)) {
                Iterator iterator2;
                PsiElement newChild = replace.replace(child);
                if (newChild.getPrevSibling() instanceof XmlText && prependElements.get(0) instanceof XmlText) {
                    prependElements.remove(0);
                    Intrinsics.checkNotNull((Object)prependElements);
                    if (!((Collection)prependElements).isEmpty()) {
                        prependElements.add(indent);
                    }
                }
                Intrinsics.checkNotNullExpressionValue(prependElements.iterator(), (String)"iterator(...)");
                while (iterator2.hasNext()) {
                    XmlTagChild element = (XmlTagChild)iterator2.next();
                    root.addBefore((PsiElement)element, newChild);
                }
            } else if (!Intrinsics.areEqual((Object)MERGE_ATTR_STRATEGY_PRESERVE, (Object)mergeStrategy) && !RecipeMergeUtils.areXmlTagsEquivalent(replace, (XmlTag)child)) {
                warningsToAdd.add("Ignoring conflict for the value: " + name2 + " wanted: \"%" + ((XmlTag)child).getText() + "\" but it already is: \"%" + replace.getText() + "\" in the file: " + fileName);
            }
            prependElements.clear();
        }
        String string = targetPsiFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final boolean areXmlTagsEquivalent(XmlTag element1, XmlTag element2) {
        if (!Intrinsics.areEqual((Object)element1.getName(), (Object)element2.getName())) {
            return false;
        }
        XmlAttribute[] xmlAttributeArray = element1.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray, (String)"getAttributes(...)");
        Object[] $this$sortedBy$iv = xmlAttributeArray;
        boolean $i$f$sortedBy = false;
        List attributes1 = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                XmlAttribute p0 = (XmlAttribute)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)p0.getName());
                p0 = (XmlAttribute)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getName())));
            }
        });
        XmlAttribute[] xmlAttributeArray2 = element2.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)xmlAttributeArray2, (String)"getAttributes(...)");
        Object[] $this$sortedBy$iv2 = xmlAttributeArray2;
        boolean $i$f$sortedBy2 = false;
        List attributes2 = ArraysKt.sortedWith((Object[])$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                XmlAttribute p0 = (XmlAttribute)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)p0.getName());
                p0 = (XmlAttribute)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getName())));
            }
        });
        if (attributes1.size() != attributes2.size()) {
            return false;
        }
        int n = ((Collection)attributes1).size();
        for (int i = 0; i < n; ++i) {
            XmlAttribute attr1 = (XmlAttribute)attributes1.get(i);
            XmlAttribute attr2 = (XmlAttribute)attributes2.get(i);
            if (Intrinsics.areEqual((Object)attr1.getName(), (Object)attr2.getName()) && Intrinsics.areEqual((Object)attr1.getValue(), (Object)attr2.getValue())) continue;
            return false;
        }
        return true;
    }

    private static final MergingReport mergeManifest(String namespace, File moduleRoot, File targetManifest, String targetXml, String mergeText) {
        try {
            boolean isMasterManifest = FileUtil.filesEqual((File)moduleRoot, (File)targetManifest.getParentFile());
            File tempFile2 = new File(targetManifest.getParentFile(), "nevercreated.xml");
            StdLogger logger = new StdLogger(StdLogger.Level.INFO);
            ManifestMerger2.Invoker.Feature[] featureArray = new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.EXTRACT_FQCNS, ManifestMerger2.Invoker.Feature.HANDLE_VALUE_CONFLICTS_AUTOMATICALLY, ManifestMerger2.Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT};
            return ManifestMerger2.newMerger((File)targetManifest, (ILogger)((ILogger)logger), (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).withFeatures(featureArray).setNamespace(namespace).addFlavorAndBuildTypeManifest(tempFile2).asType(isMasterManifest ? XmlDocument.Type.MAIN : XmlDocument.Type.OVERLAY).withFileStreamProvider(new ManifestMerger2.FileStreamProvider(targetManifest, targetXml, mergeText){
                final /* synthetic */ File $targetManifest;
                final /* synthetic */ String $targetXml;
                final /* synthetic */ String $mergeText;
                {
                    this.$targetManifest = $targetManifest;
                    this.$targetXml = $targetXml;
                    this.$mergeText = $mergeText;
                }

                protected InputStream getInputStream(File file) throws FileNotFoundException {
                    String text2;
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    String string = text2 = FileUtil.filesEqual((File)file, (File)this.$targetManifest) ? this.$targetXml : this.$mergeText;
                    Charset charset = Charsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    byte[] byArray = string.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    return new ByteArrayInputStream(byArray);
                }
            }).merge();
        }
        catch (ManifestMerger2.MergeFailureException e) {
            RecipeMergeUtils.getLOG().warn((Throwable)e);
            return null;
        }
    }

    private static final String getResourceId(XmlTag tag) {
        String string = tag.getAttributeValue("name");
        if (string == null) {
            string = tag.getAttributeValue("id");
        }
        return string;
    }

    private static final String wrapWithMergeConflict(String original, String added) {
        return "<<<<<<< Original\n" + original + "\n=======\n" + added + ">>>>>>> Added\n";
    }

    private static final boolean mergeXml$mergeManifest$lambda$0(MergingReport.Record it) {
        return it.getSeverity() == MergingReport.Record.Severity.ERROR;
    }

    private static final CharSequence mergeXml$mergeManifest$lambda$1(MergingReport.Record it) {
        return "* " + it.getMessage() + "\n\n";
    }

    private static final String mergeXml$mergeManifest(String $targetXml, String $sourceXml, RenderingContext $context, File $targetFile, Ref.ObjectRef<String> errors) {
        if (XmlUtils.parseDocumentSilently((String)$targetXml, (boolean)true) == null) {
            throw new IllegalStateException(($targetXml + " failed to parse").toString());
        }
        if (XmlUtils.parseDocumentSilently((String)$sourceXml, (boolean)true) == null) {
            throw new IllegalStateException(($sourceXml + " failed to parse").toString());
        }
        Object object = $context.getModuleTemplateData();
        if (object == null || (object = object.getNamespace()) == null) {
            object = "";
        }
        Object namespace = object;
        File file = $context.getModuleRoot();
        Intrinsics.checkNotNull((Object)file);
        MergingReport mergingReport = RecipeMergeUtils.mergeManifest((String)namespace, file, $targetFile, $targetXml, $sourceXml);
        if (mergingReport == null) {
            return null;
        }
        MergingReport report = mergingReport;
        if (report.getResult().isSuccess()) {
            return report.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
        }
        ImmutableList immutableList = report.getLoggingRecords();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getLoggingRecords(...)");
        errors.element = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)immutableList)), RecipeMergeUtils::mergeXml$mergeManifest$lambda$0), (CharSequence)"", null, null, (int)0, null, RecipeMergeUtils::mergeXml$mergeManifest$lambda$1, (int)30, null), (String)"AndroidManifest.xml", (String)"current AndroidManifest.xml", (boolean)false, (int)4, null), (String)"nevercreated.xml", (String)"template AndroidManifest.xml", (boolean)false, (int)4, null))).toString();
        return null;
    }

    private static final String mergeXml$mergePlainXml(File $targetFile, RenderingContext $context, String $targetXml, String $sourceXml, String fileName) {
        String parentFolderName = $targetFile.getParentFile().getName();
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentFolderName);
        Project project = $context.getProject();
        Collection collection2 = $context.getWarnings();
        Intrinsics.checkNotNull((Object)fileName);
        return RecipeMergeUtils.mergeResourceFile(project, collection2, $targetXml, $sourceXml, fileName, folderType);
    }
}

