/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator.xr;

import com.android.annotations.concurrency.UiThread;
import com.android.emulator.control.AngularVelocity;
import com.android.emulator.control.InputEvent;
import com.android.emulator.control.RotationRadian;
import com.android.emulator.control.Translation;
import com.android.emulator.control.Velocity;
import com.android.emulator.control.XrOptions;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.protobuf.Empty;
import com.android.tools.idea.streaming.core.MouseWheelUtilsKt;
import com.android.tools.idea.streaming.emulator.EmptyStreamObserver;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.xr.EmulatorXrInputControllerService;
import com.android.tools.idea.streaming.xr.AbstractXrInputController;
import com.android.tools.idea.streaming.xr.XrEnvironment;
import com.android.tools.idea.streaming.xr.XrInputMode;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0017J \u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0017J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0014J\b\u0010(\u001a\u00020\u0012H\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \b*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \b*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \b*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/streaming/emulator/xr/EmulatorXrInputController;", "Lcom/android/tools/idea/streaming/xr/AbstractXrInputController;", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorController;)V", "inputEvent", "Lcom/android/emulator/control/InputEvent$Builder;", "kotlin.jvm.PlatformType", "rotation", "Lcom/android/emulator/control/RotationRadian$Builder;", "translation", "Lcom/android/emulator/control/Translation$Builder;", "angularVelocity", "Lcom/android/emulator/control/AngularVelocity$Builder;", "velocity", "Lcom/android/emulator/control/Velocity$Builder;", "setPassthrough", "", "passthroughCoefficient", "", "(FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendTranslation", "x", "y", "z", "mouseDragged", "", "event", "Ljava/awt/event/MouseEvent;", "deviceDisplaySize", "Ljava/awt/Dimension;", "scaleFactor", "", "mouseWheelMoved", "Ljava/awt/event/MouseWheelEvent;", "sendVelocityUpdate", "newMask", "", "oldMask", "dispose", "sendInputEvent", "Lcom/android/emulator/control/InputEvent;", "Companion", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nEmulatorXrInputController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorXrInputController.kt\ncom/android/tools/idea/streaming/emulator/xr/EmulatorXrInputController\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n310#2,9:222\n319#2,2:232\n1#3:231\n*S KotlinDebug\n*F\n+ 1 EmulatorXrInputController.kt\ncom/android/tools/idea/streaming/emulator/xr/EmulatorXrInputController\n*L\n64#1:222,9\n64#1:232,2\n*E\n"})
public final class EmulatorXrInputController
extends AbstractXrInputController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EmulatorController emulator;
    private final InputEvent.Builder inputEvent;
    private final RotationRadian.Builder rotation;
    private final Translation.Builder translation;
    private final AngularVelocity.Builder angularVelocity;
    private final Velocity.Builder velocity;

    public EmulatorXrInputController(@NotNull EmulatorController emulator) {
        Intrinsics.checkNotNullParameter((Object)((Object)emulator), (String)"emulator");
        this.emulator = emulator;
        this.inputEvent = InputEvent.newBuilder();
        this.rotation = RotationRadian.newBuilder();
        this.translation = Translation.newBuilder();
        this.angularVelocity = AngularVelocity.newBuilder();
        this.velocity = Velocity.newBuilder();
        Disposer.register((Disposable)this.emulator, (Disposable)this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object setPassthrough(float passthroughCoefficient, @NotNull Continuation<? super Unit> $completion) {
        XrOptions.Environment environment;
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        XrOptions.Builder builder = XrOptions.newBuilder().setPassthroughCoefficient(passthroughCoefficient);
        XrEnvironment xrEnvironment = this.getEnvironment();
        if (xrEnvironment != null) {
            void it;
            XrEnvironment xrEnvironment2 = xrEnvironment;
            XrOptions.Builder builder2 = builder;
            boolean bl3 = false;
            environment = XrOptions.Environment.forNumber((int)it.ordinal());
            builder = builder2;
        } else {
            environment = null;
        }
        XrOptions xrOptions = builder.setEnvironment(environment).build();
        EmulatorController emulatorController = this.emulator;
        Intrinsics.checkNotNull((Object)xrOptions);
        emulatorController.setXrOptions(xrOptions, (StreamObserver<Empty>)new EmptyStreamObserver<Empty>(this, passthroughCoefficient, (CancellableContinuation<? super Unit>)continuation){
            final /* synthetic */ EmulatorXrInputController this$0;
            final /* synthetic */ float $passthroughCoefficient;
            final /* synthetic */ CancellableContinuation<Unit> $continuation;
            {
                this.this$0 = $receiver;
                this.$passthroughCoefficient = $passthroughCoefficient;
                this.$continuation = $continuation;
            }

            public void onNext(Empty message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.this$0.setPassthroughCoefficient(this.$passthroughCoefficient);
                ActivityTracker.getInstance().inc();
                ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
            }

            public void onError(Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t)));
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void sendTranslation(float x, float y, float z) {
        this.translation.setDeltaX(x);
        this.translation.setDeltaY(y);
        this.translation.setDeltaZ(z);
        this.inputEvent.setXrHeadMovementEvent(this.translation);
        InputEvent inputEvent = this.inputEvent.build();
        Intrinsics.checkNotNullExpressionValue((Object)inputEvent, (String)"build(...)");
        this.sendInputEvent(inputEvent);
    }

    @Override
    @UiThread
    public boolean mouseDragged(@NotNull MouseEvent event, @NotNull Dimension deviceDisplaySize, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)deviceDisplaySize, (String)"deviceDisplaySize");
        if (!this.isMouseUsedForNavigation()) {
            return false;
        }
        Point referencePoint = this.getMouseDragReferencePoint();
        if (referencePoint != null) {
            float movementScale = this.getInputMode() == XrInputMode.VIEW_DIRECTION ? (float)Math.PI : 4.0f;
            float scale = (float)((double)(movementScale / (float)Math.min(deviceDisplaySize.width, deviceDisplaySize.height)) * scaleFactor);
            int deltaX = event.getX() - referencePoint.x;
            int deltaY = event.getY() - referencePoint.y;
            this.setMouseDragReferencePoint(event.getPoint());
            if (deltaX != 0 || deltaY != 0) {
                this.inputEvent.clear();
                switch (WhenMappings.$EnumSwitchMapping$0[this.getInputMode().ordinal()]) {
                    case 1: {
                        this.translation.setDeltaX((float)(-deltaX) * scale);
                        this.translation.setDeltaY((float)deltaY * scale);
                        this.translation.clearDeltaZ();
                        InputEvent.Builder builder = this.inputEvent.setXrHeadMovementEvent(this.translation);
                        break;
                    }
                    case 2: {
                        this.translation.clear();
                        this.translation.setDeltaZ((float)(-deltaY) * scale);
                        InputEvent.Builder builder = this.inputEvent.setXrHeadMovementEvent(this.translation);
                        break;
                    }
                    case 3: {
                        this.rotation.setX((float)(-deltaY) * scale);
                        this.rotation.setY((float)(-deltaX) * scale);
                        InputEvent.Builder builder = this.inputEvent.setXrHeadRotationEvent(this.rotation);
                        break;
                    }
                    default: {
                        throw new Error("Internal error");
                    }
                }
                InputEvent inputEvent = this.inputEvent.build();
                Intrinsics.checkNotNullExpressionValue((Object)inputEvent, (String)"build(...)");
                this.sendInputEvent(inputEvent);
            }
        }
        event.consume();
        return true;
    }

    @Override
    @UiThread
    public boolean mouseWheelMoved(@NotNull MouseWheelEvent event, @NotNull Dimension deviceDisplaySize, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)deviceDisplaySize, (String)"deviceDisplaySize");
        if (!this.isMouseUsedForNavigation()) {
            return false;
        }
        this.translation.clear();
        this.translation.setDeltaZ((float)MouseWheelUtilsKt.getNormalizedScrollAmount(event, scaleFactor) * 0.25f);
        this.inputEvent.clear();
        this.inputEvent.setXrHeadMovementEvent(this.translation);
        InputEvent inputEvent = this.inputEvent.build();
        Intrinsics.checkNotNullExpressionValue((Object)inputEvent, (String)"build(...)");
        this.sendInputEvent(inputEvent);
        event.consume();
        return true;
    }

    @Override
    protected void sendVelocityUpdate(int newMask, int oldMask) {
        this.velocity.clear();
        this.angularVelocity.clear();
        int mask = newMask;
        int key = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                if (key < AbstractXrInputController.NavigationKey.ROTATE_RIGHT.ordinal()) {
                    var5_5 = key;
                    if (var5_5 == AbstractXrInputController.NavigationKey.MOVE_RIGHT.ordinal()) {
                        this.velocity.setX(1.0f);
                    } else if (var5_5 == AbstractXrInputController.NavigationKey.MOVE_LEFT.ordinal()) {
                        this.velocity.setX(-1.0f);
                    } else if (var5_5 == AbstractXrInputController.NavigationKey.MOVE_UP.ordinal()) {
                        this.velocity.setY(1.0f);
                    } else if (var5_5 == AbstractXrInputController.NavigationKey.MOVE_DOWN.ordinal()) {
                        this.velocity.setY(-1.0f);
                    } else if (var5_5 == AbstractXrInputController.NavigationKey.MOVE_FORWARD.ordinal()) {
                        this.velocity.setZ(-1.0f);
                    } else if (var5_5 == AbstractXrInputController.NavigationKey.MOVE_BACKWARD.ordinal()) {
                        this.velocity.setZ(1.0f);
                    }
                } else {
                    var5_5 = key;
                    if (var5_5 == AbstractXrInputController.NavigationKey.ROTATE_RIGHT.ordinal()) {
                        this.angularVelocity.setOmegaY(-0.5235988f);
                    } else if (var5_5 == AbstractXrInputController.NavigationKey.ROTATE_LEFT.ordinal()) {
                        this.angularVelocity.setOmegaY(0.5235988f);
                    } else if (var5_5 == AbstractXrInputController.NavigationKey.ROTATE_UP.ordinal()) {
                        this.angularVelocity.setOmegaX(0.5235988f);
                    } else if (var5_5 == AbstractXrInputController.NavigationKey.ROTATE_DOWN.ordinal()) {
                        this.angularVelocity.setOmegaX(-0.5235988f);
                    }
                }
            }
            mask >>>= 1;
            ++key;
        }
        int differences = newMask ^ oldMask;
        if ((differences & AbstractXrInputController.NavigationKey.Companion.getTRANSLATION_MASK()) != 0) {
            this.inputEvent.clear();
            this.inputEvent.setXrHeadVelocityEvent(this.velocity);
            InputEvent inputEvent = this.inputEvent.build();
            Intrinsics.checkNotNullExpressionValue((Object)inputEvent, (String)"build(...)");
            this.sendInputEvent(inputEvent);
        }
        if ((differences & AbstractXrInputController.NavigationKey.Companion.getROTATION_MASK()) != 0) {
            this.inputEvent.clear();
            this.inputEvent.setXrHeadAngularVelocityEvent(this.angularVelocity);
            InputEvent inputEvent = this.inputEvent.build();
            Intrinsics.checkNotNullExpressionValue((Object)inputEvent, (String)"build(...)");
            this.sendInputEvent(inputEvent);
        }
    }

    public void dispose() {
    }

    private final void sendInputEvent(InputEvent inputEvent) {
        this.emulator.getOrCreateInputEventSender().onNext((Object)inputEvent);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/emulator/xr/EmulatorXrInputController$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/streaming/emulator/xr/EmulatorXrInputController;", "project", "Lcom/intellij/openapi/project/Project;", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nEmulatorXrInputController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorXrInputController.kt\ncom/android/tools/idea/streaming/emulator/xr/EmulatorXrInputController$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,221:1\n31#2,2:222\n*S KotlinDebug\n*F\n+ 1 EmulatorXrInputController.kt\ncom/android/tools/idea/streaming/emulator/xr/EmulatorXrInputController$Companion\n*L\n199#1:222,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EmulatorXrInputController getInstance(@NotNull Project project, @NotNull EmulatorController emulator) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)emulator), (String)"emulator");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<EmulatorXrInputControllerService> serviceClass$iv = EmulatorXrInputControllerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return ((EmulatorXrInputControllerService)object).getXrInputController(emulator);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[XrInputMode.values().length];
            try {
                nArray[XrInputMode.LOCATION_IN_SPACE_XY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XrInputMode.LOCATION_IN_SPACE_Z.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XrInputMode.VIEW_DIRECTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

