/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.SdkConstants;
import com.android.annotations.concurrency.AnyThread;
import com.android.emulator.control.DisplayConfiguration;
import com.android.emulator.control.DisplayConfigurations;
import com.android.emulator.control.ExtendedControlsStatus;
import com.android.sdklib.deviceprovisioner.DeviceType;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.protobuf.MessageOrBuilder;
import com.android.tools.idea.protobuf.TextFormat;
import com.android.tools.idea.streaming.core.AbstractDisplayPanel;
import com.android.tools.idea.streaming.core.DeviceFileDropHandlerKt;
import com.android.tools.idea.streaming.core.DeviceId;
import com.android.tools.idea.streaming.core.DisplayDescriptor;
import com.android.tools.idea.streaming.core.LayoutNode;
import com.android.tools.idea.streaming.core.LeafNode;
import com.android.tools.idea.streaming.core.MultiDisplayLayoutOptimizerKt;
import com.android.tools.idea.streaming.core.PanelState;
import com.android.tools.idea.streaming.core.SplitNode;
import com.android.tools.idea.streaming.core.SplitPanel;
import com.android.tools.idea.streaming.core.StreamingConstants;
import com.android.tools.idea.streaming.core.StreamingDevicePanel;
import com.android.tools.idea.streaming.core.StreamingUtilsKt;
import com.android.tools.idea.streaming.emulator.DisplayConfigurationListener;
import com.android.tools.idea.streaming.emulator.EmptyStreamObserver;
import com.android.tools.idea.streaming.emulator.EmulatorAdbReadyService;
import com.android.tools.idea.streaming.emulator.EmulatorConfiguration;
import com.android.tools.idea.streaming.emulator.EmulatorConstants;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorDisplayPanel;
import com.android.tools.idea.streaming.emulator.EmulatorId;
import com.android.tools.idea.streaming.emulator.EmulatorToolWindowPanel;
import com.android.tools.idea.streaming.emulator.EmulatorToolWindowPanelKt;
import com.android.tools.idea.streaming.emulator.EmulatorView;
import com.android.tools.idea.streaming.emulator.PostureListener;
import com.android.tools.idea.streaming.emulator.actions.EmulatorManageSnapshotsActionKt;
import com.android.tools.idea.streaming.emulator.actions.EmulatorShowExtendedControlsActionKt;
import com.android.tools.idea.ui.screenrecording.ScreenRecordingParameters;
import com.android.utils.HashCodes;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import icons.StudioIcons;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0004STUVB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u000202H\u0010\u00a2\u0006\u0002\bCJ\u0018\u0010D\u001a\u00020A2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010E\u001a\u00020FH\u0016J\u001f\u0010G\u001a\u00020A2\u0006\u0010H\u001a\u0002022\b\u0010I\u001a\u0004\u0018\u00010JH\u0010\u00a2\u0006\u0002\bKJ\r\u0010L\u001a\u00020;H\u0010\u00a2\u0006\u0002\bMJ\u0010\u0010N\u001a\u00020A2\u0006\u0010O\u001a\u00020PH\u0016J\n\u0010Q\u001a\u0004\u0018\u00010RH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020 8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0014\u0010%\u001a\u00020&8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R$\u00103\u001a\u0002022\u0006\u00101\u001a\u000202@PX\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0014\u00108\u001a\u0002028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u00105R\u001e\u0010:\u001a\u0004\u0018\u00010;8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\u00a8\u0006W"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel;", "Lcom/android/tools/idea/streaming/core/StreamingDevicePanel;", "Lcom/android/tools/idea/streaming/emulator/EmulatorDisplayPanel;", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionStateListener;", "disposableParent", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "emulator", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/streaming/emulator/EmulatorController;)V", "getEmulator", "()Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "displayConfigurator", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$DisplayConfigurator;", "contentDisposable", "primaryDisplayView", "Lcom/android/tools/idea/streaming/emulator/EmulatorView;", "getPrimaryDisplayView$intellij_android_streaming", "()Lcom/android/tools/idea/streaming/emulator/EmulatorView;", "setPrimaryDisplayView$intellij_android_streaming", "(Lcom/android/tools/idea/streaming/emulator/EmulatorView;)V", "multiDisplayStateStorage", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayStateStorage;", "multiDisplayStateUpdater", "Ljava/lang/Runnable;", "emulatorId", "Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "getEmulatorId", "()Lcom/android/tools/idea/streaming/emulator/EmulatorId;", "title", "", "getTitle$intellij_android_streaming", "()Ljava/lang/String;", "description", "getDescription$intellij_android_streaming", "icon", "Ljavax/swing/Icon;", "getIcon$intellij_android_streaming", "()Ljavax/swing/Icon;", "deviceType", "Lcom/android/sdklib/deviceprovisioner/DeviceType;", "getDeviceType$intellij_android_streaming", "()Lcom/android/sdklib/deviceprovisioner/DeviceType;", "preferredFocusableComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent$intellij_android_streaming", "()Ljavax/swing/JComponent;", "value", "", "zoomToolbarVisible", "getZoomToolbarVisible$intellij_android_streaming", "()Z", "setZoomToolbarVisible$intellij_android_streaming", "(Z)V", "connected", "getConnected", "lastUiState", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$EmulatorUiState;", "getLastUiState", "()Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$EmulatorUiState;", "setLastUiState", "(Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$EmulatorUiState;)V", "setDeviceFrameVisible", "", "visible", "setDeviceFrameVisible$intellij_android_streaming", "connectionStateChanged", "connectionState", "Lcom/android/tools/idea/streaming/emulator/EmulatorController$ConnectionState;", "createContent", "deviceFrameVisible", "savedUiState", "Lcom/android/tools/idea/streaming/core/StreamingDevicePanel$UiState;", "createContent$intellij_android_streaming", "destroyContent", "destroyContent$intellij_android_streaming", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getScreenRecorderParameters", "Lcom/android/tools/idea/ui/screenrecording/ScreenRecordingParameters;", "DisplayConfigurator", "EmulatorUiState", "MultiDisplayState", "MultiDisplayStateStorage", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nEmulatorToolWindowPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorToolWindowPanel.kt\ncom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n31#2,2:506\n1#3:508\n*S KotlinDebug\n*F\n+ 1 EmulatorToolWindowPanel.kt\ncom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel\n*L\n143#1:506,2\n*E\n"})
public final class EmulatorToolWindowPanel
extends StreamingDevicePanel<EmulatorDisplayPanel>
implements EmulatorController.ConnectionStateListener {
    @NotNull
    private final Project project;
    @NotNull
    private final EmulatorController emulator;
    @NotNull
    private final DisplayConfigurator displayConfigurator;
    @Nullable
    private Disposable contentDisposable;
    @Nullable
    private EmulatorView primaryDisplayView;
    @NotNull
    private final MultiDisplayStateStorage multiDisplayStateStorage;
    @NotNull
    private final Runnable multiDisplayStateUpdater;
    private boolean zoomToolbarVisible;
    @Nullable
    private EmulatorUiState lastUiState;

    public EmulatorToolWindowPanel(@NotNull Disposable disposableParent, @NotNull Project project, @NotNull EmulatorController emulator) {
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)emulator), (String)"emulator");
        super(DeviceId.Companion.ofEmulator(emulator.getEmulatorId()), "StreamingToolbarVirtualDevice", null, 4, null);
        this.project = project;
        this.emulator = emulator;
        this.displayConfigurator = new DisplayConfigurator(this.project);
        this.multiDisplayStateStorage = MultiDisplayStateStorage.Companion.getInstance(this.project);
        this.multiDisplayStateUpdater = () -> EmulatorToolWindowPanel.multiDisplayStateUpdater$lambda$0(this);
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<EmulatorAdbReadyService> serviceClass$iv = EmulatorAdbReadyService.class;
        if ($this$service$iv.getService(serviceClass$iv) == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
    }

    @NotNull
    public final EmulatorController getEmulator() {
        return this.emulator;
    }

    @Override
    @Nullable
    public EmulatorView getPrimaryDisplayView$intellij_android_streaming() {
        return this.primaryDisplayView;
    }

    public void setPrimaryDisplayView$intellij_android_streaming(@Nullable EmulatorView emulatorView) {
        this.primaryDisplayView = emulatorView;
    }

    private final EmulatorId getEmulatorId() {
        return this.emulator.getEmulatorId();
    }

    @Override
    @NotNull
    public String getTitle$intellij_android_streaming() {
        String avdName = this.getEmulatorId().getAvdName();
        if (StringsKt.contains$default((CharSequence)avdName, (CharSequence)" API ", (boolean)false, (int)2, null)) {
            return avdName;
        }
        return avdName + " API " + this.emulator.getEmulatorConfig().getAndroidVersion().getApiStringWithoutExtension();
    }

    @Override
    @NotNull
    public String getDescription$intellij_android_streaming() {
        String string = this.getTitle$intellij_android_streaming();
        String string2 = "(" + this.getEmulatorId().getSerialNumber() + ")";
        JBColor jBColor = JBColor.GRAY;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"GRAY");
        return string + " " + StreamingUtilsKt.htmlColored(string2, (Color)jBColor);
    }

    @Override
    @NotNull
    public Icon getIcon$intellij_android_streaming() {
        AvdInfo avd = AvdManagerConnection.Companion.getDefaultAvdManagerConnection().findAvdWithFolder(this.getEmulatorId().getAvdFolder());
        Object object = avd;
        if (object == null || (object = StreamingUtilsKt.getIcon(object)) == null) {
            Icon icon = StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_PHONE;
            object = icon;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"VIRTUAL_DEVICE_PHONE");
        }
        Object icon = object;
        Icon icon2 = ExecutionUtil.getLiveIndicator((Icon)icon);
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getLiveIndicator(...)");
        return icon2;
    }

    @Override
    @NotNull
    public DeviceType getDeviceType$intellij_android_streaming() {
        return this.emulator.getEmulatorConfig().getDeviceType();
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent$intellij_android_streaming() {
        EmulatorView emulatorView = this.getPrimaryDisplayView$intellij_android_streaming();
        return emulatorView != null ? (JComponent)((Object)emulatorView) : (JComponent)((Object)this);
    }

    @Override
    public boolean getZoomToolbarVisible$intellij_android_streaming() {
        return this.zoomToolbarVisible;
    }

    @Override
    public void setZoomToolbarVisible$intellij_android_streaming(boolean value2) {
        this.zoomToolbarVisible = value2;
        ObjectIterator objectIterator = ((ObjectCollection)this.getDisplayPanels().values()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            EmulatorDisplayPanel panel2 = (EmulatorDisplayPanel)objectIterator2.next();
            panel2.setZoomToolbarVisible(value2);
        }
    }

    private final boolean getConnected() {
        return this.emulator.getConnectionState() == EmulatorController.ConnectionState.CONNECTED;
    }

    @TestOnly
    @Nullable
    public final EmulatorUiState getLastUiState() {
        return this.lastUiState;
    }

    public final void setLastUiState(@Nullable EmulatorUiState emulatorUiState) {
        this.lastUiState = emulatorUiState;
    }

    @Override
    public void setDeviceFrameVisible$intellij_android_streaming(boolean visible) {
        block0: {
            EmulatorView emulatorView = this.getPrimaryDisplayView$intellij_android_streaming();
            if (emulatorView == null) break block0;
            emulatorView.setDeviceFrameVisible(visible);
        }
    }

    @Override
    public void connectionStateChanged(@NotNull EmulatorController emulator, @NotNull EmulatorController.ConnectionState connectionState) {
        Intrinsics.checkNotNullParameter((Object)((Object)emulator), (String)"emulator");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionState), (String)"connectionState");
        if (connectionState == EmulatorController.ConnectionState.CONNECTED) {
            this.displayConfigurator.refreshDisplayConfiguration();
            Disposable disposable = this.contentDisposable;
            Intrinsics.checkNotNull((Object)disposable);
            this.showContextMenuAdvertisementIfNecessary(disposable);
        }
        ActivityTracker.getInstance().inc();
    }

    @Override
    public void createContent$intellij_android_streaming(boolean deviceFrameVisible, @Nullable StreamingDevicePanel.UiState savedUiState) {
        BorderLayoutPanel borderLayoutPanel;
        MultiDisplayState multiDisplayState;
        if (this.contentDisposable != null) {
            EmulatorToolWindowPanelKt.access$getLOG().error((Throwable)new IllegalStateException(this.getTitle$intellij_android_streaming() + ": content already exists"));
            return;
        }
        this.lastUiState = null;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        Disposer.register((Disposable)this, (Disposable)disposable2);
        this.contentDisposable = disposable2;
        EmulatorDisplayPanel primaryDisplayPanel = new EmulatorDisplayPanel(disposable2, this.emulator, this.project, SdkConstants.PRIMARY_DISPLAY_ID, null, this.getZoomToolbarVisible$intellij_android_streaming(), deviceFrameVisible);
        ((Map)this.getDisplayPanels()).put(primaryDisplayPanel.getDisplayId(), primaryDisplayPanel);
        EmulatorView emulatorView = (EmulatorView)primaryDisplayPanel.getDisplayView();
        this.setPrimaryDisplayView$intellij_android_streaming(emulatorView);
        DeviceFileDropHandlerKt.installFileDropHandler((JComponent)((Object)this), this.getId().getSerialNumber(), emulatorView, this.project);
        emulatorView.addDisplayConfigurationListener(this.displayConfigurator);
        emulatorView.addPostureListener(new PostureListener(){

            public void postureChanged(EmulatorConfiguration.PostureDescriptor posture) {
                Intrinsics.checkNotNullParameter((Object)posture, (String)"posture");
                ActivityTracker.getInstance().inc();
            }
        });
        this.emulator.addConnectionStateListener(this);
        MultiDisplayState multiDisplayState2 = multiDisplayState = this.multiDisplayStateStorage.getMultiDisplayState(this.getEmulatorId().getAvdId());
        boolean bl = multiDisplayState2 != null ? multiDisplayState2.isInitialized() : false;
        if (bl) {
            try {
                this.displayConfigurator.buildLayout(multiDisplayState);
                var7_7 = Unit.INSTANCE;
            }
            catch (RuntimeException e) {
                EmulatorToolWindowPanelKt.access$getLOG().error("Corrupted multi-display state", (Throwable)e);
                borderLayoutPanel = this.getCenterPanel().addToCenter((Component)((Object)primaryDisplayPanel));
                Intrinsics.checkNotNull((Object)borderLayoutPanel);
                var7_7 = borderLayoutPanel;
            }
        } else {
            var7_7 = this.getCenterPanel().addToCenter((Component)((Object)primaryDisplayPanel));
            Intrinsics.checkNotNull((Object)var7_7);
        }
        this.getMainToolbar().setTargetComponent((JComponent)((Object)emulatorView));
        this.getSecondaryToolbar().setTargetComponent((JComponent)((Object)emulatorView));
        emulatorView.addPropertyChangeListener("displayMode", EmulatorToolWindowPanel::createContent$lambda$1);
        EmulatorUiState emulatorUiState = (EmulatorUiState)savedUiState;
        if (emulatorUiState == null) {
            emulatorUiState = new EmulatorUiState();
        }
        EmulatorUiState uiState = emulatorUiState;
        Int2ObjectRBTreeMap<AbstractDisplayPanel.ZoomScrollState> zoomScrollState = uiState.getZoomScrollState();
        ObjectIterator objectIterator = ((ObjectCollection)this.getDisplayPanels().values()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        borderLayoutPanel = objectIterator;
        while (borderLayoutPanel.hasNext()) {
            AbstractDisplayPanel.ZoomScrollState it;
            EmulatorDisplayPanel panel2 = (EmulatorDisplayPanel)borderLayoutPanel.next();
            if ((AbstractDisplayPanel.ZoomScrollState)zoomScrollState.get(panel2.getDisplayId()) == null) continue;
            boolean bl2 = false;
            panel2.setZoomScrollState$intellij_android_streaming(it);
        }
        this.multiDisplayStateStorage.addUpdater(this.multiDisplayStateUpdater);
        if (this.getConnected()) {
            this.displayConfigurator.refreshDisplayConfiguration();
            if (uiState.getManageSnapshotsDialogShown()) {
                EmulatorManageSnapshotsActionKt.showManageSnapshotsDialog(emulatorView, this.project);
            }
            if (uiState.getExtendedControlsShown()) {
                EmulatorShowExtendedControlsActionKt.showExtendedControls$default(this.emulator, this.project, null, 4, null);
            }
        }
    }

    @Override
    @NotNull
    public EmulatorUiState destroyContent$intellij_android_streaming() {
        DialogWrapper dialogWrapper;
        EmulatorUiState uiState = new EmulatorUiState();
        Disposable disposable = this.contentDisposable;
        if (disposable == null) {
            return uiState;
        }
        Disposable disposable2 = disposable;
        this.contentDisposable = null;
        this.multiDisplayStateUpdater.run();
        this.multiDisplayStateStorage.removeUpdater(this.multiDisplayStateUpdater);
        ObjectIterator objectIterator = ((ObjectCollection)this.getDisplayPanels().values()).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            EmulatorDisplayPanel panel2 = (EmulatorDisplayPanel)objectIterator2.next();
            ((Map)uiState.getZoomScrollState()).put(panel2.getDisplayId(), panel2.getZoomScrollState$intellij_android_streaming());
        }
        EmulatorView emulatorView = this.getPrimaryDisplayView$intellij_android_streaming();
        if (emulatorView != null) {
            EmulatorView it = emulatorView;
            boolean bl = false;
            dialogWrapper = EmulatorManageSnapshotsActionKt.findManageSnapshotDialog(it);
        } else {
            dialogWrapper = null;
        }
        DialogWrapper manageSnapshotsDialog = dialogWrapper;
        uiState.setManageSnapshotsDialogShown(manageSnapshotsDialog != null);
        DialogWrapper dialogWrapper2 = manageSnapshotsDialog;
        if (dialogWrapper2 != null) {
            dialogWrapper2.close(1);
        }
        if (this.getConnected()) {
            this.emulator.closeExtendedControls((StreamObserver<ExtendedControlsStatus>)new EmptyStreamObserver<ExtendedControlsStatus>(uiState){
                final /* synthetic */ EmulatorUiState $uiState;
                {
                    this.$uiState = $uiState;
                }

                public void onNext(ExtendedControlsStatus message) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    EventQueue.invokeLater(() -> destroyContent.1.onNext$lambda$0(this.$uiState, message));
                }

                private static final void onNext$lambda$0(EmulatorUiState $uiState, ExtendedControlsStatus $message) {
                    $uiState.setExtendedControlsShown($message.getVisibilityChanged());
                }
            });
        }
        this.emulator.removeConnectionStateListener(this);
        Disposer.dispose((Disposable)disposable2);
        this.getCenterPanel().removeAll();
        this.getDisplayPanels().clear();
        this.setPrimaryDisplayView$intellij_android_streaming(null);
        this.getMainToolbar().setTargetComponent((JComponent)((Object)this));
        this.getSecondaryToolbar().setTargetComponent((JComponent)((Object)this));
        this.lastUiState = uiState;
        return uiState;
    }

    @Override
    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        sink.set(EmulatorConstants.EMULATOR_CONTROLLER_KEY, (Object)this.emulator);
        sink.set(EmulatorConstants.EMULATOR_VIEW_KEY, (Object)this.getPrimaryDisplayView$intellij_android_streaming());
        sink.set(StreamingConstants.NUMBER_OF_DISPLAYS_KEY, (Object)this.getDisplayPanels().size());
        sink.set(ScreenRecordingParameters.Companion.getDATA_KEY(), (Object)this.getScreenRecorderParameters());
    }

    private final ScreenRecordingParameters getScreenRecorderParameters() {
        return this.emulator.getConnectionState() == EmulatorController.ConnectionState.CONNECTED ? new ScreenRecordingParameters(this.getEmulatorId().getSerialNumber(), this.getEmulatorId().getAvdName(), this.emulator.getEmulatorConfig().getApi(), this.emulator, this.getEmulatorId().getAvdFolder()) : null;
    }

    private static final void multiDisplayStateUpdater$lambda$0(EmulatorToolWindowPanel this$0) {
        this$0.multiDisplayStateStorage.setMultiDisplayState(this$0.getEmulatorId().getAvdId(), this$0.displayConfigurator.getMultiDisplayState());
    }

    private static final void createContent$lambda$1(PropertyChangeEvent it) {
        ActivityTracker.getInstance().inc();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0007H\u0017J\b\u0010\u0011\u001a\u00020\u000eH\u0007J\u0016\u0010\u0012\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u0002J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0013\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001e\u0010\u0013\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u0002J\b\u0010 \u001a\u0004\u0018\u00010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$DisplayConfigurator;", "Lcom/android/tools/idea/streaming/emulator/DisplayConfigurationListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel;Lcom/intellij/openapi/project/Project;)V", "displayDescriptors", "", "Lcom/android/tools/idea/streaming/core/DisplayDescriptor;", "getDisplayDescriptors", "()Ljava/util/List;", "setDisplayDescriptors", "(Ljava/util/List;)V", "displayConfigurationChanged", "", "displayConfigs", "Lcom/android/emulator/control/DisplayConfiguration;", "refreshDisplayConfiguration", "displayConfigurationReceived", "buildLayout", "multiDisplayState", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayState;", "Ljavax/swing/JPanel;", "layoutNode", "Lcom/android/tools/idea/streaming/core/LayoutNode;", "state", "Lcom/android/tools/idea/streaming/core/PanelState;", "setRootPanel", "rootPanel", "emulatorView", "Lcom/android/tools/idea/streaming/emulator/EmulatorView;", "displays", "getMultiDisplayState", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nEmulatorToolWindowPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorToolWindowPanel.kt\ncom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$DisplayConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,505:1\n1557#2:506\n1628#2,3:507\n1557#2:511\n1628#2,3:512\n1755#2,3:515\n1#3:510\n*S KotlinDebug\n*F\n+ 1 EmulatorToolWindowPanel.kt\ncom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$DisplayConfigurator\n*L\n334#1:506\n334#1:507,3\n398#1:511\n398#1:512,3\n326#1:515,3\n*E\n"})
    private final class DisplayConfigurator
    implements DisplayConfigurationListener {
        @NotNull
        private final Project project;
        @NotNull
        private List<DisplayDescriptor> displayDescriptors;

        public DisplayConfigurator(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.displayDescriptors = CollectionsKt.emptyList();
        }

        @NotNull
        public final List<DisplayDescriptor> getDisplayDescriptors() {
            return this.displayDescriptors;
        }

        public final void setDisplayDescriptors(@NotNull List<DisplayDescriptor> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.displayDescriptors = list;
        }

        @Override
        @AnyThread
        public void displayConfigurationChanged(@Nullable List<DisplayConfiguration> displayConfigs) {
            if (displayConfigs == null) {
                this.refreshDisplayConfiguration();
            } else {
                this.displayConfigurationReceived(displayConfigs);
            }
        }

        @AnyThread
        public final void refreshDisplayConfiguration() {
            EmulatorToolWindowPanel.this.getEmulator().getDisplayConfigurations((StreamObserver<DisplayConfigurations>)new EmptyStreamObserver<DisplayConfigurations>(this){
                final /* synthetic */ DisplayConfigurator this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onNext(DisplayConfigurations message) {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    if (((Boolean)StudioFlags.EMBEDDED_EMULATOR_TRACE_GRPC_CALLS.get()).booleanValue()) {
                        EmulatorToolWindowPanelKt.access$getLOG().info("Display configurations: " + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)message)));
                    } else {
                        EmulatorToolWindowPanelKt.access$getLOG().debug("Display configurations: " + TextFormat.shortDebugString((MessageOrBuilder)((MessageOrBuilder)message)));
                    }
                    EventQueue.invokeLater(() -> refreshDisplayConfiguration.1.onNext$lambda$0(this.this$0, message));
                }

                private static final void onNext$lambda$0(DisplayConfigurator this$0, DisplayConfigurations $message) {
                    List list = $message.getDisplaysList();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDisplaysList(...)");
                    DisplayConfigurator.access$displayConfigurationReceived(this$0, list);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void displayConfigurationReceived(List<DisplayConfiguration> displayConfigs) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            EmulatorView emulatorView = EmulatorToolWindowPanel.this.getPrimaryDisplayView$intellij_android_streaming();
            if (emulatorView == null) {
                return;
            }
            EmulatorView primaryDisplayView = emulatorView;
            List<DisplayDescriptor> newDisplays = this.getDisplayDescriptors(primaryDisplayView, displayConfigs);
            if (newDisplays.size() == 1 && this.displayDescriptors.size() <= 1 || Intrinsics.areEqual(newDisplays, this.displayDescriptors)) {
                return;
            }
            EmulatorToolWindowPanel.this.getDisplayPanels().int2ObjectEntrySet().removeIf(arg_0 -> DisplayConfigurator.displayConfigurationReceived$lambda$2(arg_0 -> DisplayConfigurator.displayConfigurationReceived$lambda$1(newDisplays, arg_0), arg_0));
            Iterable iterable = newDisplays;
            Dimension dimension2 = StreamingUtilsKt.getSizeWithoutInsets((Container)EmulatorToolWindowPanel.this.getCenterPanel());
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DisplayDescriptor displayDescriptor = (DisplayDescriptor)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getSize());
            }
            LayoutNode layoutRoot = MultiDisplayLayoutOptimizerKt.computeBestLayout(dimension2, (List)destination$iv$iv);
            JPanel rootPanel = this.buildLayout(layoutRoot, newDisplays);
            this.displayDescriptors = newDisplays;
            this.setRootPanel(rootPanel);
            ActivityTracker.getInstance().inc();
        }

        public final void buildLayout(@NotNull MultiDisplayState multiDisplayState) {
            Intrinsics.checkNotNullParameter((Object)multiDisplayState, (String)"multiDisplayState");
            List<DisplayDescriptor> newDisplays = multiDisplayState.getDisplayDescriptors();
            JPanel rootPanel = this.buildLayout(multiDisplayState.getPanelState(), newDisplays);
            this.displayDescriptors = newDisplays;
            this.setRootPanel(rootPanel);
        }

        private final JPanel buildLayout(LayoutNode layoutNode, List<DisplayDescriptor> displayDescriptors) {
            JPanel jPanel;
            LayoutNode layoutNode2 = layoutNode;
            if (layoutNode2 instanceof LeafNode) {
                DisplayDescriptor display = displayDescriptors.get(((LeafNode)layoutNode).getRectangleIndex());
                int displayId = display.getDisplayId();
                Object object = EmulatorToolWindowPanel.this.getDisplayPanels().computeIfAbsent(displayId, arg_0 -> DisplayConfigurator.buildLayout$lambda$4(EmulatorToolWindowPanel.this, this, display, arg_0));
                Intrinsics.checkNotNull((Object)object);
                jPanel = (JPanel)object;
            } else if (layoutNode2 instanceof SplitNode) {
                SplitPanel splitPanel;
                SplitPanel $this$buildLayout_u24lambda_u245 = splitPanel = new SplitPanel((SplitNode)layoutNode);
                boolean bl = false;
                $this$buildLayout_u24lambda_u245.setFirstComponent(this.buildLayout(((SplitNode)layoutNode).getFirstChild(), displayDescriptors));
                $this$buildLayout_u24lambda_u245.setSecondComponent(this.buildLayout(((SplitNode)layoutNode).getSecondChild(), displayDescriptors));
                jPanel = splitPanel;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return jPanel;
        }

        private final JPanel buildLayout(PanelState state2, List<DisplayDescriptor> displayDescriptors) {
            JPanel jPanel;
            PanelState.SplitPanelState splitPanelState = state2.getSplitPanel();
            if (splitPanelState != null) {
                SplitPanel splitPanel;
                SplitPanel $this$buildLayout_u24lambda_u246 = splitPanel = new SplitPanel(splitPanelState.getSplitType(), splitPanelState.getProportion());
                boolean bl = false;
                $this$buildLayout_u24lambda_u246.setFirstComponent(this.buildLayout(splitPanelState.getFirstComponent(), displayDescriptors));
                $this$buildLayout_u24lambda_u246.setSecondComponent(this.buildLayout(splitPanelState.getSecondComponent(), displayDescriptors));
                jPanel = splitPanel;
            } else {
                Object v2;
                int displayId;
                block5: {
                    Integer n = state2.getDisplayId();
                    if (n == null) {
                        throw new IllegalArgumentException();
                    }
                    displayId = n;
                    Iterable iterable = displayDescriptors;
                    for (Object t : iterable) {
                        DisplayDescriptor it = (DisplayDescriptor)t;
                        boolean bl = false;
                        if (!(it.getDisplayId() == displayId)) continue;
                        v2 = t;
                        break block5;
                    }
                    v2 = null;
                }
                DisplayDescriptor displayDescriptor = v2;
                if (displayDescriptor == null) {
                    throw new IllegalArgumentException();
                }
                DisplayDescriptor display = displayDescriptor;
                Object object = EmulatorToolWindowPanel.this.getDisplayPanels().computeIfAbsent(displayId, arg_0 -> DisplayConfigurator.buildLayout$lambda$8(EmulatorToolWindowPanel.this, this, display, arg_0));
                Intrinsics.checkNotNull((Object)object);
                jPanel = (JPanel)object;
            }
            return jPanel;
        }

        private final void setRootPanel(JPanel rootPanel) {
            EmulatorToolWindowPanel.this.getCenterPanel().removeAll();
            EmulatorToolWindowPanel.this.getCenterPanel().addToCenter((Component)rootPanel);
            EmulatorToolWindowPanel.this.getCenterPanel().validate();
            ActivityTracker.getInstance().inc();
        }

        /*
         * WARNING - void declaration
         */
        private final List<DisplayDescriptor> getDisplayDescriptors(EmulatorView emulatorView, List<DisplayConfiguration> displays) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = displays;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DisplayConfiguration displayConfiguration = (DisplayConfiguration)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getDisplay() == SdkConstants.PRIMARY_DISPLAY_ID ? new DisplayDescriptor(SdkConstants.PRIMARY_DISPLAY_ID, emulatorView.getDisplaySizeWithFrame(), 0, null, 12, null) : EmulatorToolWindowPanelKt.access$toDisplayDescriptor((DisplayConfiguration)it));
            }
            return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        }

        @Nullable
        public final MultiDisplayState getMultiDisplayState() {
            Component panel2;
            if (EmulatorToolWindowPanel.this.getCenterPanel().getComponentCount() > 0 && (panel2 = EmulatorToolWindowPanel.this.getCenterPanel().getComponent(0)) instanceof SplitPanel) {
                return new MultiDisplayState(CollectionsKt.toMutableList((Collection)this.displayDescriptors), ((SplitPanel)panel2).getState());
            }
            return null;
        }

        private static final boolean displayConfigurationReceived$lambda$1(List $newDisplays, Int2ObjectMap.Entry entry) {
            boolean bl;
            boolean bl2;
            EmulatorDisplayPanel displayPanel;
            block5: {
                Intrinsics.checkNotNull((Object)entry);
                Integer displayId = (Integer)((Map.Entry)entry).getKey();
                displayPanel = (EmulatorDisplayPanel)((Map.Entry)entry).getValue();
                Iterable $this$any$iv = $newDisplays;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DisplayDescriptor it = (DisplayDescriptor)element$iv;
                        boolean bl3 = false;
                        Integer n = displayId;
                        if (!(n != null && it.getDisplayId() == n.intValue())) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) {
                Disposer.dispose((Disposable)displayPanel);
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        private static final boolean displayConfigurationReceived$lambda$2(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final EmulatorDisplayPanel buildLayout$lambda$4(EmulatorToolWindowPanel this$0, DisplayConfigurator this$1, DisplayDescriptor $display, int it) {
            boolean bl;
            boolean bl2 = bl = it != SdkConstants.PRIMARY_DISPLAY_ID;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Disposable disposable = this$0.contentDisposable;
            Intrinsics.checkNotNull((Object)disposable);
            return new EmulatorDisplayPanel(disposable, this$0.getEmulator(), this$1.project, it, $display.getSize(), this$0.getZoomToolbarVisible$intellij_android_streaming(), false, 64, null);
        }

        private static final EmulatorDisplayPanel buildLayout$lambda$8(EmulatorToolWindowPanel this$0, DisplayConfigurator this$1, DisplayDescriptor $display, int it) {
            boolean bl;
            boolean bl2 = bl = it != SdkConstants.PRIMARY_DISPLAY_ID;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Disposable disposable = this$0.contentDisposable;
            Intrinsics.checkNotNull((Object)disposable);
            return new EmulatorDisplayPanel(disposable, this$0.getEmulator(), this$1.project, it, $display.getSize(), this$0.getZoomToolbarVisible$intellij_android_streaming(), false, 64, null);
        }

        public static final /* synthetic */ void access$displayConfigurationReceived(DisplayConfigurator $this, List displayConfigs) {
            $this.displayConfigurationReceived(displayConfigs);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$EmulatorUiState;", "Lcom/android/tools/idea/streaming/core/StreamingDevicePanel$UiState;", "<init>", "()V", "manageSnapshotsDialogShown", "", "getManageSnapshotsDialogShown", "()Z", "setManageSnapshotsDialogShown", "(Z)V", "extendedControlsShown", "getExtendedControlsShown", "setExtendedControlsShown", "zoomScrollState", "Lit/unimi/dsi/fastutil/ints/Int2ObjectRBTreeMap;", "Lcom/android/tools/idea/streaming/core/AbstractDisplayPanel$ZoomScrollState;", "getZoomScrollState", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectRBTreeMap;", "intellij.android.streaming"})
    public static final class EmulatorUiState
    implements StreamingDevicePanel.UiState {
        private boolean manageSnapshotsDialogShown;
        private boolean extendedControlsShown;
        @NotNull
        private final Int2ObjectRBTreeMap<AbstractDisplayPanel.ZoomScrollState> zoomScrollState = new Int2ObjectRBTreeMap();

        public final boolean getManageSnapshotsDialogShown() {
            return this.manageSnapshotsDialogShown;
        }

        public final void setManageSnapshotsDialogShown(boolean bl) {
            this.manageSnapshotsDialogShown = bl;
        }

        public final boolean getExtendedControlsShown() {
            return this.extendedControlsShown;
        }

        public final void setExtendedControlsShown(boolean bl) {
            this.extendedControlsShown = bl;
        }

        @NotNull
        public final Int2ObjectRBTreeMap<AbstractDisplayPanel.ZoomScrollState> getZoomScrollState() {
            return this.zoomScrollState;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u001f\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0013\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayState;", "", "<init>", "()V", "displayDescriptors", "", "Lcom/android/tools/idea/streaming/core/DisplayDescriptor;", "panelState", "Lcom/android/tools/idea/streaming/core/PanelState;", "(Ljava/util/List;Lcom/android/tools/idea/streaming/core/PanelState;)V", "getDisplayDescriptors", "()Ljava/util/List;", "setDisplayDescriptors", "(Ljava/util/List;)V", "getPanelState", "()Lcom/android/tools/idea/streaming/core/PanelState;", "setPanelState", "(Lcom/android/tools/idea/streaming/core/PanelState;)V", "isInitialized", "", "equals", "other", "hashCode", "", "intellij.android.streaming"})
    public static final class MultiDisplayState {
        public List<DisplayDescriptor> displayDescriptors;
        public PanelState panelState;

        public MultiDisplayState() {
        }

        @NotNull
        public final List<DisplayDescriptor> getDisplayDescriptors() {
            List<DisplayDescriptor> list = this.displayDescriptors;
            if (list != null) {
                return list;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayDescriptors");
            return null;
        }

        public final void setDisplayDescriptors(@NotNull List<DisplayDescriptor> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.displayDescriptors = list;
        }

        @NotNull
        public final PanelState getPanelState() {
            PanelState panelState = this.panelState;
            if (panelState != null) {
                return panelState;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"panelState");
            return null;
        }

        public final void setPanelState(@NotNull PanelState panelState) {
            Intrinsics.checkNotNullParameter((Object)panelState, (String)"<set-?>");
            this.panelState = panelState;
        }

        public MultiDisplayState(@NotNull List<DisplayDescriptor> displayDescriptors, @NotNull PanelState panelState) {
            Intrinsics.checkNotNullParameter(displayDescriptors, (String)"displayDescriptors");
            Intrinsics.checkNotNullParameter((Object)panelState, (String)"panelState");
            this();
            this.setDisplayDescriptors(displayDescriptors);
            this.setPanelState(panelState);
        }

        public final boolean isInitialized() {
            return this.displayDescriptors != null && this.panelState != null;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.android.tools.idea.streaming.emulator.EmulatorToolWindowPanel.MultiDisplayState");
            MultiDisplayState cfr_ignored_0 = (MultiDisplayState)other;
            return Intrinsics.areEqual(this.getDisplayDescriptors(), ((MultiDisplayState)other).getDisplayDescriptors()) && Intrinsics.areEqual((Object)this.getPanelState(), (Object)((MultiDisplayState)other).getPanelState());
        }

        public int hashCode() {
            return HashCodes.mix((int)((Object)this.getDisplayDescriptors()).hashCode(), (int)this.getPanelState().hashCode());
        }
    }

    @Service(value={Service.Level.PROJECT})
    @State(name="EmulatorDisplays", storages={@Storage(value="emulatorDisplays.xml")})
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0000H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000H\u0016J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000eJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0006J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007R(\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayStateStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "<init>", "()V", "displayStateByAvdFolder", "", "", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayState;", "getDisplayStateByAvdFolder", "()Ljava/util/Map;", "setDisplayStateByAvdFolder", "(Ljava/util/Map;)V", "updaters", "", "Ljava/lang/Runnable;", "getState", "loadState", "", "state", "addUpdater", "updater", "removeUpdater", "getMultiDisplayState", "avdId", "setMultiDisplayState", "Companion", "intellij.android.streaming"})
    public static final class MultiDisplayStateStorage
    implements PersistentStateComponent<MultiDisplayStateStorage> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private Map<String, MultiDisplayState> displayStateByAvdFolder = new LinkedHashMap();
        @NotNull
        private final List<Runnable> updaters = new ArrayList();

        @Property(surroundWithTag=true)
        @NotNull
        public final Map<String, MultiDisplayState> getDisplayStateByAvdFolder() {
            return this.displayStateByAvdFolder;
        }

        public final void setDisplayStateByAvdFolder(@NotNull Map<String, MultiDisplayState> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.displayStateByAvdFolder = map2;
        }

        @NotNull
        public MultiDisplayStateStorage getState() {
            for (Runnable updater : this.updaters) {
                updater.run();
            }
            return this;
        }

        public void loadState(@NotNull MultiDisplayStateStorage state2) {
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            XmlSerializerUtil.copyBean((Object)state2, (Object)this);
        }

        public final void addUpdater(@NotNull Runnable updater) {
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            this.updaters.add(updater);
        }

        public final void removeUpdater(@NotNull Runnable updater) {
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            this.updaters.remove(updater);
        }

        @Nullable
        public final MultiDisplayState getMultiDisplayState(@NotNull String avdId) {
            Intrinsics.checkNotNullParameter((Object)avdId, (String)"avdId");
            return this.displayStateByAvdFolder.get(avdId);
        }

        public final void setMultiDisplayState(@NotNull String avdId, @Nullable MultiDisplayState state2) {
            Intrinsics.checkNotNullParameter((Object)avdId, (String)"avdId");
            if (state2 == null) {
                this.displayStateByAvdFolder.remove(avdId);
            } else {
                this.displayStateByAvdFolder.put(avdId, state2);
            }
        }

        @JvmStatic
        @NotNull
        public static final MultiDisplayStateStorage getInstance(@NotNull Project project) {
            return Companion.getInstance(project);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayStateStorage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/streaming/emulator/EmulatorToolWindowPanel$MultiDisplayStateStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.streaming"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final MultiDisplayStateStorage getInstance(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Object object = project.getService(MultiDisplayStateStorage.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
                return (MultiDisplayStateStorage)object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

