/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import com.android.emulator.control.InputEvent;
import com.android.emulator.control.KeyboardEvent;
import com.android.tools.idea.streaming.emulator.EmulatorController;
import com.android.tools.idea.streaming.emulator.EmulatorKeyStroke;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001e\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0000\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002\" \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"sendKeyStroke", "", "Lcom/android/tools/idea/streaming/emulator/EmulatorController;", "keyStroke", "Lcom/android/tools/idea/streaming/emulator/EmulatorKeyStroke;", "sendKeyEvent", "keyName", "", "eventType", "Lcom/android/emulator/control/KeyboardEvent$KeyEventType;", "sendTypedText", "text", "pressModifierKeys", "modifiers", "", "releaseModifierKeys", "EMULATOR_MODIFIER_KEYS", "", "Lkotlin/Pair;", "intellij.android.streaming"})
public final class EmulatorKeyStrokeKt {
    @NotNull
    private static final List<Pair<Integer, String>> EMULATOR_MODIFIER_KEYS;

    public static final void sendKeyStroke(@NotNull EmulatorController $this$sendKeyStroke, @NotNull EmulatorKeyStroke keyStroke) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$sendKeyStroke), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
        EmulatorKeyStrokeKt.pressModifierKeys($this$sendKeyStroke, keyStroke.getModifiers());
        EmulatorKeyStrokeKt.sendKeyEvent$default($this$sendKeyStroke, keyStroke.getKeyName(), null, 2, null);
        EmulatorKeyStrokeKt.releaseModifierKeys($this$sendKeyStroke, keyStroke.getModifiers());
    }

    public static final void sendKeyEvent(@NotNull EmulatorController $this$sendKeyEvent, @NotNull String keyName, @NotNull KeyboardEvent.KeyEventType eventType) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$sendKeyEvent), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)keyName, (String)"keyName");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        InputEvent.Builder inputEvent = InputEvent.newBuilder().setKeyEvent(KeyboardEvent.newBuilder().setKey(keyName).setEventType(eventType));
        $this$sendKeyEvent.getOrCreateInputEventSender().onNext((Object)inputEvent.build());
    }

    public static /* synthetic */ void sendKeyEvent$default(EmulatorController emulatorController, String string, KeyboardEvent.KeyEventType keyEventType, int n, Object object) {
        if ((n & 2) != 0) {
            keyEventType = KeyboardEvent.KeyEventType.keypress;
        }
        EmulatorKeyStrokeKt.sendKeyEvent(emulatorController, string, keyEventType);
    }

    public static final void sendTypedText(@NotNull EmulatorController $this$sendTypedText, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$sendTypedText), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        InputEvent.Builder inputEvent = InputEvent.newBuilder().setKeyEvent(KeyboardEvent.newBuilder().setText(text2));
        $this$sendTypedText.getOrCreateInputEventSender().onNext((Object)inputEvent.build());
    }

    private static final void pressModifierKeys(EmulatorController $this$pressModifierKeys, int modifiers) {
        if (modifiers != 0) {
            int currentModifiers = 0;
            InputEvent.Builder inputEvent = InputEvent.newBuilder();
            KeyboardEvent.Builder keyboardEvent = inputEvent.getKeyEventBuilder().setEventType(KeyboardEvent.KeyEventType.keydown);
            for (Pair<Integer, String> pair : EMULATOR_MODIFIER_KEYS) {
                int modifier = ((Number)pair.component1()).intValue();
                String key = (String)pair.component2();
                if ((modifiers & modifier) == 0) continue;
                keyboardEvent.setKey(key);
                $this$pressModifierKeys.getOrCreateInputEventSender().onNext((Object)inputEvent.build());
                if ((currentModifiers |= modifier) != modifiers) continue;
                break;
            }
        }
    }

    private static final void releaseModifierKeys(EmulatorController $this$releaseModifierKeys, int modifiers) {
        if (modifiers != 0) {
            int currentModifiers = modifiers;
            InputEvent.Builder inputEvent = InputEvent.newBuilder();
            KeyboardEvent.Builder keyboardEvent = inputEvent.getKeyEventBuilder().setEventType(KeyboardEvent.KeyEventType.keyup);
            for (Pair pair : CollectionsKt.asReversed(EMULATOR_MODIFIER_KEYS)) {
                int modifier = ((Number)pair.component1()).intValue();
                String key = (String)pair.component2();
                if ((currentModifiers & modifier) == 0) continue;
                keyboardEvent.setKey(key);
                $this$releaseModifierKeys.getOrCreateInputEventSender().onNext((Object)inputEvent.build());
                if ((currentModifiers &= ~modifier) != 0) continue;
                break;
            }
        }
    }

    static {
        Object[] objectArray = new Pair[]{new Pair((Object)512, (Object)"Alt"), new Pair((Object)64, (Object)"Shift"), new Pair((Object)128, (Object)"Control"), new Pair((Object)256, (Object)"Meta")};
        EMULATOR_MODIFIER_KEYS = CollectionsKt.listOf((Object[])objectArray);
    }
}

