/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.emulator;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u00a8\u0006\u0004"}, d2={"decodeCommandLine", "", "", "commandLine", "intellij.android.streaming"})
@JvmName(name="CommandLineDecoderUtils")
public final class CommandLineDecoderUtils {
    @NotNull
    public static final List<String> decodeCommandLine(@NotNull String commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ArrayList<String> args = new ArrayList<String>(16);
        StringBuilder argBuilder = new StringBuilder();
        boolean insideArgument = false;
        boolean quoted = false;
        boolean escaped = false;
        String string = ((Object)StringsKt.trimStart((CharSequence)commandLine)).toString();
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (insideArgument) {
                if (escaped) {
                    argBuilder.append(c);
                    escaped = false;
                    continue;
                }
                if (quoted && c == '\"' || !quoted && CharsKt.isWhitespace((char)c)) {
                    args.add(argBuilder.toString());
                    StringsKt.clear((StringBuilder)argBuilder);
                    insideArgument = false;
                    quoted = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                argBuilder.append(c);
                continue;
            }
            if (CharsKt.isWhitespace((char)c)) continue;
            insideArgument = true;
            switch (c) {
                case '\"': {
                    quoted = true;
                    continue block4;
                }
                case '\\': {
                    escaped = true;
                    continue block4;
                }
                default: {
                    argBuilder.append(c);
                }
            }
        }
        if (((CharSequence)argBuilder).length() > 0) {
            args.add(argBuilder.toString());
        }
        return args;
    }
}

