/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.SdkConstants;
import com.android.annotations.concurrency.AnyThread;
import com.android.sdklib.deviceprovisioner.DeviceProperties;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.util.AwtUtilsKt;
import com.android.tools.idea.streaming.core.StreamingUtilsKt;
import com.android.tools.idea.streaming.device.BitRateManager;
import com.android.tools.idea.streaming.device.DeviceStreamingSessionTracker;
import com.android.tools.idea.streaming.device.InvalidFrameException;
import com.android.tools.idea.streaming.device.SuspendingSocketChannel;
import com.android.tools.idea.streaming.device.VideoDecoder;
import com.android.tools.idea.streaming.device.VideoDecoderException;
import com.android.tools.idea.streaming.device.VideoDecoderKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IoKt;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.UInt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParserContext;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avutil.AVFrame;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.ffmpeg.global.swscale;
import org.bytedeco.ffmpeg.swscale.SwsContext;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0005)*+,-B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000eJ\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000eJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010!\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0007J\u000e\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0014J\u000e\u0010'\u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u000fR\u00020\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder;", "", "videoChannel", "Lcom/android/tools/idea/streaming/device/SuspendingSocketChannel;", "decoderScope", "Lkotlinx/coroutines/CoroutineScope;", "deviceProperties", "Lcom/android/sdklib/deviceprovisioner/DeviceProperties;", "streamingSessionTracker", "Lcom/android/tools/idea/streaming/device/DeviceStreamingSessionTracker;", "<init>", "(Lcom/android/tools/idea/streaming/device/SuspendingSocketChannel;Lkotlinx/coroutines/CoroutineScope;Lcom/android/sdklib/deviceprovisioner/DeviceProperties;Lcom/android/tools/idea/streaming/device/DeviceStreamingSessionTracker;)V", "decodingContexts", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/android/tools/idea/streaming/device/VideoDecoder$DecodingContext;", "codec", "Lkotlinx/coroutines/CompletableDeferred;", "Lorg/bytedeco/ffmpeg/avcodec/AVCodec;", "endOfVideoStream", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "enableDecodingForDisplay", "displayId", "disableDecodingForDisplay", "addFrameListener", "", "listener", "Lcom/android/tools/idea/streaming/device/VideoDecoder$FrameListener;", "removeFrameListener", "consumeDisplayFrame", "consumer", "Ljava/util/function/Consumer;", "Lcom/android/tools/idea/streaming/device/VideoDecoder$VideoFrame;", "start", "enableDecodingForPrimaryDisplay", "readChannelHeaderAndInitializeCodec", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "FrameListener", "VideoFrame", "PacketReader", "DecodingContext", "VideoPacketHeader", "intellij.android.streaming"})
@SourceDebugExtension(value={"SMAP\nVideoDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoDecoder.kt\ncom/android/tools/idea/streaming/device/VideoDecoder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,668:1\n25#2:669\n62#2,5:670\n*S KotlinDebug\n*F\n+ 1 VideoDecoder.kt\ncom/android/tools/idea/streaming/device/VideoDecoder\n*L\n114#1:669\n198#1:670,5\n*E\n"})
public final class VideoDecoder {
    @NotNull
    private final SuspendingSocketChannel videoChannel;
    @NotNull
    private final CoroutineScope decoderScope;
    @NotNull
    private final DeviceProperties deviceProperties;
    @NotNull
    private final DeviceStreamingSessionTracker streamingSessionTracker;
    @NotNull
    private final ConcurrentHashMap<Integer, DecodingContext> decodingContexts;
    @NotNull
    private final CompletableDeferred<AVCodec> codec;
    private volatile boolean endOfVideoStream;

    public VideoDecoder(@NotNull SuspendingSocketChannel videoChannel, @NotNull CoroutineScope decoderScope, @NotNull DeviceProperties deviceProperties, @NotNull DeviceStreamingSessionTracker streamingSessionTracker) {
        Intrinsics.checkNotNullParameter((Object)videoChannel, (String)"videoChannel");
        Intrinsics.checkNotNullParameter((Object)decoderScope, (String)"decoderScope");
        Intrinsics.checkNotNullParameter((Object)deviceProperties, (String)"deviceProperties");
        Intrinsics.checkNotNullParameter((Object)streamingSessionTracker, (String)"streamingSessionTracker");
        this.videoChannel = videoChannel;
        this.decoderScope = decoderScope;
        this.deviceProperties = deviceProperties;
        this.streamingSessionTracker = streamingSessionTracker;
        this.decodingContexts = new ConcurrentHashMap();
        this.codec = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }

    private final Logger getLogger() {
        VideoDecoder $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(VideoDecoder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    public final boolean enableDecodingForDisplay(int displayId) {
        Ref.BooleanRef decodingContextAdded = new Ref.BooleanRef();
        this.decodingContexts.computeIfAbsent(displayId, arg_0 -> VideoDecoder.enableDecodingForDisplay$lambda$1(arg_0 -> VideoDecoder.enableDecodingForDisplay$lambda$0(decodingContextAdded, this, arg_0), arg_0));
        if (decodingContextAdded.element && this.endOfVideoStream) {
            this.disableDecodingForDisplay(displayId);
            decodingContextAdded.element = false;
        }
        return decodingContextAdded.element;
    }

    public final boolean disableDecodingForDisplay(int displayId) {
        Unit unit;
        DecodingContext decodingContext = this.decodingContexts.remove(displayId);
        if (decodingContext != null) {
            decodingContext.closeAsynchronously();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit != null;
    }

    public final void addFrameListener(int displayId, @NotNull FrameListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        if (!this.endOfVideoStream) {
            DecodingContext decodingContext = this.decodingContexts.get(displayId);
            if (decodingContext != null) {
                decodingContext.addFrameListener(listener2);
            } else {
                throw new IllegalStateException("Not processing video from display " + displayId);
            }
        }
    }

    public final void removeFrameListener(int displayId, @NotNull FrameListener listener2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            DecodingContext decodingContext = this.decodingContexts.get(displayId);
            if (decodingContext == null) break block0;
            decodingContext.removeFrameListener(listener2);
        }
    }

    @AnyThread
    public final void consumeDisplayFrame(int displayId, @NotNull Consumer<VideoFrame> consumer2) {
        block0: {
            Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
            DecodingContext decodingContext = this.decodingContexts.get(displayId);
            if (decodingContext == null) break block0;
            decodingContext.consumeDisplayFrame(consumer2);
        }
    }

    public final void start(boolean enableDecodingForPrimaryDisplay) {
        if (enableDecodingForPrimaryDisplay) {
            ((Map)this.decodingContexts).put(SdkConstants.PRIMARY_DISPLAY_ID, new DecodingContext(SdkConstants.PRIMARY_DISPLAY_ID));
        }
        BuildersKt.launch$default((CoroutineScope)this.decoderScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ VideoDecoder this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = VideoDecoder.access$readChannelHeaderAndInitializeCodec(this.this$0, (Continuation)this);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        packetReader = this.this$0.new PacketReader();
                        try {
                        }
                        catch (ClosedChannelException var3_4) {
                            VideoDecoder.access$setEndOfVideoStream$p(this.this$0, true);
                            var3_5 = VideoDecoder.access$getDecodingContexts$p(this.this$0).values().iterator();
                            while (true) {
                                if (!var3_5.hasNext()) {
                                    VideoDecoder.access$getDecodingContexts$p(this.this$0).clear();
                                    packetReader.close();
                                    return Unit.INSTANCE;
                                }
                                v1 = var3_5.next();
                                Intrinsics.checkNotNullExpressionValue(v1, (String)"next(...)");
                                decodingContext = (DecodingContext)v1;
                                decodingContext.close();
                            }
                        }
                        catch (EOFException var3_6) {
                            VideoDecoder.access$setEndOfVideoStream$p(this.this$0, true);
                            var3_7 = VideoDecoder.access$getDecodingContexts$p(this.this$0).values().iterator();
                            while (true) {
                                if (!var3_7.hasNext()) {
                                    VideoDecoder.access$getDecodingContexts$p(this.this$0).clear();
                                    packetReader.close();
                                    return Unit.INSTANCE;
                                }
                                v2 = var3_7.next();
                                Intrinsics.checkNotNullExpressionValue(v2, (String)"next(...)");
                                decodingContext = (DecodingContext)v2;
                                decodingContext.close();
                            }
                            catch (CancellationException e) {
                                throw e;
                                catch (Throwable e) {
                                    VideoDecoder.access$getLogger(this.this$0).error(e);
                                    return Unit.INSTANCE;
                                }
                            }
                        }
lbl52:
                        // 2 sources

                        while (true) {
                            this.L$0 = packetReader;
                            this.label = 2;
                            v3 = packetReader.readAndProcessPacket((Continuation<? super Unit>)((Continuation)this));
                            if (v3 != var6_2) continue;
                            return var6_2;
                        }
                    }
                    case 2: {
                        packetReader = (PacketReader)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                            ** continue;
                        }
                    }
                }
                finally {
                    VideoDecoder.access$setEndOfVideoStream$p(this.this$0, true);
                    var3_10 = VideoDecoder.access$getDecodingContexts$p(this.this$0).values().iterator();
                    while (true) {
                        if (!var3_10.hasNext()) {
                            VideoDecoder.access$getDecodingContexts$p(this.this$0).clear();
                            packetReader.close();
                        }
                        v4 = var3_10.next();
                        Intrinsics.checkNotNullExpressionValue(v4, (String)"next(...)");
                        decodingContext = (DecodingContext)v4;
                        decodingContext.close();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object readChannelHeaderAndInitializeCodec(Continuation<? super Unit> $completion) {
        if (!($completion instanceof readChannelHeaderAndInitializeCodec.1)) ** GOTO lbl-1000
        var10_2 = $completion;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ VideoDecoder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VideoDecoder.access$readChannelHeaderAndInitializeCodec(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                header = ByteBuffer.allocate(20);
                Intrinsics.checkNotNull((Object)header);
                $continuation.L$0 = header;
                $continuation.label = 1;
                v0 = SuspendingSocketChannel.readFully$default(this.videoChannel, header, 0L, null, (Continuation)$continuation, 6, null);
                if (v0 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                header = (ByteBuffer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                var4_6 = header.array();
                Intrinsics.checkNotNullExpressionValue((Object)var4_6, (String)"array(...)");
                var5_7 = Charsets.UTF_8;
                codecName = StringsKt.trim((CharSequence)new String(var4_6, (Charset)var5_7)).toString();
                $this$debug_u24default$iv = this.getLogger();
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    var8_10 = $this$debug_u24default$iv;
                    $i$a$-debug$default-VideoDecoder$readChannelHeaderAndInitializeCodec$2 = false;
                    var8_10.debug("Receiving " + codecName + " video stream", e$iv);
                }
                var5_7 = codecName;
                ffmpegCodecName = Intrinsics.areEqual((Object)var5_7, (Object)"av01") != false ? "av1" : (Intrinsics.areEqual((Object)var5_7, (Object)"avc") != false ? "h264" : var3_8);
                v1 = avcodec.avcodec_find_decoder_by_name((String)ffmpegCodecName);
                if (v1 == null) {
                    throw new VideoDecoderException(ffmpegCodecName + " decoder not found");
                }
                this.codec.complete((Object)v1);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final DecodingContext enableDecodingForDisplay$lambda$0(Ref.BooleanRef $decodingContextAdded, VideoDecoder this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $decodingContextAdded.element = true;
        return this$0.new DecodingContext(SdkConstants.PRIMARY_DISPLAY_ID);
    }

    private static final DecodingContext enableDecodingForDisplay$lambda$1(Function1 $tmp0, Object p0) {
        return (DecodingContext)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$readChannelHeaderAndInitializeCodec(VideoDecoder $this, Continuation $completion) {
        return $this.readChannelHeaderAndInitializeCodec((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$setEndOfVideoStream$p(VideoDecoder $this, boolean bl) {
        $this.endOfVideoStream = bl;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getDecodingContexts$p(VideoDecoder $this) {
        return $this.decodingContexts;
    }

    public static final /* synthetic */ SuspendingSocketChannel access$getVideoChannel$p(VideoDecoder $this) {
        return $this.videoChannel;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\"J\u000e\u0010,\u001a\u00020*2\u0006\u0010+\u001a\u00020\"J\u0014\u0010-\u001a\u00020*2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0/J\u0006\u00100\u001a\u00020*J\b\u00101\u001a\u00020*H\u0016J\u0016\u00102\u001a\u00020*2\u0006\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u000205J\u000e\u00106\u001a\u00020*2\u0006\u00104\u001a\u000205J\u0018\u00107\u001a\u00020*2\u0006\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u000205H\u0002J\u0018\u00108\u001a\u00020*2\u0006\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u000205H\u0002J*\u00109\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u00042\b\u0010<\u001a\u0004\u0018\u00010=H\u0002J\u0010\u0010>\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0018\u0010?\u001a\u00020\u00132\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u0004H\u0002J\b\u0010@\u001a\u00020*H\u0002J\b\u0010A\u001a\u00020*H\u0002J\u0010\u0010B\u001a\u00020*2\u0006\u0010C\u001a\u00020DH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR:\u0010 \u001a.\u0012\f\u0012\n #*\u0004\u0018\u00010\"0\" #*\u0015\u0012\f\u0012\n #*\u0004\u0018\u00010\"0\"0%\u00a2\u0006\u0002\b$0!\u00a2\u0006\u0002\b$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder$DecodingContext;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "displayId", "", "<init>", "(Lcom/android/tools/idea/streaming/device/VideoDecoder;I)V", "getDisplayId", "()I", "value", "Lcom/android/tools/idea/streaming/device/VideoDecoder$VideoFrame;", "displayFrame", "getDisplayFrame", "()Lcom/android/tools/idea/streaming/device/VideoDecoder$VideoFrame;", "imageLock", "", "codecContext", "Lorg/bytedeco/ffmpeg/avcodec/AVCodecContext;", "decodingFrame", "Lorg/bytedeco/ffmpeg/avutil/AVFrame;", "renderingFrame", "swsContext", "Lorg/bytedeco/ffmpeg/swscale/SwsContext;", "parserContext", "Lorg/bytedeco/ffmpeg/avcodec/AVCodecParserContext;", "pendingPacket", "Lorg/bytedeco/ffmpeg/avcodec/AVPacket;", "hasPendingPacket", "", "framesAtBitRate", "initialized", "Ljava/lang/Boolean;", "frameListeners", "", "Lcom/android/tools/idea/streaming/device/VideoDecoder$FrameListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "ensureInitialized", "codec", "Lorg/bytedeco/ffmpeg/avcodec/AVCodec;", "addFrameListener", "", "listener", "removeFrameListener", "consumeDisplayFrame", "consumer", "Ljava/util/function/Consumer;", "closeAsynchronously", "close", "processPacket", "packet", "header", "Lcom/android/tools/idea/streaming/device/VideoDecoder$VideoPacketHeader;", "processEmptyPacket", "processDataPacket", "processFrame", "createFrameForDisplay", "width", "height", "pixels", "Ljava/nio/IntBuffer;", "getSwsContext", "createRenderingFrame", "onNewFrameAvailable", "onEndOfVideoStream", "onInvalidFrame", "e", "Lcom/android/tools/idea/streaming/device/InvalidFrameException;", "intellij.android.streaming"})
    @SourceDebugExtension(value={"SMAP\nVideoDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoDecoder.kt\ncom/android/tools/idea/streaming/device/VideoDecoder$DecodingContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,668:1\n1#2:669\n*E\n"})
    private final class DecodingContext
    implements AutoCloseable {
        private final int displayId;
        @Nullable
        private VideoFrame displayFrame;
        @NotNull
        private final Object imageLock;
        private AVCodecContext codecContext;
        private AVFrame decodingFrame;
        @Nullable
        private AVFrame renderingFrame;
        @Nullable
        private SwsContext swsContext;
        private AVCodecParserContext parserContext;
        @NotNull
        private final AVPacket pendingPacket;
        private boolean hasPendingPacket;
        private int framesAtBitRate;
        @Nullable
        private Boolean initialized;
        @NotNull
        private final List<FrameListener> frameListeners;

        public DecodingContext(int displayId) {
            this.displayId = displayId;
            this.imageLock = new Object();
            AVPacket aVPacket = avcodec.av_packet_alloc();
            Intrinsics.checkNotNullExpressionValue((Object)aVPacket, (String)"av_packet_alloc(...)");
            this.pendingPacket = aVPacket;
            this.initialized = false;
            List list = ContainerUtil.createLockFreeCopyOnWriteList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
            this.frameListeners = list;
            avutil.av_log_set_level((int)-8);
            BuildersKt.launch$default((CoroutineScope)VideoDecoder.this.decoderScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, VideoDecoder.this, null){
                Object L$0;
                int label;
                final /* synthetic */ DecodingContext this$0;
                final /* synthetic */ VideoDecoder this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = this.this$0;
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = VideoDecoder.access$getCodec$p(this.this$1).await((Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            var2_3 = (DecodingContext)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            DecodingContext.access$ensureInitialized(var2_3, (AVCodec)v0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public final int getDisplayId() {
            return this.displayId;
        }

        @Nullable
        public final VideoFrame getDisplayFrame() {
            return this.displayFrame;
        }

        private final synchronized boolean ensureInitialized(AVCodec codec) {
            Boolean bl = this.initialized;
            if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                return true;
            }
            if (bl == null) {
                return false;
            }
            AVCodecContext codecContext = null;
            AVCodecParserContext parserContext = null;
            try {
                AVCodecParserContext aVCodecParserContext;
                AVCodecContext aVCodecContext = avcodec.avcodec_alloc_context3((AVCodec)codec);
                if (aVCodecContext == null) {
                    throw new VideoDecoderException("Display " + this.displayId + ": could not allocate decoder context");
                }
                codecContext = aVCodecContext;
                AVCodecParserContext aVCodecParserContext2 = avcodec.av_parser_init((int)codec.id());
                if (aVCodecParserContext2 == null) {
                    throw new VideoDecoderException("Display " + this.displayId + ": could not initialize parser");
                }
                AVCodecParserContext $this$ensureInitialized_u24lambda_u240 = aVCodecParserContext = aVCodecParserContext2;
                boolean bl2 = false;
                $this$ensureInitialized_u24lambda_u240.flags($this$ensureInitialized_u24lambda_u240.flags() | 1);
                parserContext = aVCodecParserContext;
                if (avcodec.avcodec_open2((AVCodecContext)codecContext, (AVCodec)codec, null) < 0) {
                    throw new VideoDecoderException("Display " + this.displayId + ": could not open codec " + codec.name());
                }
            }
            catch (VideoDecoderException e) {
                avcodec.av_parser_close(parserContext);
                avcodec.avcodec_free_context((AVCodecContext)codecContext);
                throw e;
            }
            this.codecContext = codecContext;
            this.parserContext = parserContext;
            AVFrame aVFrame = avutil.av_frame_alloc();
            Intrinsics.checkNotNullExpressionValue((Object)aVFrame, (String)"av_frame_alloc(...)");
            this.decodingFrame = aVFrame;
            this.initialized = true;
            return true;
        }

        public final void addFrameListener(@NotNull FrameListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.frameListeners.add(listener2);
        }

        public final void removeFrameListener(@NotNull FrameListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.frameListeners.remove(listener2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void consumeDisplayFrame(@NotNull Consumer<VideoFrame> consumer2) {
            Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
            Object object = this.imageLock;
            synchronized (object) {
                Unit unit;
                boolean bl = false;
                VideoFrame videoFrame = this.displayFrame;
                if (videoFrame != null) {
                    VideoFrame it = videoFrame;
                    boolean bl2 = false;
                    consumer2.accept(it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
        }

        public final void closeAsynchronously() {
            ApplicationManager.getApplication().executeOnPooledThread(() -> DecodingContext.closeAsynchronously$lambda$3(this));
        }

        @Override
        public synchronized void close() {
            this.onEndOfVideoStream();
            if (Intrinsics.areEqual((Object)this.initialized, (Object)true)) {
                AVFrame it;
                AVCodecParserContext aVCodecParserContext = this.parserContext;
                if (aVCodecParserContext == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parserContext");
                    aVCodecParserContext = null;
                }
                avcodec.av_parser_close((AVCodecParserContext)aVCodecParserContext);
                AVCodecContext aVCodecContext = this.codecContext;
                if (aVCodecContext == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"codecContext");
                    aVCodecContext = null;
                }
                avcodec.avcodec_close((AVCodecContext)aVCodecContext);
                AVCodecContext aVCodecContext2 = this.codecContext;
                if (aVCodecContext2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"codecContext");
                    aVCodecContext2 = null;
                }
                avcodec.avcodec_free_context((AVCodecContext)aVCodecContext2);
                AVFrame aVFrame = this.decodingFrame;
                if (aVFrame == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"decodingFrame");
                    aVFrame = null;
                }
                avutil.av_frame_free((AVFrame)aVFrame);
                AVFrame aVFrame2 = this.renderingFrame;
                if (aVFrame2 != null) {
                    it = aVFrame2;
                    boolean bl = false;
                    avutil.av_frame_free((AVFrame)it);
                }
                SwsContext swsContext = this.swsContext;
                if (swsContext != null) {
                    it = swsContext;
                    boolean bl = false;
                    swscale.sws_freeContext((SwsContext)it);
                }
                avcodec.av_packet_free((AVPacket)this.pendingPacket);
            }
            this.initialized = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void processPacket(@NotNull AVPacket packet, @NotNull VideoPacketHeader header) {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            if (!this.ensureInitialized((AVCodec)VideoDecoder.this.codec.getCompleted())) {
                return;
            }
            boolean isConfig = packet.pts() == avutil.AV_NOPTS_VALUE;
            AVPacket packetToProcess = packet;
            if (this.hasPendingPacket || isConfig) {
                int offset = 0;
                if (this.hasPendingPacket) {
                    offset = this.pendingPacket.size();
                    if (avcodec.av_grow_packet((AVPacket)this.pendingPacket, (int)packet.size()) != 0) {
                        throw new VideoDecoderException("Display " + this.displayId + ": could not grow packet");
                    }
                } else {
                    offset = 0;
                    if (avcodec.av_new_packet((AVPacket)this.pendingPacket, (int)packet.size()) != 0) {
                        throw new VideoDecoderException("Display " + this.displayId + ": could not create packet for display " + this.displayId);
                    }
                    this.hasPendingPacket = true;
                }
                Pointer.memcpy((Pointer)((Pointer)this.pendingPacket.data().position((long)offset)), (Pointer)((Pointer)packet.data()), (long)packet.size());
                if (!isConfig) {
                    this.pendingPacket.pts(packet.pts());
                    this.pendingPacket.dts(packet.dts());
                    this.pendingPacket.flags(packet.flags());
                    packetToProcess = this.pendingPacket;
                }
            }
            if (!isConfig) {
                if (this.displayId == SdkConstants.PRIMARY_DISPLAY_ID) {
                    VideoDecoder.this.streamingSessionTracker.videoFrameArrived();
                }
                try {
                    this.processDataPacket(packetToProcess, header);
                }
                catch (InvalidFrameException e) {
                    this.onInvalidFrame(e);
                }
                finally {
                    if (this.hasPendingPacket) {
                        this.hasPendingPacket = false;
                        if (!Intrinsics.areEqual((Object)this.pendingPacket, (Object)packet)) {
                            avcodec.av_packet_unref((AVPacket)this.pendingPacket);
                        }
                    }
                }
            }
        }

        public final synchronized void processEmptyPacket(@NotNull VideoPacketHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            if (!this.ensureInitialized((AVCodec)VideoDecoder.this.codec.getCompleted())) {
                return;
            }
            Dimension size = AwtUtilsKt.rotatedByQuadrants((Dimension)header.getDisplaySize(), (int)header.getDisplayOrientation());
            this.createFrameForDisplay(header, size.width, size.height, null);
        }

        private final void processDataPacket(AVPacket packet, VideoPacketHeader header) {
            int ret;
            boolean bl;
            AVCodecContext aVCodecContext;
            BytePointer outData = new BytePointer();
            int[] nArray = new int[]{0};
            IntPointer outLen = new IntPointer(nArray);
            AVCodecParserContext aVCodecParserContext = this.parserContext;
            if (aVCodecParserContext == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"parserContext");
                aVCodecParserContext = null;
            }
            if ((aVCodecContext = this.codecContext) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codecContext");
                aVCodecContext = null;
            }
            boolean bl2 = bl = (ret = avcodec.av_parser_parse2((AVCodecParserContext)aVCodecParserContext, (AVCodecContext)aVCodecContext, (BytePointer)outData, (IntPointer)outLen, (BytePointer)packet.data(), (int)packet.size(), (long)avutil.AV_NOPTS_VALUE, (long)avutil.AV_NOPTS_VALUE, (long)-1L)) == packet.size();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            boolean bl3 = bl = outLen.get() == packet.size();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            AVCodecParserContext aVCodecParserContext2 = this.parserContext;
            if (aVCodecParserContext2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"parserContext");
                aVCodecParserContext2 = null;
            }
            if (aVCodecParserContext2.key_frame() == 1) {
                packet.flags(packet.flags() | 1);
            }
            this.processFrame(packet, header);
        }

        private final void processFrame(AVPacket packet, VideoPacketHeader header) {
            AVFrame aVFrame;
            int ret;
            AVCodecContext aVCodecContext = this.codecContext;
            if (aVCodecContext == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codecContext");
                aVCodecContext = null;
            }
            if ((ret = avcodec.avcodec_send_packet((AVCodecContext)aVCodecContext, (AVPacket)packet)) < 0) {
                throw new InvalidFrameException("Display " + this.displayId + ": video packet was rejected by the decoder: " + ret + " " + VideoDecoderKt.access$toDebugString(packet) + " header: " + header);
            }
            AVCodecContext aVCodecContext2 = this.codecContext;
            if (aVCodecContext2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codecContext");
                aVCodecContext2 = null;
            }
            if ((aVFrame = this.decodingFrame) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decodingFrame");
                aVFrame = null;
            }
            if (avcodec.avcodec_receive_frame((AVCodecContext)aVCodecContext2, (AVFrame)aVFrame) != 0) {
                throw new VideoDecoderException("Display " + this.displayId + ": could not receive video frame");
            }
            AVFrame aVFrame2 = this.decodingFrame;
            if (aVFrame2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decodingFrame");
                aVFrame2 = null;
            }
            int frameWidth = aVFrame2.width();
            AVFrame aVFrame3 = this.decodingFrame;
            if (aVFrame3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decodingFrame");
                aVFrame3 = null;
            }
            int frameHeight = aVFrame3.height();
            AVFrame renderingFrame = this.renderingFrame;
            if (renderingFrame == null || renderingFrame.width() != frameWidth || renderingFrame.height() != frameHeight) {
                AVFrame aVFrame4;
                AVFrame aVFrame5 = renderingFrame;
                if (aVFrame5 != null) {
                    AVFrame it = aVFrame5;
                    boolean bl = false;
                    avutil.av_frame_free((AVFrame)it);
                }
                AVFrame it = aVFrame4 = this.createRenderingFrame(frameWidth, frameHeight);
                boolean bl = false;
                this.renderingFrame = it;
                renderingFrame = aVFrame4;
                if (avutil.av_frame_get_buffer((AVFrame)renderingFrame, (int)4) < 0) {
                    throw new RuntimeException("av_frame_get_buffer failed");
                }
            }
            if (avutil.av_frame_make_writable((AVFrame)renderingFrame) < 0) {
                throw new RuntimeException("av_frame_make_writable failed");
            }
            SwsContext swsContext = this.getSwsContext(renderingFrame);
            AVFrame aVFrame6 = this.decodingFrame;
            if (aVFrame6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decodingFrame");
                aVFrame6 = null;
            }
            PointerPointer pointerPointer = aVFrame6.data();
            AVFrame aVFrame7 = this.decodingFrame;
            if (aVFrame7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decodingFrame");
                aVFrame7 = null;
            }
            swscale.sws_scale((SwsContext)swsContext, (PointerPointer)pointerPointer, (IntPointer)aVFrame7.linesize(), (int)0, (int)frameHeight, (PointerPointer)renderingFrame.data(), (IntPointer)renderingFrame.linesize());
            int numBytes = avutil.av_image_get_buffer_size((int)renderingFrame.format(), (int)frameWidth, (int)frameHeight, (int)1);
            Pointer pointer = renderingFrame.data().get();
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"get(...)");
            IntBuffer framePixels = VideoDecoderKt.access$asByteBufferOfSize(pointer, numBytes).asIntBuffer();
            Dimension rotatedDisplaySize = AwtUtilsKt.rotatedByQuadrants((Dimension)header.getDisplaySize(), (int)(header.getDisplayOrientation() - header.getDisplayOrientationCorrection()));
            int imageHeight = RangesKt.coerceAtMost((int)AwtUtilsKt.scaled((int)frameWidth, (double)((double)rotatedDisplaySize.height / (double)rotatedDisplaySize.width)), (int)frameHeight);
            int startY = (frameHeight - imageHeight) / 2;
            framePixels.position(startY * frameWidth);
            this.createFrameForDisplay(header, frameWidth, imageHeight, framePixels);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void createFrameForDisplay(VideoPacketHeader header, int width, int height, IntBuffer pixels) {
            boolean displayIsRound = header.isDisplayRound() && header.getDisplaySize().width == header.getDisplaySize().height;
            Object object = this.imageLock;
            synchronized (object) {
                int n;
                int n2;
                int n3;
                BufferedImage image;
                boolean bl = false;
                VideoFrame videoFrame = this.displayFrame;
                BufferedImage bufferedImage = image = videoFrame != null ? videoFrame.getImage() : null;
                boolean bl2 = bufferedImage != null ? bufferedImage.getWidth() == width : false;
                if (bl2 && image.getHeight() == height && (n3 = (n2 = header.getDisplayOrientationCorrection()) % (n = 2)) + (n & ((n3 ^ n) & (n3 | -n3)) >> 31) == 0) {
                    DataBuffer dataBuffer = image.getRaster().getDataBuffer();
                    Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
                    int[] imagePixels = ((DataBufferInt)dataBuffer).getData();
                    IntBuffer intBuffer = pixels;
                    if (intBuffer == null || (intBuffer = intBuffer.get(imagePixels, 0, height * width)) == null) {
                        Color color = Color.BLACK;
                        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLACK");
                        VideoDecoderKt.access$fill(image, color);
                        intBuffer = Unit.INSTANCE;
                    }
                    image = ImageUtils.rotateByQuadrants((BufferedImage)image, (int)header.getDisplayOrientationCorrection());
                } else if (pixels == null) {
                    n = header.getDisplayOrientationCorrection();
                    n3 = 2;
                    int n4 = n % n3;
                    image = n4 + (n3 & ((n4 ^ n3) & (n4 | -n4)) >> 31) == 0 ? new BufferedImage(width, height, 2) : new BufferedImage(height, width, 2);
                    Color color = Color.BLACK;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLACK");
                    VideoDecoderKt.access$fill(image, color);
                } else {
                    int[] imagePixels = new int[width * height];
                    pixels.get(imagePixels, 0, height * width);
                    DataBufferInt buffer = new DataBufferInt(imagePixels, imagePixels.length);
                    SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, width, height, VideoDecoderKt.access$getSAMPLE_MODEL_BIT_MASKS$p());
                    WritableRaster raster = Raster.createWritableRaster(sampleModel, buffer, VideoDecoderKt.access$getZERO_POINT$p());
                    image = ImageUtils.rotateByQuadrants((BufferedImage)new BufferedImage(VideoDecoderKt.access$getCOLOR_MODEL$p(), raster, false, null), (int)header.getDisplayOrientationCorrection());
                }
                if (displayIsRound) {
                    image = ImageUtils.ellipticalClip((BufferedImage)image, null);
                }
                this.displayFrame = new VideoFrame(image, header.getDisplaySize(), header.getDisplayOrientation(), header.getDisplayOrientationCorrection(), displayIsRound, header.getFrameNumber-pVg5ArA(), header.getOriginationTimestampUs() / (long)1000, null);
                Unit unit = Unit.INSTANCE;
            }
            this.onNewFrameAvailable();
            if (this.displayId == SdkConstants.PRIMARY_DISPLAY_ID && Intrinsics.areEqual((Object)VideoDecoder.this.deviceProperties.isVirtual(), (Object)false)) {
                if (header.isBitRateReduced()) {
                    BitRateManager.Companion.getInstance().bitRateReduced(header.getBitRate(), VideoDecoder.this.deviceProperties);
                    this.framesAtBitRate = 1;
                    VideoDecoder.this.getLogger().info(VideoDecoder.this.deviceProperties.getTitle() + " bit rate: " + header.getBitRate());
                } else {
                    ++this.framesAtBitRate;
                    if (this.framesAtBitRate % VideoDecoderKt.getBIT_RATE_STABILITY_FRAME_COUNT() == 0) {
                        BitRateManager.Companion.getInstance().bitRateStable(header.getBitRate(), VideoDecoder.this.deviceProperties);
                    }
                }
            }
        }

        private final SwsContext getSwsContext(AVFrame renderingFrame) {
            SwsContext context;
            AVFrame aVFrame = this.decodingFrame;
            if (aVFrame == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decodingFrame");
                aVFrame = null;
            }
            int n = aVFrame.width();
            AVFrame aVFrame2 = this.decodingFrame;
            if (aVFrame2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decodingFrame");
                aVFrame2 = null;
            }
            int n2 = aVFrame2.height();
            AVFrame aVFrame3 = this.decodingFrame;
            if (aVFrame3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"decodingFrame");
                aVFrame3 = null;
            }
            SwsContext swsContext = swscale.sws_getCachedContext((SwsContext)this.swsContext, (int)n, (int)n2, (int)aVFrame3.format(), (int)renderingFrame.width(), (int)renderingFrame.height(), (int)renderingFrame.format(), (int)2, null, null, null);
            if (swsContext == null) {
                throw new VideoDecoderException("Display " + this.displayId + ": could not allocate SwsContext");
            }
            this.swsContext = context = swsContext;
            return context;
        }

        private final AVFrame createRenderingFrame(int width, int height) {
            AVFrame aVFrame;
            AVFrame $this$createRenderingFrame_u24lambda_u249 = aVFrame = avutil.av_frame_alloc();
            boolean bl = false;
            $this$createRenderingFrame_u24lambda_u249.width(width);
            $this$createRenderingFrame_u24lambda_u249.height(height);
            $this$createRenderingFrame_u24lambda_u249.format(28);
            AVFrame aVFrame2 = aVFrame;
            Intrinsics.checkNotNullExpressionValue((Object)aVFrame2, (String)"apply(...)");
            return aVFrame2;
        }

        private final void onNewFrameAvailable() {
            for (FrameListener listener2 : this.frameListeners) {
                listener2.onNewFrameAvailable();
            }
        }

        private final void onEndOfVideoStream() {
            for (FrameListener listener2 : this.frameListeners) {
                listener2.onEndOfVideoStream();
            }
        }

        private final void onInvalidFrame(InvalidFrameException e) {
            for (FrameListener listener2 : this.frameListeners) {
                listener2.onInvalidFrame(e);
            }
        }

        private static final void closeAsynchronously$lambda$3(DecodingContext this$0) {
            this$0.close();
        }

        public static final /* synthetic */ boolean access$ensureInitialized(DecodingContext $this, AVCodec codec) {
            return $this.ensureInitialized(codec);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder$FrameListener;", "", "onNewFrameAvailable", "", "onEndOfVideoStream", "onInvalidFrame", "e", "Lcom/android/tools/idea/streaming/device/InvalidFrameException;", "intellij.android.streaming"})
    public static interface FrameListener {
        public void onNewFrameAvailable();

        public void onEndOfVideoStream();

        public void onInvalidFrame(@NotNull InvalidFrameException var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\t\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder$PacketReader;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "(Lcom/android/tools/idea/streaming/device/VideoDecoder;)V", "headerBuffer", "Ljava/nio/ByteBuffer;", "packet", "Lorg/bytedeco/ffmpeg/avcodec/AVPacket;", "readAndProcessPacket", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "intellij.android.streaming"})
    private final class PacketReader
    implements AutoCloseable {
        @NotNull
        private final ByteBuffer headerBuffer = VideoPacketHeader.Companion.createBuffer();
        @NotNull
        private final AVPacket packet;

        public PacketReader() {
            AVPacket aVPacket = avcodec.av_packet_alloc();
            Intrinsics.checkNotNullExpressionValue((Object)aVPacket, (String)"av_packet_alloc(...)");
            this.packet = aVPacket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Nullable
        public final Object readAndProcessPacket(@NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof readAndProcessPacket.1)) ** GOTO lbl-1000
            var9_2 = $completion;
            if ((var9_2.label & -2147483648) != 0) {
                var9_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    long J$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ PacketReader this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.readAndProcessPacket((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = SuspendingSocketChannel.readFully$default(VideoDecoder.access$getVideoChannel$p(VideoDecoder.this), this.headerBuffer, 0L, null, (Continuation)$continuation, 6, null);
                    if (v0 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    this.headerBuffer.rewind();
                    header = VideoPacketHeader.Companion.deserialize(this.headerBuffer);
                    this.headerBuffer.clear();
                    packetSize = header.getPacketSize();
                    presentationTimestampUs = header.getPresentationTimestampUs();
                    if (presentationTimestampUs < 0L || packetSize < 0) {
                        var6_8 = this.headerBuffer.rewind();
                        Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"rewind(...)");
                        throw new VideoDecoderException("Invalid packet header: " + StringUtil.toHexString((byte[])IoKt.toByteArray$default((ByteBuffer)var6_8, (boolean)false, (int)1, null)));
                    }
                    if (packetSize != 0) ** GOTO lbl37
                    v1 = (DecodingContext)VideoDecoder.access$getDecodingContexts$p(VideoDecoder.this).get(Boxing.boxInt((int)header.getDisplayId()));
                    if (v1 != null) {
                        v1.processEmptyPacket(header);
                    }
                    ** GOTO lbl72
lbl37:
                    // 2 sources

                    if (avcodec.av_new_packet((AVPacket)this.packet, (int)packetSize) != 0) {
                        throw new VideoDecoderException("Display " + header.getDisplayId() + ": could not allocate packet of " + packetSize + " bytes");
                    }
                    v2 = VideoDecoder.access$getVideoChannel$p(VideoDecoder.this);
                    v3 = this.packet.data();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"data(...)");
                    $continuation.L$0 = header;
                    $continuation.J$0 = presentationTimestampUs;
                    $continuation.label = 2;
                    v4 = SuspendingSocketChannel.readFully$default(v2, VideoDecoderKt.access$asByteBufferOfSize((Pointer)v3, packetSize), 0L, null, (Continuation)$continuation, 6, null);
                    ** if (v4 != var10_4) goto lbl49
lbl48:
                    // 1 sources

                    return var10_4;
lbl49:
                    // 1 sources

                    ** GOTO lbl57
                }
                case 2: {
                    presentationTimestampUs = $continuation.J$0;
                    header = (VideoPacketHeader)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl57:
                        // 2 sources

                        this.packet.pts(presentationTimestampUs == 0L ? avutil.AV_NOPTS_VALUE : presentationTimestampUs);
                        v5 = (DecodingContext)VideoDecoder.access$getDecodingContexts$p(VideoDecoder.this).get(Boxing.boxInt((int)header.getDisplayId()));
                        if (v5 != null) {
                            v5.processPacket(this.packet, header);
                            v6 = Unit.INSTANCE;
                        } else {
                            v6 = null;
                        }
                        var6_9 = v6;
                    }
                    catch (Throwable var7_10) {
                        throw var7_10;
                    }
                    finally {
                        avcodec.av_packet_unref((AVPacket)this.packet);
                    }
lbl72:
                    // 2 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        @Override
        public void close() {
            avcodec.av_packet_free((AVPacket)this.packet);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u000b\u001a\u00020\f\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder$VideoFrame;", "", "image", "Ljava/awt/image/BufferedImage;", "displaySize", "Ljava/awt/Dimension;", "orientation", "", "orientationCorrection", "round", "", "frameNumber", "Lkotlin/UInt;", "originationTime", "", "<init>", "(Ljava/awt/image/BufferedImage;Ljava/awt/Dimension;IIZIJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getImage", "()Ljava/awt/image/BufferedImage;", "getDisplaySize", "()Ljava/awt/Dimension;", "getOrientation", "()I", "getOrientationCorrection", "getRound", "()Z", "getFrameNumber-pVg5ArA", "I", "getOriginationTime", "()J", "intellij.android.streaming"})
    public static final class VideoFrame {
        @NotNull
        private final BufferedImage image;
        @NotNull
        private final Dimension displaySize;
        private final int orientation;
        private final int orientationCorrection;
        private final boolean round;
        private final int frameNumber;
        private final long originationTime;

        private VideoFrame(BufferedImage image, Dimension displaySize, int orientation, int orientationCorrection, boolean round, int frameNumber, long originationTime) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
            this.image = image;
            this.displaySize = displaySize;
            this.orientation = orientation;
            this.orientationCorrection = orientationCorrection;
            this.round = round;
            this.frameNumber = frameNumber;
            this.originationTime = originationTime;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        @NotNull
        public final Dimension getDisplaySize() {
            return this.displaySize;
        }

        public final int getOrientation() {
            return this.orientation;
        }

        public final int getOrientationCorrection() {
            return this.orientationCorrection;
        }

        public final boolean getRound() {
            return this.round;
        }

        public final int getFrameNumber-pVg5ArA() {
            return this.frameNumber;
        }

        public final long getOriginationTime() {
            return this.originationTime;
        }

        public /* synthetic */ VideoFrame(BufferedImage image, Dimension displaySize, int orientation, int orientationCorrection, boolean round, int frameNumber, long originationTime, DefaultConstructorMarker $constructor_marker) {
            this(image, displaySize, orientation, orientationCorrection, round, frameNumber, originationTime);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%BY\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0013\u0010\n\u001a\u00020\u000b\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0011\u0010\"\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010!\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder$VideoPacketHeader;", "", "displayId", "", "displaySize", "Ljava/awt/Dimension;", "displayOrientation", "displayOrientationCorrection", "flags", "bitRate", "frameNumber", "Lkotlin/UInt;", "originationTimestampUs", "", "presentationTimestampUs", "packetSize", "<init>", "(ILjava/awt/Dimension;IIIIIJJI)V", "getDisplayId", "()I", "getDisplaySize", "()Ljava/awt/Dimension;", "getDisplayOrientation", "getDisplayOrientationCorrection", "getBitRate", "getFrameNumber-pVg5ArA", "I", "getOriginationTimestampUs", "()J", "getPresentationTimestampUs", "getPacketSize", "isDisplayRound", "", "()Z", "isBitRateReduced", "toString", "", "Companion", "intellij.android.streaming"})
    private static final class VideoPacketHeader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int displayId;
        @NotNull
        private final Dimension displaySize;
        private final int displayOrientation;
        private final int displayOrientationCorrection;
        private final int flags;
        private final int bitRate;
        private final int frameNumber;
        private final long originationTimestampUs;
        private final long presentationTimestampUs;
        private final int packetSize;
        private static final int FLAG_DISPLAY_ROUND = 1;
        private static final int FLAG_BIT_RATE_REDUCED = 2;
        private static final int WIRE_SIZE = 44;

        private VideoPacketHeader(int displayId, Dimension displaySize, int displayOrientation, int displayOrientationCorrection, int flags, int bitRate, int frameNumber, long originationTimestampUs, long presentationTimestampUs, int packetSize) {
            this.displayId = displayId;
            this.displaySize = displaySize;
            this.displayOrientation = displayOrientation;
            this.displayOrientationCorrection = displayOrientationCorrection;
            this.flags = flags;
            this.bitRate = bitRate;
            this.frameNumber = frameNumber;
            this.originationTimestampUs = originationTimestampUs;
            this.presentationTimestampUs = presentationTimestampUs;
            this.packetSize = packetSize;
        }

        public final int getDisplayId() {
            return this.displayId;
        }

        @NotNull
        public final Dimension getDisplaySize() {
            return this.displaySize;
        }

        public final int getDisplayOrientation() {
            return this.displayOrientation;
        }

        public final int getDisplayOrientationCorrection() {
            return this.displayOrientationCorrection;
        }

        public final int getBitRate() {
            return this.bitRate;
        }

        public final int getFrameNumber-pVg5ArA() {
            return this.frameNumber;
        }

        public final long getOriginationTimestampUs() {
            return this.originationTimestampUs;
        }

        public final long getPresentationTimestampUs() {
            return this.presentationTimestampUs;
        }

        public final int getPacketSize() {
            return this.packetSize;
        }

        public final boolean isDisplayRound() {
            return (this.flags & 1) != 0;
        }

        public final boolean isBitRateReduced() {
            return (this.flags & 2) != 0;
        }

        @NotNull
        public String toString() {
            return "PacketHeader(displayId=" + this.displayId + ", displaySize=" + this.displaySize.width + "x" + this.displaySize.height + ", displayOrientation=" + this.displayOrientation + ", displayOrientationCorrection=" + this.displayOrientationCorrection + ", flags=" + this.flags + ", frameNumber=" + UInt.toString-impl((int)this.frameNumber) + ", packetSize=" + this.packetSize + ")";
        }

        public /* synthetic */ VideoPacketHeader(int displayId, Dimension displaySize, int displayOrientation, int displayOrientationCorrection, int flags, int bitRate, int frameNumber, long originationTimestampUs, long presentationTimestampUs, int packetSize, DefaultConstructorMarker $constructor_marker) {
            this(displayId, displaySize, displayOrientation, displayOrientationCorrection, flags, bitRate, frameNumber, originationTimestampUs, presentationTimestampUs, packetSize);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/streaming/device/VideoDecoder$VideoPacketHeader$Companion;", "", "<init>", "()V", "FLAG_DISPLAY_ROUND", "", "FLAG_BIT_RATE_REDUCED", "WIRE_SIZE", "deserialize", "Lcom/android/tools/idea/streaming/device/VideoDecoder$VideoPacketHeader;", "buffer", "Ljava/nio/ByteBuffer;", "createBuffer", "intellij.android.streaming"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final VideoPacketHeader deserialize(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                int displayId = buffer.getInt();
                int width = buffer.getInt();
                int height = buffer.getInt();
                byte displayOrientation = buffer.get();
                byte displayOrientationCorrection = buffer.get();
                short flags = buffer.getShort();
                int bitRate = buffer.getInt();
                int frameNumber = StreamingUtilsKt.getUInt(buffer);
                long originationTimestampUs = buffer.getLong();
                long presentationTimestampUs = buffer.getLong();
                int packetSize = buffer.getInt();
                return new VideoPacketHeader(displayId, new Dimension(width, height), displayOrientation, displayOrientationCorrection, flags, bitRate, frameNumber, originationTimestampUs, presentationTimestampUs, packetSize, null);
            }

            @NotNull
            public final ByteBuffer createBuffer() {
                ByteBuffer byteBuffer = ByteBuffer.allocate(44).order(ByteOrder.LITTLE_ENDIAN);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"order(...)");
                return byteBuffer;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

