/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.device;

import com.android.tools.idea.streaming.device.AndroidKeyEventActionType;
import com.android.tools.idea.streaming.device.ControlMessage;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/streaming/device/KeyEventMessage;", "Lcom/android/tools/idea/streaming/device/ControlMessage;", "action", "Lcom/android/tools/idea/streaming/device/AndroidKeyEventActionType;", "keyCode", "", "metaState", "<init>", "(Lcom/android/tools/idea/streaming/device/AndroidKeyEventActionType;II)V", "getAction", "()Lcom/android/tools/idea/streaming/device/AndroidKeyEventActionType;", "getKeyCode", "()I", "getMetaState", "serialize", "", "stream", "Lcom/android/utils/Base128OutputStream;", "toString", "", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "Companion", "intellij.android.streaming"})
public final class KeyEventMessage
extends ControlMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidKeyEventActionType action;
    private final int keyCode;
    private final int metaState;
    public static final int TYPE = 2;

    public KeyEventMessage(@NotNull AndroidKeyEventActionType action2, int keyCode, int metaState) {
        Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
        super(2, null);
        this.action = action2;
        this.keyCode = keyCode;
        this.metaState = metaState;
    }

    @NotNull
    public final AndroidKeyEventActionType getAction() {
        return this.action;
    }

    public final int getKeyCode() {
        return this.keyCode;
    }

    public final int getMetaState() {
        return this.metaState;
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        super.serialize(stream);
        stream.writeInt(this.action.getValue());
        stream.writeInt(this.keyCode);
        stream.writeInt(this.metaState);
    }

    @Override
    @NotNull
    public String toString() {
        String string = Integer.toString(this.metaState, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "KeyEventMessage(action=" + this.action + ", keyCode=" + this.keyCode + ", metaState=0x" + string + ")";
    }

    @NotNull
    public final AndroidKeyEventActionType component1() {
        return this.action;
    }

    public final int component2() {
        return this.keyCode;
    }

    public final int component3() {
        return this.metaState;
    }

    @NotNull
    public final KeyEventMessage copy(@NotNull AndroidKeyEventActionType action2, int keyCode, int metaState) {
        Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
        return new KeyEventMessage(action2, keyCode, metaState);
    }

    public static /* synthetic */ KeyEventMessage copy$default(KeyEventMessage keyEventMessage, AndroidKeyEventActionType androidKeyEventActionType, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            androidKeyEventActionType = keyEventMessage.action;
        }
        if ((n3 & 2) != 0) {
            n = keyEventMessage.keyCode;
        }
        if ((n3 & 4) != 0) {
            n2 = keyEventMessage.metaState;
        }
        return keyEventMessage.copy(androidKeyEventActionType, n, n2);
    }

    @Override
    public int hashCode() {
        int result2 = this.action.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.keyCode);
        result2 = result2 * 31 + Integer.hashCode(this.metaState);
        return result2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KeyEventMessage)) {
            return false;
        }
        KeyEventMessage keyEventMessage = (KeyEventMessage)other;
        if (this.action != keyEventMessage.action) {
            return false;
        }
        if (this.keyCode != keyEventMessage.keyCode) {
            return false;
        }
        return this.metaState == keyEventMessage.metaState;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/streaming/device/KeyEventMessage$Companion;", "Lcom/android/tools/idea/streaming/device/ControlMessage$Deserializer;", "<init>", "()V", "TYPE", "", "deserialize", "Lcom/android/tools/idea/streaming/device/KeyEventMessage;", "stream", "Lcom/android/utils/Base128InputStream;", "intellij.android.streaming"})
    public static final class Companion
    implements ControlMessage.Deserializer {
        private Companion() {
        }

        @Override
        @NotNull
        public KeyEventMessage deserialize(@NotNull Base128InputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int actionValue = stream.readInt();
            AndroidKeyEventActionType androidKeyEventActionType = AndroidKeyEventActionType.Companion.fromValue(actionValue);
            if (androidKeyEventActionType == null) {
                throw new Base128InputStream.StreamFormatException("Unrecognized action: " + actionValue);
            }
            AndroidKeyEventActionType action2 = androidKeyEventActionType;
            int keyCode = stream.readInt();
            int metaState = stream.readInt();
            return new KeyEventMessage(action2, keyCode, metaState);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

