/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.streaming.core;

import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.adtui.util.AwtUtilsKt;
import com.android.tools.idea.streaming.core.StreamingUtilsKt;
import com.android.tools.idea.streaming.core.ZoomablePanelKt;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001c\u001a\u00020\u0011H$J\b\u0010\u001d\u001a\u00020\u001eH$J\b\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0004J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001eH\u0016J\b\u0010&\u001a\u00020\u001eH\u0016J\b\u0010'\u001a\u00020\u001eH\u0016J\b\u0010(\u001a\u00020\u001eH\u0016J\u0006\u0010)\u001a\u00020 J(\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bH\u0016J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u000201H\u0016J\u000e\u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u0003J\u0010\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0007H\u0002J\b\u00106\u001a\u00020\u0011H\u0004J\u0012\u00107\u001a\u0004\u0018\u00010\u00112\u0006\u00108\u001a\u00020$H\u0002J\u0010\u00109\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010:\u001a\u00020\u0007H\u0002J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0011H\u0002J\u0018\u0010;\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\u00112\u0006\u0010<\u001a\u00020\u0011H\u0002J\u0010\u0010>\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u0010?\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010@\u001a\u00020\u0011H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\tR\u0014\u0010\u0016\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\tR\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/tools/idea/streaming/core/ZoomablePanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/android/tools/adtui/Zoomable;", "Ljava/beans/PropertyChangeListener;", "<init>", "()V", "screenScale", "", "getScreenScale", "()D", "physicalWidth", "", "getPhysicalWidth", "()I", "physicalHeight", "getPhysicalHeight", "physicalSize", "Ljava/awt/Dimension;", "getPhysicalSize", "()Ljava/awt/Dimension;", "scale", "getScale", "screenScalingFactor", "getScreenScalingFactor", "explicitlySetPreferredSize", "getExplicitlySetPreferredSize$intellij_android_streaming", "cachedScreenScale", "fractionalScaleRange", "computeActualSize", "canZoom", "", "onScreenScaleChanged", "", "roundDownIfNecessary", "zoom", "type", "Lcom/android/tools/adtui/actions/ZoomType;", "canZoomIn", "canZoomOut", "canZoomToActual", "canZoomToFit", "resetZoom", "setBounds", "x", "y", "width", "height", "propertyChange", "event", "Ljava/beans/PropertyChangeEvent;", "addPropertyChangeListener", "listener", "getCurrentScreenScaleOr", "defaultValue", "computeMaxImageSize", "computeZoomedSize", "zoomType", "nearestZoomLevel", "computeScaleToFitInParent", "computeScaleToFit", "availableSize", "actualSize", "roundDownIfGreaterThanOne", "isFractionalGreaterThanOne", "computeAvailableSize", "intellij.android.streaming"})
public abstract class ZoomablePanel
extends BorderLayoutPanel
implements Zoomable,
PropertyChangeListener {
    private double cachedScreenScale;
    private double fractionalScaleRange;

    public ZoomablePanel() {
        this.addPropertyChangeListener(this);
    }

    protected final double getScreenScale() {
        return this.cachedScreenScale > 0.0 ? this.cachedScreenScale : this.getCurrentScreenScaleOr(1.0);
    }

    protected final int getPhysicalWidth() {
        return AwtUtilsKt.scaled((int)this.getWidth(), (double)this.getScreenScale());
    }

    protected final int getPhysicalHeight() {
        return AwtUtilsKt.scaled((int)this.getHeight(), (double)this.getScreenScale());
    }

    @NotNull
    protected final Dimension getPhysicalSize() {
        return new Dimension(this.getPhysicalWidth(), this.getPhysicalHeight());
    }

    public double getScale() {
        return this.roundDownIfNecessary(this.computeScaleToFit(this.computeMaxImageSize()));
    }

    public double getScreenScalingFactor() {
        return this.getScreenScale();
    }

    @Nullable
    public final Dimension getExplicitlySetPreferredSize$intellij_android_streaming() {
        return this.isPreferredSizeSet() ? this.getPreferredSize() : null;
    }

    @NotNull
    protected abstract Dimension computeActualSize();

    protected abstract boolean canZoom();

    protected void onScreenScaleChanged() {
    }

    protected final double roundDownIfNecessary(double scale) {
        double roundedScale = this.roundDownIfGreaterThanOne(scale);
        return roundedScale == this.fractionalScaleRange ? scale : roundedScale;
    }

    public boolean zoom(@NotNull ZoomType type) {
        Dimension scaledSize;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        double oldFractionalScaleRange = this.fractionalScaleRange;
        if (type == ZoomType.FIT) {
            if (this.fractionalScaleRange == 0.0) {
                this.fractionalScaleRange = this.roundDownIfGreaterThanOne(this.computeScaleToFitInParent());
            }
        } else {
            this.fractionalScaleRange = 0.0;
        }
        if (Intrinsics.areEqual((Object)(scaledSize = this.computeZoomedSize(type)), (Object)this.getPreferredSize()) && this.fractionalScaleRange == oldFractionalScaleRange) {
            return false;
        }
        this.setPreferredSize(scaledSize);
        this.revalidate();
        this.repaint();
        return true;
    }

    public boolean canZoomIn() {
        return this.canZoom() && !Intrinsics.areEqual((Object)this.computeZoomedSize(ZoomType.IN), (Object)this.getExplicitlySetPreferredSize$intellij_android_streaming());
    }

    public boolean canZoomOut() {
        return this.canZoom() && (!Intrinsics.areEqual((Object)this.computeZoomedSize(ZoomType.OUT), (Object)this.getExplicitlySetPreferredSize$intellij_android_streaming()) || this.isFractionalGreaterThanOne(this.getScale()));
    }

    public boolean canZoomToActual() {
        return this.canZoom() && (!Intrinsics.areEqual((Object)this.computeZoomedSize(ZoomType.ACTUAL), (Object)this.getExplicitlySetPreferredSize$intellij_android_streaming()) || this.isFractionalGreaterThanOne(this.getScale()));
    }

    public boolean canZoomToFit() {
        if (!this.canZoom()) {
            return false;
        }
        if (this.isPreferredSizeSet()) {
            return true;
        }
        if (!(this.fractionalScaleRange == 0.0)) {
            return false;
        }
        double scaleToFit = this.computeScaleToFitInParent();
        double roundedScale = this.roundDownIfGreaterThanOne(scaleToFit);
        return roundedScale < scaleToFit;
    }

    public final void resetZoom() {
        this.setPreferredSize(null);
        this.fractionalScaleRange = 0.0;
        this.revalidate();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (!(this.fractionalScaleRange == 0.0) && !(this.fractionalScaleRange == this.roundDownIfGreaterThanOne(this.computeScaleToFit(this.computeMaxImageSize())))) {
            this.fractionalScaleRange = 0.0;
        }
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        double newScreenScale;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"graphicsConfiguration") && !((newScreenScale = this.getCurrentScreenScaleOr(0.0)) == 0.0) && !(newScreenScale == this.cachedScreenScale)) {
            this.cachedScreenScale = newScreenScale;
            this.onScreenScaleChanged();
        }
    }

    public final void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        super.addPropertyChangeListener(listener2);
    }

    private final double getCurrentScreenScaleOr(double defaultValue) {
        Object object = this.getGraphicsConfiguration();
        return object != null && (object = ((GraphicsConfiguration)object).getDefaultTransform()) != null ? ((AffineTransform)object).getScaleX() : defaultValue;
    }

    @NotNull
    protected final Dimension computeMaxImageSize() {
        Dimension dimension2 = this.getExplicitlySetPreferredSize$intellij_android_streaming();
        if (dimension2 == null) {
            dimension2 = this.getSize();
        }
        Dimension dimension3 = dimension2;
        Intrinsics.checkNotNull((Object)dimension3);
        return AwtUtilsKt.scaled((Dimension)dimension3, (double)this.getScreenScale());
    }

    private final Dimension computeZoomedSize(ZoomType zoomType) {
        double d;
        switch (WhenMappings.$EnumSwitchMapping$0[zoomType.ordinal()]) {
            case 1: {
                double nextScale = this.nearestZoomLevel(this.getScale() * ((double)2 * ZoomablePanelKt.access$getSQRT2$p()));
                double fitScale = this.roundDownIfGreaterThanOne(this.computeScaleToFitInParent());
                if (nextScale >= fitScale && fitScale >= ArraysKt.last((double[])ZoomablePanelKt.access$getZOOM_LEVELS$p())) {
                    return null;
                }
                d = nextScale;
                break;
            }
            case 2: {
                double scale = this.getScale();
                double nextScale = this.nearestZoomLevel(scale / ZoomablePanelKt.access$getSQRT2$p());
                double fitScale = this.roundDownIfGreaterThanOne(this.computeScaleToFitInParent());
                if (fitScale > 1.0) {
                    if (nextScale < 1.0) {
                        nextScale = 1.0;
                    }
                } else if (nextScale <= fitScale || nextScale >= scale) {
                    return null;
                }
                d = nextScale;
                break;
            }
            case 3: {
                if (this.roundDownIfGreaterThanOne(this.computeScaleToFitInParent()) == 1.0) {
                    return null;
                }
                d = 1.0;
                break;
            }
            case 4: {
                return null;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double newScale = d;
        Dimension newScaledSize = AwtUtilsKt.scaled((Dimension)this.computeActualSize(), (double)newScale);
        return AwtUtilsKt.scaled((Dimension)newScaledSize, (double)(1.0 / this.getScreenScale()));
    }

    private final double nearestZoomLevel(double scale) {
        int low = 0;
        int high = ZoomablePanelKt.access$getZOOM_LEVELS$p().length;
        while (low < high) {
            int mid = low + high >>> 1;
            double level = ZoomablePanelKt.access$getZOOM_LEVELS$p()[mid];
            double cmp = level - scale;
            if (cmp < 0.0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0.0) {
                high = mid;
                continue;
            }
            return level;
        }
        return ZoomablePanelKt.access$getZOOM_LEVELS$p()[Math.max(low - 1, 0)];
    }

    private final double computeScaleToFitInParent() {
        return this.computeScaleToFit(this.computeAvailableSize());
    }

    private final double computeScaleToFit(Dimension availableSize) {
        return this.computeScaleToFit(this.computeActualSize(), availableSize);
    }

    private final double computeScaleToFit(Dimension actualSize, Dimension availableSize) {
        if (actualSize.width == 0 || actualSize.height == 0) {
            return 1.0;
        }
        return Math.min((double)availableSize.width / (double)actualSize.width, (double)availableSize.height / (double)actualSize.height);
    }

    private final double roundDownIfGreaterThanOne(double scale) {
        return scale <= 1.0 ? scale : Math.floor(scale);
    }

    private final boolean isFractionalGreaterThanOne(double scale) {
        return scale > 1.0 && !(Math.floor(scale) == scale);
    }

    private final Dimension computeAvailableSize() {
        Serializable serializable = this.getParent();
        if (serializable == null || (serializable = StreamingUtilsKt.getSizeWithoutInsets(serializable)) == null || (serializable = AwtUtilsKt.scaled((Dimension)serializable, (double)this.getScreenScale())) == null) {
            serializable = new Dimension(0, 0);
        }
        return serializable;
    }

    public boolean zoom(@NotNull ZoomType type, int x, int y) {
        return super.zoom(type, x, y);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ZoomType.values().length];
            try {
                nArray[ZoomType.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.OUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.ACTUAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.FIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

