/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.idea.stats.StatisticsViewerListener;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0010\u0010\u0003\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/stats/StudioStatsLocalFileDumper;", "", "<init>", "()V", "STUDIO_EVENT_DUMP_DIR", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "registerStudioEventFileDumper", "", "disposable", "Lcom/intellij/openapi/Disposable;", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDateFormat$annotations", "formatTime", "time", "Ljava/time/ZonedDateTime;", "dumpStudioEventToDirectory", "studioEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "intellij.android.core"})
public final class StudioStatsLocalFileDumper {
    @NotNull
    public static final StudioStatsLocalFileDumper INSTANCE = new StudioStatsLocalFileDumper();
    @NotNull
    public static final String STUDIO_EVENT_DUMP_DIR = "studio.event.dump.dir";
    @NotNull
    private static final Logger LOG;
    private static final DateTimeFormatter dateFormat;

    private StudioStatsLocalFileDumper() {
    }

    @JvmStatic
    public static final void registerStudioEventFileDumper(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        StatisticsViewerListener.register(disposable, (Function1<? super AndroidStudioEvent.Builder, Unit>)((Function1)new Function1<AndroidStudioEvent.Builder, Unit>((Object)INSTANCE){

            public final void invoke(AndroidStudioEvent.Builder p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                StudioStatsLocalFileDumper.access$dumpStudioEventToDirectory((StudioStatsLocalFileDumper)this.receiver, p0);
            }
        }));
    }

    private static /* synthetic */ void getDateFormat$annotations() {
    }

    private final String formatTime(ZonedDateTime time2) {
        String string = dateFormat.format(time2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final void dumpStudioEventToDirectory(AndroidStudioEvent.Builder studioEvent) {
        block3: {
            String string = System.getProperty(STUDIO_EVENT_DUMP_DIR);
            if (string == null) break block3;
            String traceDir = string;
            boolean bl = false;
            Path traceDirPath = Path.of(traceDir, new String[0]);
            Intrinsics.checkNotNull((Object)traceDirPath);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(traceDirPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                ZonedDateTime now = ZonedDateTime.now();
                String string2 = studioEvent.getKind().name();
                Intrinsics.checkNotNull((Object)now);
                Path studioEventFile = traceDirPath.resolve(string2 + "-" + INSTANCE.formatTime(now) + "-" + now.toInstant().toEpochMilli() + ".textproto");
                try {
                    Files.createFile(studioEventFile, new FileAttribute[0]);
                    Path path = Files.writeString(studioEventFile, (CharSequence)TextFormat.printer().printToString((MessageOrBuilder)studioEvent), new OpenOption[0]);
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    public static final /* synthetic */ void access$dumpStudioEventToDirectory(StudioStatsLocalFileDumper $this, AndroidStudioEvent.Builder studioEvent) {
        $this.dumpStudioEventToDirectory(studioEvent);
    }

    static {
        Logger logger = Logger.getInstance(StudioStatsLocalFileDumper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
    }
}

