/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.actions.BrowserNotificationAction;
import com.android.tools.idea.actions.FeatureSurveyNotificationAction;
import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.serverflags.protos.BrowserSurvey;
import com.android.tools.idea.serverflags.protos.FeatureSurveyConfig;
import com.android.tools.idea.serverflags.protos.Survey;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.ChoiceLogger;
import com.android.tools.idea.stats.ChoiceLoggerImpl;
import com.android.tools.idea.stats.DefaultFeatureSurveyConfigKt;
import com.android.tools.idea.stats.DefaultSatisfactionSurveyKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.BrowserSurveyEvent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\rH\u0007J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\rH\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/stats/FeatureSurveys;", "", "<init>", "()V", "isSurveyPending", "", "lock", "processEvent", "", "event", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "triggerSurveyByName", "surveyFileName", "", "shouldInvokeFeatureSurvey", "name", "shouldInvokeSurvey", "config", "Lcom/android/tools/idea/serverflags/protos/FeatureSurveyConfig;", "getConfig", "()Lcom/android/tools/idea/serverflags/protos/FeatureSurveyConfig;", "config$delegate", "Lkotlin/Lazy;", "getFeatureSurveyNotification", "Lcom/intellij/notification/Notification;", "getBrowserNotification", "FeatureSurveyChoiceLogger", "intellij.android.core"})
public final class FeatureSurveys {
    @NotNull
    public static final FeatureSurveys INSTANCE = new FeatureSurveys();
    private static boolean isSurveyPending;
    @NotNull
    private static final Object lock;
    @NotNull
    private static final Lazy config$delegate;

    private FeatureSurveys() {
    }

    public final void processEvent(@NotNull AndroidStudioEvent.Builder event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getKind().getValueDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.triggerSurveyByName(string);
    }

    public final void triggerSurveyByName(@NotNull String surveyFileName) {
        Intrinsics.checkNotNullParameter((Object)surveyFileName, (String)"surveyFileName");
        Notification notification = this.getFeatureSurveyNotification(surveyFileName);
        if (notification == null && (notification = this.getBrowserNotification(surveyFileName)) == null) {
            return;
        }
        Notification notification2 = notification;
        ApplicationManager.getApplication().invokeLater(() -> FeatureSurveys.triggerSurveyByName$lambda$0(notification2));
    }

    @VisibleForTesting
    public final boolean shouldInvokeFeatureSurvey(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return AnalyticsSettings.getOptedIn() && this.shouldInvokeSurvey(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final boolean shouldInvokeSurvey(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (isSurveyPending) {
            return false;
        }
        Date now = AnalyticsSettings.getDateProvider().now();
        Date date = AnalyticsSettings.getNextFeatureSurveyDate();
        if (date != null) {
            Date it = date;
            boolean bl = false;
            if (now.before(it)) {
                return false;
            }
        }
        Map map2 = AnalyticsSettings.getNextFeatureSurveyDateMap();
        if (map2 != null) {
            Map map3 = map2;
            boolean bl = false;
            Date date2 = (Date)map3.get(name2);
            if (date2 != null) {
                Date it = date2;
                boolean bl2 = false;
                if (now.before(it)) {
                    return false;
                }
            }
        }
        Object object = lock;
        synchronized (object) {
            block10: {
                boolean bl = false;
                if (!isSurveyPending) break block10;
                boolean bl3 = false;
                return bl3;
            }
            isSurveyPending = true;
            Unit unit = Unit.INSTANCE;
        }
        return true;
    }

    @NotNull
    public final FeatureSurveyConfig getConfig() {
        Lazy lazy = config$delegate;
        return (FeatureSurveyConfig)lazy.getValue();
    }

    private final Notification getFeatureSurveyNotification(String surveyFileName) {
        String name2 = "analytics/surveys/feature/" + surveyFileName;
        Survey survey = (Survey)ServerFlagService.Companion.getInstance().getProtoOrNull(name2, (Message)DefaultSatisfactionSurveyKt.getDEFAULT_SATISFACTION_SURVEY());
        if (survey == null) {
            return null;
        }
        Survey survey2 = survey;
        if (this.shouldInvokeFeatureSurvey(name2)) {
            return null;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Feature Survey");
        if (notificationGroup == null) {
            return null;
        }
        NotificationGroup notificationGroup2 = notificationGroup;
        String string = survey2.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        Notification notification = notificationGroup2.createNotification(string, "Would you like to take a 1-question survey based on your recent activity to help us improve Android Studio?", NotificationType.INFORMATION);
        notification.addAction((AnAction)new FeatureSurveyNotificationAction(survey2));
        return notification;
    }

    /*
     * WARNING - void declaration
     */
    private final Notification getBrowserNotification(String surveyFileName) {
        void $this$getBrowserNotification_u24lambda_u247_u24lambda_u246;
        BrowserSurveyEvent.Builder builder;
        AndroidStudioEvent.Builder builder2;
        String name2 = "analytics/surveys/browser/" + surveyFileName;
        BrowserSurvey emptySurvey = BrowserSurvey.newBuilder().build();
        ServerFlagService serverFlagService = ServerFlagService.Companion.getInstance();
        Intrinsics.checkNotNull((Object)emptySurvey);
        BrowserSurvey browserSurvey = (BrowserSurvey)serverFlagService.getProtoOrNull(name2, (Message)emptySurvey);
        if (browserSurvey == null) {
            return null;
        }
        BrowserSurvey survey = browserSurvey;
        if (!this.shouldInvokeSurvey(name2)) {
            return null;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Browser Survey");
        if (notificationGroup == null) {
            return null;
        }
        NotificationGroup notificationGroup2 = notificationGroup;
        String string = survey.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        String string2 = survey.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
        Notification notification = notificationGroup2.createNotification(string, string2, NotificationType.INFORMATION);
        String string3 = AnalyticsSettings.getOptedIn() ? UUID.randomUUID().toString() : "none";
        Intrinsics.checkNotNull((Object)string3);
        String uniqueId2 = string3;
        String string4 = survey.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getUrl(...)");
        String url = StringsKt.replace$default((String)string4, (String)"_unique_id", (String)uniqueId2, (boolean)false, (int)4, null);
        notification.addAction((AnAction)new BrowserNotificationAction(url));
        AndroidStudioEvent.Builder $this$getBrowserNotification_u24lambda_u247 = builder2 = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $this$getBrowserNotification_u24lambda_u247.setKind(AndroidStudioEvent.EventKind.BROWSER_SURVEY_EVENT);
        BrowserSurveyEvent.Builder builder3 = builder = BrowserSurveyEvent.newBuilder();
        AndroidStudioEvent.Builder builder4 = $this$getBrowserNotification_u24lambda_u247;
        boolean bl2 = false;
        $this$getBrowserNotification_u24lambda_u247_u24lambda_u246.setName(survey.getName());
        $this$getBrowserNotification_u24lambda_u247_u24lambda_u246.setUniqueId(uniqueId2);
        builder4.setBrowserSurveyEvent(builder.build());
        AndroidStudioEvent.Builder builder5 = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"apply(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder5);
        FeatureSurveyChoiceLogger.INSTANCE.featureSurveyInvoked(name2, this.getConfig().getGeneralIntervalCompleted(), this.getConfig().getSpecificIntervalCompleted());
        return notification;
    }

    private static final void triggerSurveyByName$lambda$0(Notification $notification) {
        Notifications.Bus.notify((Notification)$notification);
    }

    private static final FeatureSurveyConfig config_delegate$lambda$5() {
        FeatureSurveyConfig config = (FeatureSurveyConfig)ServerFlagService.Companion.getInstance().getProtoOrNull("analytics/surveys/featureSurveyConfig", (Message)DefaultFeatureSurveyConfigKt.getDEFAULT_FEATURE_SURVEY_CONFIG());
        return config == null || !config.hasGeneralIntervalCompleted() || !config.hasGeneralIntervalCancelled() || !config.hasSpecificIntervalCompleted() || !config.hasSpecificIntervalCancelled() || !config.hasIdleIntervalMs() ? DefaultFeatureSurveyConfigKt.getDEFAULT_FEATURE_SURVEY_CONFIG() : config;
    }

    static {
        lock = new Object();
        config$delegate = LazyKt.lazy(FeatureSurveys::config_delegate$lambda$5);
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/stats/FeatureSurveys$FeatureSurveyChoiceLogger;", "Lcom/android/tools/idea/stats/ChoiceLogger;", "<init>", "()V", "log", "", "name", "", "result", "", "", "cancel", "featureSurveyInvoked", "generalInterval", "specificInterval", "intellij.android.core"})
    public static final class FeatureSurveyChoiceLogger
    implements ChoiceLogger {
        @NotNull
        public static final FeatureSurveyChoiceLogger INSTANCE = new FeatureSurveyChoiceLogger();

        private FeatureSurveyChoiceLogger() {
        }

        @Override
        public void log(@NotNull String name2, @NotNull List<Integer> result2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            ChoiceLoggerImpl.INSTANCE.log(name2, result2);
            this.featureSurveyInvoked(name2, INSTANCE.getConfig().getGeneralIntervalCompleted(), INSTANCE.getConfig().getSpecificIntervalCompleted());
        }

        @Override
        public void cancel(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            ChoiceLoggerImpl.INSTANCE.cancel(name2);
            this.featureSurveyInvoked(name2, INSTANCE.getConfig().getGeneralIntervalCancelled(), INSTANCE.getConfig().getGeneralIntervalCancelled());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        public final void featureSurveyInvoked(@NotNull String name2, int generalInterval, int specificInterval) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Date now = AnalyticsSettings.getDateProvider().now();
            Intrinsics.checkNotNull((Object)now);
            AnalyticsSettings.setNextFeatureSurveyDate((Date)AndroidStudioUsageTracker.INSTANCE.daysFromNow(now, generalInterval));
            Map map2 = AnalyticsSettings.getNextFeatureSurveyDateMap();
            if (map2 == null) {
                map2 = new LinkedHashMap();
            }
            Map map3 = map2;
            map3.put(name2, AndroidStudioUsageTracker.INSTANCE.daysFromNow(now, specificInterval));
            AnalyticsSettings.setNextFeatureSurveyDateMap((Map)map3);
            AnalyticsSettings.saveSettings();
            Object object = lock;
            synchronized (object) {
                boolean bl = false;
                isSurveyPending = false;
                Unit unit = Unit.INSTANCE;
            }
        }

        @Override
        public void log(@NotNull String name2, int result2) {
            ChoiceLogger.super.log(name2, result2);
        }
    }
}

