/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.tools.analytics.AnalyticsPublisher;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.AnalyticsSettingsData;
import com.android.tools.analytics.HighlightingStats;
import com.android.tools.analytics.StudioUpdateAnalyticsUtil;
import com.android.tools.analytics.UsageTracker;
import com.android.utils.ILogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.OptInToMetrics;
import com.google.wireless.android.sdk.stats.OptOutOfMetrics;
import com.intellij.analytics.AndroidStudioAnalytics;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.ConsentOptionsProvider;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidStudioAnalyticsImpl
extends AndroidStudioAnalytics {
    private ILogger androidLogger;

    public boolean isAllowed() {
        if (!AnalyticsSettings.getInitialized()) {
            Application application = ApplicationManager.getApplication();
            if (application != null && application.isUnitTestMode()) {
                AnalyticsSettingsData analyticsSettings = new AnalyticsSettingsData();
                analyticsSettings.setOptedIn(false);
                AnalyticsSettings.setInstanceForTest((AnalyticsSettingsData)analyticsSettings);
            } else {
                AnalyticsSettings.initialize((ILogger)this.getAndroidLogger());
            }
        }
        return AnalyticsSettings.getOptedIn();
    }

    public void recordHighlightingLatency(Document document, long latencyMs) {
        HighlightingStats.getInstance().recordHighlightingLatency(document, latencyMs);
    }

    public void logUpdateDialogOpenManually(@NotNull String newBuild) {
        StudioUpdateAnalyticsUtil.logUpdateDialogOpenManually(newBuild);
    }

    public void logNotificationShown(@NotNull String newBuild) {
        StudioUpdateAnalyticsUtil.logNotificationShown(newBuild);
    }

    public void logClickNotification(@NotNull String newBuild) {
        StudioUpdateAnalyticsUtil.logClickNotification(newBuild);
    }

    public void logUpdateDialogOpenFromNotification(@NotNull String newBuild) {
        StudioUpdateAnalyticsUtil.logUpdateDialogOpenFromNotification(newBuild);
    }

    public void logClickIgnore(String newBuild) {
        StudioUpdateAnalyticsUtil.logClickIgnore(newBuild);
    }

    public void logClickLater(String newBuild) {
        StudioUpdateAnalyticsUtil.logClickLater(newBuild);
    }

    public void logDownloadSuccess(String newBuild) {
        StudioUpdateAnalyticsUtil.logDownloadSuccess(newBuild);
    }

    public void logDownloadFailure(String newBuild) {
        StudioUpdateAnalyticsUtil.logDownloadFailure(newBuild);
    }

    public void updateAndroidStudioMetrics() {
        this.updateAndroidStudioMetrics(this.getConsentOptionsProvider().isSendingUsageStatsAllowed());
    }

    @Nullable
    private ConsentOptionsProvider getConsentOptionsProvider() {
        return UsageStatisticsPersistenceComponent.getConsentOptionsProvider();
    }

    private void updateAndroidStudioMetrics(boolean allowed) {
        boolean updated = false;
        ScheduledExecutorService scheduler = JobScheduler.getScheduler();
        AnalyticsSettings.initialize((ILogger)this.getAndroidLogger(), (ScheduledExecutorService)scheduler);
        try {
            if (allowed == AnalyticsSettings.getOptedIn()) {
                updated = false;
            } else {
                if (!allowed) {
                    UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.OPTOUT_METRICS).setOptOutOfMetrics(OptOutOfMetrics.newBuilder()));
                }
                AnalyticsSettings.setOptedIn((boolean)allowed);
                AnalyticsSettings.saveSettings();
                updated = true;
            }
        }
        catch (IOException e) {
            this.getAndroidLogger().error((Throwable)e, "Unable to update analytics settings", new Object[0]);
        }
        if (updated) {
            this.initializeAndroidStudioUsageTrackerAndPublisher();
            if (allowed) {
                UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.OPTIN_METRICS).setOptInToMetrics(OptInToMetrics.newBuilder()));
            }
        }
    }

    public void initializeAndroidStudioUsageTrackerAndPublisher() {
        ILogger logger = this.getAndroidLogger();
        ScheduledExecutorService scheduler = JobScheduler.getScheduler();
        AnalyticsSettings.initialize((ILogger)logger, (ScheduledExecutorService)(ApplicationManager.getApplication().isUnitTestMode() ? null : scheduler));
        try {
            boolean ijOptedIn = this.getConsentOptionsProvider().isSendingUsageStatsAllowed();
            if (AnalyticsSettings.getOptedIn() != ijOptedIn) {
                AnalyticsSettings.setOptedIn((boolean)ijOptedIn);
                AnalyticsSettings.saveSettings();
            }
            UsageTracker.initialize((ScheduledExecutorService)scheduler);
        }
        catch (Exception e) {
            logger.warning("Unable to initialize analytics tracker: " + e.getMessage(), new Object[0]);
            return;
        }
        UsageTracker.setMaxJournalTime((long)10L, (TimeUnit)TimeUnit.MINUTES);
        UsageTracker.setMaxJournalSize((int)1000);
        ApplicationInfo application = ApplicationInfo.getInstance();
        AnalyticsPublisher.updatePublisher((ILogger)logger, (ScheduledExecutorService)scheduler, (String)application.getStrictVersion());
    }

    private ILogger getAndroidLogger() {
        if (this.androidLogger == null) {
            final Logger intelliJLogger = Logger.getInstance((String)"#com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent");
            this.androidLogger = new ILogger(){

                public void error(@Nullable Throwable t, @Nullable String msgFormat, Object ... args) {
                    intelliJLogger.error(String.format(msgFormat, args), t);
                }

                public void warning(String msgFormat, Object ... args) {
                    intelliJLogger.warn(String.format(msgFormat, args));
                }

                public void info(String msgFormat, Object ... args) {
                    intelliJLogger.info(String.format(msgFormat, args));
                }

                public void verbose(String msgFormat, Object ... args) {
                    this.info(msgFormat, args);
                }
            };
        }
        return this.androidLogger;
    }
}

