/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.live;

import androidx.sqlite.inspection.SqliteInspectorProtocol;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.protobuf.ProtocolStringList;
import com.android.tools.idea.sqlite.DatabaseInspectorAnalyticsTracker;
import com.android.tools.idea.sqlite.model.ResultSetSqliteColumn;
import com.android.tools.idea.sqlite.model.RowIdName;
import com.android.tools.idea.sqlite.model.SqliteAffinity;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteColumnValue;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.idea.sqlite.model.SqliteValue;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a)\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\b\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00110\u0010\u001a$\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00100\u0013*\b\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u0017\u001a(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0000\u001a \u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\f\u0010#\u001a\u00020$*\u00020%H\u0002\u00a8\u0006&"}, d2={"buildQueryCommand", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Command;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "databaseConnectionId", "", "responseSizeByteLimitHint", "", "(Lcom/android/tools/idea/sqlite/model/SqliteStatement;ILjava/lang/Long;)Landroidx/sqlite/inspection/SqliteInspectorProtocol$Command;", "toSqliteColumnValue", "Lcom/android/tools/idea/sqlite/model/SqliteColumnValue;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$CellValue;", "colName", "", "toSqliteSchema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Table;", "mapToColumns", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/android/tools/idea/sqlite/model/ResultSetSqliteColumn;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Response;", "executor", "Ljava/util/concurrent/Executor;", "handleError", "", "project", "Lcom/intellij/openapi/project/Project;", "command", "errorContent", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$ErrorContent;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "handleErrorContent", "getErrorMessage", "toSqliteColumn", "Lcom/android/tools/idea/sqlite/model/SqliteColumn;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Column;", "app-inspection.inspectors.database"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/android/tools/idea/sqlite/databaseConnection/live/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1557#2:231\n1628#2,3:232\n1557#2:235\n1628#2,2:236\n1557#2:238\n1628#2,3:239\n1630#2:242\n1557#2:243\n1628#2,3:244\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/android/tools/idea/sqlite/databaseConnection/live/UtilsKt\n*L\n46#1:231\n46#1:232,3\n94#1:235\n94#1:236,2\n95#1:238\n95#1:239,3\n94#1:242\n104#1:243\n104#1:244,3\n*E\n"})
public final class UtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SqliteInspectorProtocol.Command buildQueryCommand(@NotNull SqliteStatement sqliteStatement, int databaseConnectionId, @Nullable Long responseSizeByteLimitHint) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        Iterable $this$map$iv = sqliteStatement.getParametersValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void param;
            SqliteInspectorProtocol.QueryParameterValue.Builder builder;
            SqliteValue sqliteValue = (SqliteValue)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            SqliteInspectorProtocol.QueryParameterValue.Builder builder2 = builder = SqliteInspectorProtocol.QueryParameterValue.newBuilder();
            boolean bl2 = false;
            if (param instanceof SqliteValue.StringValue) {
                builder2.setStringValue(((SqliteValue.StringValue)param).getValue());
            }
            collection2.add(builder.build());
        }
        List parameterValues = (List)destination$iv$iv;
        SqliteInspectorProtocol.QueryCommand.Builder queryBuilder = SqliteInspectorProtocol.QueryCommand.newBuilder().setQuery(sqliteStatement.getSqliteStatementText()).addAllQueryParameterValues((Iterable)parameterValues).setDatabaseId(databaseConnectionId);
        if (responseSizeByteLimitHint != null) {
            queryBuilder.setResponseSizeLimitHint(responseSizeByteLimitHint.longValue());
        }
        SqliteInspectorProtocol.Command command = SqliteInspectorProtocol.Command.newBuilder().setQuery(queryBuilder).build();
        Intrinsics.checkNotNullExpressionValue((Object)command, (String)"build(...)");
        return command;
    }

    public static /* synthetic */ SqliteInspectorProtocol.Command buildQueryCommand$default(SqliteStatement sqliteStatement, int n, Long l, int n2, Object object) {
        if ((n2 & 4) != 0) {
            l = null;
        }
        return UtilsKt.buildQueryCommand(sqliteStatement, n, l);
    }

    @NotNull
    public static final SqliteColumnValue toSqliteColumnValue(@NotNull SqliteInspectorProtocol.CellValue $this$toSqliteColumnValue, @NotNull String colName) {
        Intrinsics.checkNotNullParameter((Object)$this$toSqliteColumnValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)colName, (String)"colName");
        SqliteInspectorProtocol.CellValue.OneOfCase oneOfCase = $this$toSqliteColumnValue.getOneOfCase();
        return switch (oneOfCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oneOfCase.ordinal()]) {
            case 1 -> {
                String v1 = $this$toSqliteColumnValue.getStringValue();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getStringValue(...)");
                yield new SqliteColumnValue(colName, new SqliteValue.StringValue(v1));
            }
            case 2 -> new SqliteColumnValue(colName, new SqliteValue.StringValue(String.valueOf($this$toSqliteColumnValue.getDoubleValue())));
            case 3 -> {
                String v3 = BaseEncoding.base16().encode($this$toSqliteColumnValue.getBlobValue().toByteArray());
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"encode(...)");
                yield new SqliteColumnValue(colName, new SqliteValue.StringValue(v3));
            }
            case 4 -> new SqliteColumnValue(colName, new SqliteValue.StringValue(String.valueOf($this$toSqliteColumnValue.getLongValue())));
            case 5 -> new SqliteColumnValue(colName, SqliteValue.NullValue.INSTANCE);
            case -1 -> throw new IllegalStateException("value is null".toString());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SqliteSchema toSqliteSchema(@NotNull List<SqliteInspectorProtocol.Table> $this$toSqliteSchema) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toSqliteSchema, (String)"<this>");
        Iterable $this$map$iv = $this$toSqliteSchema;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void table2;
            SqliteInspectorProtocol.Table table3 = (SqliteInspectorProtocol.Table)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            List list = table2.getColumnsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumnsList(...)");
            Iterable $this$map$iv2 = list;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                SqliteInspectorProtocol.Column column2 = (SqliteInspectorProtocol.Column)item$iv$iv2;
                Collection collection3 = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                collection3.add(UtilsKt.toSqliteColumn((SqliteInspectorProtocol.Column)it));
            }
            List columns2 = (List)destination$iv$iv2;
            RowIdName rowIdName = table2.getWithoutRowid() ? null : com.android.tools.idea.sqlite.model.UtilsKt.getRowIdName(columns2);
            String string = table2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection2.add(new SqliteTable(string, columns2, rowIdName, table2.getIsView()));
        }
        List tables = (List)destination$iv$iv;
        return new SqliteSchema(tables);
    }

    @NotNull
    public static final ListenableFuture<List<ResultSetSqliteColumn>> mapToColumns(@NotNull ListenableFuture<SqliteInspectorProtocol.Response> $this$mapToColumns, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter($this$mapToColumns, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return FutureUtils.transform($this$mapToColumns, (Executor)executor, UtilsKt::mapToColumns$lambda$5);
    }

    public static final void handleError(@NotNull Project project, @NotNull SqliteInspectorProtocol.Command command, @NotNull SqliteInspectorProtocol.ErrorContent errorContent, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)errorContent, (String)"errorContent");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (errorContent.getErrorCode() == SqliteInspectorProtocol.ErrorContent.ErrorCode.ERROR_NO_OPEN_DATABASE_WITH_REQUESTED_ID || errorContent.getErrorCode() == SqliteInspectorProtocol.ErrorContent.ErrorCode.ERROR_DB_CLOSED_DURING_OPERATION) {
            return;
        }
        SqliteInspectorProtocol.Command.OneOfCase oneOfCase = command.getOneOfCase();
        switch (oneOfCase == null ? -1 : WhenMappings.$EnumSwitchMapping$1[oneOfCase.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                UtilsKt.handleErrorContent(project, errorContent, logger);
            }
        }
    }

    private static final void handleErrorContent(Project project, SqliteInspectorProtocol.ErrorContent errorContent, Logger logger) {
        DatabaseInspectorAnalyticsTracker analyticsTracker = DatabaseInspectorAnalyticsTracker.Companion.getInstance(project);
        SqliteInspectorProtocol.ErrorRecoverability.OneOfCase oneOfCase = errorContent.getRecoverability().getOneOfCase();
        switch (oneOfCase == null ? -1 : WhenMappings.$EnumSwitchMapping$2[oneOfCase.ordinal()]) {
            case 1: {
                if (!errorContent.getRecoverability().getIsRecoverable()) {
                    logger.warn("Unrecoverable error from on-device inspector: " + errorContent.getMessage() + "\n" + errorContent.getStackTrace());
                    analyticsTracker.trackErrorOccurred(AppInspectionEvent.DatabaseInspectorEvent.ErrorKind.IS_RECOVERABLE_FALSE);
                    break;
                }
                analyticsTracker.trackErrorOccurred(AppInspectionEvent.DatabaseInspectorEvent.ErrorKind.IS_RECOVERABLE_TRUE);
                break;
            }
            case 2: {
                logger.warn("Unknown if recoverable error from on-device inspector: " + errorContent.getMessage() + "\n" + errorContent.getStackTrace());
                analyticsTracker.trackErrorOccurred(AppInspectionEvent.DatabaseInspectorEvent.ErrorKind.IS_RECOVERABLE_UNKNOWN);
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public static final String getErrorMessage(@NotNull SqliteInspectorProtocol.ErrorContent errorContent) {
        Intrinsics.checkNotNullParameter((Object)errorContent, (String)"errorContent");
        SqliteInspectorProtocol.ErrorRecoverability.OneOfCase oneOfCase = errorContent.getRecoverability().getOneOfCase();
        return switch (oneOfCase == null ? -1 : WhenMappings.$EnumSwitchMapping$2[oneOfCase.ordinal()]) {
            case 1 -> {
                if (errorContent.getRecoverability().getIsRecoverable()) {
                    String var1_1 = errorContent.getMessage();
                    Intrinsics.checkNotNull((Object)var1_1);
                    yield var1_1;
                }
                yield "An error has occurred which requires you to restart your app: " + errorContent.getMessage();
            }
            case 2 -> "An error has occurred which might require you to restart your app: " + errorContent.getMessage();
            case -1 -> throw new IllegalStateException("value is null".toString());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final SqliteColumn toSqliteColumn(SqliteInspectorProtocol.Column $this$toSqliteColumn) {
        String string = $this$toSqliteColumn.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = $this$toSqliteColumn.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getType(...)");
        return new SqliteColumn(string, SqliteAffinity.Companion.fromTypename(string2), !$this$toSqliteColumn.getIsNotNull(), $this$toSqliteColumn.getPrimaryKey() > 0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List mapToColumns$lambda$5(SqliteInspectorProtocol.Response response2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        ProtocolStringList protocolStringList = response2.getQuery().getColumnNamesList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getColumnNamesList(...)");
        Iterable $this$map$iv = (Iterable)protocolStringList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void columnName;
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)columnName);
            collection2.add(new ResultSetSqliteColumn((String)columnName, null, null, null));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[SqliteInspectorProtocol.CellValue.OneOfCase.values().length];
            try {
                nArray[SqliteInspectorProtocol.CellValue.OneOfCase.STRING_VALUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteInspectorProtocol.CellValue.OneOfCase.DOUBLE_VALUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteInspectorProtocol.CellValue.OneOfCase.BLOB_VALUE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteInspectorProtocol.CellValue.OneOfCase.LONG_VALUE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteInspectorProtocol.CellValue.OneOfCase.ONEOF_NOT_SET.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SqliteInspectorProtocol.Command.OneOfCase.values().length];
            try {
                nArray[SqliteInspectorProtocol.Command.OneOfCase.GET_SCHEMA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteInspectorProtocol.Command.OneOfCase.KEEP_DATABASES_OPEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteInspectorProtocol.Command.OneOfCase.QUERY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteInspectorProtocol.Command.OneOfCase.TRACK_DATABASES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteInspectorProtocol.Command.OneOfCase.ONEOF_NOT_SET.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[SqliteInspectorProtocol.ErrorRecoverability.OneOfCase.values().length];
            try {
                nArray[SqliteInspectorProtocol.ErrorRecoverability.OneOfCase.IS_RECOVERABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteInspectorProtocol.ErrorRecoverability.OneOfCase.ONEOF_NOT_SET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

