/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite;

import androidx.sqlite.inspection.SqliteInspectorProtocol;
import com.android.tools.idea.appinspection.inspector.api.AppInspectorMessenger;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.sqlite.DatabaseInspectorClientCommandsChannel;
import com.android.tools.idea.sqlite.DatabaseInspectorMessenger;
import com.android.tools.idea.sqlite.DatabaseInspectorMessengerKt;
import com.android.tools.idea.sqlite.databaseConnection.live.LiveDatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.live.UtilsKt;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.settings.DatabaseInspectorSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u00b5\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007\u0012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0\u000e\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012\u0012!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u0007\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u001e\b\u0002\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\f0\u000ej\u0002`\u001c\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0007J\u000e\u0010$\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'2\u0006\u0010)\u001a\u00020(H\u0016J\u0018\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0'2\u0006\u0010\u0014\u001a\u00020+H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0'2\u0006\u0010-\u001a\u00020+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/idea/sqlite/DatabaseInspectorClient;", "Lcom/android/tools/idea/sqlite/DatabaseInspectorClientCommandsChannel;", "messenger", "Lcom/android/tools/idea/appinspection/inspector/api/AppInspectorMessenger;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "onErrorEventListener", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "errorMessage", "", "onDatabaseAddedListener", "Lkotlin/Function2;", "Lcom/android/tools/idea/sqlite/model/SqliteDatabaseId;", "Lcom/android/tools/idea/sqlite/databaseConnection/live/LiveDatabaseConnection;", "onDatabasePossiblyChanged", "Lkotlin/Function0;", "onDatabaseClosed", "databaseId", "taskExecutor", "Ljava/util/concurrent/Executor;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "errorsSideChannel", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Command;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$ErrorOccurredResponse;", "Lcom/android/tools/idea/sqlite/ErrorsSideChannel;", "<init>", "(Lcom/android/tools/idea/appinspection/inspector/api/AppInspectorMessenger;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/Executor;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function2;)V", "dbMessenger", "Lcom/android/tools/idea/sqlite/DatabaseInspectorMessenger;", "onRawEvent", "eventData", "", "startTrackingDatabaseConnections", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "keepConnectionsOpen", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "keepOpen", "acquireDatabaseLock", "", "releaseDatabaseLock", "lockId", "app-inspection.inspectors.database"})
public final class DatabaseInspectorClient
implements DatabaseInspectorClientCommandsChannel {
    @NotNull
    private final AppInspectorMessenger messenger;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final Function1<String, Unit> onErrorEventListener;
    @NotNull
    private final Function2<SqliteDatabaseId, LiveDatabaseConnection, Unit> onDatabaseAddedListener;
    @NotNull
    private final Function0<Unit> onDatabasePossiblyChanged;
    @NotNull
    private final Function1<SqliteDatabaseId, Unit> onDatabaseClosed;
    @NotNull
    private final Executor taskExecutor;
    @NotNull
    private final DatabaseInspectorMessenger dbMessenger;

    public DatabaseInspectorClient(@NotNull AppInspectorMessenger messenger, @NotNull Disposable parentDisposable, @NotNull Function1<? super String, Unit> onErrorEventListener, @NotNull Function2<? super SqliteDatabaseId, ? super LiveDatabaseConnection, Unit> onDatabaseAddedListener, @NotNull Function0<Unit> onDatabasePossiblyChanged, @NotNull Function1<? super SqliteDatabaseId, Unit> onDatabaseClosed, @NotNull Executor taskExecutor, @NotNull CoroutineScope scope, @NotNull Function2<? super SqliteInspectorProtocol.Command, ? super SqliteInspectorProtocol.ErrorOccurredResponse, Unit> errorsSideChannel) {
        Intrinsics.checkNotNullParameter((Object)messenger, (String)"messenger");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(onErrorEventListener, (String)"onErrorEventListener");
        Intrinsics.checkNotNullParameter(onDatabaseAddedListener, (String)"onDatabaseAddedListener");
        Intrinsics.checkNotNullParameter(onDatabasePossiblyChanged, (String)"onDatabasePossiblyChanged");
        Intrinsics.checkNotNullParameter(onDatabaseClosed, (String)"onDatabaseClosed");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(errorsSideChannel, (String)"errorsSideChannel");
        this.messenger = messenger;
        this.parentDisposable = parentDisposable;
        this.onErrorEventListener = onErrorEventListener;
        this.onDatabaseAddedListener = onDatabaseAddedListener;
        this.onDatabasePossiblyChanged = onDatabasePossiblyChanged;
        this.onDatabaseClosed = onDatabaseClosed;
        this.taskExecutor = taskExecutor;
        this.dbMessenger = new DatabaseInspectorMessenger(this.messenger, scope, this.taskExecutor, errorsSideChannel);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DatabaseInspectorClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.messenger.getEventFlow().collect(new FlowCollector(){

                            public final Object emit(byte[] eventData, Continuation<? super Unit> $completion) {
                                this$0.onRawEvent(eventData);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public /* synthetic */ DatabaseInspectorClient(AppInspectorMessenger appInspectorMessenger, Disposable disposable, Function1 function1, Function2 function2, Function0 function0, Function1 function12, Executor executor, CoroutineScope coroutineScope, Function2 function22, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            function22 = DatabaseInspectorClient::_init_$lambda$0;
        }
        this(appInspectorMessenger, disposable, (Function1<? super String, Unit>)function1, (Function2<? super SqliteDatabaseId, ? super LiveDatabaseConnection, Unit>)function2, (Function0<Unit>)function0, (Function1<? super SqliteDatabaseId, Unit>)function12, executor, coroutineScope, (Function2<? super SqliteInspectorProtocol.Command, ? super SqliteInspectorProtocol.ErrorOccurredResponse, Unit>)function22);
    }

    @VisibleForTesting
    public final void onRawEvent(@NotNull byte[] eventData) {
        Intrinsics.checkNotNullParameter((Object)eventData, (String)"eventData");
        SqliteInspectorProtocol.Event event = SqliteInspectorProtocol.Event.parseFrom((byte[])eventData);
        if (event.hasDatabaseOpened()) {
            SqliteInspectorProtocol.DatabaseOpenedEvent openedDatabase = event.getDatabaseOpened();
            ActionsKt.invokeLater$default(null, () -> DatabaseInspectorClient.onRawEvent$lambda$1(openedDatabase, this), (int)1, null);
        } else if (event.hasDatabasePossiblyChanged()) {
            this.onDatabasePossiblyChanged.invoke();
        } else if (event.hasDatabaseClosed()) {
            ActionsKt.invokeLater$default(null, () -> DatabaseInspectorClient.onRawEvent$lambda$2(this, event), (int)1, null);
        } else if (event.hasErrorOccurred()) {
            SqliteInspectorProtocol.ErrorContent errorContent = event.getErrorOccurred().getContent();
            Intrinsics.checkNotNull((Object)errorContent);
            String errorMessage = UtilsKt.getErrorMessage(errorContent);
            this.onErrorEventListener.invoke((Object)errorMessage);
        }
    }

    @Nullable
    public final Object startTrackingDatabaseConnections(@NotNull Continuation<? super Unit> $completion) {
        SqliteInspectorProtocol.TrackDatabasesCommand.Builder command = SqliteInspectorProtocol.TrackDatabasesCommand.newBuilder();
        if (((Boolean)StudioFlags.APP_INSPECTION_USE_EXPERIMENTAL_DATABASE_INSPECTOR.get()).booleanValue()) {
            command.setForceOpen(DatabaseInspectorSettings.Companion.getInstance().isForceOpen());
        }
        SqliteInspectorProtocol.Command.Builder builder = SqliteInspectorProtocol.Command.newBuilder().setTrackDatabases(command.build());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setTrackDatabases(...)");
        Object object = DatabaseInspectorMessengerKt.sendCommand(this.dbMessenger, builder, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public ListenableFuture<Boolean> keepConnectionsOpen(boolean keepOpen) {
        SqliteInspectorProtocol.Command.Builder builder = SqliteInspectorProtocol.Command.newBuilder().setKeepDatabasesOpen(SqliteInspectorProtocol.KeepDatabasesOpenCommand.newBuilder().setSetEnabled(keepOpen));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setKeepDatabasesOpen(...)");
        ListenableFuture<SqliteInspectorProtocol.Response> response2 = DatabaseInspectorMessengerKt.sendCommandAsync(this.dbMessenger, builder);
        return FutureUtils.transform(response2, (Executor)this.taskExecutor, arg_0 -> DatabaseInspectorClient.keepConnectionsOpen$lambda$3(keepOpen, arg_0));
    }

    @Override
    @NotNull
    public ListenableFuture<Integer> acquireDatabaseLock(int databaseId) {
        SqliteInspectorProtocol.Command.Builder builder = SqliteInspectorProtocol.Command.newBuilder().setAcquireDatabaseLock(SqliteInspectorProtocol.AcquireDatabaseLockCommand.newBuilder().setDatabaseId(databaseId));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setAcquireDatabaseLock(...)");
        return FutureUtils.transform(DatabaseInspectorMessengerKt.sendCommandAsync(this.dbMessenger, builder), (Executor)this.taskExecutor, DatabaseInspectorClient::acquireDatabaseLock$lambda$4);
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> releaseDatabaseLock(int lockId) {
        SqliteInspectorProtocol.Command.Builder builder = SqliteInspectorProtocol.Command.newBuilder().setReleaseDatabaseLock(SqliteInspectorProtocol.ReleaseDatabaseLockCommand.newBuilder().setLockId(lockId));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setReleaseDatabaseLock(...)");
        return FutureUtils.transform(DatabaseInspectorMessengerKt.sendCommandAsync(this.dbMessenger, builder), (Executor)this.taskExecutor, DatabaseInspectorClient::releaseDatabaseLock$lambda$5);
    }

    private static final Unit _init_$lambda$0(SqliteInspectorProtocol.Command command, SqliteInspectorProtocol.ErrorOccurredResponse errorOccurredResponse) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)errorOccurredResponse, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit onRawEvent$lambda$1(SqliteInspectorProtocol.DatabaseOpenedEvent $openedDatabase, DatabaseInspectorClient this$0) {
        String string = $openedDatabase.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        SqliteDatabaseId databaseId = SqliteDatabaseId.Companion.fromLiveDatabase(string, $openedDatabase.getDatabaseId(), $openedDatabase.getIsForcedConnection(), $openedDatabase.getIsReadOnly());
        LiveDatabaseConnection databaseConnection = new LiveDatabaseConnection(this$0.parentDisposable, this$0.dbMessenger, $openedDatabase.getDatabaseId(), this$0.taskExecutor);
        this$0.onDatabaseAddedListener.invoke((Object)databaseId, (Object)databaseConnection);
        return Unit.INSTANCE;
    }

    private static final Unit onRawEvent$lambda$2(DatabaseInspectorClient this$0, SqliteInspectorProtocol.Event $event) {
        Function1<SqliteDatabaseId, Unit> function1 = this$0.onDatabaseClosed;
        String string = $event.getDatabaseClosed().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        function1.invoke((Object)SqliteDatabaseId.Companion.fromLiveDatabase$default(SqliteDatabaseId.Companion, string, $event.getDatabaseClosed().getDatabaseId(), false, false, 12, null));
        return Unit.INSTANCE;
    }

    private static final Boolean keepConnectionsOpen$lambda$3(boolean $keepOpen, SqliteInspectorProtocol.Response it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SqliteInspectorProtocol.Response.OneOfCase oneOfCase = it.getOneOfCase();
        return (oneOfCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oneOfCase.ordinal()]) == 1 ? Boolean.valueOf($keepOpen) : null;
    }

    private static final Integer acquireDatabaseLock$lambda$4(SqliteInspectorProtocol.Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        SqliteInspectorProtocol.Response.OneOfCase oneOfCase = response2.getOneOfCase();
        return switch (oneOfCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oneOfCase.ordinal()]) {
            case 2 -> response2.getAcquireDatabaseLock().getLockId();
            case 3 -> null;
            default -> null;
        };
    }

    private static final Unit releaseDatabaseLock$lambda$5(SqliteInspectorProtocol.Response response2) {
        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
        SqliteInspectorProtocol.Response.OneOfCase oneOfCase = response2.getOneOfCase();
        switch (oneOfCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oneOfCase.ordinal()]) {
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqliteInspectorProtocol.Response.OneOfCase.values().length];
            try {
                nArray[SqliteInspectorProtocol.Response.OneOfCase.KEEP_DATABASES_OPEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteInspectorProtocol.Response.OneOfCase.ACQUIRE_DATABASE_LOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqliteInspectorProtocol.Response.OneOfCase.ERROR_OCCURRED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

