/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.settingssync;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.settingssync.DriveFileMetadata;
import com.android.tools.idea.settingssync.GoogleCommunicatorProviderKt;
import com.android.tools.idea.settingssync.GoogleDriveClient;
import com.android.tools.idea.settingssync.SettingsSyncFeature;
import com.android.tools.idea.settingssync.UnauthorizedException;
import com.google.api.client.auth.oauth2.Credential;
import com.google.gct.login2.LoginFeature;
import com.intellij.settingsSync.core.AbstractServerCommunicator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\"\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J \u0010\u0015\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00162\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\b\u0010\u001a\u001a\u00020\u0018H\u0014J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\bH\u0014J\b\u0010\u001d\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/settingssync/GoogleCloudServerCommunicator;", "Lcom/intellij/settingsSync/core/AbstractServerCommunicator;", "email", "", "<init>", "(Ljava/lang/String;)V", "lastRemoteErrorRef", "Ljava/util/concurrent/atomic/AtomicReference;", "", "googleDriveClient", "Lcom/android/tools/idea/settingssync/GoogleDriveClient;", "getCredential", "Lcom/google/api/client/auth/oauth2/Credential;", "userId", "getUserId", "()Ljava/lang/String;", "writeFileInternal", "filePath", "versionId", "content", "Ljava/io/InputStream;", "readFileInternal", "Lkotlin/Pair;", "deleteFileInternal", "", "getLatestVersion", "requestSuccessful", "handleRemoteError", "e", "dispose", "intellij.android.settings-sync"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nGoogleCommunicatorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleCommunicatorProvider.kt\ncom/android/tools/idea/settingssync/GoogleCloudServerCommunicator\n+ 2 LoginFeature.kt\ncom/google/gct/login2/LoginFeature$Companion\n*L\n1#1,182:1\n49#2,4:183\n*S KotlinDebug\n*F\n+ 1 GoogleCommunicatorProvider.kt\ncom/android/tools/idea/settingssync/GoogleCloudServerCommunicator\n*L\n125#1:183,4\n*E\n"})
public final class GoogleCloudServerCommunicator
extends AbstractServerCommunicator {
    @NotNull
    private final String email;
    @NotNull
    private final AtomicReference<Throwable> lastRemoteErrorRef;
    @NotNull
    private final GoogleDriveClient googleDriveClient;
    @NotNull
    private final String userId;
    public static final int $stable = 8;

    public GoogleCloudServerCommunicator(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        this.email = email;
        this.lastRemoteErrorRef = new AtomicReference();
        this.googleDriveClient = new GoogleDriveClient((Function0<? extends Credential>)((Function0)() -> GoogleCloudServerCommunicator.googleDriveClient$lambda$0(this)));
        this.userId = this.email;
    }

    private final Credential getCredential(String email) {
        LoginFeature.Companion this_$iv = LoginFeature.Companion;
        boolean $i$f$feature = false;
        LoginFeature loginFeature = (LoginFeature)this_$iv.getEP_NAME().findExtension(SettingsSyncFeature.class);
        if (loginFeature == null) {
            throw new RuntimeException("Couldn't find " + Reflection.getOrCreateKotlinClass(SettingsSyncFeature.class) + ". Is your extension registered properly?");
        }
        Credential credential = ((SettingsSyncFeature)loginFeature).credential(email);
        if (credential == null) {
            throw new UnauthorizedException("Missing feature authorization for " + email + ", please log in first.");
        }
        return credential;
    }

    @NotNull
    public String getUserId() {
        return this.userId;
    }

    @NotNull
    protected String writeFileInternal(@NotNull String filePath, @Nullable String versionId, @NotNull InputStream content2) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.googleDriveClient.deleteOldestFilesOverLimit(filePath);
        return this.googleDriveClient.write(filePath, content2).getVersionId();
    }

    @NotNull
    protected Pair<InputStream, String> readFileInternal(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Pair<byte[], DriveFileMetadata> pair = this.googleDriveClient.read(filePath);
        if (pair == null) {
            return TuplesKt.to(null, null);
        }
        Pair<byte[], DriveFileMetadata> pair2 = pair;
        byte[] content2 = (byte[])pair2.component1();
        DriveFileMetadata driveFileMetadata = (DriveFileMetadata)pair2.component2();
        return TuplesKt.to((Object)new ByteArrayInputStream(content2), (Object)driveFileMetadata.getVersionId());
    }

    protected void deleteFileInternal(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.googleDriveClient.delete(filePath);
    }

    @Nullable
    protected String getLatestVersion(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        DriveFileMetadata driveFileMetadata = this.googleDriveClient.getLatestUpdatedFileMetadata(filePath);
        return driveFileMetadata != null ? driveFileMetadata.getVersionId() : null;
    }

    protected void requestSuccessful() {
        if (this.lastRemoteErrorRef.get() != null) {
            GoogleCommunicatorProviderKt.access$getLog().info("Connection to setting sync server is restored");
        }
        this.lastRemoteErrorRef.set(null);
    }

    @NotNull
    protected String handleRemoteError(@NotNull Throwable e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String defaultMessage = "Error during communication with server";
        if (e instanceof IOException) {
            Throwable throwable = this.lastRemoteErrorRef.get();
            if (!Intrinsics.areEqual((Object)(throwable != null ? throwable.getMessage() : null), (Object)e.getMessage())) {
                this.lastRemoteErrorRef.set(e);
                GoogleCommunicatorProviderKt.access$getLog().warn(defaultMessage + ": " + e.getMessage());
            }
        } else {
            GoogleCommunicatorProviderKt.access$getLog().error(e);
        }
        if ((string = e.getMessage()) == null) {
            string = defaultMessage;
        }
        return string;
    }

    public void dispose() {
    }

    private static final Credential googleDriveClient$lambda$0(GoogleCloudServerCommunicator this$0) {
        return this$0.getCredential(this$0.email);
    }
}

