/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.InstallerFactory;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.adtui.validation.validators.FalseValidator;
import com.android.tools.adtui.validation.validators.TrueValidator;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.progress.ThrottledProgressWrapper;
import com.android.tools.idea.sdk.SdkInstallListener;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.install.StudioSdkInstallerUtil;
import com.android.tools.idea.sdk.wizard.InstallTask;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.ui.deprecated.StudioWizardStepPanel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallSelectedPackagesStep
extends ModelWizardStep.WithoutModel {
    private final BoolProperty myInstallFailed = new BoolValueProperty();
    private final BoolProperty myInstallationFinished = new BoolValueProperty();
    private final ListenerManager myListeners = new ListenerManager();
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private final Supplier<AndroidSdkHandler> mySdkHandlerSupplier;
    private JPanel myContentPanel;
    private JBLabel myLabelSdkPath;
    private JBLabel myProgressOverallLabel;
    private JTextPane mySdkManagerOutput;
    private JProgressBar myProgressBar;
    private JBLabel myProgressDetailLabel;
    private List<UpdatablePackage> myInstallRequests;
    private Collection<LocalPackage> myUninstallRequests;
    private com.android.repository.api.ProgressIndicator myLogger;
    private static final Object LOGGER_LOCK = new Object();
    private BackgroundAction myBackgroundAction = new BackgroundAction();
    private final boolean myBackgroundable;
    private InstallerFactoryFactory myFactory;
    private boolean myThrottleProgress;
    private MutableAttributeSet myOutputStyle;

    public InstallSelectedPackagesStep(@NotNull List<UpdatablePackage> installRequests, @NotNull Collection<LocalPackage> uninstallRequests, @NotNull Supplier<AndroidSdkHandler> sdkHandlerSupplier, boolean backgroundable, @NotNull Insets borderInsets) {
        this(installRequests, uninstallRequests, sdkHandlerSupplier, backgroundable, borderInsets, StudioSdkInstallerUtil::createInstallerFactory, false);
    }

    @VisibleForTesting
    public InstallSelectedPackagesStep(@NotNull List<UpdatablePackage> installRequests, @NotNull Collection<LocalPackage> uninstallRequests, @NotNull AndroidSdkHandler sdkHandler, boolean backgroundable, @NotNull Insets borderInsets, @NotNull InstallerFactory factory2, boolean throttleProgress) {
        this(installRequests, uninstallRequests, () -> sdkHandler, backgroundable, borderInsets, (AndroidSdkHandler unused) -> factory2, throttleProgress);
    }

    @VisibleForTesting
    private InstallSelectedPackagesStep(@NotNull List<UpdatablePackage> installRequests, @NotNull Collection<LocalPackage> uninstallRequests, @NotNull Supplier<AndroidSdkHandler> sdkHandlerSupplier, boolean backgroundable, @NotNull Insets borderInsets, @NotNull InstallerFactoryFactory factory2, boolean throttleProgress) {
        super(AndroidBundle.message("android.sdk.manager.installer.panel.title", new Object[0]));
        this.setupUI();
        this.myInstallRequests = installRequests;
        this.myUninstallRequests = uninstallRequests;
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myContentPanel);
        this.myStudioPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, AndroidBundle.message("android.sdk.manager.installer.panel.description", new Object[0]));
        this.myStudioPanel.setBorder(JBUI.Borders.empty((Insets)borderInsets));
        this.myBackgroundable = backgroundable;
        this.mySdkHandlerSupplier = sdkHandlerSupplier;
        this.myFactory = factory2;
        this.myThrottleProgress = throttleProgress;
    }

    @Override
    public Action getExtraAction() {
        return this.myBackgroundable ? this.myBackgroundAction : null;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard2) {
        String finishedText = AndroidBundle.message("android.sdk.manager.installer.install.finished", new Object[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myInstallationFinished, (Validator)new TrueValidator(Validator.Severity.INFO, finishedText), new ObservableValue[0]);
        String installError = AndroidBundle.message("android.sdk.manager.installer.install.error", new Object[0]);
        this.myValidatorPanel.registerValidator((ObservableValue)this.myInstallFailed, (Validator)new FalseValidator(installError), new ObservableValue[0]);
        this.myBackgroundAction.setWizard(wizard2);
        this.myListeners.listen(this.myInstallationFinished, () -> ApplicationManager.getApplication().invokeLater(wizard2::updateNavigationProperties));
    }

    @Override
    protected void onEntering() {
        this.mySdkManagerOutput.setText("");
        this.mySdkManagerOutput.setFont((Font)JBFont.create((Font)new Font("Monospaced", 0, 13)));
        this.myOutputStyle = this.mySdkManagerOutput.addStyle(null, null);
        AndroidSdkHandler sdkHandler = this.mySdkHandlerSupplier.get();
        RepoManager repoManager = sdkHandler.getRepoManagerAndLoadSynchronously((com.android.repository.api.ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        Path path = repoManager.getLocalPath();
        this.myLabelSdkPath.setText(path.toString());
        this.myInstallationFinished.set(false);
        this.startSdkInstall(sdkHandler);
    }

    @Override
    protected boolean shouldShow() {
        return !this.myInstallRequests.isEmpty() || !this.myUninstallRequests.isEmpty();
    }

    @Override
    protected boolean canGoBack() {
        return false;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myInstallationFinished;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myStudioPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.myListeners.releaseAll();
        Object object = LOGGER_LOCK;
        synchronized (object) {
            if (this.myLogger != null && !this.myBackgroundAction.isBackgrounded()) {
                this.myLogger.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSdkInstall(AndroidSdkHandler sdkHandler) {
        CustomLogger customLogger = new CustomLogger();
        Object object = LOGGER_LOCK;
        synchronized (object) {
            this.myLogger = this.myThrottleProgress ? new ThrottledProgressWrapper((com.android.repository.api.ProgressIndicator)customLogger) : customLogger;
        }
        Function<List<RepoPackage>, Void> completeCallback = failures -> {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.any(), () -> {
                Project[] projects;
                this.myProgressBar.setValue(100);
                this.myProgressOverallLabel.setText("");
                for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                    ((SdkInstallListener)project.getMessageBus().syncPublisher(SdkInstallListener.TOPIC)).installCompleted(this.myInstallRequests, this.myUninstallRequests);
                }
                if (!failures.isEmpty()) {
                    this.myInstallFailed.set(true);
                    this.myProgressBar.setEnabled(false);
                } else {
                    this.myProgressDetailLabel.setText("Done");
                    this.myInstallRequests.clear();
                    this.myUninstallRequests.clear();
                }
                this.myInstallationFinished.set(true);
            });
            return null;
        };
        InstallTask task2 = new InstallTask(this.myFactory.createInstallerFactory(sdkHandler), sdkHandler, StudioSettingsController.getInstance(), this.myLogger);
        task2.setInstallRequests(this.myInstallRequests);
        task2.setUninstallRequests(this.myUninstallRequests);
        task2.setCompleteCallback(completeCallback);
        task2.setPrepareCompleteCallback(() -> this.myBackgroundAction.setEnabled(false));
        this.myBackgroundAction.setTask(task2);
        boolean hasOpenProjects = ProjectManager.getInstance().getOpenProjects().length > 0;
        Object indicator = hasOpenProjects ? new BackgroundableProcessIndicator((Task.Backgroundable)task2) : new EmptyProgressIndicator();
        customLogger.setIndicator((ProgressIndicator)indicator);
        indicator.setIndeterminate(false);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task2, (ProgressIndicator)indicator);
    }

    private void setupUI() {
        this.myContentPanel = new JPanel();
        this.myContentPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("SDK Path:");
        this.myContentPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myLabelSdkPath = new JBLabel();
        this.myLabelSdkPath.setText("<placeholder path>");
        this.myContentPanel.add((Component)this.myLabelSdkPath, new GridConstraints(0, 1, 1, 1, 8, 0, 4, 0, null, null, null, 0, false));
        JBScrollPane jBScrollPane1 = new JBScrollPane();
        jBScrollPane1.setVerticalScrollBarPolicy(22);
        this.myContentPanel.add((Component)jBScrollPane1, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 5, null, null, null, 0, false));
        this.mySdkManagerOutput = new JTextPane();
        this.mySdkManagerOutput.setEditable(false);
        jBScrollPane1.setViewportView((Component)this.mySdkManagerOutput);
        this.myProgressOverallLabel = new JBLabel();
        this.myContentPanel.add((Component)this.myProgressOverallLabel, new GridConstraints(2, 0, 1, 2, 0, 1, 4, 0, null, null, null, 0, false));
        this.myProgressBar = new JProgressBar();
        this.myContentPanel.add((Component)this.myProgressBar, new GridConstraints(3, 0, 1, 2, 0, 1, 5, 0, null, null, null, 0, false));
        this.myProgressDetailLabel = new JBLabel();
        this.myProgressDetailLabel.setBackground(new Color(-3355444));
        this.myProgressDetailLabel.setHorizontalTextPosition(10);
        this.myProgressDetailLabel.setVerticalAlignment(1);
        this.myContentPanel.add((Component)this.myProgressDetailLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 2, null, null, null, 0, false));
    }

    private static interface InstallerFactoryFactory {
        public InstallerFactory createInstallerFactory(@NotNull AndroidSdkHandler var1);
    }

    private static class BackgroundAction
    extends AbstractAction {
        private boolean myIsBackgrounded = false;
        private ModelWizard.Facade myWizard;
        private InstallTask myTask;

        public BackgroundAction() {
            super("Background");
        }

        public void setTask(InstallTask task2) {
            this.myTask = task2;
        }

        public void setWizard(@NotNull ModelWizard.Facade wizard2) {
            this.myWizard = wizard2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myIsBackgrounded = true;
            this.myTask.foregroundIndicatorClosed();
            this.myWizard.cancel();
        }

        public boolean isBackgrounded() {
            return this.myIsBackgrounded;
        }
    }

    private final class CustomLogger
    implements com.android.repository.api.ProgressIndicator {
        private ProgressIndicator myIndicator;
        private boolean myCancelled;
        private Logger myLogger = Logger.getInstance(this.getClass());
        private double myFraction = 0.0;

        private CustomLogger() {
        }

        public void setText(@Nullable String s) {
            UIUtil.invokeLaterIfNeeded(() -> InstallSelectedPackagesStep.this.myProgressOverallLabel.setText(s));
            if (this.myIndicator != null) {
                this.myIndicator.setText(s);
            }
        }

        public boolean isCanceled() {
            if (this.myIndicator != null) {
                this.myCancelled = this.myCancelled || this.myIndicator.isCanceled();
            }
            return this.myCancelled;
        }

        public void cancel() {
            this.myCancelled = true;
            if (this.myIndicator != null) {
                this.myIndicator.cancel();
            }
        }

        public void setCancellable(boolean cancellable) {
        }

        public boolean isCancellable() {
            return true;
        }

        public void setIndeterminate(boolean indeterminate) {
            UIUtil.invokeLaterIfNeeded(() -> InstallSelectedPackagesStep.this.myProgressBar.setIndeterminate(indeterminate));
            if (this.myIndicator != null) {
                this.myIndicator.setIndeterminate(indeterminate);
            }
        }

        public boolean isIndeterminate() {
            return InstallSelectedPackagesStep.this.myProgressBar.isIndeterminate();
        }

        public void setFraction(double v) {
            this.myFraction = v;
            UIUtil.invokeLaterIfNeeded(() -> {
                InstallSelectedPackagesStep.this.myProgressBar.setIndeterminate(false);
                InstallSelectedPackagesStep.this.myProgressBar.setValue((int)(v * (double)(InstallSelectedPackagesStep.this.myProgressBar.getMaximum() - InstallSelectedPackagesStep.this.myProgressBar.getMinimum())));
            });
            if (this.myIndicator != null) {
                this.myIndicator.setFraction(v);
            }
        }

        public double getFraction() {
            return this.myFraction;
        }

        public void setSecondaryText(@Nullable String label2) {
            UIUtil.invokeLaterIfNeeded(() -> InstallSelectedPackagesStep.this.myProgressDetailLabel.setText(label2));
            if (this.myIndicator != null) {
                this.myIndicator.setText2(label2);
            }
        }

        public void logWarning(@NotNull String s) {
            this.appendText(s, (Color)JBColor.RED);
            this.myLogger.warn(s);
        }

        public void logWarning(@NotNull String s, @Nullable Throwable e) {
            this.appendText(s, (Color)JBColor.RED);
            this.myLogger.warn(s, e);
        }

        public void logError(@NotNull String s) {
            this.appendText(s, (Color)JBColor.RED);
            this.myLogger.error(s);
        }

        public void logError(@NotNull String s, @Nullable Throwable e) {
            this.appendText(s, (Color)JBColor.RED);
            this.myLogger.error(s, e);
        }

        public void logInfo(@NotNull String s) {
            this.appendText(s, JBColor.foreground());
            this.myLogger.info(s);
        }

        public void logVerbose(@NotNull String s) {
        }

        private void appendText(@NotNull String text2, @NotNull Color color) {
            UIUtil.invokeLaterIfNeeded(() -> {
                String current = InstallSelectedPackagesStep.this.mySdkManagerOutput.getText();
                int offset = 0;
                if (current == null) {
                    InstallSelectedPackagesStep.this.mySdkManagerOutput.setText("");
                } else if (current.endsWith("\n")) {
                    offset = 1;
                }
                StyledDocument document = InstallSelectedPackagesStep.this.mySdkManagerOutput.getStyledDocument();
                StyleConstants.setForeground(InstallSelectedPackagesStep.this.myOutputStyle, color);
                try {
                    document.insertString(document.getLength() - offset, text2, InstallSelectedPackagesStep.this.myOutputStyle);
                    document.insertString(document.getLength(), "\n", InstallSelectedPackagesStep.this.myOutputStyle);
                }
                catch (BadLocationException exception) {
                    this.myLogger.warn((Throwable)exception);
                }
            });
        }

        public void setIndicator(ProgressIndicator indicator) {
            this.myIndicator = indicator;
        }
    }
}

