/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sampledata.datasource;

import com.android.ide.common.util.PathString;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.StudioPathManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceContent
implements Function<OutputStream, Exception> {
    private static final Logger LOG = Logger.getInstance(ResourceContent.class);
    byte[] myContent;

    private ResourceContent(@NotNull byte[] content2) {
        this.myContent = content2;
    }

    @Nullable
    public static Path getSampleDataBaseDir() {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        Path jarPath = Paths.get(homePath, "plugins/android/resources/sampleData");
        if (StudioPathManager.isRunningFromSources()) {
            jarPath = StudioPathManager.resolvePathFromSourcesRoot((String)"tools/adt/idea/android/lib/sampleData");
        }
        if (Files.exists(jarPath, new LinkOption[0])) {
            LOG.debug("Sample data base dir found at " + jarPath);
            return jarPath;
        }
        LOG.warn("Unable to sampleData in path :" + jarPath);
        return null;
    }

    @Nullable
    public static Path getSampleDataUserDir(AndroidFacet facet) {
        PathString sampleDataDirectory = ProjectSystemUtil.getModuleSystem(facet.getModule()).getSampleDataDirectory();
        return sampleDataDirectory != null ? sampleDataDirectory.toPath() : null;
    }

    @NotNull
    public static ResourceContent fromDirectory(@NotNull String relativePath) {
        Path baseDir2 = ResourceContent.getSampleDataBaseDir();
        Path sampleDataPath = baseDir2 != null ? baseDir2.resolve(relativePath) : null;
        String content2 = "";
        if (sampleDataPath != null && Files.isDirectory(sampleDataPath, new LinkOption[0])) {
            try {
                content2 = Files.walk(sampleDataPath, 1, new FileVisitOption[0]).filter(file -> !file.equals(sampleDataPath)).map(Path::toString).collect(Collectors.joining("\n"));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new ResourceContent(content2.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static ResourceContent fromInputStream(@NotNull InputStream stream) {
        byte[] content2;
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = stream.read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }
            content2 = bytes.toByteArray();
        }
        catch (IOException e) {
            content2 = new byte[]{};
        }
        return new ResourceContent(content2);
    }

    @Override
    public Exception apply(OutputStream stream) {
        try {
            stream.write(this.myContent);
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }
}

