/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.profiler;

import com.android.utils.HashCodes;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CpuProfilerConfig {
    public static final int DEFAULT_BUFFER_SIZE_MB = 8;
    public static final String SAMPLED_JAVA_CONFIG_NAME = "Java/Kotlin Method Sample (legacy)";
    public static final String INSTRUMENTED_JAVA_CONFIG_NAME = "Java/Kotlin Method Trace";
    public static final String SAMPLED_NATIVE_CONFIG_NAME = "Callstack Sample";
    public static final String SYSTEM_TRACE_CONFIG_NAME = "System Trace";
    public static final String NATIVE_ALLOCATIONS_CONFIG_NAME = "Native Allocations";
    @NotNull
    private String myName;
    @NotNull
    private Technology myTechnology;
    private int mySamplingIntervalUs = 1000;
    private int myBufferSizeMb = 8;
    private int mySamplingRateBytes = 2048;
    private boolean myDualClock = false;

    public CpuProfilerConfig() {
        this.myName = Technology.SAMPLED_JAVA.getName();
        this.myTechnology = Technology.SAMPLED_JAVA;
    }

    public CpuProfilerConfig(@NotNull String name2, @NotNull Technology technology) {
        this.myName = name2;
        this.myTechnology = technology;
    }

    CpuProfilerConfig(@NotNull Technology technology) {
        this(technology.getName(), technology);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public CpuProfilerConfig setName(@NotNull String name2) {
        this.myName = name2;
        return this;
    }

    @NotNull
    public Technology getTechnology() {
        return this.myTechnology;
    }

    @NotNull
    public CpuProfilerConfig setTechnology(@NotNull Technology technology) {
        this.myTechnology = technology;
        return this;
    }

    public int getSamplingIntervalUs() {
        return this.mySamplingIntervalUs;
    }

    @NotNull
    public CpuProfilerConfig setSamplingIntervalUs(int samplingIntervalUs) {
        this.mySamplingIntervalUs = samplingIntervalUs;
        return this;
    }

    public int getBufferSizeMb() {
        return this.myBufferSizeMb;
    }

    @NotNull
    public CpuProfilerConfig setBufferSizeMb(int bufferSize) {
        this.myBufferSizeMb = bufferSize;
        return this;
    }

    public boolean getDualClock() {
        return this.myDualClock;
    }

    public CpuProfilerConfig setDualClock(boolean dualClock) {
        this.myDualClock = dualClock;
        return this;
    }

    public int getSamplingRateBytes() {
        return this.mySamplingRateBytes;
    }

    public CpuProfilerConfig setSamplingRateBytes(int samplingRateBytes) {
        this.mySamplingRateBytes = samplingRateBytes;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CpuProfilerConfig config = (CpuProfilerConfig)o;
        return this.mySamplingIntervalUs == config.mySamplingIntervalUs && this.myBufferSizeMb == config.myBufferSizeMb && Objects.equals(this.myName, config.myName) && this.myTechnology == config.myTechnology && this.mySamplingRateBytes == config.mySamplingRateBytes && this.myDualClock == config.myDualClock;
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myName.hashCode(), (int)this.myTechnology.hashCode(), (int)this.mySamplingIntervalUs, (int)this.myBufferSizeMb, (int)this.mySamplingRateBytes);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Technology {
        SAMPLED_JAVA{

            @Override
            @NotNull
            public String getName() {
                return CpuProfilerConfig.SAMPLED_JAVA_CONFIG_NAME;
            }
        }
        ,
        INSTRUMENTED_JAVA{

            @Override
            @NotNull
            public String getName() {
                return CpuProfilerConfig.INSTRUMENTED_JAVA_CONFIG_NAME;
            }
        }
        ,
        SAMPLED_NATIVE{

            @Override
            @NotNull
            public String getName() {
                return CpuProfilerConfig.SAMPLED_NATIVE_CONFIG_NAME;
            }
        }
        ,
        SYSTEM_TRACE{

            @Override
            @NotNull
            public String getName() {
                return CpuProfilerConfig.SYSTEM_TRACE_CONFIG_NAME;
            }
        }
        ,
        NATIVE_ALLOCATIONS{

            @Override
            @NotNull
            public String getName() {
                return CpuProfilerConfig.NATIVE_ALLOCATIONS_CONFIG_NAME;
            }
        };


        @NotNull
        public abstract String getName();
    }
}

