/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit.desugaring;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.deployment.liveedit.LiveEditCompiledClass;
import com.android.tools.idea.run.deployment.liveedit.LiveEditLogger;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.android.tools.idea.run.deployment.liveedit.desugaring.JarResourceCacheManager;
import com.android.tools.idea.run.deployment.liveedit.desugaring.LiveEditDesugarRequest;
import com.android.tools.idea.run.deployment.liveedit.desugaring.LiveEditDesugarResponse;
import com.android.tools.idea.run.deployment.liveedit.desugaring.R8DiagnosticHandler;
import com.android.tools.idea.run.deployment.liveedit.desugaring.R8MemoryClassFileConsumer;
import com.android.tools.idea.run.deployment.liveedit.desugaring.R8MemoryProgramResourceProvider;
import com.android.tools.idea.run.deployment.liveedit.tokens.ApplicationLiveEditServices;
import com.android.tools.idea.run.deployment.liveedit.tokens.DesugarConfigs;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResourceProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J6\u0010\u0018\u001a\u0016\u0012\b\u0012\u00060\u0011j\u0002`\u001a\u0012\b\u0012\u00060\u001bj\u0002`\u001c0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00132\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0002J\b\u0010\"\u001a\u00020#H\u0002J6\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001b0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00132\u0006\u0010\u0015\u001a\u00020\u00162\n\u0010%\u001a\u00060 j\u0002`!H\u0002J\b\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugar;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "applicationLiveEditServices", "Lcom/android/tools/idea/run/deployment/liveedit/tokens/ApplicationLiveEditServices;", "<init>", "(Lcom/android/tools/idea/run/deployment/liveedit/tokens/ApplicationLiveEditServices;)V", "logger", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditLogger;", "jarResourceCacheManager", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/JarResourceCacheManager;", "desugar", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugarResponse;", "request", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugarRequest;", "desugar$intellij_android_core", "getDesugarConfig", "", "getAndroidJar", "", "Lcom/android/tools/r8/ClassFileResourceProvider;", "module", "Lcom/intellij/openapi/module/Module;", "getClassPathResourceProvider", "desugarClasses", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/ClassName;", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/ByteCode;", "classes", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditCompiledClass;", "version", "", "Lcom/android/tools/idea/run/deployment/liveedit/desugaring/MinApiLevel;", "isCancelled", "", "desugarClassesForModule", "minApiLevel", "close", "", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nLiveEditDesugarer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveEditDesugarer.kt\ncom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,245:1\n1863#2:246\n1557#2:247\n1628#2,3:248\n1864#2:251\n1557#2:252\n1628#2,3:253\n1611#2,9:256\n1863#2:265\n1864#2:267\n1620#2:268\n1863#2,2:269\n1863#2,2:273\n1863#2,2:275\n1#3:266\n216#4,2:271\n*S KotlinDebug\n*F\n+ 1 LiveEditDesugarer.kt\ncom/android/tools/idea/run/deployment/liveedit/desugaring/LiveEditDesugar\n*L\n53#1:246\n54#1:247\n54#1:248,3\n53#1:251\n103#1:252\n103#1:253,3\n112#1:256,9\n112#1:265\n112#1:267\n112#1:268\n130#1:269,2\n191#1:273,2\n196#1:275,2\n112#1:266\n145#1:271,2\n*E\n"})
public final class LiveEditDesugar
implements AutoCloseable {
    @NotNull
    private final ApplicationLiveEditServices applicationLiveEditServices;
    @NotNull
    private final LiveEditLogger logger;
    @NotNull
    private final JarResourceCacheManager jarResourceCacheManager;

    public LiveEditDesugar(@NotNull ApplicationLiveEditServices applicationLiveEditServices) {
        Intrinsics.checkNotNullParameter((Object)applicationLiveEditServices, (String)"applicationLiveEditServices");
        this.applicationLiveEditServices = applicationLiveEditServices;
        this.logger = new LiveEditLogger("LE Desugar");
        this.jarResourceCacheManager = new JarResourceCacheManager(this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final LiveEditDesugarResponse desugar$intellij_android_core(@NotNull LiveEditDesugarRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        long now = System.nanoTime();
        LiveEditDesugarResponse response2 = new LiveEditDesugarResponse(request.getCompilerOutput());
        if (!((Boolean)StudioFlags.COMPOSE_DEPLOY_LIVE_EDIT_R8_DESUGAR.get()).booleanValue()) {
            Iterable $this$forEach$iv = request.getApiVersions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Collection<Pair> collection2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                int apiVersion = ((Number)element$iv).intValue();
                boolean bl = false;
                Iterable iterable = request.getCompilerOutput().getClasses$intellij_android_core();
                int n = apiVersion;
                LiveEditDesugarResponse liveEditDesugarResponse = response2;
                boolean $i$f$map = false;
                void var15_19 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LiveEditCompiledClass liveEditCompiledClass = (LiveEditCompiledClass)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(TuplesKt.to((Object)it.getName(), (Object)it.getData()));
                }
                collection2 = (List)destination$iv$iv;
                liveEditDesugarResponse.addOutputSet$intellij_android_core(n, MapsKt.toMap((Iterable)collection2));
            }
            return response2;
        }
        try {
            Iterator<Integer> $this$forEach$iv = request.getApiVersions().iterator();
            while ($this$forEach$iv.hasNext()) {
                int apiVersion = ((Number)$this$forEach$iv.next()).intValue();
                Map<String, byte[]> desugaredClasses = this.desugarClasses(request.getCompilerOutput().getClasses$intellij_android_core(), apiVersion);
                response2.addOutputSet$intellij_android_core(apiVersion, desugaredClasses);
            }
        }
        finally {
            this.jarResourceCacheManager.done();
        }
        long durationMs = (System.nanoTime() - now) / (long)1000000;
        this.logger.log$intellij_android_core("Runtime = " + durationMs);
        return response2;
    }

    private final String getDesugarConfig() {
        DesugarConfigs desguarConfigs = this.applicationLiveEditServices.getDesugarConfigs();
        if (desguarConfigs instanceof DesugarConfigs.Known) {
            if (((DesugarConfigs.Known)desguarConfigs).getConfigs().isEmpty()) {
                this.logger.log$intellij_android_core("Empty Desguar JSON Config from Build System");
                return null;
            }
            Path path = ((DesugarConfigs.Known)desguarConfigs).getConfigs().get(0);
            byte[] byArray = Files.readAllBytes(path);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            byte[] byArray2 = byArray;
            String config = new String(byArray2, Charsets.UTF_8);
            this.logger.log$intellij_android_core("Library Config = " + path);
            return config;
        }
        this.logger.log$intellij_android_core("Desugar Config Not Known");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassFileResourceProvider> getAndroidJar(Module module) {
        void $this$mapTo$iv$iv;
        if (module == null) {
            this.logger.log$intellij_android_core("Cannot retrieve android.jar (no module)");
            return CollectionsKt.emptyList();
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Collection<String> strings = ProjectSystemUtil.getProjectSystem(project).getBootClasspath(module);
        this.logger.log$intellij_android_core("Android.jar = " + strings);
        Iterable $this$map$iv = strings;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Path path = Paths.get((String)it, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            collection2.add(this.jarResourceCacheManager.getResourceCache$intellij_android_core(path));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassFileResourceProvider> getClassPathResourceProvider(Module module) {
        void $this$mapNotNullTo$iv$iv;
        if (module == null) {
            throw LiveEditUpdateException.Companion.desugarFailure$default(LiveEditUpdateException.Companion, "Cannot retrieve classpath (no module)", null, null, 6, null);
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<File> list = ProjectSystemUtil.getProjectSystem(project).getClassJarProvider().getModuleExternalLibraries(module);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getModuleExternalLibraries(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (it.toPath() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List classPath = (List)destination$iv$iv;
        this.logger.log$intellij_android_core("Classpath = " + classPath);
        List<ClassFileResourceProvider> list2 = classPath.stream().map(arg_0 -> LiveEditDesugar.getClassPathResourceProvider$lambda$5(arg_0 -> LiveEditDesugar.getClassPathResourceProvider$lambda$4(this, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"toList(...)");
        return list2;
    }

    private final Map<String, byte[]> desugarClasses(List<LiveEditCompiledClass> classes, int version2) {
        Map modulesSet = new LinkedHashMap();
        Iterable $this$forEach$iv = classes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String moduleName;
            LiveEditCompiledClass it = (LiveEditCompiledClass)element$iv;
            boolean bl = false;
            if (it.getModule() == null) {
                throw LiveEditUpdateException.Companion.desugarFailure$default(LiveEditUpdateException.Companion, "Cannot process class '" + it.getName() + "' without module", null, null, 6, null);
            }
            Intrinsics.checkNotNullExpressionValue((Object)it.getModule().getName(), (String)"getName(...)");
            if (!modulesSet.containsKey(moduleName)) {
                modulesSet.put(moduleName, new ArrayList());
            }
            Object v = modulesSet.get(moduleName);
            Intrinsics.checkNotNull(v);
            ((List)v).add(it);
        }
        HashMap<String, byte[]> allDesugaredClasses = new HashMap<String, byte[]>();
        Map $this$forEach$iv2 = modulesSet;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            String moduleName = (String)it.getKey();
            List compiledClasses = (List)it.getValue();
            this.logger.log$intellij_android_core("Batch for module: " + moduleName);
            Module module = ((LiveEditCompiledClass)((List)it.getValue()).get(0)).getModule();
            if (module == null) {
                throw LiveEditUpdateException.Companion.desugarFailure$default(LiveEditUpdateException.Companion, "Unable to desugar, no Module associated with " + moduleName, null, null, 6, null);
            }
            allDesugaredClasses.putAll(this.desugarClassesForModule(compiledClasses, module, version2));
        }
        return allDesugaredClasses;
    }

    private final boolean isCancelled() {
        try {
            ProgressManager.checkCanceled();
        }
        catch (ProcessCanceledException e) {
            return true;
        }
        return false;
    }

    private final Map<String, byte[]> desugarClassesForModule(List<LiveEditCompiledClass> classes, Module module, int minApiLevel) {
        ClassFileResourceProvider it;
        R8MemoryProgramResourceProvider memClassFileProvider = new R8MemoryProgramResourceProvider(classes, this.logger);
        R8MemoryClassFileConsumer memClassFileConsumer = new R8MemoryClassFileConsumer(this.logger);
        this.logger.log$intellij_android_core("minAPILevel =" + minApiLevel);
        R8DiagnosticHandler diagnosticHandler = new R8DiagnosticHandler(this.logger);
        D8Command.Builder command = (D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder((DiagnosticsHandler)diagnosticHandler).addProgramResourceProvider((ProgramResourceProvider)memClassFileProvider)).setMinApiLevel(minApiLevel)).setProgramConsumer((ProgramConsumer)memClassFileConsumer)).setCancelCompilationChecker(() -> LiveEditDesugar.desugarClassesForModule$lambda$8(this));
        Iterable $this$forEach$iv = this.getAndroidJar(module);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ClassFileResourceProvider)element$iv;
            boolean bl = false;
            command.addLibraryResourceProvider(it);
        }
        $this$forEach$iv = this.getClassPathResourceProvider(module);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ClassFileResourceProvider)element$iv;
            boolean bl = false;
            command.addClasspathResourceProvider(it);
        }
        DesugarConfigs desugarConfigs = this.applicationLiveEditServices.getDesugarConfigs();
        if (desugarConfigs instanceof DesugarConfigs.NotKnown) {
            throw LiveEditUpdateException.Companion.buildLibraryDesugarFailure$default(LiveEditUpdateException.Companion, String.valueOf(((DesugarConfigs.NotKnown)desugarConfigs).getMessage()), null, 2, null);
        }
        String desugarConfig = this.getDesugarConfig();
        if (desugarConfig != null) {
            command.addDesugaredLibraryConfiguration(desugarConfig);
        }
        try {
            D8.run((D8Command)((D8Command)command.build()));
        }
        catch (CompilationFailedException e) {
            ProgressManager.checkCanceled();
            throw LiveEditUpdateException.Companion.desugarFailure$default(LiveEditUpdateException.Companion, "R8 compilation error", null, e, 2, null);
        }
        return memClassFileConsumer.getClasses();
    }

    @Override
    public void close() {
        this.jarResourceCacheManager.close();
    }

    private static final ClassFileResourceProvider getClassPathResourceProvider$lambda$4(LiveEditDesugar this$0, Path it) {
        JarResourceCacheManager jarResourceCacheManager = this$0.jarResourceCacheManager;
        Intrinsics.checkNotNull((Object)it);
        return jarResourceCacheManager.getResourceCache$intellij_android_core(it);
    }

    private static final ClassFileResourceProvider getClassPathResourceProvider$lambda$5(Function1 $tmp0, Object p0) {
        return (ClassFileResourceProvider)$tmp0.invoke(p0);
    }

    private static final boolean desugarClassesForModule$lambda$8(LiveEditDesugar this$0) {
        return this$0.isCancelled();
    }
}

