/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment.liveedit;

import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.deployment.liveedit.LiveEditOutputBuilder;
import com.android.tools.idea.run.deployment.liveedit.LiveEditUpdateException;
import com.android.tools.idea.run.deployment.liveedit.PsiState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0007\u001aJ\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u001a\u0010\f\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0007\u0012\u0004\u0012\u00020\u000e0\r2\u001a\u0010\u000f\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0007\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u001a:\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u001a:\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000e0\r2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u001aV\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052 \u0010\u0019\u001a\u001c\u0012\u0004\u0012\u00020\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\r2 \u0010\u001a\u001a\u001c\u0012\u0004\u0012\u00020\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r0\rH\u0002\u001a>\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"logger", "Lcom/android/tools/idea/log/LogWrapper;", "getPsiValidationState", "Lcom/android/tools/idea/run/deployment/liveedit/PsiState;", "psiFile", "Lcom/intellij/psi/PsiFile;", "validatePsiChanges", "", "Lcom/android/tools/idea/run/deployment/liveedit/LiveEditUpdateException;", "old", "new", "validateConstructors", "oldConstructors", "", "", "newConstructors", "validateInitBlocks", "oldInit", "", "newInit", "validateProperties", "oldProps", "Lorg/jetbrains/kotlin/name/FqName;", "newProps", "validateEnums", "oldEnums", "newEnums", "validateEnum", "oldEntries", "newEntries", "flatten", "elem", "Lcom/intellij/psi/PsiElement;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nPsiValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiValidator.kt\ncom/android/tools/idea/run/deployment/liveedit/PsiValidatorKt\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,234:1\n29#2,3:235\n29#2,3:238\n126#3:241\n153#3,3:242\n126#3:245\n153#3,3:246\n*S KotlinDebug\n*F\n+ 1 PsiValidator.kt\ncom/android/tools/idea/run/deployment/liveedit/PsiValidatorKt\n*L\n42#1:235,3\n59#1:238,3\n84#1:241\n84#1:242,3\n85#1:245\n85#1:246,3\n*E\n"})
public final class PsiValidatorKt {
    @NotNull
    private static final LogWrapper logger = new LogWrapper(Logger.getInstance(LiveEditOutputBuilder.class));

    @RequiresReadLock
    @NotNull
    public static final PsiState getPsiValidationState(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiState state2 = new PsiState(psiFile);
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        psiFile.accept((PsiElementVisitor)state2);
        long traverseMs = System.currentTimeMillis() - start$iv;
        logger.info("Live Edit: PSI validator traversed PSI in " + traverseMs + " ms", new Object[0]);
        return state2;
    }

    @RequiresReadLock
    @NotNull
    public static final List<LiveEditUpdateException> validatePsiChanges(@Nullable PsiState old, @NotNull PsiState psiState) {
        Intrinsics.checkNotNullParameter((Object)((Object)psiState), (String)"new");
        if (old == null) {
            logger.info("No PSI snapshot for " + psiState.getPsiFile().getName() + "; it is likely a new file. Skipping PSI validation.", new Object[0]);
            return CollectionsKt.emptyList();
        }
        if (!Intrinsics.areEqual((Object)old.getPsiFile(), (Object)psiState.getPsiFile())) {
            throw new IllegalArgumentException("No reason to check differences between distinct PSI files");
        }
        List errors = new ArrayList();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        UtilKt.addIfNotNull((List)errors, (Object)PsiValidatorKt.validateProperties(old.getPsiFile(), old.getProperties(), psiState.getProperties()));
        UtilKt.addIfNotNull((List)errors, (Object)PsiValidatorKt.validateInitBlocks(old.getPsiFile(), old.getInitBlocks(), psiState.getInitBlocks()));
        UtilKt.addIfNotNull((List)errors, (Object)PsiValidatorKt.validateConstructors(old.getPsiFile(), old.getPrimaryConstructors(), psiState.getPrimaryConstructors()));
        UtilKt.addIfNotNull((List)errors, (Object)PsiValidatorKt.validateConstructors(old.getPsiFile(), old.getSecondaryConstructors(), psiState.getSecondaryConstructors()));
        UtilKt.addIfNotNull((List)errors, (Object)PsiValidatorKt.validateEnums(old.getPsiFile(), old.getEnums(), psiState.getEnums()));
        long validateMs = System.currentTimeMillis() - start$iv;
        logger.info("Live Edit: PSI validator checked PSI in " + validateMs + " ms", new Object[0]);
        return errors;
    }

    private static final LiveEditUpdateException validateConstructors(PsiFile psiFile, Map<List<String>, String> oldConstructors, Map<List<String>, String> newConstructors) {
        for (Map.Entry<List<String>, String> entry : oldConstructors.entrySet()) {
            String other;
            if (newConstructors.get(entry.getKey()) == null || Intrinsics.areEqual((Object)other, (Object)entry.getValue())) continue;
            return LiveEditUpdateException.Companion.unsupportedSourceModificationConstructor("in " + psiFile + ", modified constructor");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final LiveEditUpdateException validateInitBlocks(PsiFile psiFile, Map<Integer, String> oldInit, Map<Integer, String> newInit) {
        void $this$mapTo$iv$iv;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        Map $this$map$iv = MapsKt.toSortedMap(oldInit);
        boolean $i$f$map = false;
        Map map2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add((String)it.getValue());
        }
        List old = (List)destination$iv$iv;
        Map $this$map$iv2 = MapsKt.toSortedMap(newInit);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry bl = item$iv$iv = iterator3.next();
            collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add((String)it.getValue());
        }
        List list = (List)destination$iv$iv2;
        if (!Intrinsics.areEqual((Object)old, (Object)list)) {
            return LiveEditUpdateException.Companion.unsupportedSourceModificationInit("in " + psiFile + ", modified init block", psiFile);
        }
        return null;
    }

    private static final LiveEditUpdateException validateProperties(PsiFile psiFile, Map<FqName, String> oldProps, Map<FqName, String> newProps) {
        for (Map.Entry<FqName, String> entry : oldProps.entrySet()) {
            String other;
            if (newProps.get(entry.getKey()) == null || Intrinsics.areEqual((Object)other, (Object)entry.getValue())) continue;
            return LiveEditUpdateException.Companion.unsupportedSourceModificationModifiedField(String.valueOf(psiFile), "modified property " + entry.getKey().shortName() + " of " + entry.getKey().parent());
        }
        return null;
    }

    private static final LiveEditUpdateException validateEnums(PsiFile psiFile, Map<FqName, ? extends Map<FqName, String>> oldEnums, Map<FqName, ? extends Map<FqName, String>> newEnums) {
        for (Map.Entry<FqName, ? extends Map<FqName, String>> oldEnum : oldEnums.entrySet()) {
            Map<FqName, String> newEntries;
            LiveEditUpdateException result2;
            if (newEnums.get(oldEnum.getKey()) == null || (result2 = PsiValidatorKt.validateEnum(psiFile, oldEnum.getValue(), newEntries)) == null) continue;
            return result2;
        }
        return null;
    }

    private static final LiveEditUpdateException validateEnum(PsiFile psiFile, Map<FqName, String> oldEntries, Map<FqName, String> newEntries) {
        FqName removed = (FqName)CollectionsKt.singleOrNull((Iterable)SetsKt.minus(oldEntries.keySet(), (Iterable)newEntries.keySet()));
        if (removed != null) {
            return LiveEditUpdateException.Companion.unsupportedSourceModificationEnum("removed enum entry " + removed, psiFile);
        }
        FqName added = (FqName)CollectionsKt.singleOrNull((Iterable)SetsKt.minus(newEntries.keySet(), (Iterable)oldEntries.keySet()));
        if (added != null) {
            return LiveEditUpdateException.Companion.unsupportedSourceModificationEnum("added enum entry " + added, psiFile);
        }
        Iterator<Map.Entry<FqName, String>> oldIt = oldEntries.entrySet().iterator();
        Iterator<Map.Entry<FqName, String>> newIt = newEntries.entrySet().iterator();
        while (oldIt.hasNext() && newIt.hasNext()) {
            Map.Entry<FqName, String> old = oldIt.next();
            Map.Entry<FqName, String> entry = newIt.next();
            if (!Intrinsics.areEqual((Object)old.getKey(), (Object)entry.getKey())) {
                return LiveEditUpdateException.Companion.unsupportedSourceModificationEnum("modified order of enum " + old.getKey().parent(), psiFile);
            }
            if (Intrinsics.areEqual((Object)old.getValue(), (Object)entry.getValue())) continue;
            return LiveEditUpdateException.Companion.unsupportedSourceModificationEnum("modified enum initializer of " + old.getKey(), psiFile);
        }
        return null;
    }

    private static final String flatten(PsiElement elem) {
        List leafs = new ArrayList();
        ArrayDeque queue = new ArrayDeque();
        queue.addFirst((Object)elem);
        while (!((Collection)queue).isEmpty()) {
            PsiElement node = (PsiElement)queue.removeFirst();
            if (node.getFirstChild() == null && node instanceof LeafPsiElement) {
                leafs.add(node);
                continue;
            }
            PsiElement child = node.getLastChild();
            while (child != null) {
                queue.addFirst((Object)child);
                child = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)child, (boolean)false, (int)1, null);
            }
        }
        return CollectionsKt.joinToString$default((Iterable)leafs, (CharSequence)"", null, null, (int)0, null, PsiValidatorKt::flatten$lambda$4, (int)30, null);
    }

    private static final CharSequence flatten$lambda$4(LeafPsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public static final /* synthetic */ String access$flatten(PsiElement elem) {
        return PsiValidatorKt.flatten(elem);
    }
}

