/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.sdklib.deviceprovisioner.DeviceProvisioner;
import com.android.tools.idea.deviceprovisioner.DeviceProvisionerService;
import com.android.tools.idea.execution.common.debug.AndroidDebugger;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.NativeDebugOnRemoteDeviceCheckerKt;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0014\u001a\u00020\u000e2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u001a\u0010\u0014\u001a\u00020\u000e2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u0014\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/run/NativeDebugOnRemoteDeviceChecker;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "deviceProvisioner", "Lcom/android/sdklib/deviceprovisioner/DeviceProvisioner;", "getDeviceProvisioner", "()Lcom/android/sdklib/deviceprovisioner/DeviceProvisioner;", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "kotlin.jvm.PlatformType", "value", "", "showWarning", "getShowWarning", "()Z", "setShowWarning", "(Z)V", "showWarningIfNeeded", "debugger", "Lcom/android/tools/idea/execution/common/debug/AndroidDebugger;", "devices", "", "Lcom/android/tools/idea/run/AndroidDevice;", "deviceSerial", "", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nNativeDebugOnRemoteDeviceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeDebugOnRemoteDeviceChecker.kt\ncom/android/tools/idea/run/NativeDebugOnRemoteDeviceChecker\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n31#2,2:97\n1755#3,3:99\n*S KotlinDebug\n*F\n+ 1 NativeDebugOnRemoteDeviceChecker.kt\ncom/android/tools/idea/run/NativeDebugOnRemoteDeviceChecker\n*L\n37#1:97,2\n47#1:99,3\n*E\n"})
public final class NativeDebugOnRemoteDeviceChecker {
    @NotNull
    private final Project project;
    @NotNull
    private final DeviceProvisioner deviceProvisioner;
    private final PropertiesComponent propertiesComponent;

    public NativeDebugOnRemoteDeviceChecker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DeviceProvisionerService> serviceClass$iv = DeviceProvisionerService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.deviceProvisioner = ((DeviceProvisionerService)object).getDeviceProvisioner();
        this.propertiesComponent = PropertiesComponent.getInstance((Project)this.project);
    }

    @NotNull
    public final DeviceProvisioner getDeviceProvisioner() {
        return this.deviceProvisioner;
    }

    private final boolean getShowWarning() {
        return this.propertiesComponent.getBoolean("nativeDebuggerOnRemoteDeviceWarning", true);
    }

    private final void setShowWarning(boolean value2) {
        this.propertiesComponent.setValue("nativeDebuggerOnRemoteDeviceWarning", value2, true);
    }

    public final boolean showWarningIfNeeded(@NotNull AndroidDebugger<?> debugger, @NotNull List<? extends AndroidDevice> devices2) {
        Intrinsics.checkNotNullParameter(debugger, (String)"debugger");
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        if (debugger.isNative(this.project)) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = devices2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AndroidDevice it = (AndroidDevice)element$iv;
                        boolean bl2 = false;
                        if (!it.isRemote()) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return this.showWarningIfNeeded();
            }
        }
        return true;
    }

    public final boolean showWarningIfNeeded(@NotNull AndroidDebugger<?> debugger, @NotNull String deviceSerial) {
        Intrinsics.checkNotNullParameter(debugger, (String)"debugger");
        Intrinsics.checkNotNullParameter((Object)deviceSerial, (String)"deviceSerial");
        if (debugger.isNative(this.project) && NativeDebugOnRemoteDeviceCheckerKt.access$isRemote(this.deviceProvisioner, deviceSerial)) {
            return this.showWarningIfNeeded();
        }
        return true;
    }

    private final boolean showWarningIfNeeded() {
        boolean proceed2;
        boolean bl = proceed2 = this.getShowWarning() ? ((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo("Poor debugger performance", "Using a Native debugger with a remote device may result in very poor debugger performance. Do you want to proceed?").doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(this){
            final /* synthetic */ NativeDebugOnRemoteDeviceChecker this$0;
            {
                this.this$0 = $receiver;
            }

            public String getDoNotShowMessage() {
                return "Don't show me again";
            }

            public boolean isSelectedByDefault() {
                return false;
            }

            public void rememberChoice(boolean isSelected, int exitCode2) {
                NativeDebugOnRemoteDeviceChecker.access$setShowWarning(this.this$0, !isSelected);
            }
        })).guessWindowAndAsk() : true;
        if (proceed2) {
            Notification notification = new Notification("Android", "Poor debugger performance", "Debugging native code with remote devices may result in very poor performance.", NotificationType.WARNING);
            Notifications.Bus.notify((Notification)notification, (Project)this.project);
        }
        return proceed2;
    }

    public static final /* synthetic */ void access$setShowWarning(NativeDebugOnRemoteDeviceChecker $this, boolean value2) {
        $this.setShowWarning(value2);
    }
}

