/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.run.AndroidDevice;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.IndexNotReadyException;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchCompatibility {
    public static final LaunchCompatibility YES = new LaunchCompatibility(State.OK, null);
    @NonNls
    private static final String GOOGLE_APIS_TARGET_NAME = "Google APIs";
    private final String myReason;
    private final State myState;

    public LaunchCompatibility(@NotNull State state2, @Nullable String reason) {
        this.myReason = reason;
        this.myState = state2;
    }

    public LaunchCompatibility combine(@NotNull LaunchCompatibility other) {
        if (this.myState == State.ERROR) {
            return this;
        }
        if (other.myState == State.ERROR) {
            return other;
        }
        if (this.myState == State.WARNING) {
            return this;
        }
        return other;
    }

    @Nullable
    public String getReason() {
        return this.myReason;
    }

    @NotNull
    public State getState() {
        return this.myState;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("state", (Object)this.myState).add("reason", (Object)this.myReason).toString();
    }

    public boolean equals(Object o) {
        return o instanceof LaunchCompatibility && this.myState == ((LaunchCompatibility)o).myState && Objects.equal((Object)this.myReason, (Object)((LaunchCompatibility)o).myReason);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myState, this.myReason});
    }

    @NotNull
    public static LaunchCompatibility canRunOnDevice(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget projectTarget, @NotNull Supplier<EnumSet<IDevice.HardwareFeature>> getRequiredHardwareFeatures, @NotNull Set<Abi> supportedAbis, @NotNull AndroidDevice device2) {
        EnumSet<IDevice.HardwareFeature> requiredFeatures;
        AndroidVersion deviceVersion = device2.getVersion();
        if (!deviceVersion.equals((Object)AndroidVersion.DEFAULT) && !deviceVersion.canRun(minSdkVersion2)) {
            String reason = String.format("minSdk(%1$s) %3$s deviceSdk(%2$s)", minSdkVersion2, deviceVersion, minSdkVersion2.getCodename() == null ? ">" : "!=");
            return new LaunchCompatibility(State.WARNING, reason);
        }
        try {
            requiredFeatures = getRequiredHardwareFeatures.get();
        }
        catch (IndexNotReadyException e) {
            return new LaunchCompatibility(State.ERROR, "Required features are unsure because indices are not ready.");
        }
        for (IDevice.HardwareFeature feature : requiredFeatures) {
            if (device2.supportsFeature(feature)) continue;
            return new LaunchCompatibility(State.WARNING, "missing feature: " + feature);
        }
        if (device2.supportsFeature(IDevice.HardwareFeature.WATCH) && !requiredFeatures.contains(IDevice.HardwareFeature.WATCH)) {
            return new LaunchCompatibility(State.WARNING, "missing uses-feature watch, non-watch apks cannot be launched on a watch");
        }
        if (!supportedAbis.isEmpty()) {
            LinkedHashSet deviceAbis = Sets.newLinkedHashSet();
            deviceAbis.addAll(device2.getAbis());
            if (Sets.intersection(supportedAbis, (Set)deviceAbis).isEmpty()) {
                return new LaunchCompatibility(State.WARNING, "Device supports " + Joiner.on((String)", ").join((Iterable)deviceAbis) + ", but APK only supports " + Joiner.on((String)", ").join(supportedAbis));
            }
        }
        if (projectTarget.isPlatform()) {
            return YES;
        }
        List additionalLibs = projectTarget.getAdditionalLibraries();
        if (additionalLibs.isEmpty()) {
            return YES;
        }
        String targetName = projectTarget.getName();
        if (GOOGLE_APIS_TARGET_NAME.equals(targetName)) {
            return YES;
        }
        return new LaunchCompatibility(State.ERROR, "unsure if device supports addon: " + targetName);
    }

    public static enum State {
        OK,
        WARNING,
        ERROR;

    }
}

