/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.ui;

import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardData;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardRenameColumnsStep;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardRenameTablesStep;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardSelectDestinationStep;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardStep;
import com.android.tools.idea.room.migrations.update.DatabaseUpdate;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateMigrationWizard
extends AbstractWizard<GenerateMigrationWizardStep> {
    private static final String WIZARD_TITLE = "Generate a Room Migration";
    private GenerateMigrationWizardData myWizardData;
    private GenerateMigrationWizardStep selectDestinationStep;
    private GenerateMigrationWizardStep renameTablesStep;
    private GenerateMigrationWizardStep renameColumnsStep;

    public GenerateMigrationWizard(@NotNull Project project, @NotNull PsiPackage targetPackage, @NotNull PsiDirectory migrationClassDirectory, @NotNull PsiDirectory migrationTestDirectory, @NotNull DatabaseUpdate databaseUpdate) {
        super(WIZARD_TITLE, project);
        this.myWizardData = new GenerateMigrationWizardData(project, targetPackage, migrationClassDirectory, migrationTestDirectory, databaseUpdate);
        this.selectDestinationStep = new GenerateMigrationWizardSelectDestinationStep(this.myWizardData);
        this.renameTablesStep = new GenerateMigrationWizardRenameTablesStep(this.myWizardData);
        this.renameColumnsStep = new GenerateMigrationWizardRenameColumnsStep(this.myWizardData);
        this.addStep(this.selectDestinationStep);
        if (!this.renameTablesStep.shouldBeSkipped()) {
            this.addStep(this.renameTablesStep);
        }
        if (!this.renameColumnsStep.shouldBeSkipped()) {
            this.addStep(this.renameColumnsStep);
        }
        this.init();
    }

    protected boolean isLastStep() {
        return super.isLastStep() || this.allNextStepsCanBeSkipped(this.getCurrentStep());
    }

    protected int getNextStep(int step2) {
        int nextStep;
        if (step2 == this.getStepCount() - 1 || this.allNextStepsCanBeSkipped(step2)) {
            return step2;
        }
        for (nextStep = step2 + 1; nextStep < this.getStepCount() - 1 && ((GenerateMigrationWizardStep)this.mySteps.get(nextStep)).shouldBeSkipped(); ++nextStep) {
        }
        return nextStep;
    }

    protected int getPreviousStep(int step2) {
        int previousStep;
        if (step2 == 0) {
            return step2;
        }
        for (previousStep = step2 - 1; previousStep > 0 && ((GenerateMigrationWizardStep)this.mySteps.get(previousStep)).shouldBeSkipped(); --previousStep) {
        }
        return previousStep;
    }

    @Nullable
    protected String getHelpID() {
        return null;
    }

    @NotNull
    public PsiPackage getTargetPackage() {
        return this.myWizardData.getTargetPackage();
    }

    @NotNull
    public PsiDirectory getMigrationClassDirectory() {
        return this.myWizardData.getMigrationClassDirectory();
    }

    @NotNull
    public PsiDirectory getMigrationTestDirectory() {
        return this.myWizardData.getMigrationTestDirectory();
    }

    @NotNull
    public DatabaseUpdate getUserReviewedDatabaseUpdate() {
        return this.myWizardData.getUserReviewedDatabaseUpdate();
    }

    private boolean allNextStepsCanBeSkipped(int step2) {
        for (int futureStep = step2 + 1; futureStep < this.getStepCount(); ++futureStep) {
            if (((GenerateMigrationWizardStep)this.mySteps.get(futureStep)).shouldBeSkipped()) continue;
            return false;
        }
        return false;
    }

    public static class RenamePanel {
        private static final String HEADER_NAME_LABEL = "Old Name";
        private static final String HEADER_OPERATION_LABEL = "Operation";
        private static final String HEADER_NEW_NAME_LABEL = "New Name";
        private List<RenamePanelElement> renameStepElements = new ArrayList<RenamePanelElement>();
        private JBPanel renameStepPanel = new JBPanel((LayoutManager)new BorderLayout());

        public RenamePanel(@NotNull String label2, @NotNull List<String> oldNames, @NotNull List<String> newNames) {
            JBLabel renameStepPanelLabel = new JBLabel(label2);
            this.renameStepPanel.add((Component)renameStepPanelLabel, (Object)"North");
            renameStepPanelLabel.setLabelFor((Component)this.renameStepPanel);
            JBPanel listPanel = new JBPanel();
            listPanel.setLayout((LayoutManager)new BoxLayout((Container)listPanel, 1));
            JBPanel headerPanel2 = new JBPanel();
            headerPanel2.setLayout((LayoutManager)new BoxLayout((Container)headerPanel2, 0));
            headerPanel2.setMaximumSize(new Dimension(900, 35));
            JBLabel tableNameLabel = new JBLabel(HEADER_NAME_LABEL);
            tableNameLabel.setMaximumSize(new Dimension(300, 30));
            JBLabel operationLabel = new JBLabel(HEADER_OPERATION_LABEL);
            operationLabel.setMaximumSize(new Dimension(300, 30));
            JBLabel newNameLabel = new JBLabel(HEADER_NEW_NAME_LABEL);
            newNameLabel.setMaximumSize(new Dimension(300, 30));
            headerPanel2.add((Component)tableNameLabel);
            headerPanel2.add((Component)operationLabel);
            headerPanel2.add((Component)newNameLabel);
            listPanel.add((Component)headerPanel2);
            for (String oldName : oldNames) {
                RenamePanelElement renameStepElement = new RenamePanelElement(oldName, newNames);
                this.renameStepElements.add(renameStepElement);
                listPanel.add((Component)renameStepElement.getRenameStepElementPanel());
            }
            JBScrollPane renameStepScrollPane = new JBScrollPane();
            renameStepScrollPane.getViewport().setView((Component)listPanel);
            this.renameStepPanel.add((Component)renameStepScrollPane, (Object)"Center");
        }

        @NotNull
        public JBPanel getRenameStepPanel() {
            return this.renameStepPanel;
        }

        @NotNull
        public Map<String, String> getOldToNewNamesMapping() {
            HashMap<String, String> oldToNewNamesMapping = new HashMap<String, String>();
            for (RenamePanelElement renameStepElement : this.renameStepElements) {
                if (!renameStepElement.markedAsRenamed()) continue;
                oldToNewNamesMapping.put(renameStepElement.getInitialName(), renameStepElement.getNewName());
            }
            return oldToNewNamesMapping;
        }
    }

    public static class RenamePanelElement {
        public static final int MAX_PANEL_WIDTH = 900;
        public static final int MAX_PANEL_HEIGHT = 35;
        public static final int MAX_PANEL_COMPONENT_WIDTH = 300;
        public static final int MAX_PANEL_COMPONENT_HEIGHT = 30;
        private static final String DELETED = "deleted";
        private static final String RENAMED = "renamed";
        private static final String[] STATUSES = new String[]{"deleted", "renamed"};
        private JBLabel initialName;
        private ComboBox<String> statusComboBox;
        private ComboBox<String> newNamesComboBox;
        private JBPanel renameStepElementPanel;

        public RenamePanelElement(@NotNull String initialName, @NotNull List<String> newNames) {
            this.initialName = new JBLabel(initialName);
            this.initialName.setMaximumSize(new Dimension(300, 30));
            this.statusComboBox = new ComboBox((Object[])STATUSES);
            this.statusComboBox.setMaximumSize(new Dimension(300, 30));
            this.newNamesComboBox = new ComboBox();
            newNames.forEach(newName -> this.newNamesComboBox.addItem(newName));
            this.newNamesComboBox.setMaximumSize(new Dimension(300, 30));
            this.newNamesComboBox.setEnabled(false);
            this.renameStepElementPanel = new JBPanel();
            this.renameStepElementPanel.setLayout((LayoutManager)new BoxLayout((Container)this.renameStepElementPanel, 0));
            this.renameStepElementPanel.add((Component)this.initialName);
            this.renameStepElementPanel.add(this.statusComboBox);
            this.renameStepElementPanel.add(this.newNamesComboBox);
            this.renameStepElementPanel.setMaximumSize(new Dimension(900, 35));
            this.statusComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getItem().equals(RenamePanelElement.RENAMED)) {
                        if (e.getStateChange() == 1) {
                            newNamesComboBox.setEnabled(true);
                        } else {
                            newNamesComboBox.setEnabled(false);
                        }
                    }
                }
            });
        }

        @NotNull
        public String getInitialName() {
            return this.initialName.getText();
        }

        @NotNull
        String getStatus() {
            return (String)this.statusComboBox.getItemAt(this.statusComboBox.getSelectedIndex());
        }

        @NotNull
        String getNewName() {
            return (String)this.newNamesComboBox.getItemAt(this.newNamesComboBox.getSelectedIndex());
        }

        @NotNull
        public JBPanel getRenameStepElementPanel() {
            return this.renameStepElementPanel;
        }

        public boolean markedAsRenamed() {
            return this.getStatus().equals(RENAMED);
        }
    }
}

