/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.psi;

import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.android.utils.HashCodes;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceNavigationItem
implements NavigationItem {
    @NotNull
    private final ResourceItem myResource;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;

    public ResourceNavigationItem(@NotNull ResourceItem resourceItem, @NotNull VirtualFile file, @NotNull Project project) {
        this.myResource = resourceItem;
        this.myFile = file;
        this.myProject = project;
    }

    @NotNull
    public ResourceItem getResource() {
        return this.myResource;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getName() {
        return this.myResource.getName();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ResourceItemPresentation(this.myResource, this.myFile);
    }

    public void navigate(boolean requestFocus) {
        Navigatable target2 = this.getNavigationTarget();
        if (target2 != null) {
            target2.navigate(requestFocus);
        }
    }

    @Nullable
    private Navigatable getNavigationTarget() {
        PsiElement psiElement = AndroidResourceToPsiResolver.getInstance().resolveToDeclaration(this.myResource, this.myProject);
        return psiElement == null ? null : PsiNavigationSupport.getInstance().getDescriptor(psiElement);
    }

    public boolean canNavigate() {
        Navigatable target2 = this.getNavigationTarget();
        return target2 != null && target2.canNavigate();
    }

    public boolean canNavigateToSource() {
        Navigatable target2 = this.getNavigationTarget();
        return target2 != null && target2.canNavigateToSource();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceNavigationItem item = (ResourceNavigationItem)o;
        return this.myResource.equals(item.myResource) && this.myFile.equals(item.myFile) && this.myProject.equals(item.myProject);
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myResource.hashCode(), (int)this.myFile.hashCode(), (int)this.myProject.hashCode());
    }

    public static class ResourceItemPresentation
    implements ItemPresentation {
        @NotNull
        private final ResourceItem myResource;
        @NotNull
        private final VirtualFile myFile;

        public ResourceItemPresentation(@NotNull ResourceItem resourceItem, @NotNull VirtualFile file) {
            this.myResource = resourceItem;
            this.myFile = file;
        }

        @NotNull
        public String getPresentableText() {
            VirtualFile parentDir = this.myFile.getParent();
            if (parentDir == null) {
                return this.myResource.getName();
            }
            if (this.myResource.isFileBased()) {
                return this.myResource.getName() + " (" + parentDir.getName() + ")";
            }
            return this.myResource.getName() + " (..." + File.separatorChar + parentDir.getName() + File.separatorChar + this.myFile.getName() + ")";
        }

        @Nullable
        public Icon getIcon(boolean open2) {
            return ResourceReferencePsiElement.RESOURCE_ICON;
        }
    }
}

