/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.fileTypes.FontFileType;
import com.android.tools.idea.gradle.feature.flags.DeclarativeStudioSupport;
import com.android.tools.idea.lang.rs.AndroidRenderscriptFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.gradle.config.GradleFileType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"isGradleFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "isRelevantFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isRelevantFileType", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "intellij.android.core"})
public final class FileRelevanceKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isGradleFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (GradleFileType.isGradleFile((PsiFile)psiFile)) {
            return true;
        }
        FileType fileType = psiFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        String string = psiFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name2 = string;
        if (Intrinsics.areEqual((Object)fileType2.getName(), (Object)"Kotlin") && StringsKt.endsWith$default((String)name2, (String)"gradle.kts", (boolean)false, (int)2, null)) {
            return true;
        }
        if (DeclarativeStudioSupport.isEnabled() && StringsKt.endsWith$default((String)name2, (String)"gradle.dcl", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.endsWith$default((String)name2, (String)".versions.toml", (boolean)false, (int)2, null)) {
            return true;
        }
        if (fileType2 != PropertiesFileType.INSTANCE) return false;
        if (Intrinsics.areEqual((Object)"gradle.properties", (Object)name2)) return true;
        if (Intrinsics.areEqual((Object)"gradle-wrapper.properties", (Object)name2)) return true;
        if (!Intrinsics.areEqual((Object)"config.properties", (Object)name2)) return false;
        PsiDirectory psiDirectory = psiFile.getParent();
        if (!Intrinsics.areEqual((Object)".gradle", (Object)(psiDirectory != null ? psiDirectory.getName() : null))) return false;
        return true;
    }

    public static final boolean isRelevantFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        if (fileType2 == JavaFileType.INSTANCE || fileType2 == KotlinFileType.INSTANCE) {
            return false;
        }
        if (FileRelevanceKt.isRelevantFileType(fileType2)) {
            return true;
        }
        Object object = file.getParent();
        return object != null && (object = object.getName()) != null ? StringsKt.startsWith$default((String)object, (String)"raw", (boolean)false, (int)2, null) : false;
    }

    @Slow
    public static final boolean isRelevantFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String extension = file.getExtension();
        if (StringUtil.isEmpty((String)extension)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)"java", (Object)extension) || Intrinsics.areEqual((Object)"kt", (Object)extension)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)"xml", (Object)extension)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)"AndroidManifest.xml", (Object)file.getName())) {
            return true;
        }
        if (Intrinsics.areEqual((Object)"aidl", (Object)extension)) {
            return true;
        }
        Object object = file.getParent();
        boolean bl = object != null && (object = object.getName()) != null ? StringsKt.startsWith$default((String)object, (String)"raw", (boolean)false, (int)2, null) : false;
        if (bl) {
            return true;
        }
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        return Intrinsics.areEqual((Object)fileType2, (Object)((Object)AndroidRenderscriptFileType.INSTANCE)) || FileRelevanceKt.isRelevantFileType(fileType2);
    }

    private static final boolean isRelevantFileType(FileType fileType) {
        if (fileType == JavaFileType.INSTANCE || fileType == KotlinFileType.INSTANCE) {
            return false;
        }
        if (fileType == XmlFileType.INSTANCE) {
            return true;
        }
        return fileType.isBinary() && (fileType == ImageFileTypeManager.getInstance().getImageFileType() || fileType == FontFileType.INSTANCE);
    }
}

