/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.resources.ResourceRepository;
import com.google.common.base.Verify;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidClassWithOnlyInnerClassesBase
extends AndroidLightClassBase {
    private static final Logger LOG = Logger.getInstance(AndroidClassWithOnlyInnerClassesBase.class);
    @NotNull
    protected final CachedValue<PsiClass[]> myClassCache;
    @NotNull
    protected final String myShortName;
    @Nullable
    private final String myPackageName;

    protected AndroidClassWithOnlyInnerClassesBase(@NotNull String shortName, @Nullable String packageName, @NotNull PsiManager psiManager, @NotNull Collection<String> modifiers, @NotNull AndroidLightClassBase.AndroidLightClassModuleInfo moduleInfo) {
        this(shortName, packageName, psiManager, modifiers, new AndroidLightClassBase.ContainingFileProvider.Builder(AndroidClassWithOnlyInnerClassesBase.packageNameForContainingFile(packageName, psiManager.getProject()), shortName), moduleInfo);
    }

    private AndroidClassWithOnlyInnerClassesBase(@NotNull String shortName, @Nullable String packageName, @NotNull PsiManager psiManager, @NotNull Collection<String> modifiers, @NotNull AndroidLightClassBase.ContainingFileProvider.Builder containingFileProvider, @NotNull AndroidLightClassBase.AndroidLightClassModuleInfo moduleInfo) {
        super(psiManager, modifiers, containingFileProvider, moduleInfo);
        Project project = this.getProject();
        this.myShortName = shortName;
        this.myPackageName = packageName;
        this.myClassCache = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Recomputing inner classes of " + ((Object)((Object)this)).getClass());
            }
            PsiClass[] innerClasses = this.doGetInnerClasses();
            ModificationTracker dependencies2 = this.getInnerClassesDependencies();
            Verify.verify((!(dependencies2 instanceof ResourceRepository) ? 1 : 0) != 0, (String)"Resource repository leaked in a CachedValue.", (Object[])new Object[0]);
            return CachedValueProvider.Result.create((Object)innerClasses, (Object[])new Object[]{dependencies2});
        });
    }

    private static String packageNameForContainingFile(String packageName, Project project) {
        if (packageName == null || !PsiNameHelper.getInstance((Project)project).isQualifiedName(packageName)) {
            return "_";
        }
        return packageName;
    }

    @Nullable
    public String getPackageName() {
        return this.myPackageName;
    }

    @NotNull
    protected abstract PsiClass[] doGetInnerClasses();

    @NotNull
    protected abstract ModificationTracker getInnerClassesDependencies();

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        return (PsiClass[])this.myClassCache.getValue();
    }

    @NotNull
    public final String getName() {
        return this.myShortName;
    }

    @Override
    public TextRange getTextRange() {
        return TextRange.EMPTY_RANGE;
    }
}

