/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.tools.idea.rendering.webp.WebpConversionSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpConversionDialog
extends DialogWrapper
implements DocumentListener,
ChangeListener,
ActionListener {
    @Nls(capitalization=Nls.Capitalization.Title)
    public static final String TITLE = "Converting Images to WebP";
    private JSlider myQualitySlider;
    private JBTextField myQualityField;
    private JBRadioButton myLossyButton;
    private JBRadioButton myLosslessButton;
    private JBLabel myMinSdkVersionLabel;
    private JBCheckBox mySkipLargerCheckBox;
    private JBCheckBox mySkipNinePatchCheckBox;
    private JBCheckBox myPreviewImagesCheckBox;
    private JBLabel myWarningLabel;
    private JPanel myPanel;
    private JBLabel myPercentLabel;
    private JBLabel myLosslessReqLabel;
    private JBLabel myQualityLabel;
    private JBCheckBox mySkipTransparency;
    private JBLabel myMinSdkVersionLabel2;
    private boolean myIgnore;

    public WebpConversionDialog(@NotNull Project project, int minSdkVersion2, @NotNull WebpConversionSettings settings, boolean singleFile) {
        super(project);
        this.setupUI();
        this.setTitle(TITLE);
        this.fromSettings(settings);
        this.myQualityField.getDocument().addDocumentListener(this);
        this.myQualitySlider.addChangeListener(this);
        this.myLossyButton.addActionListener((ActionListener)this);
        this.myLosslessButton.addActionListener((ActionListener)this);
        this.actionPerformed(null);
        String minSdkVersionString = minSdkVersion2 == Integer.MAX_VALUE ? "unknown" : String.valueOf(minSdkVersion2);
        String minSdkText = "Current minSdkVersion is " + minSdkVersionString;
        this.myMinSdkVersionLabel.setText(minSdkText);
        this.myMinSdkVersionLabel2.setText(minSdkText);
        if (minSdkVersion2 < 14) {
            this.myWarningLabel.setText("WARNING: WebP requires API 14; current minSdkVersion is " + minSdkVersionString);
            this.myWarningLabel.setForeground((Color)JBColor.RED);
            this.myWarningLabel.setVisible(true);
        } else if (minSdkVersion2 < 18) {
            this.mySkipTransparency.setSelected(true);
            if (singleFile) {
                this.myMinSdkVersionLabel.setForeground((Color)JBColor.RED);
                this.myMinSdkVersionLabel2.setForeground((Color)JBColor.RED);
            }
        } else {
            this.myLosslessReqLabel.setVisible(false);
            this.myMinSdkVersionLabel.setVisible(false);
        }
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myPanel.setPreferredSize((Dimension)JBUI.size((int)500, (int)300));
        return this.myPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuality(int quality, boolean updateText, boolean updateSlider) {
        boolean old = this.myIgnore;
        try {
            this.myIgnore = true;
            if (updateSlider) {
                this.myQualitySlider.setValue(quality);
            }
            if (updateText) {
                this.myQualityField.setText(Integer.toString(quality));
            }
        }
        finally {
            this.myIgnore = old;
        }
    }

    private int getQualityPercent() {
        String text2 = this.myQualityField.getText().trim();
        try {
            int parsed = (int)Float.parseFloat(text2);
            return Math.max(0, Math.min(100, parsed));
        }
        catch (NumberFormatException ignore) {
            return -1;
        }
    }

    public void toSettings(@NotNull WebpConversionSettings settings) {
        settings.skipLargerImages = this.mySkipLargerCheckBox.isSelected();
        settings.skipNinePatches = this.mySkipNinePatchCheckBox.isSelected();
        settings.previewConversion = this.myPreviewImagesCheckBox.isSelected();
        settings.skipTransparentImages = this.mySkipTransparency.isSelected();
        settings.lossless = this.myLosslessButton.isSelected();
        int quality = this.getQualityPercent();
        if (quality < 0) {
            quality = 75;
        }
        settings.quality = quality;
    }

    public void fromSettings(@Nullable WebpConversionSettings settings) {
        if (settings != null) {
            boolean old = this.myIgnore;
            try {
                this.myIgnore = true;
                this.mySkipLargerCheckBox.setSelected(settings.skipLargerImages);
                this.mySkipNinePatchCheckBox.setSelected(settings.skipNinePatches);
                this.myPreviewImagesCheckBox.setSelected(settings.previewConversion);
                this.mySkipTransparency.setSelected(settings.skipTransparentImages);
                this.myLosslessButton.setSelected(settings.lossless);
                this.myQualitySlider.setValue(settings.quality);
                this.myQualityField.setText(Integer.toString(settings.quality));
            }
            finally {
                this.myIgnore = old;
            }
        }
    }

    private void qualityFieldEdited() {
        int quality;
        if (!this.myIgnore && (quality = this.getQualityPercent()) >= 0) {
            this.updateQuality(quality, false, true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.qualityFieldEdited();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.qualityFieldEdited();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.qualityFieldEdited();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.myIgnore && e.getSource() == this.myQualitySlider) {
            this.updateQuality(this.myQualitySlider.getValue(), true, false);
        }
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent e) {
        if (!this.myIgnore) {
            boolean lossless = this.myLosslessButton.isSelected();
            this.myQualityLabel.setEnabled(!lossless);
            this.myQualitySlider.setEnabled(!lossless);
            this.myQualityField.setEnabled(!lossless);
            this.myPercentLabel.setEnabled(!lossless);
            this.myPreviewImagesCheckBox.setEnabled(!lossless);
            this.myMinSdkVersionLabel.setEnabled(lossless);
            this.myLosslessReqLabel.setEnabled(lossless);
        }
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(14, 5, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.setVisible(true);
        this.myLossyButton = new JBRadioButton();
        this.myLossyButton.setSelected(true);
        this.myLossyButton.setText("Lossy encoding");
        this.myPanel.add((Component)this.myLossyButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.mySkipLargerCheckBox = new JBCheckBox();
        this.mySkipLargerCheckBox.setSelected(true);
        this.mySkipLargerCheckBox.setText("Skip files where the encoded result is larger than the original");
        this.myPanel.add((Component)this.mySkipLargerCheckBox, new GridConstraints(7, 0, 1, 5, 8, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(0, 20), null, 0, false));
        this.myQualityLabel = new JBLabel();
        this.myQualityLabel.setText("Encoding quality:");
        this.myPanel.add((Component)this.myQualityLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 4, false));
        Spacer spacer2 = new Spacer();
        this.myPanel.add((Component)spacer2, new GridConstraints(1, 4, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myQualityField = new JBTextField();
        this.myQualityField.setColumns(3);
        this.myPanel.add((Component)this.myQualityField, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.myQualitySlider = new JSlider();
        this.myQualitySlider.setMajorTickSpacing(10);
        this.myQualitySlider.setPaintLabels(false);
        this.myQualitySlider.setPaintTicks(true);
        this.myQualitySlider.setValue(80);
        this.myPanel.add((Component)this.myQualitySlider, new GridConstraints(1, 3, 1, 1, 8, 1, 0, 0, null, new Dimension(150, -1), null, 0, false));
        this.myPercentLabel = new JBLabel();
        this.myPercentLabel.setText("%");
        this.myPanel.add((Component)this.myPercentLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myLosslessButton = new JBRadioButton();
        this.myLosslessButton.setText("Lossless encoding");
        this.myPanel.add((Component)this.myLosslessButton, new GridConstraints(3, 0, 1, 5, 8, 0, 3, 3, null, null, null, 0, false));
        this.myLosslessReqLabel = new JBLabel();
        this.myLosslessReqLabel.setText("Warning: Lossless encoding requires Android 4.3 (API 18)");
        this.myPanel.add((Component)this.myLosslessReqLabel, new GridConstraints(4, 0, 1, 5, 8, 0, 0, 0, null, null, null, 4, false));
        this.myMinSdkVersionLabel = new JBLabel();
        this.myMinSdkVersionLabel.setText("");
        this.myPanel.add((Component)this.myMinSdkVersionLabel, new GridConstraints(5, 0, 1, 5, 8, 0, 0, 0, null, null, null, 4, false));
        this.myPreviewImagesCheckBox = new JBCheckBox();
        this.myPreviewImagesCheckBox.setSelected(true);
        this.myPreviewImagesCheckBox.setText("Preview/inspect each converted image before saving");
        this.myPanel.add((Component)this.myPreviewImagesCheckBox, new GridConstraints(2, 0, 1, 5, 8, 0, 3, 3, null, null, null, 4, false));
        this.myWarningLabel = new JBLabel();
        this.myWarningLabel.setVisible(false);
        this.myPanel.add((Component)this.myWarningLabel, new GridConstraints(13, 0, 1, 5, 8, 0, 0, 0, null, null, null, 4, false));
        Spacer spacer3 = new Spacer();
        this.myPanel.add((Component)spacer3, new GridConstraints(12, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.mySkipTransparency = new JBCheckBox();
        this.mySkipTransparency.setText("Skip images with transparency/alpha channel");
        this.myPanel.add((Component)this.mySkipTransparency, new GridConstraints(9, 0, 1, 5, 8, 0, 3, 3, null, null, null, 0, false));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Transparency requires Android 4.3 (API 18)");
        this.myPanel.add((Component)jBLabel1, new GridConstraints(10, 0, 1, 5, 8, 0, 0, 0, null, null, null, 4, false));
        this.mySkipNinePatchCheckBox = new JBCheckBox();
        this.mySkipNinePatchCheckBox.setEnabled(false);
        this.mySkipNinePatchCheckBox.setText("Skip nine-patch (.9.png) images");
        this.myPanel.add((Component)this.mySkipNinePatchCheckBox, new GridConstraints(8, 0, 1, 5, 8, 0, 3, 3, null, null, null, 0, false));
        this.myMinSdkVersionLabel2 = new JBLabel();
        this.myMinSdkVersionLabel2.setText("");
        this.myPanel.add((Component)this.myMinSdkVersionLabel2, new GridConstraints(11, 0, 1, 5, 8, 0, 0, 0, null, null, null, 4, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.myLossyButton);
        buttonGroup.add((AbstractButton)this.myLosslessButton);
    }
}

