/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.Gray;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class GutterIconFactory {
    private static final Logger LOG = Logger.getInstance(GutterIconFactory.class);
    private static final int RENDERING_SCALING_FACTOR = 10;

    GutterIconFactory() {
    }

    @Slow
    @Nullable
    public static Icon createIcon(@NotNull VirtualFile file, @Nullable RenderResources resolver, @NotNull AndroidFacet facet, int maxWidth, int maxHeight) {
        String path = file.getPath();
        if (path.endsWith(".xml")) {
            return GutterIconFactory.createXmlIcon(file, resolver, facet, maxWidth, maxHeight);
        }
        return GutterIconFactory.createBitmapIcon(file, maxWidth, maxHeight);
    }

    @NotNull
    private static String getXmlContent(@NotNull VirtualFile file) throws IOException {
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document == null) {
            return new String(file.contentsToByteArray());
        }
        return document.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    @Nullable
    private static Icon createXmlIcon(@NotNull VirtualFile file, @Nullable RenderResources resolver, @NotNull AndroidFacet facet, int maxWidth, int maxHeight) {
        try {
            Image image;
            String xml = GutterIconFactory.getXmlContent(file);
            if (xml.contains("<vector")) {
                VdPreview.TargetSize imageTargetSize = VdPreview.TargetSize.createFromMaxDimension((int)((int)JBUI.pixScale((float)maxWidth)));
                org.w3c.dom.Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document == null) {
                    return null;
                }
                Element root = document.getDocumentElement();
                if (root == null) {
                    return null;
                }
                if (resolver != null) {
                    GutterIconFactory.replaceResourceReferences(root, resolver);
                }
                StringBuilder builder = new StringBuilder(100);
                image = VdPreview.getPreviewFromVectorDocument((VdPreview.TargetSize)imageTargetSize, (org.w3c.dom.Document)document, (StringBuilder)builder);
                image = ImageUtil.ensureHiDPI((Image)image, (ScaleContext)ScaleContext.create());
                if (builder.length() > 0) {
                    LOG.warn("Problems rendering " + file.getPresentableUrl() + ": " + builder);
                }
            } else {
                DrawableRenderer renderer2 = new DrawableRenderer(facet, file);
                Dimension size = new Dimension(maxWidth * 10, maxHeight * 10);
                try {
                    CompletableFuture<BufferedImage> imageFuture = renderer2.renderDrawable(xml, size);
                    image = ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode() ? (Image)imageFuture.get(250L, TimeUnit.MILLISECONDS) : (Image)ProgressIndicatorUtils.awaitWithCheckCanceled(imageFuture);
                }
                catch (Throwable e) {
                    String message = String.format("Could not read/render icon image %1$s", file.getPresentableUrl());
                    LOG.debug(message, e);
                    image = null;
                }
                finally {
                    Disposer.dispose((Disposable)renderer2);
                }
                if (image == null) {
                    return null;
                }
                image = ImageUtil.ensureHiDPI((Image)image, (ScaleContext)ScaleContext.create());
                image = ImageUtil.scaleImage((Image)image, (int)maxWidth, (int)maxHeight);
            }
            return IconUtil.createImageIcon((Image)image);
        }
        catch (Throwable e) {
            String message = String.format("Could not read/render icon image %1$s", file.getPresentableUrl());
            LOG.warn(message, e);
            return null;
        }
    }

    @VisibleForTesting
    static boolean isReference(String attributeValue) {
        return ResourceUrl.parse((String)attributeValue) != null;
    }

    @VisibleForTesting
    static void replaceResourceReferences(@NotNull Node node, @NotNull RenderResources resolver) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            NamedNodeMap attributes = element.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String resolvedValue;
                Node attribute2 = attributes.item(i);
                String value2 = attribute2.getNodeValue();
                if (!GutterIconFactory.isReference(value2) || GutterIconFactory.isReference(resolvedValue = IdeResourcesUtil.resolveStringValue(resolver, value2))) continue;
                attribute2.setNodeValue(resolvedValue);
            }
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            GutterIconFactory.replaceResourceReferences(node, resolver);
        }
    }

    @Nullable
    private static Icon createBitmapIcon(@NotNull VirtualFile file, int maxWidth, int maxHeight) {
        Icon icon;
        block8: {
            InputStream stream = file.getInputStream();
            try {
                icon = GutterIconFactory.createBitmapIcon(ImageIO.read(stream), maxWidth, maxHeight);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn(String.format("Could not read icon image %1$s", file.getPresentableUrl()), (Throwable)e);
                    return null;
                }
            }
            stream.close();
        }
        return icon;
    }

    @Nullable
    private static Icon createBitmapIcon(BufferedImage bufferedImage, int maxWidth, int maxHeight) {
        if (bufferedImage != null) {
            Image image = ImageUtil.ensureHiDPI((Image)bufferedImage, (ScaleContext)ScaleContext.create());
            int imageWidth = image.getWidth(null);
            int imageHeight = image.getHeight(null);
            if (imageWidth > maxWidth || imageHeight > maxHeight) {
                double scale = Math.min((double)maxWidth / (double)imageWidth, (double)maxHeight / (double)imageHeight);
                if (bufferedImage.getType() == 13) {
                    BufferedImage bg = ImageUtil.createImage((int)imageWidth, (int)imageHeight, (int)2);
                    Graphics g = bg.getGraphics();
                    g.setColor(Gray.TRANSPARENT);
                    g.fillRect(0, 0, bg.getWidth(), bg.getHeight());
                    UIUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
                    g.dispose();
                    image = bg;
                }
                if ((image = ImageUtil.scaleImage((Image)image, (double)scale)).getWidth(null) > maxWidth || image.getHeight(null) > maxHeight) {
                    image = ImageUtil.toBufferedImage((Image)image, (boolean)false);
                    scale = Math.min((double)maxWidth / (double)image.getWidth(null), (double)maxHeight / (double)image.getHeight(null));
                    image = ImageUtil.scaleImage((Image)image, (double)scale);
                }
            } else {
                image = bufferedImage;
            }
            return IconUtil.createImageIcon((Image)image);
        }
        return null;
    }
}

