/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemBuildManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.BuildListener;
import com.android.tools.idea.rendering.BuildListenerKt;
import com.android.tools.idea.rendering.BuildTargetReference;
import com.android.tools.idea.rendering.ProjectSubscription;
import com.android.tools.idea.rendering.tokens.BuildSystemFilePreviewServices;
import com.android.tools.idea.util.SyncUtil;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000=\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\r\u001a$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\nH\u0002\u001a\u0011\u0010\f\u001a\u00020\r*\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"projectSubscriptionsLock", "Ljava/util/concurrent/locks/ReentrantLock;", "projectSubscriptions", "Ljava/util/WeakHashMap;", "Lcom/intellij/openapi/project/Project;", "Lcom/android/tools/idea/rendering/ProjectSubscription;", "forEachNonDisposedBuildListener", "", "project", "method", "Lkotlin/Function1;", "Lcom/android/tools/idea/rendering/BuildListener;", "createBuildListener", "com/android/tools/idea/rendering/BuildListenerKt$createBuildListener$1", "(Lcom/intellij/openapi/project/Project;)Lcom/android/tools/idea/rendering/BuildListenerKt$createBuildListener$1;", "setupBuildListener", "buildTargetReference", "Lcom/android/tools/idea/rendering/BuildTargetReference;", "buildable", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nBuildListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildListener.kt\ncom/android/tools/idea/rendering/BuildListenerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1863#2,2:230\n*S KotlinDebug\n*F\n+ 1 BuildListener.kt\ncom/android/tools/idea/rendering/BuildListenerKt\n*L\n73#1:230,2\n*E\n"})
public final class BuildListenerKt {
    @NotNull
    private static final ReentrantLock projectSubscriptionsLock = new ReentrantLock();
    @NotNull
    private static final WeakHashMap<Project, ProjectSubscription> projectSubscriptions = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void forEachNonDisposedBuildListener(Project project, Function1<? super BuildListener, Unit> method2) {
        List $i$a$-withLock-BuildListenerKt$forEachNonDisposedBuildListener$22;
        Lock lock = projectSubscriptionsLock;
        lock.lock();
        try {
            List list;
            boolean $i$a$-withLock-BuildListenerKt$forEachNonDisposedBuildListener$22 = false;
            ProjectSubscription projectSubscription = projectSubscriptions.get(project);
            if (projectSubscription != null) {
                ProjectSubscription subscription = projectSubscription;
                boolean bl = false;
                subscription.getListenersMap().keySet().removeIf(arg_0 -> BuildListenerKt.forEachNonDisposedBuildListener$lambda$3$lambda$2$lambda$1(BuildListenerKt::forEachNonDisposedBuildListener$lambda$3$lambda$2$lambda$0, arg_0));
                if (subscription.getListenersMap().isEmpty()) {
                    Disposer.dispose((Disposable)subscription.getProjectSystemListenerDisposable());
                    projectSubscriptions.remove(project);
                }
                list = new ArrayList<BuildListener>(subscription.getListenersMap().values());
            } else {
                list = CollectionsKt.emptyList();
            }
            $i$a$-withLock-BuildListenerKt$forEachNonDisposedBuildListener$22 = list;
        }
        finally {
            lock.unlock();
        }
        Iterable $this$forEach$iv = $i$a$-withLock-BuildListenerKt$forEachNonDisposedBuildListener$22;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            method2.invoke(element$iv);
        }
    }

    private static final createBuildListener.1 createBuildListener(Project $this$createBuildListener) {
        return new BuildSystemFilePreviewServices.BuildListener($this$createBuildListener){
            private final Project project;
            {
                this.project = $receiver;
            }

            public final Project getProject() {
                return this.project;
            }

            @UiThread
            public void buildStarted(BuildSystemFilePreviewServices.BuildListener.BuildMode buildMode, ListenableFuture<BuildSystemFilePreviewServices.BuildListener.BuildResult> buildResult) {
                boolean isCleanBuild;
                Intrinsics.checkNotNullParameter((Object)((Object)buildMode), (String)"buildMode");
                Intrinsics.checkNotNullParameter(buildResult, (String)"buildResult");
                boolean bl = isCleanBuild = buildMode == BuildSystemFilePreviewServices.BuildListener.BuildMode.CLEAN;
                if (!isCleanBuild) {
                    BuildListenerKt.access$forEachNonDisposedBuildListener(this.project, createBuildListener.buildStarted.1.INSTANCE);
                }
                Executor executor = MoreExecutors.directExecutor();
                Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"directExecutor(...)");
                FutureUtils.addCallback(buildResult, (Executor)executor, (FutureCallback)((FutureCallback)new FutureCallback<BuildSystemFilePreviewServices.BuildListener.BuildResult>(isCleanBuild, this){
                    final /* synthetic */ boolean $isCleanBuild;
                    final /* synthetic */ createBuildListener.1 this$0;
                    {
                        this.$isCleanBuild = $isCleanBuild;
                        this.this$0 = $receiver;
                    }

                    public void onSuccess(BuildSystemFilePreviewServices.BuildListener.BuildResult result2) {
                        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                        KFunction eventMethod2 = this.$isCleanBuild ? (KFunction)createBuildListener.buildStarted.onSuccess.eventMethod.1.INSTANCE : (!this.$isCleanBuild && result2.getStatus() == ProjectSystemBuildManager.BuildStatus.SUCCESS ? (KFunction)createBuildListener.buildStarted.onSuccess.eventMethod.2.INSTANCE : (KFunction)createBuildListener.buildStarted.onSuccess.eventMethod.3.INSTANCE);
                        BuildListenerKt.access$forEachNonDisposedBuildListener(this.this$0.getProject(), (Function1)eventMethod2);
                    }

                    public void onFailure(Throwable t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        if (!(t instanceof CancellationException)) {
                            createBuildListener.buildStarted.2 $this$thisLogger$iv = this;
                            boolean $i$f$thisLogger = false;
                            Logger logger = Logger.getInstance(createBuildListener.buildStarted.2.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                            logger.error(t);
                        }
                        BuildListenerKt.access$forEachNonDisposedBuildListener(this.this$0.getProject(), createBuildListener.buildStarted.onFailure.1.INSTANCE);
                    }
                }));
            }
        };
    }

    public static final void setupBuildListener(@NotNull BuildTargetReference buildTargetReference, @NotNull BuildListener buildable, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)buildTargetReference, (String)"buildTargetReference");
        Intrinsics.checkNotNullParameter((Object)buildable, (String)"buildable");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Project project = buildTargetReference.getProject();
        BuildSystemFilePreviewServices<?, AndroidProjectSystem> previewServices = BuildSystemFilePreviewServices.Companion.getBuildSystemFilePreviewServices(ProjectSystemUtil.getProjectSystem(project));
        if (Disposer.isDisposed((Disposable)parentDisposable)) {
            Logger.getInstance((String)"com.android.tools.idea.common.util.ChangeManager").warn("calling setupBuildListener for a disposed component " + parentDisposable);
            return;
        }
        BuildListenerKt.setupBuildListener$setupListener(parentDisposable, project, buildTargetReference, buildable, previewServices);
    }

    private static final boolean forEachNonDisposedBuildListener$lambda$3$lambda$2$lambda$0(Disposable it) {
        return Disposer.isDisposed((Disposable)it);
    }

    private static final boolean forEachNonDisposedBuildListener$lambda$3$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ProjectSubscription setupBuildListener$setupListenerWhenSmartAndSynced$lambda$8$lambda$4(BuildSystemFilePreviewServices $previewServices, Project $project, Project it) {
        ProjectSubscription projectSubscription = new ProjectSubscription();
        $previewServices.subscribeBuildListener($project, projectSubscription.getProjectSystemListenerDisposable(), BuildListenerKt.createBuildListener($project));
        return projectSubscription;
    }

    private static final ProjectSubscription setupBuildListener$setupListenerWhenSmartAndSynced$lambda$8$lambda$5(Function1 $tmp0, Object p0) {
        return (ProjectSubscription)$tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setupBuildListener$setupListenerWhenSmartAndSynced$lambda$8$lambda$7(Project $project, Disposable $parentDisposable) {
        Lock lock = projectSubscriptionsLock;
        lock.lock();
        try {
            boolean bl = false;
            ProjectSubscription projectSubscription = projectSubscriptions.get($project);
            if (projectSubscription != null) {
                ProjectSubscription disposingSubscription = projectSubscription;
                disposingSubscription.getListenersMap().remove($parentDisposable);
                if (disposingSubscription.getListenersMap().isEmpty()) {
                    Disposer.dispose((Disposable)disposingSubscription.getProjectSystemListenerDisposable());
                    projectSubscriptions.remove($project);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setupBuildListener$setupListenerWhenSmartAndSynced(Disposable $parentDisposable, BuildTargetReference $buildTargetReference, BuildListener $buildable, Project project, BuildSystemFilePreviewServices<?, ?> previewServices) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (Disposer.isDisposed((Disposable)$parentDisposable)) {
            return;
        }
        BuildSystemFilePreviewServices.BuildServices<BuildTargetReference> buildServices2 = BuildSystemFilePreviewServices.Companion.getBuildSystemFilePreviewServices($buildTargetReference).getBuildServices();
        ProjectSystemBuildManager.BuildStatus lastStatus = buildServices2.getLastCompileStatus($buildTargetReference);
        if (lastStatus == ProjectSystemBuildManager.BuildStatus.SUCCESS) {
            $buildable.buildStarted();
            $buildable.buildSucceeded();
        }
        Lock lock = projectSubscriptionsLock;
        lock.lock();
        try {
            boolean bl = false;
            ProjectSubscription subscription = projectSubscriptions.computeIfAbsent(project, arg_0 -> BuildListenerKt.setupBuildListener$setupListenerWhenSmartAndSynced$lambda$8$lambda$5(arg_0 -> BuildListenerKt.setupBuildListener$setupListenerWhenSmartAndSynced$lambda$8$lambda$4(previewServices, project, arg_0), arg_0));
            ((Map)subscription.getListenersMap()).put($parentDisposable, $buildable);
            $buildable.startedListening();
            Disposer.register((Disposable)$parentDisposable, () -> BuildListenerKt.setupBuildListener$setupListenerWhenSmartAndSynced$lambda$8$lambda$7(project, $parentDisposable));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private static final void setupBuildListener$setupListener$lambda$9(Project $project, Disposable $parentDisposable, BuildTargetReference $buildTargetReference, BuildListener $buildable, BuildSystemFilePreviewServices $previewServices, ProjectSystemSyncManager.SyncResult result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        if (result2.isSuccessful()) {
            BuildListenerKt.setupBuildListener$setupListenerWhenSmartAndSynced($parentDisposable, $buildTargetReference, $buildable, $project, $previewServices);
        } else {
            SyncUtil.listenUntilNextSync($project, $parentDisposable, new ProjectSystemSyncManager.SyncResultListener($parentDisposable, $project, $buildTargetReference, $buildable, $previewServices){
                final /* synthetic */ Disposable $parentDisposable;
                final /* synthetic */ Project $project;
                final /* synthetic */ BuildTargetReference $buildTargetReference;
                final /* synthetic */ BuildListener $buildable;
                final /* synthetic */ BuildSystemFilePreviewServices<?, ?> $previewServices;
                {
                    this.$parentDisposable = $parentDisposable;
                    this.$project = $project;
                    this.$buildTargetReference = $buildTargetReference;
                    this.$buildable = $buildable;
                    this.$previewServices = $previewServices;
                }

                public void syncEnded(ProjectSystemSyncManager.SyncResult result2) {
                    Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
                    BuildListenerKt.access$setupBuildListener$setupListener(this.$parentDisposable, this.$project, this.$buildTargetReference, this.$buildable, this.$previewServices);
                }
            });
        }
    }

    private static final void setupBuildListener$setupListener(Disposable $parentDisposable, Project project, BuildTargetReference $buildTargetReference, BuildListener $buildable, BuildSystemFilePreviewServices<?, ?> previewServices) {
        if (Disposer.isDisposed((Disposable)$parentDisposable)) {
            return;
        }
        SyncUtil.runWhenSmartAndSyncedOnEdt$default(project, $parentDisposable, arg_0 -> BuildListenerKt.setupBuildListener$setupListener$lambda$9(project, $parentDisposable, $buildTargetReference, $buildable, previewServices, arg_0), null, 4, null);
    }

    public static final /* synthetic */ void access$forEachNonDisposedBuildListener(Project project, Function1 method2) {
        BuildListenerKt.forEachNonDisposedBuildListener(project, (Function1<? super BuildListener, Unit>)method2);
    }

    public static final /* synthetic */ void access$setupBuildListener$setupListener(Disposable $parentDisposable, Project project, BuildTargetReference $buildTargetReference, BuildListener $buildable, BuildSystemFilePreviewServices previewServices) {
        BuildListenerKt.setupBuildListener$setupListener($parentDisposable, project, $buildTargetReference, $buildable, previewServices);
    }
}

