/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.rtl;

import com.android.tools.idea.refactoring.rtl.RtlSupportProperties;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nullable;

public class RtlSupportDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JCheckBox myAndroidManifestCheckBox;
    private JCheckBox myLayoutsCheckBox;
    private JCheckBox myReplaceLeftRightPropertiesCheckBox;
    private JCheckBox myGenerateV17VersionsCheckBox;
    private final RtlSupportProperties myProperties;
    private static Method cachedGetBundleMethod = null;

    public RtlSupportDialog(Project project) {
        super(project, true);
        this.setupUI();
        this.myProperties = new RtlSupportProperties();
        this.setTitle(AndroidBundle.message("android.refactoring.rtl.addsupport.dialog.title", new Object[0]));
        this.setOKButtonText(AndroidBundle.message("android.refactoring.rtl.addsupport.dialog.ok.button.text", new Object[0]));
        this.myLayoutsCheckBox.addItemListener(itemEvent -> {
            boolean isSelected = this.myLayoutsCheckBox.isSelected();
            this.myReplaceLeftRightPropertiesCheckBox.setEnabled(isSelected);
            this.myGenerateV17VersionsCheckBox.setEnabled(isSelected);
        });
        this.setDefaultValues();
        this.init();
    }

    protected String getHelpId() {
        return "org.jetbrains.android.r/studio-ui/rtl-refactor-help";
    }

    private void setDefaultValues() {
        this.myAndroidManifestCheckBox.setSelected(true);
        this.myLayoutsCheckBox.setSelected(true);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myAndroidManifestCheckBox;
    }

    public final RtlSupportProperties getProperties() {
        this.myProperties.updateAndroidManifest = this.myAndroidManifestCheckBox.isSelected();
        this.myProperties.updateLayouts = this.myLayoutsCheckBox.isSelected();
        this.myProperties.replaceLeftRightPropertiesOption = this.myReplaceLeftRightPropertiesCheckBox.isSelected();
        this.myProperties.generateV17resourcesOption = this.myGenerateV17VersionsCheckBox.isSelected();
        if (this.myProperties.generateV17resourcesOption) {
            this.myProperties.replaceLeftRightPropertiesOption = true;
        }
        return this.myProperties;
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)panel1, "North");
        JTextArea textArea1 = new JTextArea();
        textArea1.setBackground(UIManager.getColor("Button.background"));
        textArea1.setText(this.getMessageFromBundle("messages/AndroidBundle", "android.refactoring.rtl.addsupport.dialog.label.text"));
        panel1.add((Component)textArea1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)panel2, "Center");
        this.myAndroidManifestCheckBox = new JCheckBox();
        this.loadButtonText(this.myAndroidManifestCheckBox, this.getMessageFromBundle("messages/AndroidBundle", "android.refactoring.rtl.addsupport.dialog.option.label.update.manifest.text"));
        panel2.add((Component)this.myAndroidManifestCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myLayoutsCheckBox = new JCheckBox();
        this.loadButtonText(this.myLayoutsCheckBox, this.getMessageFromBundle("messages/AndroidBundle", "android.refactoring.rtl.addsupport.dialog.option.label.update.layouts.text"));
        panel2.add((Component)this.myLayoutsCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel2.add((Component)panel3, new GridConstraints(2, 0, 1, 1, 0, 2, 3, 3, null, null, null, 0, false));
        panel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)this.getMessageFromBundle("messages/AndroidBundle", "android.refactoring.rtl.addsupport.dialog.option.label.layouts.options.txt"), (int)0, (int)0, null, null));
        this.myReplaceLeftRightPropertiesCheckBox = new JCheckBox();
        this.loadButtonText(this.myReplaceLeftRightPropertiesCheckBox, this.getMessageFromBundle("messages/AndroidBundle", "android.refactoring.rtl.addsupport.dialog.option.label.layouts.options.replace.leftright.txt"));
        panel3.add((Component)this.myReplaceLeftRightPropertiesCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(251, 23), null, 0, false));
        this.myGenerateV17VersionsCheckBox = new JCheckBox();
        this.loadButtonText(this.myGenerateV17VersionsCheckBox, this.getMessageFromBundle("messages/AndroidBundle", "android.refactoring.rtl.addsupport.dialog.option.label.layouts.options.generate.v17.txt"));
        panel3.add((Component)this.myGenerateV17VersionsCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(251, 23), null, 0, false));
    }

    private String getMessageFromBundle(String path, String key) {
        ResourceBundle bundle;
        try {
            Class<?> thisClass = ((Object)((Object)this)).getClass();
            if (cachedGetBundleMethod == null) {
                Class<?> dynamicBundleClass = thisClass.getClassLoader().loadClass("com.intellij.DynamicBundle");
                cachedGetBundleMethod = dynamicBundleClass.getMethod("getBundle", String.class, Class.class);
            }
            bundle = (ResourceBundle)cachedGetBundleMethod.invoke(null, path, thisClass);
        }
        catch (Exception e) {
            bundle = ResourceBundle.getBundle(path);
        }
        return bundle.getString(key);
    }

    private void loadButtonText(AbstractButton component, String text2) {
        StringBuffer result2 = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text2.length(); ++i) {
            if (text2.charAt(i) == '&') {
                if (++i == text2.length()) break;
                if (!haveMnemonic && text2.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text2.charAt(i);
                    mnemonicIndex = result2.length();
                }
            }
            result2.append(text2.charAt(i));
        }
        component.setText(result2.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }
}

