/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.refactoring.modularize.AndroidCodeAndResourcesGraph;
import com.android.tools.idea.refactoring.modularize.DependencyTreeNode;
import com.android.tools.idea.refactoring.modularize.ResourceUrlTreeNode;
import com.android.tools.idea.refactoring.modularize.ResourceXmlUsageInfo;
import com.android.tools.idea.refactoring.modularize.UsageInfoTreeNode;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeHelper;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;

public class AndroidModularizePreviewPanel {
    private static final Logger LOGGER = Logger.getInstance(AndroidModularizePreviewPanel.class);
    private JPanel myPanel;
    private JPanel myDependenciesPanel;
    private JBLabel myClassesCount;
    private JBLabel myResourcesCount;
    private JBLabel myMethodsCount;
    private JBLabel mySizeEstimate;
    private final AndroidCodeAndResourcesGraph myGraph;
    private final Map<PsiElement, UsageInfo> myLookupMap;
    private final CheckedTreeNode myRootNode = new CheckedTreeNode();
    private CodeAndResourcesTreeTable myTreeView;
    private final boolean myShouldSelectAllReferences;

    public AndroidModularizePreviewPanel(@NotNull AndroidCodeAndResourcesGraph graph, UsageInfo[] infos, boolean shouldSelectAllReferences) {
        this.myGraph = graph;
        this.myLookupMap = Maps.newHashMapWithExpectedSize((int)infos.length);
        for (UsageInfo info : infos) {
            this.myLookupMap.put(info.getElement(), info);
        }
        this.myShouldSelectAllReferences = shouldSelectAllReferences;
        this.setupUI();
    }

    @NotNull
    public UsageInfo[] getSelectedUsages() {
        Set<UsageInfo> result2 = this.myTreeView.getCheckedNodes();
        return result2.toArray(UsageInfo.EMPTY_ARRAY);
    }

    public JPanel getPanel() {
        HashSet<PsiElement> parentElements = new HashSet<PsiElement>();
        for (PsiElement root : this.myGraph.getRoots()) {
            UsageInfoTreeNode rootNode = new UsageInfoTreeNode(this.myLookupMap.get(root), 0);
            this.myRootNode.add((MutableTreeNode)((Object)rootNode));
            parentElements.add(root);
            this.buildTree(rootNode, root, parentElements, this.myGraph.getReferencedOutsideScope());
            parentElements.remove(root);
        }
        PreviewRenderer renderer2 = new PreviewRenderer();
        GridConstraints constraints = new GridConstraints();
        constraints.setFill(3);
        ColumnInfo[] classesColumns = new ColumnInfo[]{new TreeColumnInfo("")};
        this.myTreeView = new CodeAndResourcesTreeTable(this.myRootNode, renderer2, classesColumns);
        this.myDependenciesPanel.add((Component)new JBScrollPane((Component)((Object)this.myTreeView)), constraints);
        this.myTreeView.getTree().getSelectionModel().setSelectionMode(1);
        this.myTreeView.getTree().addTreeSelectionListener(e -> ApplicationManager.getApplication().invokeLater(this::updateCounts));
        this.updateCounts();
        return this.myPanel;
    }

    private void updateCounts() {
        int classesCount = 0;
        int methodsCount = 0;
        int resourcesCount = 0;
        long size = 0L;
        for (UsageInfo usageInfo : this.myTreeView.getCheckedNodes()) {
            PsiElement psiElement = usageInfo.getElement();
            if (psiElement instanceof PsiFile) {
                if (psiElement instanceof KtFile) {
                    methodsCount += ((KtFile)psiElement).getDeclarations().size();
                    classes = ((KtFile)psiElement).getClasses();
                    classesCount += classes.length;
                    for (PsiClass clazz2 : classes) {
                        methodsCount += clazz2.getMethods().length;
                    }
                } else if (psiElement instanceof PsiJavaFile) {
                    classes = ((PsiJavaFile)psiElement).getClasses();
                    classesCount += classes.length;
                    for (PsiClass clazz2 : classes) {
                        methodsCount += clazz2.getMethods().length;
                    }
                } else {
                    ++resourcesCount;
                }
                size += ((PsiFile)psiElement).getVirtualFile().getLength();
                continue;
            }
            if (psiElement instanceof XmlTag) {
                size += (long)psiElement.getText().getBytes(Charset.defaultCharset()).length;
                continue;
            }
            LOGGER.warn("Couldn't determine contribution for element " + psiElement);
        }
        this.myClassesCount.setText(Integer.toString(classesCount));
        this.myMethodsCount.setText(Integer.toString(methodsCount));
        this.myResourcesCount.setText(Integer.toString(resourcesCount));
        this.mySizeEstimate.setText("~" + Long.toString(size / 1024L) + " KB");
    }

    private void buildTree(CheckedTreeNode parentNode, PsiElement psiElement, Set<PsiElement> parentElements, Set<PsiElement> outsiders) {
        Set<PsiElement> references = this.myGraph.getTargets(psiElement);
        ArrayList<DependencyTreeNode> childrenNodes = new ArrayList<DependencyTreeNode>(references.size());
        HashMap<ResourceReference, Set> resourceGroups = new HashMap<ResourceReference, Set>();
        for (PsiElement psiElement2 : references) {
            if (parentElements.contains(psiElement2)) continue;
            if (this.myLookupMap.get(psiElement2) instanceof ResourceXmlUsageInfo) {
                ResourceItem resourceItem = ((ResourceXmlUsageInfo)this.myLookupMap.get(psiElement2)).getResourceItem();
                ResourceReference resourceReference = resourceItem.getReferenceToSelf();
                Set otherItems = resourceGroups.computeIfAbsent(resourceReference, k -> new HashSet());
                otherItems.add(psiElement2);
                continue;
            }
            UsageInfoTreeNode childNode = new UsageInfoTreeNode(this.myLookupMap.get(psiElement2), this.myGraph.getFrequency(psiElement, psiElement2));
            childrenNodes.add(childNode);
            childNode.setChecked(this.myShouldSelectAllReferences || !outsiders.contains(psiElement2));
            parentElements.add(psiElement2);
            this.buildTree(childNode, psiElement2, parentElements, outsiders);
            parentElements.remove(psiElement2);
        }
        for (ResourceReference resourceReference : resourceGroups.keySet()) {
            ResourceUrlTreeNode urlTreeNode = new ResourceUrlTreeNode(resourceReference.getResourceUrl());
            childrenNodes.add(urlTreeNode);
            boolean checked = true;
            for (PsiElement reference : (Set)resourceGroups.get(resourceReference)) {
                if (this.myShouldSelectAllReferences || !outsiders.contains(reference)) continue;
                checked = false;
                break;
            }
            for (PsiElement reference : (Set)resourceGroups.get(resourceReference)) {
                UsageInfoTreeNode childNode = new UsageInfoTreeNode(this.myLookupMap.get(reference), this.myGraph.getFrequency(psiElement, reference));
                childNode.setEnabled(false);
                childNode.setChecked(checked);
                urlTreeNode.add((MutableTreeNode)((Object)childNode));
                parentElements.add(reference);
                this.buildTree(childNode, reference, parentElements, outsiders);
                parentElements.remove(reference);
            }
            urlTreeNode.setChecked(checked);
        }
        for (CheckedTreeNode checkedTreeNode : childrenNodes) {
            parentNode.add((MutableTreeNode)checkedTreeNode);
        }
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.setPreferredSize(new Dimension(640, 480));
        this.myDependenciesPanel = new JPanel();
        this.myDependenciesPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)this.myDependenciesPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 8, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)panel1, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Classes:");
        panel1.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Resource files:");
        panel1.add((Component)jBLabel2, new GridConstraints(0, 4, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.myClassesCount = new JBLabel();
        panel1.add((Component)this.myClassesCount, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myResourcesCount = new JBLabel();
        panel1.add((Component)this.myResourcesCount, new GridConstraints(0, 5, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Methods:");
        panel1.add((Component)jBLabel3, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.myMethodsCount = new JBLabel();
        panel1.add((Component)this.myMethodsCount, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Size:");
        panel1.add((Component)jBLabel4, new GridConstraints(0, 6, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
        this.mySizeEstimate = new JBLabel();
        panel1.add((Component)this.mySizeEstimate, new GridConstraints(0, 7, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
    }

    private static class CodeAndResourcesTreeTable
    extends TreeTableView {
        private final EventDispatcher<CheckboxTreeListener> myEventDispatcher;

        public CodeAndResourcesTreeTable(CheckedTreeNode root, CheckboxTree.CheckboxTreeCellRenderer renderer2, ColumnInfo[] columns2) {
            super(new ListTreeTableModelOnColumns((TreeNode)root, columns2));
            TreeTableTree tree = this.getTree();
            this.myEventDispatcher = EventDispatcher.create(CheckboxTreeListener.class);
            CheckboxTreeBase.CheckPolicy selectionPolicy = new CheckboxTreeBase.CheckPolicy(true, true, true, false);
            CheckboxTreeHelper helper = new CheckboxTreeHelper(selectionPolicy, this.myEventDispatcher);
            helper.initTree((Tree)tree, (JComponent)((Object)this), (CheckboxTreeBase.CheckboxTreeCellRendererBase)renderer2);
            tree.setSelectionRow(0);
            for (int i = 0; i < root.getChildCount(); ++i) {
                tree.expandPath(new TreePath(((DefaultMutableTreeNode)root.getChildAt(i)).getPath()));
            }
        }

        public void addCheckboxTreeListener(@NotNull CheckboxTreeListener listener2) {
            this.myEventDispatcher.addListener((EventListener)listener2);
        }

        public Set<UsageInfo> getCheckedNodes() {
            final HashSet<UsageInfo> nodes = new HashSet<UsageInfo>();
            new Object(){

                public void collect(CheckedTreeNode node) {
                    if (!node.isChecked()) {
                        return;
                    }
                    Object userObject = node.getUserObject();
                    if (userObject instanceof UsageInfo) {
                        nodes.add((UsageInfo)userObject);
                    }
                    if (!node.isLeaf()) {
                        for (int i = 0; i < node.getChildCount(); ++i) {
                            TreeNode child = node.getChildAt(i);
                            if (!(child instanceof CheckedTreeNode)) continue;
                            this.collect((CheckedTreeNode)child);
                        }
                    }
                }
            }.collect((CheckedTreeNode)this.getTree().getModel().getRoot());
            return nodes;
        }
    }

    private static class PreviewRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private PreviewRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value2 instanceof DependencyTreeNode) {
                ((DependencyTreeNode)((Object)value2)).render(this.getTextRenderer());
            }
        }
    }
}

