/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.stacktrace;

import com.android.tools.nativeSymbolizer.NativeSymbolizer;
import com.android.tools.nativeSymbolizer.Symbol;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.stacktrace.NativeFrameSymbolizer;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class IntelliJNativeFrameSymbolizer
implements NativeFrameSymbolizer {
    static final int PREVIOUS_INSTRUCTION_OFFSET = -1;
    @NotNull
    private final NativeSymbolizer mySymbolizer;

    private static Logger getLogger() {
        return Logger.getInstance(IntelliJNativeFrameSymbolizer.class);
    }

    public IntelliJNativeFrameSymbolizer(@NotNull NativeSymbolizer symbolizer) {
        this.mySymbolizer = symbolizer;
    }

    @NotNull
    public Memory.NativeCallStack.NativeFrame symbolize(String abi, Memory.NativeCallStack.NativeFrame unsymbolizedFrame) {
        Symbol symbol = null;
        long instructionOffset = this.getOffsetOfPreviousInstruction(unsymbolizedFrame.getModuleOffset());
        try {
            symbol = this.mySymbolizer.symbolize(abi, new File(unsymbolizedFrame.getModuleName()), instructionOffset);
        }
        catch (IOException | RuntimeException e) {
            IntelliJNativeFrameSymbolizer.getLogger().warn((Throwable)e);
        }
        Memory.NativeCallStack.NativeFrame.Builder builder = unsymbolizedFrame.toBuilder();
        if (symbol == null) {
            String unfoundSymbolName = String.format("0x%x", instructionOffset);
            builder.setSymbolName(unfoundSymbolName);
        } else {
            builder.setSymbolName(symbol.getName()).setModuleName(symbol.getModule()).setFileName(symbol.getSourceFile()).setLineNumber(symbol.getLineNumber());
        }
        return builder.build();
    }

    public void stop() {
        this.mySymbolizer.stop();
    }

    private long getOffsetOfPreviousInstruction(long offset) {
        return offset + -1L;
    }
}

