/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.profilingconfig;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.ArtSampledConfiguration;
import com.android.tools.profilers.cpu.config.AtraceConfiguration;
import com.android.tools.profilers.cpu.config.PerfettoNativeAllocationsConfiguration;
import com.android.tools.profilers.cpu.config.PerfettoSystemTraceConfiguration;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.config.SimpleperfConfiguration;
import com.android.tools.profilers.cpu.config.UnspecifiedConfiguration;
import com.android.tools.profilers.taskbased.home.TaskHomeTabModel;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Unmodifiable;

public class CpuProfilerConfigConverter {
    private CpuProfilerConfigConverter() {
    }

    public static CpuProfilerConfig fromProfilingConfiguration(ProfilingConfiguration config) {
        CpuProfilerConfig cpuProfilerConfig = null;
        switch (config.getTraceType()) {
            case ART: {
                if (config instanceof ArtSampledConfiguration) {
                    ArtSampledConfiguration artSampledConfiguration = (ArtSampledConfiguration)config;
                    cpuProfilerConfig = new CpuProfilerConfig(artSampledConfiguration.getName(), CpuProfilerConfig.Technology.SAMPLED_JAVA);
                    cpuProfilerConfig.setSamplingIntervalUs(artSampledConfiguration.getProfilingSamplingIntervalUs());
                    cpuProfilerConfig.setBufferSizeMb(artSampledConfiguration.getProfilingBufferSizeInMb());
                    cpuProfilerConfig.setDualClock(artSampledConfiguration.getDualClock());
                    break;
                }
                ArtInstrumentedConfiguration artInstrumentedConfiguration = (ArtInstrumentedConfiguration)config;
                cpuProfilerConfig = new CpuProfilerConfig(artInstrumentedConfiguration.getName(), CpuProfilerConfig.Technology.INSTRUMENTED_JAVA);
                cpuProfilerConfig.setBufferSizeMb(artInstrumentedConfiguration.getProfilingBufferSizeInMb());
                cpuProfilerConfig.setDualClock(artInstrumentedConfiguration.getDualClock());
                break;
            }
            case SIMPLEPERF: {
                SimpleperfConfiguration simpleperfConfiguration = (SimpleperfConfiguration)config;
                cpuProfilerConfig = new CpuProfilerConfig(simpleperfConfiguration.getName(), CpuProfilerConfig.Technology.SAMPLED_NATIVE);
                cpuProfilerConfig.setSamplingIntervalUs(simpleperfConfiguration.getProfilingSamplingIntervalUs());
                break;
            }
            case ATRACE: {
                AtraceConfiguration atraceConfiguration = (AtraceConfiguration)config;
                cpuProfilerConfig = new CpuProfilerConfig(atraceConfiguration.getName(), CpuProfilerConfig.Technology.SYSTEM_TRACE);
                cpuProfilerConfig.setBufferSizeMb(4);
                break;
            }
            case PERFETTO: {
                if (config instanceof PerfettoNativeAllocationsConfiguration) {
                    PerfettoNativeAllocationsConfiguration perfettoNativeAllocationsConfiguration = (PerfettoNativeAllocationsConfiguration)config;
                    cpuProfilerConfig = new CpuProfilerConfig(perfettoNativeAllocationsConfiguration.getName(), CpuProfilerConfig.Technology.NATIVE_ALLOCATIONS);
                    cpuProfilerConfig.setSamplingRateBytes(perfettoNativeAllocationsConfiguration.getMemorySamplingIntervalBytes());
                    break;
                }
                PerfettoSystemTraceConfiguration perfettoSystemTraceConfiguration = (PerfettoSystemTraceConfiguration)config;
                cpuProfilerConfig = new CpuProfilerConfig(perfettoSystemTraceConfiguration.getName(), CpuProfilerConfig.Technology.SYSTEM_TRACE);
                cpuProfilerConfig.setBufferSizeMb(4);
                break;
            }
            case UNSPECIFIED: {
                UnspecifiedConfiguration unspecifiedConfiguration = (UnspecifiedConfiguration)config;
                cpuProfilerConfig = new CpuProfilerConfig(unspecifiedConfiguration.getName(), CpuProfilerConfig.Technology.SAMPLED_JAVA);
            }
        }
        return cpuProfilerConfig;
    }

    public static ProfilingConfiguration toProfilingConfiguration(CpuProfilerConfig config, int deviceApi) {
        ArtSampledConfiguration configuration2 = null;
        String name2 = config.getName();
        switch (config.getTechnology()) {
            case SAMPLED_JAVA: {
                configuration2 = new ArtSampledConfiguration(name2);
                configuration2.setProfilingBufferSizeInMb(config.getBufferSizeMb());
                configuration2.setProfilingSamplingIntervalUs(config.getSamplingIntervalUs());
                configuration2.setDualClock(config.getDualClock());
                break;
            }
            case INSTRUMENTED_JAVA: {
                configuration2 = new ArtInstrumentedConfiguration(name2);
                ((ArtInstrumentedConfiguration)configuration2).setProfilingBufferSizeInMb(config.getBufferSizeMb());
                ((ArtInstrumentedConfiguration)configuration2).setDualClock(config.getDualClock());
                break;
            }
            case SAMPLED_NATIVE: {
                configuration2 = new SimpleperfConfiguration(name2);
                ((SimpleperfConfiguration)configuration2).setProfilingSamplingIntervalUs(config.getSamplingIntervalUs());
                break;
            }
            case SYSTEM_TRACE: {
                if (((Boolean)StudioFlags.PROFILER_TRACEBOX.get()).booleanValue() && deviceApi >= 23) {
                    configuration2 = new PerfettoSystemTraceConfiguration(name2, true);
                    break;
                }
                if (deviceApi >= 28) {
                    configuration2 = new PerfettoSystemTraceConfiguration(name2, false);
                    break;
                }
                configuration2 = new AtraceConfiguration(name2);
                break;
            }
            case NATIVE_ALLOCATIONS: {
                configuration2 = new PerfettoNativeAllocationsConfiguration(name2);
                ((PerfettoNativeAllocationsConfiguration)configuration2).setMemorySamplingIntervalBytes(config.getSamplingRateBytes());
            }
        }
        return configuration2;
    }

    public static @Unmodifiable List<ProfilingConfiguration> toProfilingConfiguration(List<CpuProfilerConfig> configs, int deviceApi) {
        return ContainerUtil.map(configs, config -> CpuProfilerConfigConverter.toProfilingConfiguration(config, deviceApi));
    }

    public static String fromTaskTypeToConfigName(ProfilerTaskType taskType, TaskHomeTabModel.TaskRecordingType recordingType) {
        String configName = "";
        switch (taskType) {
            case JAVA_KOTLIN_METHOD_RECORDING: {
                if (recordingType == TaskHomeTabModel.TaskRecordingType.SAMPLED) {
                    configName = "Java/Kotlin Method Sample (legacy)";
                    break;
                }
                if (recordingType != TaskHomeTabModel.TaskRecordingType.INSTRUMENTED) break;
                configName = "Java/Kotlin Method Trace";
                break;
            }
            case CALLSTACK_SAMPLE: {
                configName = "Callstack Sample";
                break;
            }
            case SYSTEM_TRACE: {
                configName = "System Trace";
                break;
            }
            case NATIVE_ALLOCATIONS: {
                configName = "Native Allocations";
            }
        }
        return configName;
    }

    public static ProfilerTaskType fromTechnologyToTaskType(CpuProfilerConfig.Technology technology) {
        return switch (technology) {
            default -> throw new IncompatibleClassChangeError();
            case CpuProfilerConfig.Technology.SAMPLED_JAVA, CpuProfilerConfig.Technology.INSTRUMENTED_JAVA -> ProfilerTaskType.JAVA_KOTLIN_METHOD_RECORDING;
            case CpuProfilerConfig.Technology.SAMPLED_NATIVE -> ProfilerTaskType.CALLSTACK_SAMPLE;
            case CpuProfilerConfig.Technology.SYSTEM_TRACE -> ProfilerTaskType.SYSTEM_TRACE;
            case CpuProfilerConfig.Technology.NATIVE_ALLOCATIONS -> ProfilerTaskType.NATIVE_ALLOCATIONS;
        };
    }
}

