/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.analytics;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.ide.common.util.DeviceUtils;
import com.android.sdklib.AndroidVersion;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.profilingconfig.CpuProfilerConfigConverter;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.FilterMetadata;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.CpuCaptureSessionArtifact;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.ArtSampledConfiguration;
import com.android.tools.profilers.cpu.config.PerfettoNativeAllocationsConfiguration;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.config.SimpleperfConfiguration;
import com.android.tools.profilers.memory.HprofSessionArtifact;
import com.android.tools.profilers.memory.LegacyAllocationsSessionArtifact;
import com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.ProjectClassesInstanceFilter;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.tasks.ProfilerTaskType;
import com.android.tools.profilers.tasks.TaskAttachmentPoint;
import com.android.tools.profilers.tasks.TaskDataOrigin;
import com.android.tools.profilers.tasks.TaskFinishedState;
import com.android.tools.profilers.tasks.TaskMetadataStatus;
import com.android.tools.profilers.tasks.TaskProcessingFailedMetadata;
import com.android.tools.profilers.tasks.TaskStartFailedMetadata;
import com.android.tools.profilers.tasks.TaskStopFailedMetadata;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AdtUiBoxSelectionMetadata;
import com.google.wireless.android.sdk.stats.AdtUiTrackGroupMetadata;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.google.wireless.android.sdk.stats.CpuApiTracingMetadata;
import com.google.wireless.android.sdk.stats.CpuCaptureMetadata;
import com.google.wireless.android.sdk.stats.CpuImportTraceMetadata;
import com.google.wireless.android.sdk.stats.CpuProfilingConfig;
import com.google.wireless.android.sdk.stats.CpuStartupProfilingMetadata;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.FilterMetadata;
import com.google.wireless.android.sdk.stats.MemoryInstanceFilterMetadata;
import com.google.wireless.android.sdk.stats.PowerProfilerCaptureMetadata;
import com.google.wireless.android.sdk.stats.ProfilerSessionCreationMetaData;
import com.google.wireless.android.sdk.stats.ProfilerSessionSelectionMetaData;
import com.google.wireless.android.sdk.stats.RunWithProfilingMetadata;
import com.google.wireless.android.sdk.stats.TaskEnteredMetadata;
import com.google.wireless.android.sdk.stats.TaskFailedMetadata;
import com.google.wireless.android.sdk.stats.TaskFinishedMetadata;
import com.google.wireless.android.sdk.stats.TaskMetadata;
import com.google.wireless.android.sdk.stats.TraceProcessorDaemonManagerStats;
import com.google.wireless.android.sdk.stats.TraceProcessorDaemonQueryStats;
import com.google.wireless.android.sdk.stats.TransportFailureMetadata;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioFeatureTracker
implements FeatureTracker {
    @Nullable
    private Common.Device myActiveDevice;
    @Nullable
    private Common.Process myActiveProcess;
    @NotNull
    private final Project myTrackingProject;
    private final ImmutableMap<Common.SessionMetaData.SessionType, ProfilerSessionCreationMetaData.SessionType> SESSION_TYPE_MAP = ImmutableMap.of((Object)Common.SessionMetaData.SessionType.FULL, (Object)ProfilerSessionCreationMetaData.SessionType.FULL_SESSION, (Object)Common.SessionMetaData.SessionType.MEMORY_CAPTURE, (Object)ProfilerSessionCreationMetaData.SessionType.MEMORY_CAPTURE, (Object)Common.SessionMetaData.SessionType.CPU_CAPTURE, (Object)ProfilerSessionCreationMetaData.SessionType.CPU_CAPTURE);
    private final ImmutableMap<SessionsManager.SessionCreationSource, ProfilerSessionCreationMetaData.CreationSource> SESSION_CREATION_SOURCE_MAP = ImmutableMap.of((Object)SessionsManager.SessionCreationSource.MANUAL, (Object)ProfilerSessionCreationMetaData.CreationSource.MANUAL);
    private final ImmutableMap<Class<? extends SessionArtifact>, ProfilerSessionSelectionMetaData.ArtifactType> SESSION_ARTIFACT_MAP = ImmutableMap.of(SessionItem.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_SESSION, HprofSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_HPROF, CpuCaptureSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_CPU_CAPTURE, LegacyAllocationsSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_LEGACY_ALLOCATIONS);
    private final ImmutableMap<Class<? extends Exception>, TransportFailureMetadata.FailureType> TRANSPORT_FAILURE_MAP = ImmutableMap.builder().put(TimeoutException.class, (Object)TransportFailureMetadata.FailureType.TIMEOUT).put(InterruptedException.class, (Object)TransportFailureMetadata.FailureType.INTERRUPTED).put(IOException.class, (Object)TransportFailureMetadata.FailureType.IO).put(SyncException.class, (Object)TransportFailureMetadata.FailureType.SYNC).put(ShellCommandUnresponsiveException.class, (Object)TransportFailureMetadata.FailureType.SHELL_COMMAND_UNRESPONSIVE).put(AdbCommandRejectedException.class, (Object)TransportFailureMetadata.FailureType.ADB_COMMAND_REJECTED).build();
    private static final ImmutableMap<CpuCaptureMetadata.CaptureStatus, CpuCaptureMetadata.CaptureStatus> CPU_CAPTURE_STATUS_MAP = ImmutableMap.builder().put((Object)CpuCaptureMetadata.CaptureStatus.SUCCESS, (Object)CpuCaptureMetadata.CaptureStatus.SUCCESS).put((Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE, (Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE).put((Object)CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING, (Object)CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING).put((Object)CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE, (Object)CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_NO_GOING_PROFILING, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_NO_GOING_PROFILING).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PROCESS_DIED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PROCESS_DIED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PID_CHANGED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PID_CHANGED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_PROFILER_PROCESS_DIED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_PROFILER_PROCESS_DIED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STOP_COMMAND_FAILED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STOP_COMMAND_FAILED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STILL_PROFILING_AFTER_STOP, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STILL_PROFILING_AFTER_STOP).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_START_WAITING, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_START_WAITING).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_TIMEOUT, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_TIMEOUT).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_FAILED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_FAILED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_WAIT_EVENT, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_WAIT_EVENT).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_COPY_FILE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_COPY_FILE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_FORM_FILE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_FORM_FILE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_FILE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_FILE).put((Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_PATH_INVALID, (Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_PATH_INVALID).put((Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_READ_ERROR, (Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_READ_ERROR).put((Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_PARSER_UNKNOWN, (Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_PARSER_UNKNOWN).put((Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_FILE_HEADER_ERROR, (Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_FILE_HEADER_ERROR).put((Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_PARSER_ERROR, (Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_PARSER_ERROR).put((Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_CAUSE_UNKNOWN, (Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILED_CAUSE_UNKNOWN).build();
    private static final ImmutableMap<CpuCaptureMetadata.CpuProfilerEntryPoint, CpuCaptureMetadata.CpuProfilerEntryPoint> CPU_PROFILER_ENTRY_POINT_MAP = ImmutableMap.builder().put((Object)CpuCaptureMetadata.CpuProfilerEntryPoint.UNKNOWN, (Object)CpuCaptureMetadata.CpuProfilerEntryPoint.UNKNOWN).put((Object)CpuCaptureMetadata.CpuProfilerEntryPoint.CPU_MONITOR, (Object)CpuCaptureMetadata.CpuProfilerEntryPoint.CPU_MONITOR).put((Object)CpuCaptureMetadata.CpuProfilerEntryPoint.STARTUP_PROFILING, (Object)CpuCaptureMetadata.CpuProfilerEntryPoint.STARTUP_PROFILING).put((Object)CpuCaptureMetadata.CpuProfilerEntryPoint.ENERGY_DEPRECATION_LINK, (Object)CpuCaptureMetadata.CpuProfilerEntryPoint.ENERGY_DEPRECATION_LINK).put((Object)CpuCaptureMetadata.CpuProfilerEntryPoint.ONGOING_SESSION_SELECTION, (Object)CpuCaptureMetadata.CpuProfilerEntryPoint.ONGOING_SESSION_SELECTION).put((Object)CpuCaptureMetadata.CpuProfilerEntryPoint.CHILD_STAGE_BACK_BTN_OR_FAILURE, (Object)CpuCaptureMetadata.CpuProfilerEntryPoint.CHILD_STAGE_BACK_BTN_OR_FAILURE).put((Object)CpuCaptureMetadata.CpuProfilerEntryPoint.ENERGY_TASK, (Object)CpuCaptureMetadata.CpuProfilerEntryPoint.ENERGY_TASK).build();
    private final ImmutableMap<Class<? extends CaptureObjectInstanceFilter>, MemoryInstanceFilterMetadata.FilterType> MEMORY_INSTANCE_FILTER_MAP = ImmutableMap.builder().put(ActivityFragmentLeakInstanceFilter.class, (Object)MemoryInstanceFilterMetadata.FilterType.ACTIVITY_FRAGMENT_LEAKS).put(ProjectClassesInstanceFilter.class, (Object)MemoryInstanceFilterMetadata.FilterType.PROJECT_CLASSES).build();
    private final ImmutableMap<ProfilerTaskType, TaskMetadata.ProfilerTaskType> PROFILER_TASK_TYPE_MAP = ImmutableMap.of((Object)ProfilerTaskType.UNSPECIFIED, (Object)TaskMetadata.ProfilerTaskType.PROFILER_TASK_TYPE_UNSPECIFIED, (Object)ProfilerTaskType.CALLSTACK_SAMPLE, (Object)TaskMetadata.ProfilerTaskType.CALLSTACK_SAMPLE, (Object)ProfilerTaskType.SYSTEM_TRACE, (Object)TaskMetadata.ProfilerTaskType.SYSTEM_TRACE, (Object)ProfilerTaskType.JAVA_KOTLIN_METHOD_RECORDING, (Object)TaskMetadata.ProfilerTaskType.JAVA_KOTLIN_METHOD_RECORDING, (Object)ProfilerTaskType.HEAP_DUMP, (Object)TaskMetadata.ProfilerTaskType.HEAP_DUMP, (Object)ProfilerTaskType.NATIVE_ALLOCATIONS, (Object)TaskMetadata.ProfilerTaskType.NATIVE_ALLOCATIONS, (Object)ProfilerTaskType.JAVA_KOTLIN_ALLOCATIONS, (Object)TaskMetadata.ProfilerTaskType.JAVA_KOTLIN_ALLOCATIONS, (Object)ProfilerTaskType.LIVE_VIEW, (Object)TaskMetadata.ProfilerTaskType.LIVE_VIEW, (Object)ProfilerTaskType.LEAKCANARY, (Object)TaskMetadata.ProfilerTaskType.PROFILER_TASK_TYPE_UNSPECIFIED);
    private final ImmutableMap<Common.Process.ExposureLevel, TaskMetadata.ExposureLevel> PROCESS_EXPOSURE_LEVEL_MAP = ImmutableMap.of((Object)Common.Process.ExposureLevel.UNKNOWN, (Object)TaskMetadata.ExposureLevel.UNKNOWN, (Object)Common.Process.ExposureLevel.RELEASE, (Object)TaskMetadata.ExposureLevel.RELEASE, (Object)Common.Process.ExposureLevel.PROFILEABLE, (Object)TaskMetadata.ExposureLevel.PROFILEABLE, (Object)Common.Process.ExposureLevel.DEBUGGABLE, (Object)TaskMetadata.ExposureLevel.DEBUGGABLE);
    private final ImmutableMap<TaskDataOrigin, TaskMetadata.TaskDataOrigin> TASK_DATA_ORIGIN_MAP = ImmutableMap.of((Object)TaskDataOrigin.UNSPECIFIED, (Object)TaskMetadata.TaskDataOrigin.TASK_DATA_ORIGIN_UNSPECIFIED, (Object)TaskDataOrigin.NEW, (Object)TaskMetadata.TaskDataOrigin.NEW, (Object)TaskDataOrigin.PAST_RECORDING, (Object)TaskMetadata.TaskDataOrigin.PAST_RECORDING, (Object)TaskDataOrigin.IMPORTED, (Object)TaskMetadata.TaskDataOrigin.IMPORTED);
    private final ImmutableMap<TaskAttachmentPoint, TaskMetadata.TaskAttachmentPoint> TASK_ATTACHMENT_POINT_MAP = ImmutableMap.of((Object)TaskAttachmentPoint.UNSPECIFIED, (Object)TaskMetadata.TaskAttachmentPoint.TASK_ATTACHMENT_POINT_UNSPECIFIED, (Object)TaskAttachmentPoint.NEW_PROCESS, (Object)TaskMetadata.TaskAttachmentPoint.NEW_PROCESS, (Object)TaskAttachmentPoint.EXISTING_PROCESS, (Object)TaskMetadata.TaskAttachmentPoint.EXISTING_PROCESS);
    private final ImmutableMap<TaskFinishedState, TaskFinishedMetadata.TaskFinishedState> TASK_FINISHED_STATE_MAP = ImmutableMap.of((Object)TaskFinishedState.UNSPECIFIED, (Object)TaskFinishedMetadata.TaskFinishedState.TASK_FINISHED_STATE_UNSPECIFIED, (Object)TaskFinishedState.COMPLETED, (Object)TaskFinishedMetadata.TaskFinishedState.COMPLETED, (Object)TaskFinishedState.USER_CANCELLED, (Object)TaskFinishedMetadata.TaskFinishedState.USER_CANCELLED);
    private final ImmutableMap<TaskFailedMetadata.FailingPoint, TaskFailedMetadata.FailingPoint> TASK_FAILED_STATE_MAP = ImmutableMap.of((Object)TaskFailedMetadata.FailingPoint.FAILING_POINT_UNSPECIFIED, (Object)TaskFailedMetadata.FailingPoint.FAILING_POINT_UNSPECIFIED, (Object)TaskFailedMetadata.FailingPoint.TASK_START, (Object)TaskFailedMetadata.FailingPoint.TASK_START, (Object)TaskFailedMetadata.FailingPoint.TASK_STOP, (Object)TaskFailedMetadata.FailingPoint.TASK_STOP, (Object)TaskFailedMetadata.FailingPoint.TASK_PROCESSING, (Object)TaskFailedMetadata.FailingPoint.TASK_PROCESSING);
    @NotNull
    private AndroidProfilerEvent.Stage myCurrStage = AndroidProfilerEvent.Stage.UNKNOWN_STAGE;

    public StudioFeatureTracker(@NotNull Project trackingProject) {
        this.myTrackingProject = trackingProject;
    }

    public void trackPreTransportDaemonStarts(@NotNull Common.Device transportDevice) {
        this.newTracker(AndroidProfilerEvent.Type.PRE_TRANSPORT_DAEMON_STARTS).setDevice(transportDevice).track();
    }

    public void trackTransportDaemonFailed(@NotNull Common.Device transportDevice, Exception exception) {
        TransportFailureMetadata.FailureType failureType = (TransportFailureMetadata.FailureType)this.TRANSPORT_FAILURE_MAP.getOrDefault(exception.getClass(), (Object)TransportFailureMetadata.FailureType.UNKNOWN_FAILURE_TYPE);
        this.newTracker(AndroidProfilerEvent.Type.TRANSPORT_DAEMON_FAILED).setDevice(transportDevice).setTransportFailureMetadata(TransportFailureMetadata.newBuilder().setFailureType(failureType).build()).track();
    }

    public void trackTransportProxyCreationFailed(@NotNull Common.Device transportDevice, Exception exception) {
        TransportFailureMetadata.FailureType failureType = (TransportFailureMetadata.FailureType)this.TRANSPORT_FAILURE_MAP.getOrDefault(exception.getClass(), (Object)TransportFailureMetadata.FailureType.UNKNOWN_FAILURE_TYPE);
        this.newTracker(AndroidProfilerEvent.Type.TRANSPORT_PROXY_FAILED).setDevice(transportDevice).setTransportFailureMetadata(TransportFailureMetadata.newBuilder().setFailureType(failureType).build()).track();
    }

    public void trackEnterStage(AndroidProfilerEvent.Stage stageType) {
        this.myCurrStage = stageType;
        this.track(AndroidProfilerEvent.Type.STAGE_ENTERED);
    }

    public void trackRunWithProfiling(@NotNull RunWithProfilingMetadata metadata) {
        this.newTracker(AndroidProfilerEvent.Type.RUN_WITH_PROFILING).setRunWithProfilingMetadata(metadata).track();
    }

    public void trackAutoProfilingRequested() {
        this.track(AndroidProfilerEvent.Type.AUTO_PROFILING_REQUESTED);
    }

    public void trackAutoProfilingSucceeded() {
        this.track(AndroidProfilerEvent.Type.AUTO_PROFILING_SUCCEEDED);
    }

    public void trackProfilingStarted() {
        this.newTracker(AndroidProfilerEvent.Type.PROFILING_STARTED).setDevice(this.myActiveDevice).track();
    }

    public void trackAdvancedProfilingStarted() {
        this.newTracker(AndroidProfilerEvent.Type.ADVANCED_PROFILING_STARTED).setDevice(this.myActiveDevice).track();
    }

    public void trackChangeDevice(@Nullable Common.Device device2) {
        if (this.myActiveDevice != device2) {
            this.myActiveDevice = device2;
            this.newTracker(AndroidProfilerEvent.Type.CHANGE_DEVICE).setDevice(this.myActiveDevice).track();
        }
    }

    public void trackChangeProcess(@Nullable Common.Process process2) {
        if (this.myActiveProcess != process2) {
            this.myActiveProcess = process2;
            this.newTracker(AndroidProfilerEvent.Type.CHANGE_PROCESS).setDevice(this.myActiveDevice).track();
        }
    }

    public void trackSessionDropdownClicked() {
        this.track(AndroidProfilerEvent.Type.SESSION_DROPDOWN_CLICKED);
    }

    public void trackCreateSession(Common.SessionMetaData.SessionType sessionType, SessionsManager.SessionCreationSource sourceType) {
        ProfilerSessionCreationMetaData.Builder builder = ProfilerSessionCreationMetaData.newBuilder().setCreatedType((ProfilerSessionCreationMetaData.SessionType)this.SESSION_TYPE_MAP.getOrDefault((Object)sessionType, (Object)ProfilerSessionCreationMetaData.SessionType.UNKNOWN_SESSION)).setCreationSource((ProfilerSessionCreationMetaData.CreationSource)this.SESSION_CREATION_SOURCE_MAP.getOrDefault((Object)sourceType, (Object)ProfilerSessionCreationMetaData.CreationSource.UNKNOWN_SOURCE));
        this.newTracker(AndroidProfilerEvent.Type.SESSION_CREATED).setSessionCreationMetadata(builder.build()).track();
    }

    public void trackStopSession() {
        this.track(AndroidProfilerEvent.Type.SESSION_STOPPED);
    }

    public void trackSessionsPanelStateChanged(boolean isExpanded) {
        this.track(isExpanded ? AndroidProfilerEvent.Type.SESSION_UI_EXPANDED : AndroidProfilerEvent.Type.SESSION_UI_COLLAPSED);
    }

    public void trackSessionsPanelResized() {
        this.track(AndroidProfilerEvent.Type.SESSION_UI_RESIZED);
    }

    public void trackSessionArtifactSelected(@NotNull SessionArtifact artifact, boolean isSessionLive) {
        ProfilerSessionSelectionMetaData.Builder builder = ProfilerSessionSelectionMetaData.newBuilder().setSelectedType((ProfilerSessionSelectionMetaData.ArtifactType)this.SESSION_ARTIFACT_MAP.getOrDefault(artifact.getClass(), (Object)ProfilerSessionSelectionMetaData.ArtifactType.UNKNOWN_ARTIFACT_TYPE)).setIsSessionAlive(isSessionLive);
        this.newTracker(AndroidProfilerEvent.Type.SESSION_ARTIFACT_SELECTED).setSessionSelectionMetadata(builder.build()).track();
    }

    public void trackGoBack() {
        this.track(AndroidProfilerEvent.Type.GO_BACK);
    }

    public void trackSelectMonitor() {
        this.track(AndroidProfilerEvent.Type.SELECT_MONITOR);
    }

    public void trackZoomIn() {
        this.track(AndroidProfilerEvent.Type.ZOOM_IN);
    }

    public void trackZoomOut() {
        this.track(AndroidProfilerEvent.Type.ZOOM_OUT);
    }

    public void trackResetZoom() {
        this.track(AndroidProfilerEvent.Type.ZOOM_RESET);
    }

    public void trackZoomToSelection() {
        this.track(AndroidProfilerEvent.Type.ZOOM_TO_SELECTION);
    }

    public void trackToggleStreaming() {
        this.track(AndroidProfilerEvent.Type.GO_LIVE);
    }

    public void trackNavigateToCode() {
        this.track(AndroidProfilerEvent.Type.NAVIGATE_TO_CODE);
    }

    public void trackToggleCpuThreadsHideablePanel() {
        this.track(AndroidProfilerEvent.Type.THREADS_VIEW_TOGGLED);
    }

    public void trackSelectRange() {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_RANGE).setDevice(this.myActiveDevice).track();
    }

    public void trackCaptureTrace(@NotNull com.android.tools.profilers.cpu.CpuCaptureMetadata cpuCaptureMetadata) {
        this.newTracker(AndroidProfilerEvent.Type.CAPTURE_TRACE).setDevice(this.myActiveDevice).setCpuCaptureMetadata(cpuCaptureMetadata).track();
    }

    public void trackImportTrace(@NotNull CpuImportTraceMetadata metadata) {
        this.newTracker(AndroidProfilerEvent.Type.CPU_IMPORT_TRACE).setDevice(this.myActiveDevice).setCpuImportTraceMetadata(metadata).track();
    }

    public void trackCpuStartupProfiling(@NotNull Common.Device device2, @NotNull ProfilingConfiguration configuration2) {
        this.newTracker(AndroidProfilerEvent.Type.CPU_STARTUP_PROFILING).setDevice(device2).setCpuStartupProfilingConfiguration(configuration2).track();
    }

    public void trackCpuApiTracing(boolean sampling, boolean pathProvided, int bufferSize, int flags, int intervalUs) {
        CpuApiTracingMetadata metadata = CpuApiTracingMetadata.newBuilder().setUseSampling(sampling).setArgTracePath(pathProvided).setArgBufferSize(bufferSize).setArgFlags(flags).setArgIntervalUs(intervalUs).build();
        this.newTracker(AndroidProfilerEvent.Type.CPU_API_TRACING).setDevice(this.myActiveDevice).setCpuApiTracingMetadata(metadata).track();
    }

    public void trackSelectThread() {
        this.track(AndroidProfilerEvent.Type.SELECT_THREAD);
    }

    public void trackSelectCaptureTopDown() {
        this.track(AndroidProfilerEvent.Type.SELECT_TOP_DOWN);
    }

    public void trackSelectCaptureBottomUp() {
        this.track(AndroidProfilerEvent.Type.SELECT_BOTTOM_UP);
    }

    public void trackSelectCaptureFlameChart() {
        this.track(AndroidProfilerEvent.Type.SELECT_FLAME_CHART);
    }

    public void trackForceGc() {
        this.track(AndroidProfilerEvent.Type.FORCE_GC);
    }

    public void trackDumpHeap() {
        this.track(AndroidProfilerEvent.Type.SNAPSHOT_HPROF);
    }

    public void trackRecordAllocations() {
        this.newTracker(AndroidProfilerEvent.Type.CAPTURE_ALLOCATIONS).setDevice(this.myActiveDevice).track();
    }

    public void trackExportHeap() {
        this.track(AndroidProfilerEvent.Type.EXPORT_HPROF);
    }

    public void trackExportAllocation() {
        this.track(AndroidProfilerEvent.Type.EXPORT_ALLOCATION);
    }

    public void trackChangeClassArrangment() {
        this.track(AndroidProfilerEvent.Type.ARRANGE_CLASSES);
    }

    public void trackSelectMemoryStack() {
        this.track(AndroidProfilerEvent.Type.SELECT_MEMORY_STACK);
    }

    public void trackSelectMemoryReferences() {
        this.track(AndroidProfilerEvent.Type.SELECT_MEMORY_REFERENCES);
    }

    public void trackSelectMemoryHeap(@NotNull String heapName) {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_MEMORY_HEAP).setMemoryHeapId(switch (heapName) {
            case "default" -> AndroidProfilerEvent.MemoryHeap.DEFAULT_HEAP;
            case "app" -> AndroidProfilerEvent.MemoryHeap.APP_HEAP;
            case "image" -> AndroidProfilerEvent.MemoryHeap.IMAGE_HEAP;
            case "zygote" -> AndroidProfilerEvent.MemoryHeap.ZYGOTE_HEAP;
            case "JNI" -> AndroidProfilerEvent.MemoryHeap.JNI_HEAP;
            case "Native" -> AndroidProfilerEvent.MemoryHeap.NATIVE_HEAP;
            case "All" -> AndroidProfilerEvent.MemoryHeap.ALL_HEAP;
            default -> {
                StudioFeatureTracker.getLogger().warn("Attempt to report selection of unknown heap name: " + heapName);
                yield AndroidProfilerEvent.MemoryHeap.UNKNOWN_HEAP;
            }
        }).track();
    }

    public void trackSelectNetworkRequest() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTION);
    }

    public void trackSelectNetworkDetailsOverview() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_OVERVIEW);
    }

    public void trackSelectNetworkDetailsResponse() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_RESPONSE);
    }

    public void trackSelectNetworkDetailsRequest() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_REQUEST);
    }

    public void trackSelectNetworkDetailsStack() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_STACK);
    }

    public void trackSelectNetworkConnectionsView() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTIONS_CONNECTION_VIEW);
    }

    public void trackSelectNetworkThreadsView() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTIONS_THREADS_VIEW);
    }

    public void trackOpenProfilingConfigDialog() {
        this.track(AndroidProfilerEvent.Type.OPEN_CPU_CONFIG_DIALOG);
    }

    public void trackCreateCustomProfilingConfig() {
        this.track(AndroidProfilerEvent.Type.CREATE_CPU_CONFIG);
    }

    public void trackFilterMetadata(@NotNull FilterMetadata filterMetadata) {
        this.newTracker(AndroidProfilerEvent.Type.FILTER).setFilterMetadata(filterMetadata).track();
    }

    public void trackMemoryProfilerInstanceFilter(@NotNull CaptureObjectInstanceFilter filter2) {
        MemoryInstanceFilterMetadata.Builder builder = MemoryInstanceFilterMetadata.newBuilder().setFilterType((MemoryInstanceFilterMetadata.FilterType)this.MEMORY_INSTANCE_FILTER_MAP.getOrDefault(filter2.getClass(), (Object)MemoryInstanceFilterMetadata.FilterType.UNKNOWN_FILTER_TYPE));
        this.newTracker(AndroidProfilerEvent.Type.MEMORY_INSTANCE_FILTER).setMemoryInstanceFilterMetadata(builder.build()).track();
    }

    public void trackTraceProcessorDaemonSpawnAttempt(boolean successful, long timeToSpawnMs) {
        TraceProcessorDaemonManagerStats stats = TraceProcessorDaemonManagerStats.newBuilder().setTimeToSpawnMs(timeToSpawnMs).build();
        AndroidProfilerEvent.Type type = successful ? AndroidProfilerEvent.Type.TPD_MANAGER_SPAWN_OK : AndroidProfilerEvent.Type.TPD_MANAGER_SPAWN_FAILED;
        this.newTracker(type).setTraceProcessorDaemonManagerStats(stats).track();
    }

    public void trackTraceProcessorLoadTrace(@NotNull TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus, long methodTimeMs, long queryTimeMs, long traceSizeBytes) {
        TraceProcessorDaemonQueryStats stats = TraceProcessorDaemonQueryStats.newBuilder().setQueryStatus(queryStatus).setMethodDurationMs(methodTimeMs).setGrpcQueryDurationMs(queryTimeMs).setTraceSizeBytes(traceSizeBytes).build();
        this.newTracker(AndroidProfilerEvent.Type.TPD_QUERY_LOAD_TRACE).setTraceProcessorDaemonQueryStats(stats).track();
    }

    public void trackTraceProcessorProcessMetadata(@NotNull TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus, long methodTimeMs, long queryTimeMs) {
        TraceProcessorDaemonQueryStats stats = TraceProcessorDaemonQueryStats.newBuilder().setQueryStatus(queryStatus).setMethodDurationMs(methodTimeMs).setGrpcQueryDurationMs(queryTimeMs).build();
        this.newTracker(AndroidProfilerEvent.Type.TPD_QUERY_PROCESS_METADATA).setTraceProcessorDaemonQueryStats(stats).track();
    }

    public void trackTraceProcessorCpuData(@NotNull TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus, long methodTimeMs, long queryTimeMs) {
        TraceProcessorDaemonQueryStats stats = TraceProcessorDaemonQueryStats.newBuilder().setQueryStatus(queryStatus).setMethodDurationMs(methodTimeMs).setGrpcQueryDurationMs(queryTimeMs).build();
        this.newTracker(AndroidProfilerEvent.Type.TPD_QUERY_LOAD_CPU_DATA).setTraceProcessorDaemonQueryStats(stats).track();
    }

    public void trackTraceProcessorMemoryData(@NotNull TraceProcessorDaemonQueryStats.QueryReturnStatus queryStatus, long methodTimeMs, long queryTimeMs) {
        TraceProcessorDaemonQueryStats stats = TraceProcessorDaemonQueryStats.newBuilder().setQueryStatus(queryStatus).setMethodDurationMs(methodTimeMs).setGrpcQueryDurationMs(queryTimeMs).build();
        this.newTracker(AndroidProfilerEvent.Type.TPD_QUERY_LOAD_MEMORY_DATA).setTraceProcessorDaemonQueryStats(stats).track();
    }

    public void trackMoveTrackGroupUp(@NotNull String title2) {
        this.trackTrackGroupAction(title2, AdtUiTrackGroupMetadata.TrackGroupActionType.MOVE_UP);
    }

    public void trackMoveTrackGroupDown(@NotNull String title2) {
        this.trackTrackGroupAction(title2, AdtUiTrackGroupMetadata.TrackGroupActionType.MOVE_DOWN);
    }

    public void trackExpandTrackGroup(@NotNull String title2) {
        this.trackTrackGroupAction(title2, AdtUiTrackGroupMetadata.TrackGroupActionType.EXPAND);
    }

    public void trackCollapseTrackGroup(@NotNull String title2) {
        this.trackTrackGroupAction(title2, AdtUiTrackGroupMetadata.TrackGroupActionType.COLLAPSE);
    }

    public void trackMouseOverTrackGroup(@NotNull String title2) {
        this.trackTrackGroupAction(title2, AdtUiTrackGroupMetadata.TrackGroupActionType.MOUSE_OVER);
    }

    private void trackTrackGroupAction(@NotNull String title2, @NotNull AdtUiTrackGroupMetadata.TrackGroupActionType actionType) {
        this.newTracker(AndroidProfilerEvent.Type.TRACK_GROUP_ACTION).setTrackGroupMetadata(AdtUiTrackGroupMetadata.newBuilder().setTitle(title2).setActionType(actionType).build()).track();
    }

    public void trackSelectBox(long durationUs, int trackCount) {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_BOX).setBoxSelectionMetadata(AdtUiBoxSelectionMetadata.newBuilder().setDurationUs(durationUs).setTrackCount(trackCount).build()).track();
    }

    public void trackFrameSelectionPerTrace(int count) {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_FRAME).setEventCount(count).track();
    }

    public void trackAllFrameTogglingPerTrace(int count) {
        this.newTracker(AndroidProfilerEvent.Type.TOGGLE_ALL_FRAMES).setEventCount(count).track();
    }

    public void trackLifecycleTogglingPerTrace(int count) {
        this.newTracker(AndroidProfilerEvent.Type.TOGGLE_LIFECYCLE).setEventCount(count).track();
    }

    public void trackNetworkMigrationDialogSelected() {
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.APP_INSPECTION).setAppInspectionEvent(AppInspectionEvent.newBuilder().setType(AppInspectionEvent.Type.INSPECTOR_EVENT).setNetworkInspectorEvent(AppInspectionEvent.NetworkInspectorEvent.newBuilder().setType(AppInspectionEvent.NetworkInspectorEvent.Type.MIGRATION_LINK_SELECTED))), this.myTrackingProject));
    }

    public void trackLoading(AndroidProfilerEvent.Loading loading) {
        this.newTracker(AndroidProfilerEvent.Type.LOADING).setLoading(loading).track();
    }

    public void trackPowerProfilerCapture(int powerRailCount, int batteryCounterCount) {
        this.newTracker(AndroidProfilerEvent.Type.POWER_PROFILER_DATA_CAPTURED).setPowerProfilerCaptureMetadata(PowerProfilerCaptureMetadata.newBuilder().setPowerRailCount(powerRailCount).setBatteryCounterCount(batteryCounterCount).build()).track();
    }

    public void trackTaskSettingsOpened(boolean isTaskSettingsChanged) {
        this.newTracker(AndroidProfilerEvent.Type.TASK_SETTINGS_OPENED).setIsTaskSettingsChanged(isTaskSettingsChanged).track();
    }

    private TaskMetadata.TaskConfig buildCustomTaskConfig(@NotNull ProfilingConfiguration taskConfig) {
        TaskMetadata.TaskConfig.Builder taskConfigBuilder = TaskMetadata.TaskConfig.newBuilder();
        if (taskConfig instanceof SimpleperfConfiguration) {
            int profilingSamplingIntervalUs = ((SimpleperfConfiguration)taskConfig).getProfilingSamplingIntervalUs();
            taskConfigBuilder.setCallstackSampleTaskConfig(TaskMetadata.CallstackSampleTaskConfig.newBuilder().setSampleIntervalUs(profilingSamplingIntervalUs).build());
        } else if (taskConfig instanceof ArtSampledConfiguration) {
            int profilingSamplingIntervalUs = ((ArtSampledConfiguration)taskConfig).getProfilingSamplingIntervalUs();
            int profilingBufferSizeInMb = ((ArtSampledConfiguration)taskConfig).getProfilingBufferSizeInMb();
            taskConfigBuilder.setJavaKotlinMethodSampleTaskConfig(TaskMetadata.JavaKotlinMethodSampleTaskConfig.newBuilder().setSampleIntervalUs(profilingSamplingIntervalUs).setBufferSizeMb(profilingBufferSizeInMb).build());
        } else if (taskConfig instanceof ArtInstrumentedConfiguration) {
            int profilingBufferSizeInMb = ((ArtInstrumentedConfiguration)taskConfig).getProfilingBufferSizeInMb();
            taskConfigBuilder.setJavaKotlinMethodTraceTaskConfig(TaskMetadata.JavaKotlinMethodTraceTaskConfig.newBuilder().setBufferSizeMb(profilingBufferSizeInMb).build());
        } else if (taskConfig instanceof PerfettoNativeAllocationsConfiguration) {
            int memorySamplingIntervalBytes = ((PerfettoNativeAllocationsConfiguration)taskConfig).getMemorySamplingIntervalBytes();
            taskConfigBuilder.setNativeAllocationsTaskConfig(TaskMetadata.NativeAllocationsTaskConfig.newBuilder().setSampleIntervalBytes(memorySamplingIntervalBytes).build());
        }
        return taskConfigBuilder.build();
    }

    private TaskMetadata buildStatsTaskMetadata(com.android.tools.profilers.tasks.TaskMetadata taskMetadata) {
        TaskMetadata.Builder taskMetadataBuilder = TaskMetadata.newBuilder().setTaskType((TaskMetadata.ProfilerTaskType)this.PROFILER_TASK_TYPE_MAP.getOrDefault((Object)taskMetadata.getTaskType(), (Object)TaskMetadata.ProfilerTaskType.PROFILER_TASK_TYPE_UNSPECIFIED)).setTaskId(taskMetadata.getTaskId()).setExposureLevel((TaskMetadata.ExposureLevel)this.PROCESS_EXPOSURE_LEVEL_MAP.getOrDefault((Object)taskMetadata.getExposureLevel(), (Object)TaskMetadata.ExposureLevel.UNKNOWN)).setTaskDataOrigin((TaskMetadata.TaskDataOrigin)this.TASK_DATA_ORIGIN_MAP.getOrDefault((Object)taskMetadata.getTaskDataOrigin(), (Object)TaskMetadata.TaskDataOrigin.TASK_DATA_ORIGIN_UNSPECIFIED)).setTaskAttachmentPoint((TaskMetadata.TaskAttachmentPoint)this.TASK_ATTACHMENT_POINT_MAP.getOrDefault((Object)taskMetadata.getTaskAttachmentPoint(), (Object)TaskMetadata.TaskAttachmentPoint.TASK_ATTACHMENT_POINT_UNSPECIFIED));
        if (taskMetadata.getTaskConfig() != null) {
            TaskMetadata.TaskConfig taskConfig = this.buildCustomTaskConfig(taskMetadata.getTaskConfig());
            taskMetadataBuilder.setTaskConfig(taskConfig);
        }
        return taskMetadataBuilder.build();
    }

    public void trackTaskEntered(@NotNull com.android.tools.profilers.tasks.TaskMetadata taskMetadata) {
        this.newTracker(AndroidProfilerEvent.Type.TASK_ENTERED).setTaskEnteredMetadata(TaskEnteredMetadata.newBuilder().setTaskData(this.buildStatsTaskMetadata(taskMetadata)).build()).track();
    }

    public void trackTaskFinished(@NotNull com.android.tools.profilers.tasks.TaskMetadata taskMetadata, @NotNull TaskFinishedState taskFinishedState) {
        this.newTracker(AndroidProfilerEvent.Type.TASK_FINISHED).setTaskFinishedMetadata(TaskFinishedMetadata.newBuilder().setTaskData(this.buildStatsTaskMetadata(taskMetadata)).setTaskFinishedState((TaskFinishedMetadata.TaskFinishedState)this.TASK_FINISHED_STATE_MAP.getOrDefault((Object)taskFinishedState, (Object)TaskFinishedMetadata.TaskFinishedState.TASK_FINISHED_STATE_UNSPECIFIED)).build()).track();
    }

    public void trackTaskFailed(@NotNull com.android.tools.profilers.tasks.TaskMetadata taskMetadata, @NotNull TaskStartFailedMetadata taskStartFailedMetadata) {
        TaskFailedMetadata.Builder taskMetadataBuilder = this.getTaskFailedMetadata(taskMetadata, TaskFailedMetadata.FailingPoint.TASK_START);
        taskMetadataBuilder.setTaskStartFailureMetadata(this.buildStatsTaskStartFailedMetadata(taskStartFailedMetadata));
        this.newTracker(AndroidProfilerEvent.Type.TASK_FAILED).setTaskFailedMetadata(taskMetadataBuilder.build()).track();
    }

    public void trackTaskFailed(@NotNull com.android.tools.profilers.tasks.TaskMetadata taskMetadata, @Nullable TaskStopFailedMetadata taskStopFailedMetadata) {
        TaskFailedMetadata.Builder taskMetadataBuilder = this.getTaskFailedMetadata(taskMetadata, TaskFailedMetadata.FailingPoint.TASK_STOP);
        if (taskStopFailedMetadata != null) {
            taskMetadataBuilder.setTaskStopFailureMetadata(this.buildStatsTaskStopFailedMetadata(taskStopFailedMetadata));
        }
        this.newTracker(AndroidProfilerEvent.Type.TASK_FAILED).setTaskFailedMetadata(taskMetadataBuilder.build()).track();
    }

    public void trackTaskFailed(@NotNull com.android.tools.profilers.tasks.TaskMetadata taskMetadata, @NotNull TaskProcessingFailedMetadata taskProcessingFailedMetadata) {
        TaskFailedMetadata.Builder taskMetadataBuilder = this.getTaskFailedMetadata(taskMetadata, TaskFailedMetadata.FailingPoint.TASK_PROCESSING);
        taskMetadataBuilder.setTaskProcessingFailureMetadata(this.buildStatsTaskProcessingFailedMetadata(taskProcessingFailedMetadata));
        this.newTracker(AndroidProfilerEvent.Type.TASK_FAILED).setTaskFailedMetadata(taskMetadataBuilder.build()).track();
    }

    TaskFailedMetadata.TaskProcessingFailedMetadata buildStatsTaskProcessingFailedMetadata(TaskProcessingFailedMetadata metadata) {
        TaskFailedMetadata.TaskProcessingFailedMetadata.Builder result2 = TaskFailedMetadata.TaskProcessingFailedMetadata.newBuilder();
        if (metadata.getCpuCaptureMetadata() != null) {
            result2.setCpuCaptureMetadata(CpuCaptureParser.getCpuCaptureMetadata((com.android.tools.profilers.cpu.CpuCaptureMetadata)metadata.getCpuCaptureMetadata()));
        }
        return result2.build();
    }

    TaskFailedMetadata.TaskStopFailedMetadata buildStatsTaskStopFailedMetadata(TaskStopFailedMetadata metadata) {
        TaskFailedMetadata.TaskStopFailedMetadata.Builder result2 = TaskFailedMetadata.TaskStopFailedMetadata.newBuilder();
        if (metadata.getCpuCaptureMetadata() != null) {
            result2.setCpuCaptureMetadata(CpuCaptureParser.getCpuCaptureMetadata((com.android.tools.profilers.cpu.CpuCaptureMetadata)metadata.getCpuCaptureMetadata()));
        } else if (metadata.getTraceStopStatus() != null) {
            result2.setTraceStopStatus(TaskMetadataStatus.Companion.getTaskFailedTraceStopStatus(metadata.getTraceStopStatus()));
        } else if (metadata.getAllocationTrackStatus() != null) {
            result2.setTrackStatus(TaskMetadataStatus.Companion.getTaskFailedAllocationTrackStatus(metadata.getAllocationTrackStatus()));
        }
        return result2.build();
    }

    TaskFailedMetadata.TaskStartFailedMetadata buildStatsTaskStartFailedMetadata(TaskStartFailedMetadata metadata) {
        TaskFailedMetadata.TaskStartFailedMetadata.Builder result2 = TaskFailedMetadata.TaskStartFailedMetadata.newBuilder();
        if (metadata.getTraceStartStatus() != null) {
            result2.setTraceStartStatus(TaskMetadataStatus.Companion.getTaskFailedTraceStartStatus(metadata.getTraceStartStatus()));
        } else if (metadata.getAllocationTrackStatus() != null) {
            result2.setTrackStatus(TaskMetadataStatus.Companion.getTaskFailedAllocationTrackStatus(metadata.getAllocationTrackStatus()));
        } else if (metadata.getHeapDumpStatus() != null) {
            result2.setHeapDumpStartStatus(TaskMetadataStatus.Companion.getTaskFailedHeapDumpStatus(metadata.getHeapDumpStatus()));
        }
        return result2.build();
    }

    private TaskFailedMetadata.Builder getTaskFailedMetadata(@NotNull com.android.tools.profilers.tasks.TaskMetadata taskMetadata, TaskFailedMetadata.FailingPoint failingPoint) {
        return TaskFailedMetadata.newBuilder().setTaskData(this.buildStatsTaskMetadata(taskMetadata)).setFailingPoint(Objects.requireNonNull((TaskFailedMetadata.FailingPoint)this.TASK_FAILED_STATE_MAP.getOrDefault((Object)failingPoint, (Object)TaskFailedMetadata.FailingPoint.FAILING_POINT_UNSPECIFIED)));
    }

    @NotNull
    private Tracker newTracker(AndroidProfilerEvent.Type eventType) {
        return new Tracker(this.myTrackingProject, eventType, this.myCurrStage);
    }

    private void track(AndroidProfilerEvent.Type eventType) {
        this.newTracker(eventType).track();
    }

    private static Logger getLogger() {
        return Logger.getInstance(StudioFeatureTracker.class);
    }

    private static final class Tracker {
        @NotNull
        private final AndroidProfilerEvent.Type myEventType;
        @NotNull
        private final AndroidProfilerEvent.Stage myCurrStage;
        @NotNull
        private final Project myTrackingProject;
        @Nullable
        private Common.Device myDevice;
        @Nullable
        private com.android.tools.profilers.cpu.CpuCaptureMetadata myCpuCaptureMetadata;
        @Nullable
        private CpuImportTraceMetadata myCpuImportTraceMetadata;
        @Nullable
        private FilterMetadata myFeatureMetadata;
        @Nullable
        private CpuApiTracingMetadata myCpuApiTracingMetadata;
        @Nullable
        private ProfilerSessionCreationMetaData mySessionCreationMetadata;
        @Nullable
        private ProfilerSessionSelectionMetaData mySessionArtifactMetadata;
        @Nullable
        private ProfilingConfiguration myCpuStartupProfilingConfiguration;
        @Nullable
        private TransportFailureMetadata myTransportFailureMetadata;
        @Nullable
        private MemoryInstanceFilterMetadata myMemoryInstanceFilterMetadata;
        @Nullable
        private TraceProcessorDaemonManagerStats myTraceProcessorDaemonManagerStats;
        @Nullable
        private TraceProcessorDaemonQueryStats myTraceProcessorDaemonQueryStats;
        @Nullable
        private AdtUiTrackGroupMetadata myTrackGroupMetadata;
        @Nullable
        private AdtUiBoxSelectionMetadata myBoxSelectionMetadata;
        private int myEventCount = 0;
        @Nullable
        private AndroidProfilerEvent.Loading myLoading;
        @Nullable
        private PowerProfilerCaptureMetadata myPowerProfilerCaptureMetadata;
        @Nullable
        private RunWithProfilingMetadata myRunWithProfilingMetadata;
        private boolean isTaskSettingsChanged;
        @Nullable
        private TaskEnteredMetadata myTaskEnteredMetadata;
        @Nullable
        private TaskFinishedMetadata myTaskFinishedMetadata;
        @Nullable
        private TaskFailedMetadata myTaskFailedMetadata;
        private AndroidProfilerEvent.MemoryHeap myMemoryHeap = AndroidProfilerEvent.MemoryHeap.UNKNOWN_HEAP;

        public Tracker(@NotNull Project trackingProject, @NotNull AndroidProfilerEvent.Type eventType, @NotNull AndroidProfilerEvent.Stage stage) {
            this.myEventType = eventType;
            this.myCurrStage = stage;
            this.myTrackingProject = trackingProject;
        }

        @NotNull
        public Tracker setDevice(@Nullable Common.Device device2) {
            this.myDevice = device2;
            return this;
        }

        @NotNull
        public Tracker setCpuCaptureMetadata(@Nullable com.android.tools.profilers.cpu.CpuCaptureMetadata cpuCaptureMetadata) {
            this.myCpuCaptureMetadata = cpuCaptureMetadata;
            return this;
        }

        @NotNull
        public Tracker setCpuImportTraceMetadata(CpuImportTraceMetadata cpuImportTraceMetadata) {
            this.myCpuImportTraceMetadata = cpuImportTraceMetadata;
            return this;
        }

        @NotNull
        public Tracker setCpuStartupProfilingConfiguration(@Nullable ProfilingConfiguration configuration2) {
            this.myCpuStartupProfilingConfiguration = configuration2;
            return this;
        }

        @NotNull
        public Tracker setCpuApiTracingMetadata(@Nullable CpuApiTracingMetadata metadata) {
            this.myCpuApiTracingMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setFilterMetadata(@Nullable FilterMetadata filterMetadata) {
            this.myFeatureMetadata = filterMetadata;
            return this;
        }

        @NotNull
        public Tracker setMemoryHeapId(AndroidProfilerEvent.MemoryHeap heap) {
            this.myMemoryHeap = heap;
            return this;
        }

        @NotNull
        public Tracker setSessionCreationMetadata(ProfilerSessionCreationMetaData metadata) {
            this.mySessionCreationMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setSessionSelectionMetadata(ProfilerSessionSelectionMetaData metadata) {
            this.mySessionArtifactMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setTransportFailureMetadata(TransportFailureMetadata metadata) {
            this.myTransportFailureMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setMemoryInstanceFilterMetadata(MemoryInstanceFilterMetadata metadata) {
            this.myMemoryInstanceFilterMetadata = metadata;
            return this;
        }

        @NotNull
        public Tracker setTraceProcessorDaemonManagerStats(TraceProcessorDaemonManagerStats traceProcessorDaemonManagerStats) {
            this.myTraceProcessorDaemonManagerStats = traceProcessorDaemonManagerStats;
            return this;
        }

        @NotNull
        public Tracker setTraceProcessorDaemonQueryStats(TraceProcessorDaemonQueryStats traceProcessorDaemonQueryStats) {
            this.myTraceProcessorDaemonQueryStats = traceProcessorDaemonQueryStats;
            return this;
        }

        @NotNull
        public Tracker setTrackGroupMetadata(AdtUiTrackGroupMetadata trackGroupMetadata) {
            this.myTrackGroupMetadata = trackGroupMetadata;
            return this;
        }

        @NotNull
        private Tracker setBoxSelectionMetadata(AdtUiBoxSelectionMetadata boxSelectionMetadata) {
            this.myBoxSelectionMetadata = boxSelectionMetadata;
            return this;
        }

        @NotNull
        private Tracker setEventCount(int eventCount) {
            this.myEventCount = eventCount;
            return this;
        }

        @NotNull
        private Tracker setLoading(AndroidProfilerEvent.Loading loading) {
            this.myLoading = loading;
            return this;
        }

        @NotNull
        private Tracker setPowerProfilerCaptureMetadata(PowerProfilerCaptureMetadata powerProfilerCaptureMetadata) {
            this.myPowerProfilerCaptureMetadata = powerProfilerCaptureMetadata;
            return this;
        }

        @NotNull
        private Tracker setRunWithProfilingMetadata(@NotNull RunWithProfilingMetadata metadata) {
            this.myRunWithProfilingMetadata = metadata;
            return this;
        }

        @NotNull
        private Tracker setIsTaskSettingsChanged(boolean taskSettingsChanged) {
            this.isTaskSettingsChanged = taskSettingsChanged;
            return this;
        }

        @NotNull
        private Tracker setTaskEnteredMetadata(TaskEnteredMetadata taskEnteredMetadata) {
            this.myTaskEnteredMetadata = taskEnteredMetadata;
            return this;
        }

        @NotNull
        private Tracker setTaskFinishedMetadata(TaskFinishedMetadata taskFinishedMetadata) {
            this.myTaskFinishedMetadata = taskFinishedMetadata;
            return this;
        }

        @NotNull
        private Tracker setTaskFailedMetadata(TaskFailedMetadata taskFailedMetadata) {
            this.myTaskFailedMetadata = taskFailedMetadata;
            return this;
        }

        public void track() {
            AndroidProfilerEvent.Builder profilerEvent = AndroidProfilerEvent.newBuilder().setType(this.myEventType);
            if (!((Boolean)StudioFlags.PROFILER_TASK_BASED_UX.get()).booleanValue()) {
                profilerEvent.setStage(this.myCurrStage);
            }
            this.populateCpuCaptureMetadata(profilerEvent);
            this.populateFilterMetadata(profilerEvent);
            this.populateMemoryInstanceFilterMetadata(profilerEvent);
            switch (this.myEventType) {
                case SELECT_MEMORY_HEAP: {
                    profilerEvent.setMemoryHeap(this.myMemoryHeap);
                    break;
                }
                case SESSION_CREATED: {
                    profilerEvent.setSessionStartMetadata(this.mySessionCreationMetadata);
                    break;
                }
                case SESSION_ARTIFACT_SELECTED: {
                    profilerEvent.setSessionArtifactMetadata(this.mySessionArtifactMetadata);
                    break;
                }
                case TRANSPORT_DAEMON_FAILED: 
                case TRANSPORT_PROXY_FAILED: {
                    assert (this.myTransportFailureMetadata != null);
                    profilerEvent.setTransportFailureMetadata(this.myTransportFailureMetadata);
                    break;
                }
                case CPU_API_TRACING: {
                    profilerEvent.setCpuApiTracingMetadata(this.myCpuApiTracingMetadata);
                    break;
                }
                case CPU_STARTUP_PROFILING: {
                    profilerEvent.setCpuStartupProfilingMetadata(CpuStartupProfilingMetadata.newBuilder().setProfilingConfig(Tracker.toStatsCpuProfilingConfig(this.myCpuStartupProfilingConfiguration)));
                    break;
                }
                case CPU_IMPORT_TRACE: {
                    assert (this.myCpuImportTraceMetadata != null);
                    profilerEvent.setCpuImportTraceMetadata(this.myCpuImportTraceMetadata);
                    break;
                }
                case TPD_MANAGER_SPAWN_OK: 
                case TPD_MANAGER_SPAWN_FAILED: {
                    profilerEvent.setTpdManagerStats(this.myTraceProcessorDaemonManagerStats);
                    break;
                }
                case TPD_QUERY_LOAD_TRACE: 
                case TPD_QUERY_PROCESS_METADATA: 
                case TPD_QUERY_LOAD_CPU_DATA: 
                case TPD_QUERY_LOAD_MEMORY_DATA: {
                    profilerEvent.setTpdQueryStats(this.myTraceProcessorDaemonQueryStats);
                    break;
                }
                case TRACK_GROUP_ACTION: {
                    profilerEvent.setTrackGroupMetadata(this.myTrackGroupMetadata);
                    break;
                }
                case SELECT_BOX: {
                    profilerEvent.setBoxSelectionMetadata(this.myBoxSelectionMetadata);
                    break;
                }
                case SELECT_FRAME: 
                case TOGGLE_ALL_FRAMES: 
                case TOGGLE_LIFECYCLE: {
                    profilerEvent.setEventCount(this.myEventCount);
                    break;
                }
                case LOADING: {
                    profilerEvent.setLoading(this.myLoading);
                    break;
                }
                case RUN_WITH_PROFILING: {
                    profilerEvent.setRunWithProfilingMetadata(this.myRunWithProfilingMetadata);
                    break;
                }
                case POWER_PROFILER_DATA_CAPTURED: {
                    profilerEvent.setPowerProfilerCaptureMetadata(this.myPowerProfilerCaptureMetadata);
                    break;
                }
                case TASK_SETTINGS_OPENED: {
                    profilerEvent.setIsTaskSettingsChanged(this.isTaskSettingsChanged);
                    break;
                }
                case TASK_ENTERED: {
                    profilerEvent.setTaskEnteredMetadata(this.myTaskEnteredMetadata);
                    break;
                }
                case TASK_FINISHED: {
                    profilerEvent.setTaskFinishedMetadata(this.myTaskFinishedMetadata);
                    break;
                }
                case TASK_FAILED: {
                    profilerEvent.setTaskFailedMetadata(this.myTaskFailedMetadata);
                    break;
                }
            }
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER).setAndroidProfilerEvent(profilerEvent);
            if (this.myDevice != null) {
                event.setDeviceInfo(DeviceInfo.newBuilder().setAnonymizedSerialNumber(AnonymizerUtil.anonymizeUtf8((String)this.myDevice.getSerial())).setBuildTags(this.myDevice.getBuildTags()).setBuildType(this.myDevice.getBuildType()).setBuildVersionRelease(this.myDevice.getVersion()).setBuildApiLevelFull(new AndroidVersion(this.myDevice.getApiLevel(), this.myDevice.getCodename()).getApiString()).setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)this.myDevice.getCpuAbi())).setManufacturer(this.myDevice.getManufacturer()).setDeviceType(this.myDevice.getIsEmulator() ? DeviceInfo.DeviceType.LOCAL_EMULATOR : DeviceInfo.DeviceType.LOCAL_PHYSICAL).setMdnsConnectionType(DeviceUtils.isMdnsAutoConnectUnencrypted((String)this.myDevice.getSerial()) ? DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_UNENCRYPTED : (DeviceUtils.isMdnsAutoConnectTls((String)this.myDevice.getSerial()) ? DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_TLS : DeviceInfo.MdnsConnectionType.MDNS_NONE)).setModel(this.myDevice.getModel()).build());
            }
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event, this.myTrackingProject));
        }

        private void populateMemoryInstanceFilterMetadata(@NotNull AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myMemoryInstanceFilterMetadata == null) {
                return;
            }
            profilerEvent.setMemoryInstanceFilterMetadata(this.myMemoryInstanceFilterMetadata);
        }

        private void populateFilterMetadata(AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myFeatureMetadata != null) {
                FilterMetadata.Builder filterMetadata = com.google.wireless.android.sdk.stats.FilterMetadata.newBuilder();
                filterMetadata.setFeaturesUsed((long)this.myFeatureMetadata.getFeaturesUsed());
                filterMetadata.setMatchedElements(this.myFeatureMetadata.getMatchedElementCount());
                filterMetadata.setTotalElements(this.myFeatureMetadata.getTotalElementCount());
                filterMetadata.setSearchLength(this.myFeatureMetadata.getFilterTextLength());
                switch (this.myFeatureMetadata.getView()) {
                    case UNKNOWN_FILTER_VIEW: {
                        filterMetadata.setActiveView(FilterMetadata.View.UNKNOWN_FILTER_VIEW);
                        break;
                    }
                    case CPU_TOP_DOWN: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_TOP_DOWN);
                        break;
                    }
                    case CPU_BOTTOM_UP: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_BOTTOM_UP);
                        break;
                    }
                    case CPU_FLAME_CHART: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_FLAME_CHART);
                        break;
                    }
                    case CPU_CALL_CHART: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_CALL_CHART);
                        break;
                    }
                    case MEMORY_CALLSTACK: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_CALLSTACK);
                        break;
                    }
                    case MEMORY_PACKAGE: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_PACKAGE);
                        break;
                    }
                    case MEMORY_CLASS: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_CLASS);
                        break;
                    }
                    case NETWORK_CONNECTIONS: {
                        filterMetadata.setActiveView(FilterMetadata.View.NETWORK_CONNECTIONS);
                        break;
                    }
                    case NETWORK_THREADS: {
                        filterMetadata.setActiveView(FilterMetadata.View.NETWORK_THREADS);
                    }
                }
                profilerEvent.setFilterMetadata(filterMetadata);
            }
        }

        private void populateCpuCaptureMetadata(AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myCpuCaptureMetadata != null) {
                CpuCaptureMetadata.Builder captureMetadata = CpuCaptureMetadata.newBuilder().setCaptureDurationMs(this.myCpuCaptureMetadata.getCaptureDurationMs()).setRecordDurationMs(this.myCpuCaptureMetadata.getRecordDurationMs()).setTraceFileSizeBytes(this.myCpuCaptureMetadata.getTraceFileSizeBytes()).setParsingTimeMs(this.myCpuCaptureMetadata.getParsingTimeMs()).setStoppingTimeMs(this.myCpuCaptureMetadata.getStoppingTimeMs()).setCpuProfilerEntryPoint((CpuCaptureMetadata.CpuProfilerEntryPoint)CPU_PROFILER_ENTRY_POINT_MAP.getOrDefault((Object)this.myCpuCaptureMetadata.getCpuProfilerEntryPoint(), (Object)CpuCaptureMetadata.CpuProfilerEntryPoint.UNKNOWN)).setCaptureStatus((CpuCaptureMetadata.CaptureStatus)CPU_CAPTURE_STATUS_MAP.getOrDefault((Object)this.myCpuCaptureMetadata.getStatus(), (Object)CpuCaptureMetadata.CaptureStatus.SUCCESS));
                Boolean hasComposeTracingNodes = this.myCpuCaptureMetadata.getHasComposeTracingNodes();
                if (hasComposeTracingNodes != null) {
                    captureMetadata.setHasComposeTracingNodes(hasComposeTracingNodes.booleanValue());
                }
                captureMetadata.setProfilingConfig(Tracker.toStatsCpuProfilingConfig(this.myCpuCaptureMetadata.getProfilingConfiguration()));
                if (this.myCpuCaptureMetadata.getProfilingConfiguration().getTraceType() == ProfilingConfiguration.TraceType.ART) {
                    captureMetadata.setArtStopTimeoutSec(CpuProfilerStage.CPU_ART_STOP_TIMEOUT_SEC);
                }
                profilerEvent.setCpuCaptureMetadata(captureMetadata);
            }
        }

        @NotNull
        private static CpuProfilingConfig toStatsCpuProfilingConfig(@NotNull ProfilingConfiguration config) {
            CpuProfilingConfig.Builder cpuConfigInfo = CpuProfilingConfig.newBuilder();
            CpuProfilerConfig cpuProfilerConfig = CpuProfilerConfigConverter.fromProfilingConfiguration(config);
            switch (config.getTraceType()) {
                case ART: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.ART);
                    cpuConfigInfo.setMode(config instanceof ArtSampledConfiguration ? CpuProfilingConfig.Mode.SAMPLED : CpuProfilingConfig.Mode.INSTRUMENTED);
                    cpuConfigInfo.setSampleInterval(cpuProfilerConfig.getSamplingIntervalUs());
                    break;
                }
                case SIMPLEPERF: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.SIMPLE_PERF);
                    cpuConfigInfo.setMode(CpuProfilingConfig.Mode.SAMPLED);
                    cpuConfigInfo.setSampleInterval(cpuProfilerConfig.getSamplingIntervalUs());
                    break;
                }
                case ATRACE: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.ATRACE);
                    cpuConfigInfo.setSizeLimit(cpuProfilerConfig.getBufferSizeMb());
                    break;
                }
                case PERFETTO: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.PERFETTO);
                    cpuConfigInfo.setSizeLimit(cpuProfilerConfig.getBufferSizeMb());
                    break;
                }
            }
            return cpuConfigInfo.build();
        }
    }
}

