/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.profilers.LegacyCpuTraceRecord;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.TransportServiceUtils;
import com.android.tools.profiler.proto.Trace;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0005J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000bH\u0016R>\u0010\u0004\u001a2\u0012\u0004\u0012\u00020\u0006\u0012(\u0012&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00050\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/profilers/LegacyCpuProfilingHandler;", "Lcom/android/ddmlib/ClientData$IMethodProfilingHandler;", "<init>", "()V", "deviceToProfilingMetadata", "", "Lcom/android/ddmlib/IDevice;", "Lkotlin/Pair;", "", "", "Lcom/android/tools/idea/profilers/LegacyCpuTraceRecord;", "", "registerDevice", "", "device", "profilingRecords", "filePathCache", "onSuccess", "remoteFilePath", "client", "Lcom/android/ddmlib/Client;", "data", "", "onStartFailure", "message", "onEndFailure", "intellij.android.profilersAndroid"})
public final class LegacyCpuProfilingHandler
implements ClientData.IMethodProfilingHandler {
    @NotNull
    public static final LegacyCpuProfilingHandler INSTANCE = new LegacyCpuProfilingHandler();
    @NotNull
    private static final Map<IDevice, Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, String>>> deviceToProfilingMetadata = new LinkedHashMap();

    private LegacyCpuProfilingHandler() {
    }

    public final void registerDevice(@NotNull IDevice device2, @NotNull Map<Integer, LegacyCpuTraceRecord> profilingRecords, @NotNull Map<String, String> filePathCache) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter(profilingRecords, (String)"profilingRecords");
        Intrinsics.checkNotNullParameter(filePathCache, (String)"filePathCache");
        deviceToProfilingMetadata.put(device2, (Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, String>>)new Pair(profilingRecords, filePathCache));
    }

    public void onSuccess(@NotNull String remoteFilePath, @NotNull Client client) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)remoteFilePath, (String)"remoteFilePath");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, String>> pair = deviceToProfilingMetadata.get(client.getDevice());
            if (pair == null) break block1;
            Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, String>> pair2 = pair;
            boolean bl = false;
            Map traceRecords = (Map)pair2.component1();
            LegacyCpuTraceRecord legacyCpuTraceRecord = (LegacyCpuTraceRecord)traceRecords.get(client.getClientData().getPid());
            if (legacyCpuTraceRecord != null) {
                LegacyCpuTraceRecord record = legacyCpuTraceRecord;
                boolean bl2 = false;
                Trace.TraceStopStatus status2 = Trace.TraceStopStatus.newBuilder().setStatus(Trace.TraceStopStatus.Status.CANNOT_COPY_FILE).setErrorMessage("Method profiling: Older devices (API level < 10) are not supported. Please use DDMS.").build();
                Trace.TraceInfo.Builder builder = record.getTraceInfo();
                Intrinsics.checkNotNull((Object)builder);
                builder.setStopStatus(status2);
                record.getStopLatch().countDown();
            }
        }
    }

    public void onSuccess(@NotNull byte[] data2, @NotNull Client client) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, String>> pair = deviceToProfilingMetadata.get(client.getDevice());
            if (pair == null) break block1;
            Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, String>> pair2 = pair;
            boolean bl = false;
            Map traceRecords = (Map)pair2.component1();
            Map filePathCache = (Map)pair2.component2();
            LegacyCpuTraceRecord legacyCpuTraceRecord = (LegacyCpuTraceRecord)traceRecords.get(client.getClientData().getPid());
            if (legacyCpuTraceRecord != null) {
                LegacyCpuTraceRecord record = legacyCpuTraceRecord;
                boolean bl2 = false;
                Trace.TraceInfo.Builder builder = record.getTraceInfo();
                Intrinsics.checkNotNull((Object)builder);
                Trace.TraceInfo.Builder traceInfo = builder;
                traceInfo.setStopStatus(Trace.TraceStopStatus.newBuilder().setStatus(Trace.TraceStopStatus.Status.SUCCESS).build());
                String string = "legacy_trace_" + traceInfo.getTraceId();
                ByteString byteString = ByteString.copyFrom((byte[])data2);
                Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"copyFrom(...)");
                File tempFile = TransportServiceUtils.createTempFile(string, ".trace", byteString);
                filePathCache.put(String.valueOf(traceInfo.getTraceId()), tempFile.getAbsolutePath());
                record.getStopLatch().countDown();
            }
        }
    }

    public void onStartFailure(@NotNull Client client, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    public void onEndFailure(@NotNull Client client, @NotNull String message) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, String>> pair = deviceToProfilingMetadata.get(client.getDevice());
            if (pair == null) break block3;
            Pair<Map<Integer, LegacyCpuTraceRecord>, Map<String, String>> pair2 = pair;
            boolean bl = false;
            Map traceRecords = (Map)pair2.component1();
            LegacyCpuTraceRecord legacyCpuTraceRecord = (LegacyCpuTraceRecord)traceRecords.get(client.getClientData().getPid());
            if (legacyCpuTraceRecord != null) {
                LegacyCpuTraceRecord record = legacyCpuTraceRecord;
                boolean bl2 = false;
                if (record.getStartLatch().getCount() > 0L) {
                    record.setStartFailureMessage(message);
                    record.getStartLatch().countDown();
                } else {
                    Trace.TraceStopStatus status2 = Trace.TraceStopStatus.newBuilder().setStatus(Trace.TraceStopStatus.Status.STOP_COMMAND_FAILED).setErrorMessage("Failed to stop profiling: " + message).build();
                    Trace.TraceInfo.Builder builder = record.getTraceInfo();
                    Intrinsics.checkNotNull((Object)builder);
                    builder.setStopStatus(status2);
                    record.getStopLatch().countDown();
                }
            }
        }
    }

    static {
        ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)INSTANCE);
    }
}

