/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.npw.model.MultiTemplateRendererKt;
import com.android.tools.idea.npw.model.ProjectRenderRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0003\u0011\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\bJ\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/npw/model/MultiTemplateRenderer;", "", "renderRunner", "Lcom/android/tools/idea/npw/model/ProjectRenderRunner;", "<init>", "(Lcom/android/tools/idea/npw/model/ProjectRenderRunner;)V", "templateRenderers", "", "Lcom/android/tools/idea/npw/model/MultiTemplateRenderer$TemplateRenderer;", "requestCount", "", "incrementRenders", "", "requestRender", "templateRenderer", "skipRender", "countDown", "TemplateRendererListener", "TemplateRenderer", "Companion", "intellij.android.newProjectWizard"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMultiTemplateRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiTemplateRenderer.kt\ncom/android/tools/idea/npw/model/MultiTemplateRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1#2:172\n1863#3,2:173\n1863#3,2:175\n1734#3,3:177\n1863#3,2:180\n*S KotlinDebug\n*F\n+ 1 MultiTemplateRenderer.kt\ncom/android/tools/idea/npw/model/MultiTemplateRenderer\n*L\n149#1:173,2\n131#1:175,2\n132#1:177,3\n144#1:180,2\n*E\n"})
public final class MultiTemplateRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectRenderRunner renderRunner;
    @NotNull
    private final List<TemplateRenderer> templateRenderers;
    private int requestCount;
    public static final int $stable = 8;
    @NotNull
    private static final Topic<TemplateRendererListener> TEMPLATE_RENDERER_TOPIC = new Topic("Template rendering", TemplateRendererListener.class);

    public MultiTemplateRenderer(@NotNull ProjectRenderRunner renderRunner) {
        Intrinsics.checkNotNullParameter((Object)renderRunner, (String)"renderRunner");
        this.renderRunner = renderRunner;
        this.templateRenderers = new ArrayList();
        this.requestCount = 1;
    }

    public final void incrementRenders() {
        int n = this.requestCount;
        this.requestCount = n + 1;
    }

    public final void requestRender(@NotNull TemplateRenderer templateRenderer) {
        Intrinsics.checkNotNullParameter((Object)templateRenderer, (String)"templateRenderer");
        this.templateRenderers.add(templateRenderer);
        this.countDown();
    }

    public final void skipRender() {
        this.countDown();
    }

    private final void countDown() {
        if (!(this.requestCount != 0)) {
            boolean bl = false;
            String string = "Invalid extra call to MultiTemplateRenderer#countDown";
            throw new IllegalStateException(string.toString());
        }
        int n = this.requestCount;
        this.requestCount = n + -1;
        if (this.requestCount != 0 || this.templateRenderers.isEmpty()) {
            return;
        }
        this.renderRunner.runRenderer((Function1<? super Project, Unit>)((Function1)arg_0 -> MultiTemplateRenderer.countDown$lambda$6(this, arg_0)));
    }

    private static final void countDown$lambda$6$lambda$2(MultiTemplateRenderer this$0) {
        for (TemplateRenderer templateRenderer : this$0.templateRenderers) {
            templateRenderer.logUsage();
            templateRenderer.render();
        }
    }

    private static final void countDown$lambda$6$lambda$5(MultiTemplateRenderer this$0, Project $project) {
        MultiTemplateRendererKt.access$getLog$p().info("Finishing generating sources.");
        Iterable $this$forEach$iv = this$0.templateRenderers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TemplateRenderer p0 = (TemplateRenderer)element$iv;
            boolean bl = false;
            p0.finish();
        }
        Companion.multiRenderingFinished($project);
    }

    private static final Unit countDown$lambda$6(MultiTemplateRenderer this$0, Project project) {
        boolean bl;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        block6: {
            TemplateRenderer p0;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            MultiTemplateRendererKt.access$getLog$p().info("Generating sources.");
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            Companion.multiRenderingStarted(project);
            $this$forEach$iv = this$0.templateRenderers;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (TemplateRenderer)element$iv;
                boolean bl2 = false;
                p0.init();
            }
            Iterable $this$all$iv = this$0.templateRenderers;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    p0 = (TemplateRenderer)element$iv;
                    boolean bl3 = false;
                    if (p0.doDryRun()) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            TransactionGuard.getInstance().submitTransactionAndWait(() -> MultiTemplateRenderer.countDown$lambda$6$lambda$2(this$0));
        }
        MultiTemplateRendererKt.access$getLog$p().info("Generate sources completed.");
        $this$forEach$iv = this$0.templateRenderers;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TemplateRenderer it = (TemplateRenderer)element$iv;
            boolean bl4 = false;
            it.onSourcesCreated();
        }
        TransactionGuard.getInstance().submitTransactionAndWait(() -> MultiTemplateRenderer.countDown$lambda$6$lambda$5(this$0, project));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bR\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/npw/model/MultiTemplateRenderer$Companion;", "", "<init>", "()V", "TEMPLATE_RENDERER_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/android/tools/idea/npw/model/MultiTemplateRenderer$TemplateRendererListener;", "kotlin.jvm.PlatformType", "subscribe", "Lcom/intellij/util/messages/MessageBusConnection;", "project", "Lcom/intellij/openapi/project/Project;", "listener", "multiRenderingStarted", "", "multiRenderingFinished", "intellij.android.newProjectWizard"})
    @SourceDebugExtension(value={"SMAP\nMultiTemplateRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiTemplateRenderer.kt\ncom/android/tools/idea/npw/model/MultiTemplateRenderer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MessageBusConnection subscribe(@NotNull Project project, @NotNull TemplateRendererListener listener2) {
            MessageBusConnection messageBusConnection;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            MessageBusConnection $this$subscribe_u24lambda_u240 = messageBusConnection = project.getMessageBus().connect((Disposable)project);
            boolean bl = false;
            $this$subscribe_u24lambda_u240.subscribe(TEMPLATE_RENDERER_TOPIC, (Object)listener2);
            return messageBusConnection;
        }

        public final void multiRenderingStarted(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ((TemplateRendererListener)project.getMessageBus().syncPublisher(TEMPLATE_RENDERER_TOPIC)).multiRenderingStarted();
        }

        public final void multiRenderingFinished(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ((TemplateRendererListener)project.getMessageBus().syncPublisher(TEMPLATE_RENDERER_TOPIC)).multiRenderingFinished();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0005H'J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H'J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H&\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/npw/model/MultiTemplateRenderer$TemplateRenderer;", "", "init", "", "doDryRun", "", "onSourcesCreated", "render", "finish", "logUsage", "intellij.android.newProjectWizard"})
    public static interface TemplateRenderer {
        @WorkerThread
        @Slow
        default public void init() {
        }

        @WorkerThread
        @Slow
        public boolean doDryRun();

        @WorkerThread
        @Slow
        default public void onSourcesCreated() {
        }

        @WorkerThread
        @Slow
        public void render();

        @UiThread
        default public void finish() {
        }

        public void logUsage();

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @WorkerThread
            @Slow
            @Deprecated
            public static void init(@NotNull TemplateRenderer $this) {
                $this.init();
            }

            @WorkerThread
            @Slow
            @Deprecated
            public static void onSourcesCreated(@NotNull TemplateRenderer $this) {
                $this.onSourcesCreated();
            }

            @UiThread
            @Deprecated
            public static void finish(@NotNull TemplateRenderer $this) {
                $this.finish();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/npw/model/MultiTemplateRenderer$TemplateRendererListener;", "", "multiRenderingStarted", "", "multiRenderingFinished", "intellij.android.newProjectWizard"})
    public static interface TemplateRendererListener {
        default public void multiRenderingStarted() {
        }

        default public void multiRenderingFinished() {
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            public static void multiRenderingStarted(@NotNull TemplateRendererListener $this) {
                $this.multiRenderingStarted();
            }

            @Deprecated
            public static void multiRenderingFinished(@NotNull TemplateRendererListener $this) {
                $this.multiRenderingFinished();
            }
        }
    }
}

