/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.vectordrawable.VdOverrideInfo;
import com.android.resources.ResourceFolderType;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.VectorIconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.ui.SliderUtils;
import com.android.tools.idea.npw.assetstudio.ui.VectorAssetBrowser;
import com.android.tools.idea.npw.assetstudio.ui.VectorIconButton;
import com.android.tools.idea.npw.assetstudio.ui.VectorImageComponent;
import com.android.tools.idea.npw.assetstudio.wizard.ConfirmGenerateIconsStep;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.npw.project.AndroidPackageUtils;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.Receiver;
import com.android.tools.idea.observable.adapters.StringToDoubleAdapterProperty;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.DoubleProperty;
import com.android.tools.idea.observable.core.DoubleValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.optional.AsOptionalExpression;
import com.android.tools.idea.observable.ui.ColorProperty;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.HasFocusProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.SelectedRadioButtonProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.SwingWorker;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class NewVectorAssetStep
extends ModelWizardStep<GenerateIconsModel>
implements PersistentStateComponent<PersistentState> {
    private static final String DEFAULT_OUTPUT_NAME = "vector_name";
    private static final AssetSourceType DEFAULT_ASSET_SOURCE_TYPE = AssetSourceType.CLIP_ART;
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final String VECTOR_ASSET_STEP_PROPERTY = "vectorAssetStep";
    private static final String OUTPUT_NAME_PROPERTY = "outputName";
    private static final String ASSET_SOURCE_TYPE_PROPERTY = "assetSourceType";
    private static final String CLIPART_ASSET_PROPERTY = "clipartAsset";
    private static final String SOURCE_FILE_PROPERTY = "sourceFile";
    private static final String COLOR_PROPERTY = "color";
    private static final String OPACITY_PERCENT_PROPERTY = "opacityPercent";
    private static final String AUTO_MIRRORED_PROPERTY = "autoMirrored";
    private final ObjectProperty<AssetSourceType> myAssetSourceType;
    private final ObjectProperty<VectorAsset> myActiveAsset;
    private final StringProperty myOutputName;
    private final ObservableBool myWidthHasFocus;
    private final ObservableBool myHeightHasFocus;
    private final DoubleProperty myWidth = new DoubleValueProperty();
    private final DoubleProperty myHeight = new DoubleValueProperty();
    private final ColorProperty myColor;
    private final IntProperty myOpacityPercent;
    private final BoolProperty myAutoMirrored;
    private final BoolValueProperty myAssetIsValid = new BoolValueProperty();
    private final ObjectValueProperty<Validator.Result> myAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
    private final IdeResourceNameValidator myNameValidator = IdeResourceNameValidator.forFilename(ResourceFolderType.DRAWABLE);
    private final BindingsManager myGeneralBindings = new BindingsManager();
    private final BindingsManager myActiveAssetBindings = new BindingsManager();
    private final ListenerManager myListeners = new ListenerManager();
    @NotNull
    private final VectorIconGenerator myIconGenerator;
    @NotNull
    private final AndroidFacet myFacet;
    private final ValidatorPanel myValidatorPanel;
    private double myAspectRatio;
    @Nullable
    StringToDoubleAdapterProperty myWidthAdapter;
    @Nullable
    StringToDoubleAdapterProperty myHeightAdapter;
    private JPanel myPanel;
    private JPanel myImagePreviewPanel;
    private VectorImageComponent myImagePreview;
    private JPanel myResourceNamePanel;
    private JTextField myOutputNameTextField;
    private JPanel mySourceAssetTypePanel;
    private JPanel mySourceAssetRadioButtons;
    private JRadioButton myClipartRadioButton;
    private JRadioButton myLocalFileRadioButton;
    private JPanel myIconPickerPanel;
    private VectorIconButton myClipartAssetButton;
    private JPanel myFileBrowserPanel;
    private VectorAssetBrowser myFileBrowser;
    private JPanel myResizePanel;
    private JTextField myWidthTextField;
    private JTextField myHeightTextField;
    private JPanel myColorRowPanel;
    private ColorPanel myColorPanel;
    private JPanel myOpacityPanel;
    private JSlider myOpacitySlider;
    private JTextField myOpacityValueTextField;
    private JBLabel myOpacityValueLabel;
    private JCheckBox myEnableAutoMirroredCheckBox;
    private JPanel myPreviewPanel;
    private JPanel myLeftPanel;
    private JPanel myRightPanel;

    public NewVectorAssetStep(@NotNull GenerateIconsModel model, @NotNull AndroidFacet facet) {
        super(model, "Configure Vector Asset");
        this.setupUI();
        this.myFacet = facet;
        int minSdkVersion2 = StudioAndroidModuleInfo.getInstance(this.myFacet).getMinSdkVersion().getApiLevel();
        this.myIconGenerator = new VectorIconGenerator(this.myFacet.getModule().getProject(), minSdkVersion2);
        Disposer.register((Disposable)this, (Disposable)this.myIconGenerator);
        this.myImagePreviewPanel.setBorder(JBUI.Borders.customLine((Color)JBColor.border()));
        this.myAssetSourceType = new SelectedRadioButtonProperty<AssetSourceType>(DEFAULT_ASSET_SOURCE_TYPE, (T[])AssetSourceType.values(), this.myClipartRadioButton, this.myLocalFileRadioButton);
        this.myActiveAsset = new ObjectValueProperty<VectorAsset>(this.myClipartAssetButton.getAsset());
        this.myOutputName = new TextProperty(this.myOutputNameTextField);
        this.myOutputName.set(DEFAULT_OUTPUT_NAME);
        this.myWidthHasFocus = new HasFocusProperty(this.myWidthTextField);
        this.myHeightHasFocus = new HasFocusProperty(this.myHeightTextField);
        this.myColor = new ColorProperty(this.myColorPanel);
        this.myOpacityPercent = SliderUtils.bindTwoWay(this.myGeneralBindings, this.myOpacitySlider, this.myOpacityValueTextField);
        this.myAutoMirrored = new SelectedProperty(this.myEnableAutoMirroredCheckBox);
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel, false, "Conversion Issues", "Encountered Issues:");
        ActionListener assetListener = actionEvent -> this.renderPreviews();
        this.myClipartAssetButton.addAssetListener(assetListener);
        this.myClipartAssetButton.setToolTipText("Select Clip Art");
        this.myFileBrowser.addAssetListener(assetListener);
        this.myListeners.listenAndFire(this.myAssetSourceType, sourceType -> {
            this.myIconPickerPanel.setVisible(sourceType == AssetSourceType.CLIP_ART);
            this.myColorRowPanel.setVisible(sourceType == AssetSourceType.CLIP_ART);
            this.myFileBrowserPanel.setVisible(sourceType == AssetSourceType.FILE);
            this.myActiveAsset.set(sourceType == AssetSourceType.CLIP_ART ? this.myClipartAssetButton.getAsset() : this.myFileBrowser.getAsset());
        });
        this.myListeners.listenAll(this.myWidthHasFocus, this.myHeightHasFocus).with(() -> {
            this.myGeneralBindings.release(this.myWidth);
            this.myGeneralBindings.release(this.myHeight);
            this.bindWidthAndHeight();
        });
        TextProperty widthText = new TextProperty(this.myWidthTextField);
        TextProperty heightText = new TextProperty(this.myHeightTextField);
        Receiver<VectorAsset.VectorDrawableInfo> drawableListener = drawableInfo -> {
            this.myAssetIsValid.set(drawableInfo.isValid());
            this.myAssetValidityState.set(drawableInfo.getValidityState());
            this.myGeneralBindings.release(this.myWidth);
            this.myGeneralBindings.release(this.myHeight);
            if (this.myWidthAdapter != null) {
                this.myGeneralBindings.release(this.myWidthAdapter);
                this.myWidthAdapter = null;
            }
            if (this.myHeightAdapter != null) {
                this.myGeneralBindings.release(this.myHeightAdapter);
                this.myHeightAdapter = null;
            }
            double width = drawableInfo.getOriginalWidth();
            double height = drawableInfo.getOriginalHeight();
            if (width > 0.0 && height > 0.0) {
                this.myWidth.set(width);
                this.myHeight.set(height);
                this.myAspectRatio = width / height;
                int numDecimals = Math.max(AssetStudioUtils.roundToInt(Math.ceil(2.0 - Math.log10(Math.min(width, height)))), 0);
                this.myWidthAdapter = new StringToDoubleAdapterProperty((AbstractProperty<String>)widthText, numDecimals);
                this.myHeightAdapter = new StringToDoubleAdapterProperty((AbstractProperty<String>)heightText, numDecimals);
                this.bindWidthAndHeight();
                this.myWidthTextField.setEnabled(true);
                this.myHeightTextField.setEnabled(true);
            } else {
                this.myWidth.set(1.0);
                this.myHeight.set(1.0);
                this.myWidthTextField.setText("");
                this.myHeightTextField.setText("");
                this.myWidthTextField.setEnabled(false);
                this.myHeightTextField.setEnabled(false);
            }
            this.renderPreviews();
        };
        this.myListeners.listenAndFire(this.myActiveAsset, () -> {
            this.myActiveAssetBindings.releaseAll();
            VectorAsset activeAsset = (VectorAsset)this.myActiveAsset.get();
            OptionalValueProperty<File> fileProperty = activeAsset.path();
            this.myActiveAssetBindings.bind(this.myOutputName, Expression.create(() -> {
                File file = (File)fileProperty.getValueOrNull();
                if (file == null || !file.exists() || file.isDirectory()) {
                    return DEFAULT_OUTPUT_NAME;
                }
                String name2 = FileUtil.getNameWithoutExtension((File)file).toLowerCase(Locale.getDefault());
                return FileResourceNameValidator.getValidResourceFileName((String)name2);
            }, fileProperty));
            this.myListeners.release(drawableListener);
            ObjectProperty<VectorAsset.VectorDrawableInfo> vectorDrawableInfo = activeAsset.getVectorDrawableInfo();
            this.myListeners.listenAndFire(vectorDrawableInfo, drawableListener);
            this.myValidatorPanel.registerValidator((ObservableValue)this.myOutputName, name2 -> Validator.Result.fromNullableMessage((String)this.myNameValidator.getErrorText((String)name2)), new ObservableValue[0]);
            this.myValidatorPanel.registerValidator(this.myAssetValidityState, validity -> validity, new ObservableValue[0]);
            EnabledProperty widthEnabled = new EnabledProperty(this.myWidthTextField);
            Expression<String> widthForValidation = Expression.create(() -> widthEnabled.get() != false ? widthText.get() : "24", widthText, widthEnabled);
            this.myValidatorPanel.registerValidator(widthForValidation, (Validator)new SizeValidator("Width has to be a positive number"), new ObservableValue[0]);
            EnabledProperty heightEnabled = new EnabledProperty(this.myHeightTextField);
            Expression<String> heightForValidation = Expression.create(() -> heightEnabled.get() != false ? heightText.get() : "24", heightText, heightEnabled);
            this.myValidatorPanel.registerValidator(heightForValidation, (Validator)new SizeValidator("Height has to be a positive number"), new ObservableValue[0]);
            this.myValidatorPanel.registerValidator((ObservableValue)new TextProperty(this.myOpacityValueTextField), SliderUtils.inRange(this.myOpacitySlider, "Opacity"), new ObservableValue[0]);
            if (this.myAssetSourceType.get() == AssetSourceType.CLIP_ART) {
                this.myActiveAssetBindings.bind(activeAsset.color(), this.myColor);
            }
            this.myActiveAssetBindings.bind(activeAsset.opacityPercent(), this.myOpacityPercent);
            this.myActiveAssetBindings.bind(activeAsset.autoMirrored(), this.myAutoMirrored);
            this.myActiveAssetBindings.bind(activeAsset.outputWidth(), Expression.create(this.myWidth::get, this.myWidth));
            this.myActiveAssetBindings.bind(activeAsset.outputHeight(), Expression.create(this.myHeight::get, this.myHeight));
            this.myListeners.listenAll(this.myActiveAsset, activeAsset.outputWidth(), activeAsset.outputHeight(), activeAsset.color(), activeAsset.opacityPercent(), activeAsset.autoMirrored()).with(this::renderPreviews);
        });
        this.myGeneralBindings.bind(this.myIconGenerator.sourceAsset(), new AsOptionalExpression<VectorAsset>((ObservableValue<VectorAsset>)this.myActiveAsset));
        this.myGeneralBindings.bind(this.myIconGenerator.outputName(), this.myOutputName);
        PersistentStateUtil.load(this, ((GenerateIconsModel)this.getModel()).getPersistentState().getChild(VECTOR_ASSET_STEP_PROPERTY));
        this.renderPreviews();
    }

    private void bindWidthAndHeight() {
        if (this.myWidthAdapter != null && this.myHeightAdapter != null) {
            this.myGeneralBindings.bind(this.myWidthAdapter, this.myWidth);
            this.myGeneralBindings.bind(this.myHeightAdapter, this.myHeight);
            if (((Boolean)this.myWidthHasFocus.get()).booleanValue()) {
                this.myGeneralBindings.bind(this.myWidth, this.myWidthAdapter);
                this.myGeneralBindings.bind(this.myHeight, Expression.create(() -> (Double)this.myWidth.get() / this.myAspectRatio, this.myWidth));
            } else if (((Boolean)this.myHeightHasFocus.get()).booleanValue()) {
                this.myGeneralBindings.bind(this.myHeight, this.myHeightAdapter);
                this.myGeneralBindings.bind(this.myWidth, Expression.create(() -> (Double)this.myHeight.get() * this.myAspectRatio, this.myHeight));
            }
        }
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep<?>> createDependentSteps() {
        return Collections.singletonList(new ConfirmGenerateIconsStep((GenerateIconsModel)this.getModel(), AndroidPackageUtils.getModuleTemplates(this.myFacet, null)));
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myValidatorPanel;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myAssetIsValid.and(this.myValidatorPanel.hasErrors().not());
    }

    @Override
    protected void onProceeding() {
        ((GenerateIconsModel)this.getModel()).setIconGenerator(this.myIconGenerator);
    }

    @Override
    public void onWizardFinished() {
        ((GenerateIconsModel)this.getModel()).getPersistentState().setChild(VECTOR_ASSET_STEP_PROPERTY, this.getState());
    }

    @Override
    public void dispose() {
        this.myGeneralBindings.releaseAll();
        this.myActiveAssetBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state2 = new PersistentState();
        state2.set(OUTPUT_NAME_PROPERTY, (String)this.myOutputName.get(), DEFAULT_OUTPUT_NAME);
        state2.set(ASSET_SOURCE_TYPE_PROPERTY, (AssetSourceType)((Object)this.myAssetSourceType.get()), DEFAULT_ASSET_SOURCE_TYPE);
        state2.setChild(CLIPART_ASSET_PROPERTY, this.myClipartAssetButton.getState());
        File file = (File)this.myFileBrowser.getAsset().path().getValueOrNull();
        state2.set(SOURCE_FILE_PROPERTY, file == null ? this.getProjectPath() : file.getPath(), this.getProjectPath());
        state2.set(COLOR_PROPERTY, (Color)this.myColor.getValueOrNull(), DEFAULT_COLOR);
        state2.set(OPACITY_PERCENT_PROPERTY, (Integer)this.myOpacityPercent.get(), 100);
        state2.set(AUTO_MIRRORED_PROPERTY, (Boolean)this.myAutoMirrored.get(), false);
        return state2;
    }

    public void loadState(@NotNull PersistentState state2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            String name2 = state2.get(OUTPUT_NAME_PROPERTY);
            if (name2 != null) {
                this.myOutputName.set(name2);
            }
            this.myAssetSourceType.set(state2.get(ASSET_SOURCE_TYPE_PROPERTY, DEFAULT_ASSET_SOURCE_TYPE));
            PersistentStateUtil.load(this.myClipartAssetButton, state2.getChild(CLIPART_ASSET_PROPERTY));
            String path = state2.get(SOURCE_FILE_PROPERTY, this.getProjectPath());
            this.myFileBrowser.getAsset().path().setValue(new File(path));
            this.myColor.setValue(state2.get(COLOR_PROPERTY, DEFAULT_COLOR));
            this.myOpacityPercent.set(state2.get(OPACITY_PERCENT_PROPERTY, 100));
            this.myAutoMirrored.set(state2.get(AUTO_MIRRORED_PROPERTY, false));
        }, ModalityState.any());
    }

    private @SystemIndependent @NotNull String getProjectPath() {
        String projectPath = this.myFacet.getModule().getProject().getBasePath();
        assert (projectPath != null);
        return projectPath;
    }

    private void renderPreviews() {
        VectorPreviewUpdater previewUpdater = new VectorPreviewUpdater();
        this.invokeLater(() -> this.invokeLater(previewUpdater::enqueueUpdate));
    }

    private void invokeLater(@NotNull Runnable runnable2) {
        ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.any(), o -> Disposer.isDisposed((Disposable)this));
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.setMinimumSize(new Dimension(720, 512));
        this.myPanel.setPreferredSize(new Dimension(-1, -1));
        this.myPanel.setToolTipText("");
        this.myLeftPanel = new JPanel();
        this.myLeftPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)this.myLeftPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 3, null, null, null, 0, false));
        this.myResourceNamePanel = new JPanel();
        this.myResourceNamePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myLeftPanel.add((Component)this.myResourceNamePanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel label1 = new JLabel();
        label1.setText("Name:");
        this.myResourceNamePanel.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(-1, 15), null, null, 0, false));
        this.myOutputNameTextField = new JTextField();
        this.myOutputNameTextField.setText("(name)");
        this.myResourceNamePanel.add((Component)this.myOutputNameTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, new Dimension(-1, 20), null, null, 0, false));
        this.myIconPickerPanel = new JPanel();
        this.myIconPickerPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myLeftPanel.add((Component)this.myIconPickerPanel, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Clip art:");
        this.myIconPickerPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myClipartAssetButton = new VectorIconButton();
        this.myIconPickerPanel.add((Component)this.myClipartAssetButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(24, 24), null, 0, false));
        this.myFileBrowserPanel = new JPanel();
        this.myFileBrowserPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myFileBrowserPanel.setVisible(true);
        this.myLeftPanel.add((Component)this.myFileBrowserPanel, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        JLabel label2 = new JLabel();
        label2.setText("Path:");
        this.myFileBrowserPanel.add((Component)label2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myFileBrowser = new VectorAssetBrowser();
        this.myFileBrowserPanel.add((Component)((Object)this.myFileBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.mySourceAssetTypePanel = new JPanel();
        this.mySourceAssetTypePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myLeftPanel.add((Component)this.mySourceAssetTypePanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.mySourceAssetRadioButtons = new JPanel();
        this.mySourceAssetRadioButtons.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.mySourceAssetTypePanel.add((Component)this.mySourceAssetRadioButtons, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null, 0, false));
        this.myClipartRadioButton = new JRadioButton();
        this.myClipartRadioButton.setSelected(true);
        this.myClipartRadioButton.setText("Clip art");
        this.mySourceAssetRadioButtons.add((Component)this.myClipartRadioButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.myLocalFileRadioButton = new JRadioButton();
        this.myLocalFileRadioButton.setText("Local file (SVG, PSD)");
        this.mySourceAssetRadioButtons.add((Component)this.myLocalFileRadioButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Asset type:");
        this.mySourceAssetTypePanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myResizePanel = new JPanel();
        this.myResizePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myLeftPanel.add((Component)this.myResizePanel, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        JLabel label3 = new JLabel();
        label3.setText("Size:");
        this.myResizePanel.add((Component)label3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), 0, -1));
        this.myResizePanel.add((Component)panel1, new GridConstraints(0, 1, 1, 1, 8, 0, 1, 3, new Dimension(-1, 25), null, null, 0, false));
        this.myWidthTextField = new JFormattedTextField();
        this.myWidthTextField.setText("24");
        panel1.add((Component)this.myWidthTextField, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null, 0, false));
        JLabel label4 = new JLabel();
        label4.setText("dp  X ");
        panel1.add((Component)label4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myHeightTextField = new JFormattedTextField();
        this.myHeightTextField.setText("24");
        panel1.add((Component)this.myHeightTextField, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null, 0, false));
        JLabel label5 = new JLabel();
        label5.setText("dp");
        panel1.add((Component)label5, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myColorRowPanel = new JPanel();
        this.myColorRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myLeftPanel.add((Component)this.myColorRowPanel, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Color:");
        this.myColorRowPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myColorPanel = new ColorPanel();
        this.myColorPanel.setSelectedColor(new Color(-16777216));
        this.myColorRowPanel.add((Component)this.myColorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(78, -1), null, null, 0, false));
        this.myOpacityPanel = new JPanel();
        this.myOpacityPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myLeftPanel.add((Component)this.myOpacityPanel, new GridConstraints(6, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        JLabel label6 = new JLabel();
        label6.setText("Opacity:");
        this.myOpacityPanel.add((Component)label6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myOpacityPanel.add((Component)panel2, new GridConstraints(0, 1, 1, 1, 8, 2, 5, 3, null, null, null, 0, false));
        this.myOpacitySlider = new JSlider();
        this.myOpacitySlider.setMajorTickSpacing(20);
        this.myOpacitySlider.setMinorTickSpacing(10);
        this.myOpacitySlider.setPaintLabels(false);
        this.myOpacitySlider.setPaintTicks(false);
        this.myOpacitySlider.setPaintTrack(true);
        this.myOpacitySlider.setValue(100);
        panel2.add((Component)this.myOpacitySlider, new GridConstraints(0, 0, 1, 1, 8, 1, 4, 0, null, null, null, 0, false));
        this.myOpacityValueTextField = new JTextField();
        this.myOpacityValueTextField.setHorizontalAlignment(4);
        this.myOpacityValueTextField.setText("100");
        panel2.add((Component)this.myOpacityValueTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(30, -1), null, 0, false));
        this.myOpacityValueLabel = new JBLabel();
        this.myOpacityValueLabel.setHorizontalAlignment(4);
        this.myOpacityValueLabel.setText("%");
        panel2.add((Component)this.myOpacityValueLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, new Dimension(-1, -1), null, 0, false));
        this.myEnableAutoMirroredCheckBox = new JCheckBox();
        this.myEnableAutoMirroredCheckBox.setText("Enable auto mirroring for RTL layout");
        this.myEnableAutoMirroredCheckBox.setToolTipText("Check if your icon should flip in right-to-left layouts.");
        this.myLeftPanel.add((Component)this.myEnableAutoMirroredCheckBox, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myLeftPanel.add((Component)spacer1, new GridConstraints(8, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        this.myRightPanel = new JPanel();
        this.myRightPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myPanel.add((Component)this.myRightPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.myPreviewPanel = new JPanel();
        this.myPreviewPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 20), -1, -1));
        this.myRightPanel.add((Component)this.myPreviewPanel, new GridConstraints(0, 0, 1, 1, 1, 0, 3, 4, null, null, null, 0, false));
        this.myImagePreviewPanel = new JPanel();
        this.myImagePreviewPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myPreviewPanel.add((Component)this.myImagePreviewPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myImagePreviewPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), null, 0, 0, null, null));
        this.myImagePreview = new VectorImageComponent();
        this.myImagePreviewPanel.add((Component)((Object)this.myImagePreview), new GridConstraints(0, 0, 1, 1, 1, 0, 3, 5, new Dimension(256, 256), new Dimension(256, 256), null, 0, false));
        JLabel label7 = new JLabel();
        label7.setText("Vector drawable preview");
        this.myPreviewPanel.add((Component)label7, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        label1.setLabelFor(this.myOutputNameTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myClipartRadioButton);
        buttonGroup.add(this.myLocalFileRadioButton);
    }

    private static enum AssetSourceType {
        CLIP_ART,
        FILE;

    }

    private final class VectorPreviewUpdater {
        @Nullable
        private SwingWorker<VectorAsset.Preview> myCurrentWorker;
        @Nullable
        private SwingWorker<VectorAsset.Preview> myEnqueuedWorker;

        private VectorPreviewUpdater() {
        }

        @UiThread
        public void enqueueUpdate() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            int previewWidth = NewVectorAssetStep.this.myImagePreview.getWidth();
            if (previewWidth <= 0) {
                NewVectorAssetStep.this.invokeLater(this::enqueueUpdate);
                return;
            }
            if (this.myCurrentWorker == null) {
                this.myCurrentWorker = new Worker(previewWidth);
                this.myCurrentWorker.start();
            } else if (this.myEnqueuedWorker == null) {
                this.myEnqueuedWorker = new Worker(previewWidth);
            }
        }

        private class Worker
        extends SwingWorker<VectorAsset.Preview> {
            @Nullable
            VectorAsset.Preview myPreview;
            @NotNull
            final VectorAsset myAsset;
            @Nullable
            final File myAssetFile;
            @NotNull
            final VectorAsset.VectorDrawableInfo myVectorDrawableInfo;
            @NotNull
            final VdOverrideInfo myOverrideInfo;
            private final int myPreviewWidth;

            @UiThread
            Worker(int previewWidth) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                this.myPreviewWidth = previewWidth;
                this.myAsset = (VectorAsset)NewVectorAssetStep.this.myActiveAsset.get();
                this.myAssetFile = (File)this.myAsset.path().getValueOrNull();
                this.myVectorDrawableInfo = (VectorAsset.VectorDrawableInfo)this.myAsset.getVectorDrawableInfo().get();
                this.myOverrideInfo = this.myAsset.createOverrideInfo();
            }

            @WorkerThread
            @NotNull
            public VectorAsset.Preview construct() {
                try {
                    this.myPreview = VectorAsset.generatePreview(this.myVectorDrawableInfo, this.myPreviewWidth, this.myOverrideInfo);
                }
                catch (Throwable t) {
                    Logger.getInstance(((Object)((Object)this)).getClass()).error(t);
                    String message = this.myAssetFile == null ? "Internal error generating preview" : "Internal error generating preview for " + this.myAssetFile.getName();
                    this.myPreview = new VectorAsset.Preview(message);
                }
                return this.myPreview;
            }

            @UiThread
            public void finished() {
                ApplicationManager.getApplication().assertIsDispatchThread();
                assert (this.myPreview != null);
                if (this.myAsset.equals(NewVectorAssetStep.this.myActiveAsset.get()) && this.myAsset.isCurrentFile(this.myAssetFile) && this.myVectorDrawableInfo.equals(this.myAsset.getVectorDrawableInfo().get()) && this.myOverrideInfo.equals((Object)this.myAsset.createOverrideInfo())) {
                    NewVectorAssetStep.this.myAssetValidityState.set(this.myPreview.getValidityState());
                    BufferedImage image = this.myPreview.getImage();
                    NewVectorAssetStep.this.myImagePreview.setIcon(image == null ? null : new ImageIcon(image));
                }
                VectorPreviewUpdater.this.myCurrentWorker = null;
                if (VectorPreviewUpdater.this.myEnqueuedWorker != null) {
                    VectorPreviewUpdater.this.myCurrentWorker = VectorPreviewUpdater.this.myEnqueuedWorker;
                    VectorPreviewUpdater.this.myEnqueuedWorker = null;
                    VectorPreviewUpdater.this.myCurrentWorker.start();
                }
            }
        }
    }

    private static class SizeValidator
    implements Validator<String> {
        private static final NumberFormat myFormat = NumberFormat.getNumberInstance();
        private final Validator.Result myInvalidResult;

        SizeValidator(@NotNull String message) {
            this.myInvalidResult = new Validator.Result(Validator.Severity.ERROR, message);
        }

        @NotNull
        public Validator.Result validate(@NotNull String value2) {
            ParsePosition pos = new ParsePosition(0);
            Number number = myFormat.parse(value2, pos);
            return number != null && pos.getIndex() == value2.length() && number.doubleValue() > 0.0 ? Validator.Result.OK : this.myInvalidResult;
        }
    }
}

