/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.assetstudio.ActionBarIconGenerator;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.LauncherLegacyIconGenerator;
import com.android.tools.idea.npw.assetstudio.NotificationIconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconType;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.ui.ClipartIconButton;
import com.android.tools.idea.npw.assetstudio.ui.ConfigureIconView;
import com.android.tools.idea.npw.assetstudio.ui.ImageAssetBrowser;
import com.android.tools.idea.npw.assetstudio.ui.MultiLineTextAssetEditor;
import com.android.tools.idea.npw.assetstudio.ui.SliderUtils;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.SettableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.tools.idea.observable.expressions.optional.AsOptionalExpression;
import com.android.tools.idea.observable.ui.ColorProperty;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.SelectedRadioButtonProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigureIconPanel
extends JPanel
implements Disposable,
ConfigureIconView {
    private static final AssetType DEFAULT_ASSET_TYPE = AssetType.CLIP_ART;
    private static final Map<IconGenerator.Shape, String> SHAPE_NAMES = ImmutableMap.of((Object)((Object)IconGenerator.Shape.NONE), (Object)"None", (Object)((Object)IconGenerator.Shape.SOLID), (Object)"Solid Color", (Object)((Object)IconGenerator.Shape.CIRCLE), (Object)"Circle", (Object)((Object)IconGenerator.Shape.SQUARE), (Object)"Square", (Object)((Object)IconGenerator.Shape.VRECT), (Object)"Vertical", (Object)((Object)IconGenerator.Shape.HRECT), (Object)"Horizontal");
    private static final String OUTPUT_NAME_PROPERTY = "outputName";
    private static final String ASSET_TYPE_PROPERTY = "assetType";
    private static final String IMAGE_ASSET_PROPERTY = "imageAsset";
    private static final String CLIPART_ASSET_PROPERTY = "clipartAsset";
    private static final String TEXT_ASSET_PROPERTY = "textAsset";
    private static final String BACKGROUND_COLOR_PROPERTY = "backgroundColor";
    private static final String ICON_SHAPE_PROPERTY = "iconShape";
    private static final String CROPPED_PROPERTY = "cropped";
    private static final String DOG_EARED_PROPERTY = "dogEared";
    private static final String THEME_PROPERTY = "theme";
    private static final String THEME_COLOR_PROPERTY = "themeColor";
    private JPanel myRootPanel;
    private JRadioButton myClipartRadioButton;
    private JRadioButton myTextRadioButton;
    private JRadioButton myImageRadioButton;
    private JPanel myAllOptionsPanel;
    private JPanel mySourceAssetTypePanel;
    private JPanel myIconOptionsPanel;
    private JRadioButton myTrimmedRadioButton;
    private JRadioButton myNotTrimmedRadioButton;
    private JPanel myTrimOptionsPanel;
    private JSlider myPaddingSlider;
    private JTextField myPaddingValueTextField;
    private JLabel myPaddingValueLabel;
    private JPanel myAssetRadioButtonsPanel;
    private JPanel myPaddingSliderPanel;
    private JTextField myOutputNameTextField;
    private JPanel myOutputNamePanel;
    private JPanel myTrimRowPanel;
    private JPanel myNameRowPanel;
    private JPanel myPaddingRowPanel;
    private JPanel myForegroundRowPanel;
    private ColorPanel myForegroundColorPanel;
    private JPanel myBackgroundRowPanel;
    private ColorPanel myBackgroundColorPanel;
    private JPanel myScalingRowPanel;
    private JPanel myShapeRowPanel;
    private JPanel myScalingRadioButtonsPanel;
    private JRadioButton myCropRadioButton;
    private JRadioButton myShrinkToFitRadioButton;
    private JPanel myEffectRadioButtonsPanel;
    private JRadioButton myNoEffectRadioButton;
    private JRadioButton myDogEarRadioButton;
    private JPanel myThemeRowPanel;
    private JComboBox<ActionBarIconGenerator.Theme> myThemeComboBox;
    private JPanel myEffectRowPanel;
    private JBScrollPane myScrollPane;
    private JComboBox<IconGenerator.Shape> myShapeComboBox;
    private JPanel myCustomThemeRowPanel;
    private ColorPanel myCustomThemeColorPanel;
    private JPanel myAssetPanels;
    private JPanel myImageAssetRowPanel;
    private JPanel myClipartAssetRowPanel;
    private JPanel myTextAssetRowPanel;
    private ImageAssetBrowser myImageAssetBrowser;
    private ClipartIconButton myClipartAssetButton;
    private MultiLineTextAssetEditor myTextAssetEditor;
    private JBLabel myOutputNameLabel;
    private JLabel myAssetTypeLabel;
    private JBLabel myImagePathLabel;
    private JBLabel myClipartLabel;
    private JBLabel myTextLabel;
    private JBLabel myTrimLabel;
    private JBLabel myPaddingLabel;
    private JBLabel myForegroundLabel;
    private JBLabel myThemeLabel;
    private JBLabel myCustomColorLabel;
    private JBLabel myBackgroundLabel;
    private JBLabel myScalingLabel;
    private JBLabel myShapeLabel;
    private JBLabel myEffectLabel;
    @NotNull
    private final List<ActionListener> myAssetListeners = new ArrayList<ActionListener>(1);
    @NotNull
    private final AndroidIconType myIconType;
    @NotNull
    private final IconGenerator myIconGenerator;
    @NotNull
    private final ValidatorPanel myValidatorPanel;
    @NotNull
    private final String myDefaultOutputName;
    @NotNull
    private final BindingsManager myGeneralBindings = new BindingsManager();
    @NotNull
    private final BindingsManager myActiveAssetBindings = new BindingsManager();
    @NotNull
    private final ListenerManager myListeners = new ListenerManager();
    @NotNull
    private final ImmutableMap<AssetType, AssetComponent<?>> myAssetPanelMap;
    @NotNull
    private final ObjectProperty<BaseAsset> myActiveAsset;
    @NotNull
    private final StringProperty myOutputName;
    @NotNull
    private final AbstractProperty<AssetType> myAssetType;
    private ColorProperty myForegroundColor;
    private AbstractProperty<Color> myBackgroundColor;
    private AbstractProperty<IconGenerator.Shape> myShape;
    private BoolProperty myCropped;
    private BoolProperty myDogEared;
    private AbstractProperty<ActionBarIconGenerator.Theme> myTheme;
    private AbstractProperty<Color> myThemeColor;

    public ConfigureIconPanel(@NotNull Disposable disposableParent, @NotNull AndroidFacet facet, @NotNull AndroidIconType iconType, int minSdkVersion2, @NotNull ValidatorPanel validatorPanel2, @Nullable DrawableRenderer renderer2) {
        super(new BorderLayout());
        this.setupUI();
        this.myIconType = iconType;
        this.myDefaultOutputName = this.myIconType.toOutputName("name");
        this.myIconGenerator = ConfigureIconPanel.createIconGenerator(facet.getModule().getProject(), iconType, minSdkVersion2, renderer2);
        this.myValidatorPanel = validatorPanel2;
        this.myTextAssetEditor.getAsset().setDefaultText("Aa");
        DefaultComboBoxModel<ActionBarIconGenerator.Theme> themesModel = new DefaultComboBoxModel<ActionBarIconGenerator.Theme>(ActionBarIconGenerator.Theme.values());
        this.myThemeComboBox.setModel(themesModel);
        DefaultComboBoxModel<IconGenerator.Shape> shapesModel = new DefaultComboBoxModel<IconGenerator.Shape>();
        for (IconGenerator.Shape shape : SHAPE_NAMES.keySet()) {
            shapesModel.addElement(shape);
        }
        this.myShapeComboBox.setRenderer((ListCellRenderer<IconGenerator.Shape>)SimpleListCellRenderer.create((String)"", SHAPE_NAMES::get));
        this.myShapeComboBox.setModel(shapesModel);
        this.myShapeComboBox.setSelectedItem((Object)IconGenerator.Shape.SQUARE);
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myOutputName = new TextProperty(this.myOutputNameTextField);
        this.myAssetPanelMap = ImmutableMap.of((Object)((Object)AssetType.IMAGE), (Object)this.myImageAssetBrowser, (Object)((Object)AssetType.CLIP_ART), (Object)this.myClipartAssetButton, (Object)((Object)AssetType.TEXT), (Object)this.myTextAssetEditor);
        this.myOutputNameLabel.setLabelFor((Component)this.myOutputNameTextField);
        this.myAssetTypeLabel.setLabelFor(this.myAssetRadioButtonsPanel);
        this.myImagePathLabel.setLabelFor((Component)((Object)this.myImageAssetBrowser));
        this.myClipartLabel.setLabelFor((Component)this.myClipartAssetButton);
        this.myTextLabel.setLabelFor((Component)this.myTextAssetEditor);
        this.myTrimLabel.setLabelFor((Component)this.myTrimOptionsPanel);
        this.myPaddingLabel.setLabelFor((Component)this.myPaddingSliderPanel);
        this.myForegroundLabel.setLabelFor((Component)this.myForegroundColorPanel);
        this.myThemeLabel.setLabelFor(this.myThemeComboBox);
        this.myCustomColorLabel.setLabelFor((Component)this.myCustomThemeColorPanel);
        this.myBackgroundLabel.setLabelFor((Component)this.myBackgroundColorPanel);
        this.myScalingLabel.setLabelFor((Component)this.myScalingRadioButtonsPanel);
        this.myShapeLabel.setLabelFor(this.myShapeComboBox);
        this.myEffectLabel.setLabelFor((Component)this.myEffectRadioButtonsPanel);
        ImageAsset clipartAsset = this.myClipartAssetButton.getAsset();
        this.myActiveAsset = new ObjectValueProperty<ImageAsset>(clipartAsset);
        this.myAssetType = new SelectedRadioButtonProperty<AssetType>(DEFAULT_ASSET_TYPE, (T[])AssetType.values(), this.myImageRadioButton, this.myClipartRadioButton, this.myTextRadioButton);
        this.initializeListenersAndBindings();
        this.initializeValidators();
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        for (AssetComponent assetComponent : this.myAssetPanelMap.values()) {
            Disposer.register((Disposable)this, (Disposable)assetComponent);
        }
        Disposer.register((Disposable)this, (Disposable)this.myIconGenerator);
        this.add(this.myRootPanel);
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state2 = new PersistentState();
        for (Map.Entry entry : this.myAssetPanelMap.entrySet()) {
            state2.setChild(AssetStudioUtils.toLowerCamelCase((Enum)entry.getKey()), ((BaseAsset)((AssetComponent)entry.getValue()).getAsset()).getState());
        }
        state2.set(OUTPUT_NAME_PROPERTY, (String)this.myOutputName.get(), this.myDefaultOutputName);
        state2.set(ASSET_TYPE_PROPERTY, (AssetType)((Object)this.myAssetType.get()), DEFAULT_ASSET_TYPE);
        File file = (File)this.myImageAssetBrowser.getAsset().imagePath().getValueOrNull();
        state2.set(IMAGE_ASSET_PROPERTY, file == null ? null : file.getPath());
        state2.setChild(CLIPART_ASSET_PROPERTY, this.myClipartAssetButton.getState());
        state2.setChild(TEXT_ASSET_PROPERTY, this.myTextAssetEditor.getAsset().getState());
        switch (this.myIconType) {
            case LAUNCHER_LEGACY: {
                state2.set(BACKGROUND_COLOR_PROPERTY, (Color)this.myBackgroundColor.get(), LauncherLegacyIconGenerator.DEFAULT_BACKGROUND_COLOR);
                state2.set(ICON_SHAPE_PROPERTY, (IconGenerator.Shape)((Object)this.myShape.get()), LauncherLegacyIconGenerator.DEFAULT_ICON_SHAPE);
                state2.set(CROPPED_PROPERTY, (Boolean)this.myCropped.get(), false);
                state2.set(DOG_EARED_PROPERTY, (Boolean)this.myDogEared.get(), false);
                break;
            }
            case ACTIONBAR: {
                state2.set(THEME_PROPERTY, (ActionBarIconGenerator.Theme)((Object)this.myTheme.get()), ActionBarIconGenerator.DEFAULT_THEME);
                state2.set(THEME_COLOR_PROPERTY, (Color)this.myThemeColor.get(), ActionBarIconGenerator.DEFAULT_CUSTOM_COLOR);
                break;
            }
        }
        return state2;
    }

    public void loadState(@NotNull PersistentState state2) {
        for (Map.Entry entry : this.myAssetPanelMap.entrySet()) {
            PersistentStateUtil.load(((AssetComponent)entry.getValue()).getAsset(), state2.getChild(AssetStudioUtils.toLowerCamelCase((Enum)entry.getKey())));
        }
        this.myOutputName.set(state2.get(OUTPUT_NAME_PROPERTY, this.myDefaultOutputName));
        this.myAssetType.set(state2.get(ASSET_TYPE_PROPERTY, DEFAULT_ASSET_TYPE));
        String path = state2.get(IMAGE_ASSET_PROPERTY);
        this.myImageAssetBrowser.getAsset().imagePath().setNullableValue(path == null ? null : new File(path));
        PersistentStateUtil.load(this.myClipartAssetButton, state2.getChild(CLIPART_ASSET_PROPERTY));
        PersistentStateUtil.load(this.myTextAssetEditor.getAsset(), state2.getChild(TEXT_ASSET_PROPERTY));
        switch (this.myIconType) {
            case LAUNCHER_LEGACY: {
                this.myBackgroundColor.set(state2.get(BACKGROUND_COLOR_PROPERTY, LauncherLegacyIconGenerator.DEFAULT_BACKGROUND_COLOR));
                this.myShape.set(state2.get(ICON_SHAPE_PROPERTY, LauncherLegacyIconGenerator.DEFAULT_ICON_SHAPE));
                this.myCropped.set(state2.get(CROPPED_PROPERTY, false));
                this.myDogEared.set(state2.get(DOG_EARED_PROPERTY, false));
                break;
            }
            case ACTIONBAR: {
                this.myTheme.set(state2.get(THEME_PROPERTY, ActionBarIconGenerator.DEFAULT_THEME));
                this.myThemeColor.set(state2.get(THEME_COLOR_PROPERTY, ActionBarIconGenerator.DEFAULT_CUSTOM_COLOR));
                break;
            }
        }
    }

    private void setupUI() {
        this.myRootPanel = new JPanel();
        this.myRootPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myScrollPane = new JBScrollPane();
        this.myScrollPane.setHorizontalScrollBarPolicy(31);
        this.myRootPanel.add((Component)this.myScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.myAllOptionsPanel = new JPanel();
        this.myAllOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myScrollPane.setViewportView((Component)this.myAllOptionsPanel);
        this.myAllOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20), null, 0, 0, null, null));
        this.mySourceAssetTypePanel = new JPanel();
        this.mySourceAssetTypePanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myAllOptionsPanel.add((Component)this.mySourceAssetTypePanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myAssetTypeLabel = new JLabel();
        this.myAssetTypeLabel.setText("Asset type:");
        this.mySourceAssetTypePanel.add((Component)this.myAssetTypeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myAssetRadioButtonsPanel = new JPanel();
        this.myAssetRadioButtonsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.mySourceAssetTypePanel.add((Component)this.myAssetRadioButtonsPanel, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null, 0, false));
        this.myClipartRadioButton = new JRadioButton();
        this.myClipartRadioButton.setText("Clip art");
        this.myClipartRadioButton.setToolTipText("Select from a list of clipart choices to generate Android icons for your app.");
        this.myAssetRadioButtonsPanel.add((Component)this.myClipartRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myTextRadioButton = new JRadioButton();
        this.myTextRadioButton.setText("Text");
        this.myTextRadioButton.setToolTipText("Enter text which will be rendered into Android icons for your app.");
        this.myAssetRadioButtonsPanel.add((Component)this.myTextRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myImageRadioButton = new JRadioButton();
        this.myImageRadioButton.setText("Image");
        this.myImageRadioButton.setToolTipText("Select an image, e.g. PNG, SVG, PSD, or a drawable from disk to generate Android icons for your app.");
        this.myAssetRadioButtonsPanel.add((Component)this.myImageRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myIconOptionsPanel = new JPanel();
        this.myIconOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myAllOptionsPanel.add((Component)this.myIconOptionsPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myTrimRowPanel = new JPanel();
        this.myTrimRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myTrimRowPanel.setVisible(true);
        this.myIconOptionsPanel.add((Component)this.myTrimRowPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myTrimLabel = new JBLabel();
        this.myTrimLabel.setText("Trim:");
        this.myTrimRowPanel.add((Component)this.myTrimLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myTrimOptionsPanel = new JPanel();
        this.myTrimOptionsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myTrimRowPanel.add((Component)this.myTrimOptionsPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myTrimOptionsPanel.add((Component)spacer1, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myTrimmedRadioButton = new JRadioButton();
        this.myTrimmedRadioButton.setText("Yes");
        this.myTrimmedRadioButton.setToolTipText("Remove any transparent space from around your source asset before rendering to icon.");
        this.myTrimOptionsPanel.add((Component)this.myTrimmedRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myNotTrimmedRadioButton = new JRadioButton();
        this.myNotTrimmedRadioButton.setSelected(true);
        this.myNotTrimmedRadioButton.setText("No");
        this.myNotTrimmedRadioButton.setToolTipText("Leave the original asset unmodified.");
        this.myTrimOptionsPanel.add((Component)this.myNotTrimmedRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myPaddingRowPanel = new JPanel();
        this.myPaddingRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myPaddingRowPanel.setVisible(true);
        this.myIconOptionsPanel.add((Component)this.myPaddingRowPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myPaddingLabel = new JBLabel();
        this.myPaddingLabel.setText("Padding:");
        this.myPaddingRowPanel.add((Component)this.myPaddingLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myPaddingSliderPanel = new JPanel();
        this.myPaddingSliderPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myPaddingRowPanel.add((Component)this.myPaddingSliderPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myPaddingSlider = new JSlider();
        this.myPaddingSlider.setMaximum(50);
        this.myPaddingSlider.setMinimum(-10);
        this.myPaddingSlider.setMinorTickSpacing(5);
        this.myPaddingSlider.setPaintLabels(false);
        this.myPaddingSlider.setPaintTicks(true);
        this.myPaddingSlider.setSnapToTicks(true);
        this.myPaddingSlider.setToolTipText("Add a percentage of padding around the original asset before rendering. This happens after any trimming.");
        this.myPaddingSlider.setValue(0);
        this.myPaddingSliderPanel.add((Component)this.myPaddingSlider, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        this.myPaddingValueTextField = new JTextField();
        this.myPaddingValueTextField.setHorizontalAlignment(4);
        this.myPaddingValueTextField.setText("100");
        this.myPaddingSliderPanel.add((Component)this.myPaddingValueTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(30, -1), null, 0, false));
        this.myPaddingValueLabel = new JLabel();
        this.myPaddingValueLabel.setHorizontalAlignment(4);
        this.myPaddingValueLabel.setText("%");
        this.myPaddingSliderPanel.add((Component)this.myPaddingValueLabel, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, new Dimension(-1, -1), null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myPaddingSliderPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myForegroundRowPanel = new JPanel();
        this.myForegroundRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myIconOptionsPanel.add((Component)this.myForegroundRowPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myForegroundLabel = new JBLabel();
        this.myForegroundLabel.setText("Foreground:");
        this.myForegroundRowPanel.add((Component)this.myForegroundLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myForegroundColorPanel = new ColorPanel();
        this.myForegroundColorPanel.setSelectedColor(new Color(-16777216));
        this.myForegroundRowPanel.add((Component)this.myForegroundColorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(78, -1), null, null, 0, false));
        this.myBackgroundRowPanel = new JPanel();
        this.myBackgroundRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myIconOptionsPanel.add((Component)this.myBackgroundRowPanel, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBackgroundLabel = new JBLabel();
        this.myBackgroundLabel.setText("Background:");
        this.myBackgroundRowPanel.add((Component)this.myBackgroundLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myBackgroundColorPanel = new ColorPanel();
        this.myBackgroundColorPanel.setSelectedColor(new Color(-1));
        this.myBackgroundRowPanel.add((Component)this.myBackgroundColorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, new Dimension(78, -1), null, null, 0, false));
        this.myScalingRowPanel = new JPanel();
        this.myScalingRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myIconOptionsPanel.add((Component)this.myScalingRowPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myScalingLabel = new JBLabel();
        this.myScalingLabel.setText("Scaling:");
        this.myScalingRowPanel.add((Component)this.myScalingLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myScalingRadioButtonsPanel = new JPanel();
        this.myScalingRadioButtonsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myScalingRowPanel.add((Component)this.myScalingRadioButtonsPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myCropRadioButton = new JRadioButton();
        this.myCropRadioButton.setText("Crop");
        this.myCropRadioButton.setToolTipText("Crop source asset to fit icon size.");
        this.myScalingRadioButtonsPanel.add((Component)this.myCropRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myShrinkToFitRadioButton = new JRadioButton();
        this.myShrinkToFitRadioButton.setSelected(true);
        this.myShrinkToFitRadioButton.setText("Shrink to fit");
        this.myShrinkToFitRadioButton.setToolTipText("Shrink the source asset to fit icon size.");
        this.myScalingRadioButtonsPanel.add((Component)this.myShrinkToFitRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        this.myScalingRadioButtonsPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myShapeRowPanel = new JPanel();
        this.myShapeRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myIconOptionsPanel.add((Component)this.myShapeRowPanel, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myShapeLabel = new JBLabel();
        this.myShapeLabel.setText("Shape:");
        this.myShapeRowPanel.add((Component)this.myShapeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myShapeRowPanel.add((Component)panel1, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myShapeComboBox = new JComboBox();
        this.myShapeComboBox.setToolTipText("The shape of the launcher icon's backdrop.");
        panel1.add(this.myShapeComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        Spacer spacer4 = new Spacer();
        panel1.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myEffectRowPanel = new JPanel();
        this.myEffectRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myIconOptionsPanel.add((Component)this.myEffectRowPanel, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myEffectLabel = new JBLabel();
        this.myEffectLabel.setText("Effect:");
        this.myEffectRowPanel.add((Component)this.myEffectLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myEffectRadioButtonsPanel = new JPanel();
        this.myEffectRadioButtonsPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.myEffectRowPanel.add((Component)this.myEffectRadioButtonsPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myNoEffectRadioButton = new JRadioButton();
        this.myNoEffectRadioButton.setSelected(true);
        this.myNoEffectRadioButton.setText("None");
        this.myNoEffectRadioButton.setToolTipText("Do not apply any transformative effects to the icon.");
        this.myEffectRadioButtonsPanel.add((Component)this.myNoEffectRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.myDogEarRadioButton = new JRadioButton();
        this.myDogEarRadioButton.setText("DogEar");
        this.myDogEarRadioButton.setToolTipText("Add a fold to the top right of the icon's backdrop shape (if supported).");
        this.myEffectRadioButtonsPanel.add((Component)this.myDogEarRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer5 = new Spacer();
        this.myEffectRadioButtonsPanel.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myThemeRowPanel = new JPanel();
        this.myThemeRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myIconOptionsPanel.add((Component)this.myThemeRowPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myThemeLabel = new JBLabel();
        this.myThemeLabel.setText("Theme:");
        this.myThemeRowPanel.add((Component)this.myThemeLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myThemeRowPanel.add((Component)panel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myThemeComboBox = new JComboBox();
        panel2.add(this.myThemeComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer6 = new Spacer();
        panel2.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myCustomThemeRowPanel = new JPanel();
        this.myCustomThemeRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myIconOptionsPanel.add((Component)this.myCustomThemeRowPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myCustomColorLabel = new JBLabel();
        this.myCustomColorLabel.setText("Custom color:");
        this.myCustomThemeRowPanel.add((Component)this.myCustomColorLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myCustomThemeColorPanel = new ColorPanel();
        this.myCustomThemeColorPanel.setSelectedColor(new Color(-1));
        this.myCustomThemeRowPanel.add((Component)this.myCustomThemeColorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 5, 3, new Dimension(78, -1), null, null, 0, false));
        Spacer spacer7 = new Spacer();
        this.myAllOptionsPanel.add((Component)spacer7, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 4, null, null, null, 0, false));
        this.myAssetPanels = new JPanel();
        this.myAssetPanels.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myAllOptionsPanel.add((Component)this.myAssetPanels, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myImageAssetRowPanel = new JPanel();
        this.myImageAssetRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myAssetPanels.add((Component)this.myImageAssetRowPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myImagePathLabel = new JBLabel();
        this.myImagePathLabel.setText("Path:");
        this.myImageAssetRowPanel.add((Component)this.myImagePathLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myImageAssetBrowser = new ImageAssetBrowser();
        this.myImageAssetRowPanel.add((Component)((Object)this.myImageAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.myClipartAssetRowPanel = new JPanel();
        this.myClipartAssetRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myAssetPanels.add((Component)this.myClipartAssetRowPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myClipartLabel = new JBLabel();
        this.myClipartLabel.setText("Clip art:");
        this.myClipartAssetRowPanel.add((Component)this.myClipartLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myClipartAssetButton = new ClipartIconButton();
        this.myClipartAssetRowPanel.add((Component)this.myClipartAssetButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.myTextAssetRowPanel = new JPanel();
        this.myTextAssetRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myAssetPanels.add((Component)this.myTextAssetRowPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myTextLabel = new JBLabel();
        this.myTextLabel.setText("Text:");
        this.myTextAssetRowPanel.add((Component)this.myTextLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myTextAssetEditor = new MultiLineTextAssetEditor();
        this.myTextAssetRowPanel.add((Component)this.myTextAssetEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.myNameRowPanel = new JPanel();
        this.myNameRowPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myNameRowPanel.setVisible(true);
        this.myAllOptionsPanel.add((Component)this.myNameRowPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 5, 3, null, null, null, 0, true));
        this.myOutputNameLabel = new JBLabel();
        this.myOutputNameLabel.setText("Name:");
        this.myNameRowPanel.add((Component)this.myOutputNameLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myOutputNamePanel = new JPanel();
        this.myOutputNamePanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myNameRowPanel.add((Component)this.myOutputNamePanel, new GridConstraints(0, 1, 1, 1, 0, 3, 5, 3, null, null, null, 0, false));
        this.myOutputNameTextField = new JTextField();
        this.myOutputNameTextField.setText("(name)");
        this.myOutputNameTextField.setToolTipText("The filename which will be used for these icons.");
        this.myOutputNamePanel.add((Component)this.myOutputNameTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myImageRadioButton);
        buttonGroup.add(this.myClipartRadioButton);
        buttonGroup.add(this.myTextRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myNotTrimmedRadioButton);
        buttonGroup.add(this.myNotTrimmedRadioButton);
        buttonGroup.add(this.myTrimmedRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myShrinkToFitRadioButton);
        buttonGroup.add(this.myCropRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myDogEarRadioButton);
        buttonGroup.add(this.myNoEffectRadioButton);
    }

    @NotNull
    private static IconGenerator createIconGenerator(@NotNull Project project, @NotNull AndroidIconType iconType, int minSdkVersion2, @Nullable DrawableRenderer renderer2) {
        switch (iconType) {
            case LAUNCHER_LEGACY: {
                return new LauncherLegacyIconGenerator(project, minSdkVersion2, renderer2);
            }
            case ACTIONBAR: {
                return new ActionBarIconGenerator(project, minSdkVersion2, renderer2);
            }
            case NOTIFICATION: {
                return new NotificationIconGenerator(project, minSdkVersion2, renderer2);
            }
        }
        throw new IllegalArgumentException("Unexpected icon type: " + iconType);
    }

    private void initializeListenersAndBindings() {
        IntProperty paddingPercent = SliderUtils.bindTwoWay(this.myGeneralBindings, this.myPaddingSlider, this.myPaddingValueTextField);
        this.myForegroundColor = new ColorProperty(this.myForegroundColorPanel);
        this.myBackgroundColor = ObjectProperty.wrap(new ColorProperty(this.myBackgroundColorPanel));
        this.myCropped = new SelectedProperty(this.myCropRadioButton);
        this.myDogEared = new SelectedProperty(this.myDogEarRadioButton);
        this.myTheme = ObjectProperty.wrap(new SelectedItemProperty(this.myThemeComboBox));
        this.myThemeColor = ObjectProperty.wrap(new ColorProperty(this.myCustomThemeColorPanel));
        this.myShape = ObjectProperty.wrap(new SelectedItemProperty(this.myShapeComboBox));
        this.initializeBindingsAndUiForIconType();
        this.myAssetType.addListener(() -> {
            AssetComponent assetComponent = (AssetComponent)this.myAssetPanelMap.get(this.myAssetType.get());
            this.myActiveAsset.set((BaseAsset)assetComponent.getAsset());
        });
        ActionListener assetPanelListener = e -> this.fireAssetListeners();
        for (AssetComponent assetComponent : this.myAssetPanelMap.values()) {
            assetComponent.addAssetListener(assetPanelListener);
        }
        SelectedProperty trimmed = new SelectedProperty(this.myTrimmedRadioButton);
        Runnable onAssetModified = this::fireAssetListeners;
        this.myListeners.listenAll(this.myAssetType, trimmed, paddingPercent, this.myForegroundColor, this.myBackgroundColor, this.myCropped, this.myDogEared, this.myTheme, this.myThemeColor, this.myShape).with(onAssetModified);
        this.myListeners.listenAndFire(this.myActiveAsset, () -> {
            this.myActiveAssetBindings.releaseAll();
            BaseAsset asset = (BaseAsset)this.myActiveAsset.get();
            this.myActiveAssetBindings.bindTwoWay(trimmed, asset.trimmed());
            this.myActiveAssetBindings.bindTwoWay(paddingPercent, asset.paddingPercent());
            OptionalValueProperty<Color> assetColor = asset.color();
            if (assetColor.getValueOrNull() == null) {
                assetColor.setNullableValue((Color)this.myForegroundColor.getValueOrNull());
            }
            this.myActiveAssetBindings.bindTwoWay(this.myForegroundColor, assetColor);
            this.getIconGenerator().sourceAsset().setValue(asset);
            onAssetModified.run();
        });
        BoolValueProperty isLauncherIcon = new BoolValueProperty(this.myIconType == AndroidIconType.LAUNCHER_LEGACY);
        BoolValueProperty isActionBarIcon = new BoolValueProperty(this.myIconType == AndroidIconType.ACTIONBAR);
        ObservableBool isCustomTheme = this.myTheme.isEqualTo(ActionBarIconGenerator.Theme.CUSTOM);
        Expression<Boolean> isClipartOrText = this.myActiveAsset.transform(asset -> this.myClipartAssetButton.getAsset() == asset || this.myTextAssetEditor.getAsset() == asset);
        BooleanExpression supportsEffects = new BooleanExpression(new ObservableValue[]{this.myShape}){

            @Override
            @NotNull
            public Boolean get() {
                IconGenerator.Shape shape = (IconGenerator.Shape)((Object)ConfigureIconPanel.this.myShape.get());
                switch (shape) {
                    case SQUARE: 
                    case VRECT: 
                    case HRECT: {
                        return true;
                    }
                }
                return false;
            }
        };
        ImmutableMap.Builder layoutPropertiesBuilder = ImmutableMap.builder();
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myImageAssetRowPanel), (Object)new SelectedProperty(this.myImageRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myClipartAssetRowPanel), (Object)new SelectedProperty(this.myClipartRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myTextAssetRowPanel), (Object)new SelectedProperty(this.myTextRadioButton));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myForegroundRowPanel), (Object)isLauncherIcon.and(isClipartOrText));
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myBackgroundRowPanel), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myScalingRowPanel), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myShapeRowPanel), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myEffectRowPanel), (Object)isLauncherIcon);
        layoutPropertiesBuilder.put((Object)new EnabledProperty(this.myDogEarRadioButton), (Object)supportsEffects);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myThemeRowPanel), (Object)isActionBarIcon);
        layoutPropertiesBuilder.put((Object)new VisibleProperty(this.myCustomThemeRowPanel), (Object)isActionBarIcon.and(isCustomTheme));
        ImmutableMap layoutProperties = layoutPropertiesBuilder.build();
        for (Map.Entry e2 : layoutProperties.entrySet()) {
            ((BoolProperty)e2.getKey()).set(false);
            this.myGeneralBindings.bind((SettableValue)e2.getKey(), (ObservableValue)e2.getValue());
        }
        this.myListeners.listenAll((Collection<? extends ObservableValue<?>>)layoutProperties.keySet()).with(() -> SwingUtilities.updateComponentTreeUI(this.myAllOptionsPanel));
    }

    private void initializeValidators() {
        this.myValidatorPanel.registerValidator((ObservableValue)new TextProperty(this.myPaddingValueTextField), SliderUtils.inRange(this.myPaddingSlider, "Padding scale"), new ObservableValue[0]);
    }

    @NotNull
    public BaseAsset getAsset() {
        return (BaseAsset)this.myActiveAsset.get();
    }

    @Override
    @NotNull
    public IconGenerator getIconGenerator() {
        return this.myIconGenerator;
    }

    @Override
    @NotNull
    public JComponent getRootComponent() {
        return this;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener2) {
        this.myAssetListeners.add(listener2);
    }

    @Override
    @NotNull
    public StringProperty outputName() {
        return this.myOutputName;
    }

    private void fireAssetListeners() {
        ActionEvent event = new ActionEvent(this, 1001, null);
        for (ActionListener assetListener : this.myAssetListeners) {
            assetListener.actionPerformed(event);
        }
    }

    private void initializeBindingsAndUiForIconType() {
        this.myOutputName.set(this.myDefaultOutputName);
        this.myGeneralBindings.bind(this.myIconGenerator.sourceAsset(), new AsOptionalExpression<BaseAsset>((ObservableValue<BaseAsset>)this.myActiveAsset));
        this.myGeneralBindings.bind(this.myIconGenerator.outputName(), this.myOutputName);
        switch (this.myIconType) {
            case LAUNCHER_LEGACY: {
                LauncherLegacyIconGenerator launcherIconGenerator = (LauncherLegacyIconGenerator)this.myIconGenerator;
                this.myGeneralBindings.bindTwoWay(launcherIconGenerator.backgroundColor(), this.myBackgroundColor);
                this.myGeneralBindings.bindTwoWay(launcherIconGenerator.cropped(), this.myCropped);
                this.myGeneralBindings.bindTwoWay(launcherIconGenerator.shape(), this.myShape);
                this.myGeneralBindings.bindTwoWay(launcherIconGenerator.dogEared(), this.myDogEared);
                break;
            }
            case ACTIONBAR: {
                ActionBarIconGenerator actionBarIconGenerator = (ActionBarIconGenerator)this.myIconGenerator;
                this.myGeneralBindings.bindTwoWay(actionBarIconGenerator.customColor(), this.myThemeColor);
                this.myGeneralBindings.bindTwoWay(actionBarIconGenerator.theme(), this.myTheme);
                break;
            }
            case NOTIFICATION: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected icon type: " + this.myIconType);
            }
        }
    }

    public void dispose() {
        this.myGeneralBindings.releaseAll();
        this.myActiveAssetBindings.releaseAll();
        this.myListeners.releaseAll();
        this.myAssetListeners.clear();
    }

    private static enum AssetType {
        IMAGE,
        CLIP_ART,
        TEXT;

    }
}

