/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.other;

import com.android.tools.idea.navigator.nodes.AndroidViewModuleNode;
import com.android.tools.idea.navigator.nodes.AndroidViewTypeSortWeight;
import com.android.tools.idea.navigator.nodes.ModuleNodeUtils;
import com.android.tools.idea.navigator.nodes.android.AndroidBuildScriptNode;
import com.android.tools.idea.navigator.nodes.other.NonAndroidSourceType;
import com.android.tools.idea.navigator.nodes.other.NonAndroidSourceTypeNode;
import com.android.tools.idea.projectsystem.BuildConfigurationSourceProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.collect.Sets;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonAndroidModuleNode
extends AndroidViewModuleNode {
    public NonAndroidModuleNode(@NotNull Project project, @NotNull Module value2, @NotNull ViewSettings settings) {
        super(project, value2, settings);
    }

    @Override
    @NotNull
    protected Collection<AbstractTreeNode<?>> getModuleChildren() {
        Module module = this.getModule();
        Set<NonAndroidSourceType> sourceTypes = NonAndroidModuleNode.getNonEmptySourceTypes(module);
        ArrayList nodes = new ArrayList(sourceTypes.size());
        assert (this.myProject != null);
        for (NonAndroidSourceType type : sourceTypes) {
            nodes.add((AbstractTreeNode<?>)new NonAndroidSourceTypeNode(this.myProject, module, this.getSettings(), type));
        }
        if (ModuleNodeUtils.showBuildFilesInModule()) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            BuildConfigurationSourceProvider buildProvider = ProjectSystemUtil.getProjectSystem(this.myProject).getBuildConfigurationSourceProvider();
            if (buildProvider != null) {
                @NotNull List<BuildConfigurationSourceProvider.ConfigurationFile> allBuildFiles = buildProvider.getBuildConfigurationFiles();
                for (BuildConfigurationSourceProvider.ConfigurationFile file : allBuildFiles) {
                    PsiFile psiFile;
                    if (!ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)file.getFile(), (boolean)true) && !ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)file.getFile(), (boolean)false) || (psiFile = psiManager.findFile(file.getFile())) == null || ModuleNodeUtils.showInProjectBuildScriptsGroup(psiFile)) continue;
                    String qualifier = file.getDisplayName();
                    if (file.getFile().getFileType() == FileTypeRegistry.getInstance().findFileTypeByName("Shrinker Config File") || Objects.equals(file.getFile().getExtension(), "gradle")) {
                        qualifier = null;
                    }
                    nodes.add((AbstractTreeNode<?>)new AndroidBuildScriptNode(this.myProject, psiFile, this.getSettings(), qualifier, file.getGroupOrder()));
                }
            }
        }
        return nodes;
    }

    @NotNull
    private static Set<NonAndroidSourceType> getNonEmptySourceTypes(@NotNull Module module) {
        ContentEntry[] contentEntries;
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        HashSet sourceTypes = Sets.newHashSetWithExpectedSize((int)NonAndroidSourceType.values().length);
        for (ContentEntry entry : contentEntries = rootManager.getContentEntries()) {
            block1: for (NonAndroidSourceType type : NonAndroidSourceType.values()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders(type.rootType)) {
                    if (sourceFolder.getFile() == null) continue;
                    sourceTypes.add(type);
                    continue block1;
                }
            }
        }
        return sourceTypes;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getModule().getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    public int getTypeSortWeight(boolean sortByType) {
        return AndroidViewTypeSortWeight.PACKAGE.getWeight();
    }

    @Override
    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return String.format("%1$s (non-Android)", super.toTestString(printInfo));
    }

    @NotNull
    private Module getModule() {
        Module module = (Module)this.getValue();
        assert (module != null);
        return module;
    }
}

