/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.PresentationDataWrapper;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNodes;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingViewNode
extends IncludeViewNode<PackageValue> {
    protected PackagingViewNode(@NotNull Collection<File> includeFolders, @Nullable Project project, @NotNull PackageValue dependency, @NotNull ViewSettings viewSettings, boolean showPackageType) {
        super(dependency, includeFolders, showPackageType, project, viewSettings);
    }

    @NotNull
    private PackageValue getPackageValue() {
        PackageValue value2 = (PackageValue)this.getValue();
        assert (value2 != null);
        return value2;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode<?>> getChildren() {
        Project project = this.getProject();
        if (project == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<File> folders = new ArrayList<File>();
        ArrayList<SimpleIncludeValue> result2 = new ArrayList<SimpleIncludeValue>();
        PackageValue value2 = this.getPackageValue();
        for (File folder : this.myIncludeFolders) {
            for (SimpleIncludeValue simpleIncludeValue : value2.getIncludes()) {
                if (!FileUtil.filesEqual((File)simpleIncludeValue.getIncludeFolder(), (File)folder)) continue;
                result2.add(simpleIncludeValue);
            }
        }
        for (SimpleIncludeValue child : result2) {
            folders.add(child.getIncludeFolder());
        }
        return IncludeViewNodes.getIncludeFolderNodesWithShadowing(folders, (ImmutableList<VirtualFile>)ImmutableList.of(), true, project, this.getSettings());
    }

    @Override
    protected void writeDescription(@NotNull PresentationDataWrapper presentation) {
        presentation.setIcon(AllIcons.Nodes.Module);
        PackageValue value2 = this.getPackageValue();
        presentation.addText(value2.getSimplePackageName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myShowPackageType) {
            presentation.addText(String.format(" (%s, ", this.getPackageValue().getPackageType().myDescription), SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            presentation.addText(" (", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.addText(String.format("%s)", this.getPackageValue().getDescriptiveText()), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (!LexicalIncludePaths.hasHeaderExtension(file.getName())) {
            return false;
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        PackageValue value2 = this.getPackageValue();
        for (SimpleIncludeValue include2 : value2.getIncludes()) {
            VirtualFile ancestor = fileSystem.findFileByIoFile(include2.getIncludeFolder());
            if (ancestor == null || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

