/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.backup;

import com.android.tools.idea.navigator.nodes.backup.BackupDirectoryNode;
import com.android.tools.idea.navigator.nodes.backup.BackupFileNode;
import com.android.tools.idea.navigator.nodes.backup.DirectoryNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0012\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u0014H\u0016J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u0003*\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0002R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/navigator/nodes/backup/BackupGroupNode;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "", "Lcom/android/tools/idea/navigator/nodes/backup/DirectoryNode;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/projectView/ViewSettings;)V", "children", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "addChild", "", "node", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "getChildren", "", "contains", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "canRepresent", "element", "", "getOrCreateDirectoryNode", "", "pathString", "intellij.android.navigator"})
@SourceDebugExtension(value={"SMAP\nBackupGroupNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupGroupNode.kt\ncom/android/tools/idea/navigator/nodes/backup/BackupGroupNode\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,93:1\n381#2,7:94\n*S KotlinDebug\n*F\n+ 1 BackupGroupNode.kt\ncom/android/tools/idea/navigator/nodes/backup/BackupGroupNode\n*L\n85#1:94,7\n*E\n"})
public final class BackupGroupNode
extends ProjectViewNode<String>
implements DirectoryNode {
    @NotNull
    private final List<AbstractTreeNode<?>> children;

    public BackupGroupNode(@NotNull Project project, @NotNull ViewSettings settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(project, (Object)"/", settings);
        this.children = new ArrayList();
    }

    @Override
    public void addChild(@NotNull AbstractTreeNode<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        this.children.add(node);
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setPresentableText("Backup Files");
        presentation.setIcon(AllIcons.Actions.Upload);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        Map dirs = new LinkedHashMap();
        dirs.clear();
        this.children.clear();
        ProjectFileIndex.getInstance((Project)this.getProject()).iterateContent(arg_0 -> BackupGroupNode.getChildren$lambda$0(this, dirs, arg_0), BackupGroupNode::getChildren$lambda$1);
        return (Collection)ExtensionsKt.toImmutableList((Iterable)this.children);
    }

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    public boolean canRepresent(@NotNull Object element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VirtualFile virtualFile = element instanceof VirtualFile ? (VirtualFile)element : null;
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        if (!file.isDirectory()) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex index = projectFileIndex;
        return !index.isInProjectOrExcluded(file) ? false : (!index.isInContent(file) ? false : (index.isInSource(file) ? false : !index.isInLibrary(file)));
    }

    /*
     * WARNING - void declaration
     */
    private final DirectoryNode getOrCreateDirectoryNode(Map<String, DirectoryNode> $this$getOrCreateDirectoryNode, String pathString) {
        Object object;
        void $this$getOrPut$iv;
        if (((CharSequence)pathString).length() == 0 || Intrinsics.areEqual((Object)pathString, (Object)File.Companion.getSeparator())) {
            return this;
        }
        Map<String, DirectoryNode> map2 = $this$getOrCreateDirectoryNode;
        String key$iv = pathString;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Path path = Path.of(pathString, new String[0]);
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Intrinsics.checkNotNull((Object)path);
            String string = PathsKt.getName((Path)path);
            ViewSettings viewSettings = this.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)viewSettings, (String)"getSettings(...)");
            BackupDirectoryNode dir = new BackupDirectoryNode(project, string, viewSettings);
            Path path2 = path.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            this.getOrCreateDirectoryNode($this$getOrCreateDirectoryNode, ((Object)path2).toString()).addChild((AbstractTreeNode)dir);
            DirectoryNode answer$iv = dir;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (DirectoryNode)object;
    }

    private static final boolean getChildren$lambda$0(BackupGroupNode this$0, Map $dirs, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getParent().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String string2 = this$0.getProject().getBasePath();
        if (string2 == null) {
            string2 = "";
        }
        String parent = StringsKt.removePrefix((String)string, (CharSequence)string2);
        DirectoryNode directoryNode = this$0.getOrCreateDirectoryNode($dirs, parent);
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ViewSettings viewSettings = this$0.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)viewSettings, (String)"getSettings(...)");
        directoryNode.addChild((AbstractTreeNode)new BackupFileNode(project, it, viewSettings));
        return true;
    }

    private static final boolean getChildren$lambda$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getExtension(), (Object)"backup");
    }
}

