/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.memorysettings;

import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.gradle.util.GradleProperties;
import com.android.tools.idea.memorysettings.GradlePropertiesUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class GradleUserProperties {
    private static final Logger LOG = Logger.getInstance(GradleUserProperties.class);
    private GradleProperties gradleUserHomeProperties;
    private File propertiesPath;
    private int gradleXmx = -1;
    private int kotlinXmx = -1;

    GradleUserProperties(Project project) {
        this.gradleUserHomeProperties = GradleUserProperties.getProperties(project);
        if (GradlePropertiesUtil.hasJvmArgs(this.gradleUserHomeProperties)) {
            this.propertiesPath = this.gradleUserHomeProperties.getPath();
            this.findGradleDaemonXmx(this.gradleUserHomeProperties);
            this.findKotlinDaemonXmx(this.gradleUserHomeProperties);
        }
    }

    File getPropertiesPath() {
        return this.propertiesPath;
    }

    int getGradleXmx() {
        return this.gradleXmx;
    }

    int getKotlinXmx() {
        return this.kotlinXmx;
    }

    private void findGradleDaemonXmx(GradleProperties properties) {
        int xmx = GradlePropertiesUtil.getGradleDaemonXmx(properties);
        if (xmx > 0) {
            this.gradleXmx = xmx;
            return;
        }
    }

    private void findKotlinDaemonXmx(GradleProperties properties) {
        int xmx = GradlePropertiesUtil.getKotlinDaemonXmx(properties);
        if (xmx > 0) {
            this.kotlinXmx = xmx;
            return;
        }
        xmx = GradlePropertiesUtil.getGradleDaemonXmx(properties);
        if (xmx > 0) {
            this.kotlinXmx = xmx;
            return;
        }
    }

    @Nullable
    private static GradleProperties getProperties(Project project) {
        File file = GradleProjectSystemUtil.getUserGradlePropertiesFile(project);
        try {
            if (file.exists()) {
                return new GradleProperties(file);
            }
            return null;
        }
        catch (IOException e) {
            LOG.info("Failed to read " + file, (Throwable)e);
            return null;
        }
    }
}

