/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.material.icons.metadata;

import com.android.tools.idea.material.icons.metadata.MaterialIconsMetadata;
import com.android.tools.idea.material.icons.metadata.MaterialMetadataIcon;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\n\u001a\u0004\u0018\u00010\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/material/icons/metadata/MetadataDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/android/tools/idea/material/icons/metadata/MaterialIconsMetadata;", "<init>", "()V", "hostKey", "", "urlPatternKey", "familiesKey", "iconsKey", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "intellij.android.android-material"})
final class MetadataDeserializer
implements JsonDeserializer<MaterialIconsMetadata> {
    @NotNull
    private final String hostKey;
    @NotNull
    private final String urlPatternKey;
    @NotNull
    private final String familiesKey;
    @NotNull
    private final String iconsKey;

    public MetadataDeserializer() {
        this.hostKey = "host";
        this.urlPatternKey = "asset_url_pattern";
        this.familiesKey = "families";
        this.iconsKey = "icons";
    }

    @Nullable
    public MaterialIconsMetadata deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
        if (json == null || typeOfT == null || context == null) {
            return null;
        }
        JsonObject jsonObject = json.getAsJsonObject();
        String host = jsonObject.get(this.hostKey).getAsString();
        String urlPattern = jsonObject.get(this.urlPatternKey).getAsString();
        String[] families = (String[])context.deserialize(jsonObject.get(this.familiesKey), (Type)((Object)String[].class));
        MaterialMetadataIcon[] icons = (MaterialMetadataIcon[])context.deserialize(jsonObject.get(this.iconsKey), (Type)((Object)MaterialMetadataIcon[].class));
        Intrinsics.checkNotNull((Object)host);
        Intrinsics.checkNotNull((Object)urlPattern);
        Intrinsics.checkNotNull((Object)families);
        Intrinsics.checkNotNull((Object)icons);
        return new MaterialIconsMetadata(host, urlPattern, families, icons);
    }
}

