/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.service;

import com.android.adblib.ShellV2Collector;
import com.android.logcat.proto.LogcatEntryProto;
import com.android.logcat.proto.LogcatPriorityProto;
import com.android.processmonitor.monitor.ProcessNameMonitor;
import com.android.processmonitor.monitor.ProcessNames;
import com.android.tools.idea.logcat.message.LogLevel;
import com.android.tools.idea.logcat.message.LogcatHeader;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.service.LogcatProtoShellCollectorKt;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J*\u0010\u0011\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J*\u0010\u0015\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J*\u0010\u0017\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\f\u0010\u001e\u001a\u00020\u0019*\u00020\u000bH\u0002J\f\u0010\u001f\u001a\u00020\u0003*\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/logcat/service/LogcatProtoShellCollector;", "Lcom/android/adblib/ShellV2Collector;", "", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "serialNumber", "", "processNameMonitor", "Lcom/android/processmonitor/monitor/ProcessNameMonitor;", "<init>", "(Ljava/lang/String;Lcom/android/processmonitor/monitor/ProcessNameMonitor;)V", "leftoverBytes", "", "start", "", "collector", "Lkotlinx/coroutines/flow/FlowCollector;", "(Lkotlinx/coroutines/flow/FlowCollector;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectStdout", "stdout", "Ljava/nio/ByteBuffer;", "(Lkotlinx/coroutines/flow/FlowCollector;Ljava/nio/ByteBuffer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectStderr", "stderr", "end", "exitCode", "", "(Lkotlinx/coroutines/flow/FlowCollector;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFirstLogMessage", "buffer", "getLogcatMessage", "getSize", "toLogcatMessage", "Lcom/android/logcat/proto/LogcatEntryProto;", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nLogcatProtoShellCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogcatProtoShellCollector.kt\ncom/android/tools/idea/logcat/service/LogcatProtoShellCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1#2:241\n*E\n"})
public final class LogcatProtoShellCollector
implements ShellV2Collector<List<? extends LogcatMessage>> {
    @NotNull
    private final String serialNumber;
    @NotNull
    private final ProcessNameMonitor processNameMonitor;
    @NotNull
    private byte[] leftoverBytes;

    public LogcatProtoShellCollector(@NotNull String serialNumber, @NotNull ProcessNameMonitor processNameMonitor) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        Intrinsics.checkNotNullParameter((Object)processNameMonitor, (String)"processNameMonitor");
        this.serialNumber = serialNumber;
        this.processNameMonitor = processNameMonitor;
        this.leftoverBytes = new byte[0];
    }

    @Nullable
    public Object start(@NotNull FlowCollector<? super List<LogcatMessage>> collector, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Nullable
    public Object collectStdout(@NotNull FlowCollector<? super List<LogcatMessage>> collector, @NotNull ByteBuffer stdout, @NotNull Continuation<? super Unit> $completion) {
        stdout.order(ByteOrder.LITTLE_ENDIAN);
        List messages = new ArrayList();
        LogcatMessage logcatMessage = this.getFirstLogMessage(stdout);
        if (logcatMessage == null) {
            return Unit.INSTANCE;
        }
        messages.add(logcatMessage);
        while (true) {
            LogcatMessage logcatMessage2 = this.getLogcatMessage(stdout);
            if (logcatMessage2 == null) break;
            messages.add(logcatMessage2);
        }
        this.leftoverBytes = LogcatProtoShellCollectorKt.access$getBytes(stdout, stdout.remaining());
        Object object = collector.emit((Object)messages, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object collectStderr(@NotNull FlowCollector<? super List<LogcatMessage>> collector, @NotNull ByteBuffer stderr, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Nullable
    public Object end(@NotNull FlowCollector<? super List<LogcatMessage>> collector, int exitCode2, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    private final LogcatMessage getFirstLogMessage(ByteBuffer buffer) {
        int needed;
        int n;
        int remaining = buffer.remaining();
        if (this.leftoverBytes.length == 0) {
            if (remaining < 8) {
                this.leftoverBytes = LogcatProtoShellCollectorKt.access$getBytes(buffer, remaining);
                return null;
            }
            int size = LogcatProtoShellCollectorKt.access$getSize(buffer);
            buffer.position(0);
            n = size;
        } else if (this.leftoverBytes.length >= 8) {
            n = this.getSize(this.leftoverBytes);
        } else {
            needed = 8 - this.leftoverBytes.length;
            if (remaining < needed) {
                this.leftoverBytes = ArraysKt.plus((byte[])this.leftoverBytes, (byte[])LogcatProtoShellCollectorKt.access$getBytes(buffer, remaining));
                return null;
            }
            byte[] bytes = ArraysKt.plus((byte[])this.leftoverBytes, (byte[])LogcatProtoShellCollectorKt.access$getBytes(buffer, needed));
            buffer.position(0);
            n = this.getSize(bytes);
        }
        int size = n;
        needed = 8 + size - this.leftoverBytes.length;
        if (remaining < needed) {
            this.leftoverBytes = ArraysKt.plus((byte[])this.leftoverBytes, (byte[])LogcatProtoShellCollectorKt.access$getBytes(buffer, remaining));
            return null;
        }
        ByteBuffer messageBuffer = this.leftoverBytes.length == 0 ? buffer : ByteBuffer.wrap(ArraysKt.plus((byte[])this.leftoverBytes, (byte[])LogcatProtoShellCollectorKt.access$getBytes(buffer, needed))).order(ByteOrder.LITTLE_ENDIAN);
        Intrinsics.checkNotNull((Object)messageBuffer);
        return this.getLogcatMessage(messageBuffer);
    }

    private final LogcatMessage getLogcatMessage(ByteBuffer buffer) {
        if (buffer.remaining() < 8) {
            return null;
        }
        int start2 = buffer.position();
        int size = LogcatProtoShellCollectorKt.access$getSize(buffer);
        if (buffer.remaining() < size) {
            buffer.position(start2);
            return null;
        }
        int position = buffer.position();
        LogcatEntryProto entry = LogcatEntryProto.parseFrom((ByteBuffer)buffer.slice(position, size));
        buffer.position(position + size);
        Intrinsics.checkNotNull((Object)entry);
        return this.toLogcatMessage(entry);
    }

    private final int getSize(byte[] $this$getSize) {
        return (int)ByteBuffer.wrap($this$getSize).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    private final LogcatMessage toLogcatMessage(LogcatEntryProto $this$toLogcatMessage) {
        Object object;
        String processName;
        String string;
        ProcessNames processNames = this.processNameMonitor.getProcessNames(this.serialNumber, (int)$this$toLogcatMessage.getPid());
        String it = string = $this$toLogcatMessage.getProcessName();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        Object object2 = ((CharSequence)it).length() > 0 ? string : null;
        if (object2 == null) {
            ProcessNames processNames2 = processNames;
            object2 = processNames2 != null ? processNames2.getProcessName() : null;
            if (object2 == null) {
                object2 = processName = "pid-" + $this$toLogcatMessage.getPid();
            }
        }
        if ((object = processNames) == null || (object = object.getApplicationId()) == null) {
            object = processName;
        }
        Object applicationId2 = object;
        LogcatPriorityProto logcatPriorityProto = $this$toLogcatMessage.getPriority();
        Intrinsics.checkNotNullExpressionValue((Object)logcatPriorityProto, (String)"getPriority(...)");
        LogLevel logLevel = LogcatProtoShellCollectorKt.access$toLogLevel(logcatPriorityProto);
        int n = (int)$this$toLogcatMessage.getPid();
        int n2 = (int)$this$toLogcatMessage.getTid();
        ByteString byteString = $this$toLogcatMessage.getTag();
        Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"getTag(...)");
        String string2 = LogcatProtoShellCollectorKt.access$toTag(byteString);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"access$toTag(...)");
        Instant instant = Instant.ofEpochSecond($this$toLogcatMessage.getTimeSec(), $this$toLogcatMessage.getTimeNsec());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
        LogcatHeader logcatHeader = new LogcatHeader(logLevel, n, n2, (String)applicationId2, processName, string2, instant);
        ByteString byteString2 = $this$toLogcatMessage.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)byteString2, (String)"getMessage(...)");
        return new LogcatMessage(logcatHeader, LogcatProtoShellCollectorKt.access$toMessage(byteString2));
    }
}

