/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.messages;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.ConstantsKt;
import com.android.tools.idea.logcat.message.LogcatHeader;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.messages.AutoProguardMessageRewriter;
import com.android.tools.idea.logcat.messages.ExceptionMessageRewriter;
import com.android.tools.idea.logcat.messages.FormattingOptions;
import com.android.tools.idea.logcat.messages.LogcatColors;
import com.android.tools.idea.logcat.messages.MessageFormatterKt;
import com.android.tools.idea.logcat.messages.ProguardMessageRewriter;
import com.android.tools.idea.logcat.messages.TextAccumulator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u000bJ$\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J\u0006\u0010#\u001a\u00020\u0016J&\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\"2\u0014\u0010&\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00160'H\u0002J&\u0010(\u001a\u00020\r2\u0006\u0010%\u001a\u00020\"2\u0014\u0010&\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00160'H\u0002J\"\u0010)\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/logcat/messages/MessageFormatter;", "", "project", "Lcom/intellij/openapi/project/Project;", "logcatColors", "Lcom/android/tools/idea/logcat/messages/LogcatColors;", "zoneId", "Ljava/time/ZoneId;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/logcat/messages/LogcatColors;Ljava/time/ZoneId;)V", "softWrapEnabled", "", "previousTag", "", "previousPid", "", "Ljava/lang/Integer;", "proguardMessageRewriter", "Lcom/android/tools/idea/logcat/messages/ProguardMessageRewriter;", "autoProguardMessageRewriter", "Lcom/android/tools/idea/logcat/messages/AutoProguardMessageRewriter;", "setProguardMapping", "", "path", "Ljava/nio/file/Path;", "setSoftWrapEnabled", "value", "formatMessages", "formattingOptions", "Lcom/android/tools/idea/logcat/messages/FormattingOptions;", "textAccumulator", "Lcom/android/tools/idea/logcat/messages/TextAccumulator;", "messages", "", "Lcom/android/tools/idea/logcat/message/LogcatMessage;", "reset", "rewriteException", "message", "onDeobfuscated", "Lkotlin/Function1;", "deobfuscateException", "appendRetraceInfo", "mapping", "newline", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nMessageFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageFormatter.kt\ncom/android/tools/idea/logcat/messages/MessageFormatter\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n31#2,2:156\n1863#3,2:158\n*S KotlinDebug\n*F\n+ 1 MessageFormatter.kt\ncom/android/tools/idea/logcat/messages/MessageFormatter\n*L\n45#1:156,2\n121#1:158,2\n*E\n"})
public final class MessageFormatter {
    @NotNull
    private final LogcatColors logcatColors;
    @NotNull
    private final ZoneId zoneId;
    private boolean softWrapEnabled;
    @Nullable
    private String previousTag;
    @Nullable
    private Integer previousPid;
    @NotNull
    private final ProguardMessageRewriter proguardMessageRewriter;
    @NotNull
    private final AutoProguardMessageRewriter autoProguardMessageRewriter;

    public MessageFormatter(@NotNull Project project, @NotNull LogcatColors logcatColors, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)logcatColors, (String)"logcatColors");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.logcatColors = logcatColors;
        this.zoneId = zoneId;
        this.proguardMessageRewriter = new ProguardMessageRewriter();
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<AutoProguardMessageRewriter> serviceClass$iv = AutoProguardMessageRewriter.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.autoProguardMessageRewriter = (AutoProguardMessageRewriter)object;
    }

    public final void setProguardMapping(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.proguardMessageRewriter.loadProguardMap(path);
    }

    public final void setSoftWrapEnabled(boolean value2) {
        this.softWrapEnabled = value2;
    }

    public final void formatMessages(@NotNull FormattingOptions formattingOptions, @NotNull TextAccumulator textAccumulator, @NotNull List<LogcatMessage> messages) {
        Intrinsics.checkNotNullParameter((Object)formattingOptions, (String)"formattingOptions");
        Intrinsics.checkNotNullParameter((Object)textAccumulator, (String)"textAccumulator");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        int headerWidth = formattingOptions.getHeaderWidth();
        String newline = this.softWrapEnabled ? "\n" : StringsKt.padEnd$default((String)"\n", (int)(headerWidth + 1), (char)'\u0000', (int)2, null);
        for (LogcatMessage message : messages) {
            int start2 = textAccumulator.getTextLength();
            LogcatHeader header = message.getHeader();
            if (message.getHeader() == ConstantsKt.SYSTEM_HEADER) {
                TextAccumulator.accumulate$default(textAccumulator, message.getMessage(), null, null, 6, null);
            } else {
                String string;
                boolean isException;
                String tag = header.getTag();
                String appName = header.getAppName();
                TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getTimestampFormat().format(header.getTimestamp(), this.zoneId), null, null, 6, null);
                TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getProcessThreadFormat().format(header.getPid(), header.getTid()), null, null, 6, null);
                TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getTagFormat().format(tag, this.previousTag), formattingOptions.getTagFormat().getColorize() ? this.logcatColors.getTagColor$intellij_android_logcat(tag) : null, null, 4, null);
                TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getAppNameFormat().format(appName, header.getPid(), this.previousPid), null, null, 6, null);
                TextAccumulator.accumulate$default(textAccumulator, formattingOptions.getProcessNameFormat().format(header.getProcessName(), header.getPid(), this.previousPid), null, null, 6, null);
                formattingOptions.getLevelFormat().format(header.getLogLevel(), textAccumulator, this.logcatColors);
                boolean bl = isException = MessageFormatterKt.access$getExceptionLinePattern$p().containsMatchIn((CharSequence)message.getMessage());
                if (bl) {
                    string = this.rewriteException(message, (Function1<? super Path, Unit>)((Function1)arg_0 -> MessageFormatter.formatMessages$lambda$0(this, textAccumulator, newline, arg_0)));
                } else if (!bl) {
                    string = message.getMessage();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String msg = string;
                TextAccumulator.accumulate$default(textAccumulator, StringsKt.replace$default((String)msg, (String)"\n", (String)newline, (boolean)false, (int)4, null), null, this.logcatColors.getMessageKey$intellij_android_logcat(header.getLogLevel()), 2, null);
                this.previousTag = tag;
                this.previousPid = header.getPid();
            }
            TextAccumulator.accumulate$default(textAccumulator, "\n", null, null, 6, null);
            int end = textAccumulator.getTextLength();
            textAccumulator.addMessageRange(start2, end - 1, message);
        }
    }

    public final void reset() {
        this.previousTag = null;
        this.previousPid = null;
    }

    private final String rewriteException(LogcatMessage message, Function1<? super Path, Unit> onDeobfuscated) {
        String result2 = null;
        result2 = this.deobfuscateException(message, onDeobfuscated);
        Iterable $this$forEach$iv = ExceptionMessageRewriter.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExceptionMessageRewriter it = (ExceptionMessageRewriter)element$iv;
            boolean bl = false;
            result2 = it.rewrite(result2);
        }
        return result2;
    }

    private final String deobfuscateException(LogcatMessage message, Function1<? super Path, Unit> onDeobfuscated) {
        if (((Boolean)StudioFlags.LOGCAT_DEOBFUSCATE.get()).booleanValue()) {
            String msg;
            if (((Boolean)StudioFlags.LOGCAT_AUTO_DEOBFUSCATE.get()).booleanValue() && !Intrinsics.areEqual((Object)(msg = this.autoProguardMessageRewriter.rewrite(message.getMessage(), message.getHeader().getApplicationId())), (Object)message.getMessage())) {
                onDeobfuscated.invoke((Object)this.autoProguardMessageRewriter.getMapping());
                return msg;
            }
            msg = this.proguardMessageRewriter.rewrite(message);
            if (!Intrinsics.areEqual((Object)msg, (Object)message.getMessage())) {
                onDeobfuscated.invoke((Object)this.proguardMessageRewriter.getMapping());
                return msg;
            }
        }
        return message.getMessage();
    }

    private final void appendRetraceInfo(Path mapping, TextAccumulator textAccumulator, String newline) {
        if (mapping != null) {
            TextAccumulator.accumulate$default(textAccumulator, "Stack has been retraced with " + mapping + newline, MessageFormatterKt.access$getDEOBFUSCATED_ANNOTATION_ATTRIBUTES$p(), null, 4, null);
        }
    }

    private static final Unit formatMessages$lambda$0(MessageFormatter this$0, TextAccumulator $textAccumulator, String $newline, Path it) {
        this$0.appendRetraceInfo(it, $textAccumulator, $newline);
        return Unit.INSTANCE;
    }
}

