/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.messages;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.messages.AutoProguardMessageRewriterKt;
import com.android.tools.idea.logcat.messages.RetraceUtilsKt;
import com.android.tools.idea.logcat.util.LogcatUsageTracker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.r8.retrace.RetraceCommand;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013J \u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\u0004\u0018\u00010\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/logcat/messages/AutoProguardMessageRewriter;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lock", "", "alarm", "Lcom/intellij/util/Alarm;", "autoRetracer", "Lcom/android/tools/idea/logcat/messages/AutoProguardMessageRewriter$AutoRetracer;", "getAutoRetracer", "()Lcom/android/tools/idea/logcat/messages/AutoProguardMessageRewriter$AutoRetracer;", "setAutoRetracer", "(Lcom/android/tools/idea/logcat/messages/AutoProguardMessageRewriter$AutoRetracer;)V", "getMapping", "Ljava/nio/file/Path;", "rewrite", "", "message", "applicationId", "id", "modules", "", "Lcom/intellij/openapi/module/Module;", "rescheduleCachePurge", "", "findMapping", "mapId", "dispose", "AutoRetracer", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nAutoProguardMessageRewriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoProguardMessageRewriter.kt\ncom/android/tools/idea/logcat/messages/AutoProguardMessageRewriter\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n95#2:185\n135#2,3:186\n1611#3,9:189\n1863#3:198\n1864#3:200\n1620#3:201\n1#4:199\n1#4:202\n*S KotlinDebug\n*F\n+ 1 AutoProguardMessageRewriter.kt\ncom/android/tools/idea/logcat/messages/AutoProguardMessageRewriter\n*L\n83#1:185\n83#1:186,3\n127#1:189,9\n127#1:198\n127#1:200\n127#1:201\n127#1:199\n*E\n"})
public final class AutoProguardMessageRewriter
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Object lock;
    @NotNull
    private final Alarm alarm;
    @VisibleForTesting
    @Nullable
    private AutoRetracer autoRetracer;

    public AutoProguardMessageRewriter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lock = new Object();
        this.alarm = new Alarm((Disposable)this);
    }

    @Nullable
    public final AutoRetracer getAutoRetracer() {
        return this.autoRetracer;
    }

    public final void setAutoRetracer(@Nullable AutoRetracer autoRetracer) {
        this.autoRetracer = autoRetracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Path getMapping() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            AutoRetracer autoRetracer = this.autoRetracer;
            Path path = autoRetracer != null ? autoRetracer.getMapping() : null;
            return path;
        }
    }

    @NotNull
    public final String rewrite(@NotNull String message, @NotNull String applicationId2) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)applicationId2, (String)"applicationId");
        if (((Boolean)StudioFlags.LOGCAT_AUTO_DEOBFUSCATE.get()).booleanValue()) {
            try {
                MatchResult matchResult = Regex.find$default((Regex)AutoProguardMessageRewriterKt.access$getExceptionLinePattern$p(), (CharSequence)message, (int)0, (int)2, null);
                if (matchResult == null) {
                    return message;
                }
                MatchResult match = matchResult;
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"mapId");
                if (object == null || (object = object.getValue()) == null) {
                    return message;
                }
                Object id2 = object;
                Collection<Module> modules = ProjectSystemUtil.getProjectSystem(this.project).findModulesWithApplicationId(applicationId2);
                if (modules.isEmpty()) {
                    LogcatUsageTracker.INSTANCE.logRetraceAppNotFound();
                    return message;
                }
                AutoRetracer retracer = this.getAutoRetracer((String)id2, modules);
                if (retracer == null) {
                    LogcatUsageTracker.INSTANCE.logRetraceMappingNotFound();
                    return message;
                }
                boolean $i$f$measureTimedValue = false;
                TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
                boolean $i$f$measureTimedValue2 = false;
                long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
                boolean bl = false;
                String result$iv$iv = RetraceUtilsKt.rewrite(retracer.getBuilder(), message);
                TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
                String retraced = (String)timedValue.component1();
                long duration = timedValue.component2-UwyO8pc();
                String result2 = !Intrinsics.areEqual((Object)retraced, (Object)message) ? "SUCCESS" : "NOOP";
                LogcatUsageTracker.INSTANCE.logRetrace-dWUq8MI(result2, duration, retracer.getMappingSize(), retracer.isCached());
                return retraced;
            }
            catch (Throwable e) {
                LogcatUsageTracker.INSTANCE.logRetraceException(e);
                throw e;
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AutoRetracer getAutoRetracer(String id2, Collection<? extends Module> modules) {
        Object object = this.lock;
        synchronized (object) {
            Path path;
            block6: {
                block5: {
                    AutoRetracer retracer;
                    boolean bl = false;
                    AutoRetracer autoRetracer = retracer = this.autoRetracer;
                    if (!Intrinsics.areEqual((Object)(autoRetracer != null ? autoRetracer.getId() : null), (Object)id2)) break block5;
                    this.rescheduleCachePurge();
                    AutoRetracer autoRetracer2 = AutoRetracer.copy$default(retracer, null, null, null, true, 0L, 23, null);
                    return autoRetracer2;
                }
                if (this.findMapping(modules, id2) != null) break block6;
                AutoRetracer autoRetracer = null;
                return autoRetracer;
            }
            Path mapping = path;
            RetraceCommand.Builder builder = RetraceUtilsKt.createRetracer(mapping);
            this.autoRetracer = new AutoRetracer(id2, builder, mapping, false, 0L, 16, null);
            this.rescheduleCachePurge();
            AutoRetracer autoRetracer = this.autoRetracer;
            return autoRetracer;
        }
    }

    private final void rescheduleCachePurge() {
        this.alarm.cancelAllRequests();
        Runnable runnable2 = () -> AutoProguardMessageRewriter.rescheduleCachePurge$lambda$4(this);
        Object t = StudioFlags.LOGCAT_AUTO_DEOBFUSCATE_CACHE_TIME_MS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        this.alarm.addRequest(runnable2, ((Number)t).longValue());
    }

    /*
     * WARNING - void declaration
     */
    private final Path findMapping(Collection<? extends Module> modules, String mapId) {
        Iterable iterable;
        block2: {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = modules;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Path it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Module it = (Module)element$iv$iv;
                boolean bl2 = false;
                VirtualFile virtualFile = ProjectUtil.guessModuleDir((Module)ProjectSystemUtil.getModuleSystem(it).getHolderModule());
                if ((virtualFile != null ? virtualFile.toNioPath() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List moduleDirs = (List)destination$iv$iv;
            for (Path it : (Iterable)moduleDirs) {
                boolean bl = false;
                Path mappingDir = it.resolve("build/outputs/mapping");
                Intrinsics.checkNotNull((Object)mappingDir);
                iterable2 = AutoProguardMessageRewriterKt.access$findMapping(mappingDir, mapId);
                if (iterable2 == null) continue;
                iterable = iterable2;
                break block2;
            }
            iterable = null;
        }
        return iterable;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void rescheduleCachePurge$lambda$4(AutoProguardMessageRewriter this$0) {
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            this$0.autoRetracer = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/logcat/messages/AutoProguardMessageRewriter$AutoRetracer;", "", "id", "", "builder", "Lcom/android/tools/r8/retrace/RetraceCommand$Builder;", "mapping", "Ljava/nio/file/Path;", "isCached", "", "mappingSize", "", "<init>", "(Ljava/lang/String;Lcom/android/tools/r8/retrace/RetraceCommand$Builder;Ljava/nio/file/Path;ZJ)V", "getId", "()Ljava/lang/String;", "getBuilder", "()Lcom/android/tools/r8/retrace/RetraceCommand$Builder;", "getMapping", "()Ljava/nio/file/Path;", "()Z", "getMappingSize", "()J", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.android.logcat"})
    @VisibleForTesting
    public static final class AutoRetracer {
        @NotNull
        private final String id;
        @NotNull
        private final RetraceCommand.Builder builder;
        @NotNull
        private final Path mapping;
        private final boolean isCached;
        private final long mappingSize;

        public AutoRetracer(@NotNull String id2, @NotNull RetraceCommand.Builder builder, @NotNull Path mapping, boolean isCached, long mappingSize) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            this.id = id2;
            this.builder = builder;
            this.mapping = mapping;
            this.isCached = isCached;
            this.mappingSize = mappingSize;
        }

        public /* synthetic */ AutoRetracer(String string, RetraceCommand.Builder builder, Path path, boolean bl, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                l = Files.size(path);
            }
            this(string, builder, path, bl, l);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final RetraceCommand.Builder getBuilder() {
            return this.builder;
        }

        @NotNull
        public final Path getMapping() {
            return this.mapping;
        }

        public final boolean isCached() {
            return this.isCached;
        }

        public final long getMappingSize() {
            return this.mappingSize;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final RetraceCommand.Builder component2() {
            return this.builder;
        }

        @NotNull
        public final Path component3() {
            return this.mapping;
        }

        public final boolean component4() {
            return this.isCached;
        }

        public final long component5() {
            return this.mappingSize;
        }

        @NotNull
        public final AutoRetracer copy(@NotNull String id2, @NotNull RetraceCommand.Builder builder, @NotNull Path mapping, boolean isCached, long mappingSize) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            return new AutoRetracer(id2, builder, mapping, isCached, mappingSize);
        }

        public static /* synthetic */ AutoRetracer copy$default(AutoRetracer autoRetracer, String string, RetraceCommand.Builder builder, Path path, boolean bl, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = autoRetracer.id;
            }
            if ((n & 2) != 0) {
                builder = autoRetracer.builder;
            }
            if ((n & 4) != 0) {
                path = autoRetracer.mapping;
            }
            if ((n & 8) != 0) {
                bl = autoRetracer.isCached;
            }
            if ((n & 0x10) != 0) {
                l = autoRetracer.mappingSize;
            }
            return autoRetracer.copy(string, builder, path, bl, l);
        }

        @NotNull
        public String toString() {
            return "AutoRetracer(id=" + this.id + ", builder=" + this.builder + ", mapping=" + this.mapping + ", isCached=" + this.isCached + ", mappingSize=" + this.mappingSize + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.builder.hashCode();
            result2 = result2 * 31 + ((Object)this.mapping).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isCached);
            result2 = result2 * 31 + Long.hashCode(this.mappingSize);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AutoRetracer)) {
                return false;
            }
            AutoRetracer autoRetracer = (AutoRetracer)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)autoRetracer.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.builder, (Object)autoRetracer.builder)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mapping, (Object)autoRetracer.mapping)) {
                return false;
            }
            if (this.isCached != autoRetracer.isCached) {
                return false;
            }
            return this.mappingSize == autoRetracer.mappingSize;
        }
    }
}

