/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.filters.AgeFilter;
import com.android.tools.idea.logcat.filters.CrashFilter;
import com.android.tools.idea.logcat.filters.ExactLevelFilter;
import com.android.tools.idea.logcat.filters.ExactStringFilter;
import com.android.tools.idea.logcat.filters.FilterType;
import com.android.tools.idea.logcat.filters.LevelFilter;
import com.android.tools.idea.logcat.filters.LogcatFilter;
import com.android.tools.idea.logcat.filters.LogcatFilterField;
import com.android.tools.idea.logcat.filters.LogcatFilterParseException;
import com.android.tools.idea.logcat.filters.NameFilter;
import com.android.tools.idea.logcat.filters.NegatedExactStringFilter;
import com.android.tools.idea.logcat.filters.NegatedRegexFilter;
import com.android.tools.idea.logcat.filters.NegatedStringFilter;
import com.android.tools.idea.logcat.filters.ProjectAppFilter;
import com.android.tools.idea.logcat.filters.RegexFilter;
import com.android.tools.idea.logcat.filters.StackTraceFilter;
import com.android.tools.idea.logcat.filters.StringFilter;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterAndExpression;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterExpression;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterLiteralExpression;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterOrExpression;
import com.android.tools.idea.logcat.filters.parser.PsiExtensionsKt;
import com.android.tools.idea.logcat.message.LogLevel;
import com.android.tools.idea.logcat.util.AndroidProjectDetector;
import com.android.tools.idea.projectsystem.ProjectApplicationIdsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.impl.source.tree.PsiErrorElementImpl;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.time.Clock;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a,\u0010\u0006\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001c\u0010\u0010\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002\u001a\f\u0010\u0017\u001a\u00020\t*\u00020\u0002H\u0000\u001a\f\u0010\u0018\u001a\u00020\t*\u00020\u0002H\u0000\u001a\f\u0010\u0019\u001a\u00020\t*\u00020\u0002H\u0000\u001a\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u001a\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u001a\u0014\u0010\u001f\u001a\u00020 *\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0002\"&\u0010\u0000\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010&\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"IS_FILTERS", "", "", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/TextRange;", "Lcom/android/tools/idea/logcat/filters/LogcatFilter;", "toKeyFilter", "Lcom/android/tools/idea/logcat/filters/parser/LogcatFilterLiteralExpression;", "matchCase", "", "clock", "Ljava/time/Clock;", "projectApplicationIdsProvider", "Lcom/android/tools/idea/projectsystem/ProjectApplicationIdsProvider;", "androidProjectDetector", "Lcom/android/tools/idea/logcat/util/AndroidProjectDetector;", "createAgeFilter", "text", "createIsFilter", "createNameFilter", "asLogLevel", "Lcom/android/tools/idea/logcat/message/LogLevel;", "Lcom/intellij/psi/PsiElement;", "isValidLogLevel", "isValidIsFilter", "isValidLogAge", "flattenOrExpression", "", "Lcom/android/tools/idea/logcat/filters/parser/LogcatFilterExpression;", "expression", "flattenAndExpression", "getFieldForImplicitOr", "Lcom/android/tools/idea/logcat/filters/FilterType;", "index", "", "durationRegex", "Lkotlin/text/Regex;", "firebaseTags", "firebaseRegex", "intellij.android.logcat"})
@SourceDebugExtension(value={"SMAP\nLogcatFilterParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogcatFilterParser.kt\ncom/android/tools/idea/logcat/filters/LogcatFilterParserKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,521:1\n1187#2,2:522\n1261#2,4:524\n*S KotlinDebug\n*F\n+ 1 LogcatFilterParser.kt\ncom/android/tools/idea/logcat/filters/LogcatFilterParserKt\n*L\n66#1:522,2\n66#1:524,4\n*E\n"})
public final class LogcatFilterParserKt {
    @NotNull
    private static final Map<String, Function1<TextRange, LogcatFilter>> IS_FILTERS;
    @NotNull
    private static final Regex durationRegex;
    @NotNull
    private static final List<String> firebaseTags;
    @NotNull
    private static final String firebaseRegex;

    private static final LogcatFilter toKeyFilter(LogcatFilterLiteralExpression $this$toKeyFilter, boolean matchCase, Clock clock, ProjectApplicationIdsProvider projectApplicationIdsProvider, AndroidProjectDetector androidProjectDetector) {
        TextRange textRange = new TextRange(PsiTreeUtilKt.getStartOffset((PsiElement)$this$toKeyFilter), PsiTreeUtilKt.getEndOffset((PsiElement)$this$toKeyFilter));
        String string = $this$toKeyFilter.getFirstChild().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char[] cArray = new char[]{':', '-', '~', '='};
        return switch (StringsKt.trim((String)string, (char[])cArray)) {
            case "level" -> {
                PsiElement v1 = $this$toKeyFilter.getLastChild();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getLastChild(...)");
                yield new LevelFilter(LogcatFilterParserKt.asLogLevel(v1), textRange);
            }
            case "age" -> {
                String v3 = $this$toKeyFilter.getLastChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getText(...)");
                yield LogcatFilterParserKt.createAgeFilter($this$toKeyFilter, v3, clock);
            }
            case "is" -> {
                String v4 = $this$toKeyFilter.getLastChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getText(...)");
                yield LogcatFilterParserKt.createIsFilter($this$toKeyFilter, v4);
            }
            case "name" -> {
                PsiElement v5 = $this$toKeyFilter.getLastChild();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getLastChild(...)");
                yield LogcatFilterParserKt.createNameFilter($this$toKeyFilter, PsiExtensionsKt.toText(v5));
            }
            default -> {
                String key;
                PsiElement v6 = $this$toKeyFilter.getLastChild();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getLastChild(...)");
                String value = PsiExtensionsKt.toText(v6);
                String v7 = $this$toKeyFilter.getFirstChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getText(...)");
                boolean isNegated = StringsKt.startsWith$default((CharSequence)v7, (char)'-', (boolean)false, (int)2, null);
                String v8 = $this$toKeyFilter.getFirstChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getText(...)");
                boolean isRegex = StringsKt.endsWith$default((String)v8, (String)"~:", (boolean)false, (int)2, null);
                String v9 = $this$toKeyFilter.getFirstChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getText(...)");
                boolean isExact = StringsKt.endsWith$default((String)v9, (String)"=:", (boolean)false, (int)2, null);
                LogcatFilterField v10 = switch (key) {
                    case "tag" -> LogcatFilterField.TAG;
                    case "package" -> LogcatFilterField.APP;
                    case "process" -> LogcatFilterField.PROCESS;
                    case "message" -> LogcatFilterField.MESSAGE;
                    case "line" -> LogcatFilterField.LINE;
                    default -> throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid key: " + key));
                };
                LogcatFilterField field = v10;
                yield isNegated && isRegex ? (LogcatFilter)new NegatedRegexFilter(value, field, matchCase, textRange) : (isNegated && isExact ? (LogcatFilter)new NegatedExactStringFilter(value, field, matchCase, textRange) : (isNegated ? (LogcatFilter)new NegatedStringFilter(value, field, matchCase, textRange) : (isRegex ? (LogcatFilter)new RegexFilter(value, field, matchCase, textRange) : (isExact ? (LogcatFilter)new ExactStringFilter(value, field, matchCase, textRange) : (Intrinsics.areEqual((Object)key, (Object)"package") && Intrinsics.areEqual((Object)value, (Object)"mine") && LogcatFilterParserKt.toKeyFilter$isAndroidProject(androidProjectDetector, $this$toKeyFilter) ? (LogcatFilter)new ProjectAppFilter(projectApplicationIdsProvider, textRange) : (LogcatFilter)new StringFilter(value, field, matchCase, textRange))))));
            }
        };
    }

    private static final LogcatFilter createAgeFilter(LogcatFilterLiteralExpression $this$createAgeFilter, String text2, Clock clock) {
        LogcatFilter logcatFilter;
        try {
            logcatFilter = new AgeFilter(text2, clock, new TextRange(PsiTreeUtilKt.getStartOffset((PsiElement)$this$createAgeFilter), PsiTreeUtilKt.getEndOffset((PsiElement)$this$createAgeFilter)));
        }
        catch (IllegalArgumentException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Parse error";
            }
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl(string));
        }
        return logcatFilter;
    }

    private static final LogcatFilter createIsFilter(LogcatFilterLiteralExpression $this$createIsFilter, String text2) {
        if (!((Boolean)StudioFlags.LOGCAT_IS_FILTER.get()).booleanValue()) {
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid key: is"));
        }
        Function1<TextRange, LogcatFilter> function1 = IS_FILTERS.get(text2);
        if (function1 == null) {
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid filter: is:" + text2));
        }
        Function1<TextRange, LogcatFilter> createFilter = function1;
        return (LogcatFilter)createFilter.invoke((Object)new TextRange(PsiTreeUtilKt.getStartOffset((PsiElement)$this$createIsFilter), PsiTreeUtilKt.getEndOffset((PsiElement)$this$createIsFilter)));
    }

    private static final LogcatFilter createNameFilter(LogcatFilterLiteralExpression $this$createNameFilter, String text2) {
        return new NameFilter(text2, new TextRange(PsiTreeUtilKt.getStartOffset((PsiElement)$this$createNameFilter), PsiTreeUtilKt.getEndOffset((PsiElement)$this$createNameFilter)));
    }

    private static final LogLevel asLogLevel(PsiElement $this$asLogLevel) {
        String string = $this$asLogLevel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        LogLevel logLevel = LogLevel.Companion.getByString(string2);
        if (logLevel == null) {
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid Log Level: " + $this$asLogLevel.getText()));
        }
        return logLevel;
    }

    public static final boolean isValidLogLevel(@NotNull String $this$isValidLogLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidLogLevel, (String)"<this>");
        String string = $this$isValidLogLevel.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return LogLevel.Companion.getByString(string) != null;
    }

    public static final boolean isValidIsFilter(@NotNull String $this$isValidIsFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidIsFilter, (String)"<this>");
        return IS_FILTERS.containsKey($this$isValidIsFilter);
    }

    public static final boolean isValidLogAge(@NotNull String $this$isValidLogAge) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidLogAge, (String)"<this>");
        if (durationRegex.matchEntire((CharSequence)$this$isValidLogAge) == null) {
            return false;
        }
        try {
            String string = $this$isValidLogAge.substring(0, $this$isValidLogAge.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static final List<LogcatFilterExpression> flattenOrExpression(LogcatFilterExpression expression) {
        List list;
        if (expression instanceof LogcatFilterOrExpression) {
            LogcatFilterExpression logcatFilterExpression = ((LogcatFilterOrExpression)expression).getExpressionList().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)logcatFilterExpression, (String)"get(...)");
            Collection collection2 = LogcatFilterParserKt.flattenOrExpression(logcatFilterExpression);
            LogcatFilterExpression logcatFilterExpression2 = ((LogcatFilterOrExpression)expression).getExpressionList().get(1);
            Intrinsics.checkNotNullExpressionValue((Object)logcatFilterExpression2, (String)"get(...)");
            list = CollectionsKt.plus((Collection)collection2, (Iterable)LogcatFilterParserKt.flattenOrExpression(logcatFilterExpression2));
        } else {
            list = CollectionsKt.listOf((Object)expression);
        }
        return list;
    }

    private static final List<LogcatFilterExpression> flattenAndExpression(LogcatFilterExpression expression) {
        List list;
        if (expression instanceof LogcatFilterAndExpression) {
            LogcatFilterExpression logcatFilterExpression = ((LogcatFilterAndExpression)expression).getExpressionList().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)logcatFilterExpression, (String)"get(...)");
            Collection collection2 = LogcatFilterParserKt.flattenAndExpression(logcatFilterExpression);
            LogcatFilterExpression logcatFilterExpression2 = ((LogcatFilterAndExpression)expression).getExpressionList().get(1);
            Intrinsics.checkNotNullExpressionValue((Object)logcatFilterExpression2, (String)"get(...)");
            list = CollectionsKt.plus((Collection)collection2, (Iterable)LogcatFilterParserKt.flattenAndExpression(logcatFilterExpression2));
        } else {
            list = CollectionsKt.listOf((Object)expression);
        }
        return list;
    }

    private static final FilterType getFieldForImplicitOr(LogcatFilter $this$getFieldForImplicitOr, int index) {
        return $this$getFieldForImplicitOr instanceof StringFilter && ((StringFilter)$this$getFieldForImplicitOr).getField() != LogcatFilterField.IMPLICIT_LINE ? new FilterType((Object)((StringFilter)$this$getFieldForImplicitOr).getField()) : ($this$getFieldForImplicitOr instanceof RegexFilter ? new FilterType((Object)((RegexFilter)$this$getFieldForImplicitOr).getField()) : ($this$getFieldForImplicitOr instanceof ExactStringFilter ? new FilterType((Object)((ExactStringFilter)$this$getFieldForImplicitOr).getField()) : ($this$getFieldForImplicitOr instanceof LevelFilter ? new FilterType("level") : ($this$getFieldForImplicitOr instanceof ExactLevelFilter ? new FilterType("level") : ($this$getFieldForImplicitOr instanceof AgeFilter ? new FilterType("age") : ($this$getFieldForImplicitOr instanceof CrashFilter ? new FilterType("is") : ($this$getFieldForImplicitOr instanceof StackTraceFilter ? new FilterType("is") : new FilterType(index))))))));
    }

    private static final LogcatFilter IS_FILTERS$lambda$0(TextRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new CrashFilter(it);
    }

    private static final LogcatFilter IS_FILTERS$lambda$1(TextRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RegexFilter(firebaseRegex, LogcatFilterField.TAG, true, it);
    }

    private static final LogcatFilter IS_FILTERS$lambda$2(TextRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new StackTraceFilter(it);
    }

    private static final ExactLevelFilter IS_FILTERS$lambda$4$lambda$3(LogLevel $level, TextRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ExactLevelFilter($level, it);
    }

    private static final boolean toKeyFilter$isAndroidProject(AndroidProjectDetector $androidProjectDetector, LogcatFilterLiteralExpression $this_toKeyFilter) {
        Project project = $this_toKeyFilter.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return $androidProjectDetector.isAndroidProject(project);
    }

    public static final /* synthetic */ List access$flattenAndExpression(LogcatFilterExpression expression) {
        return LogcatFilterParserKt.flattenAndExpression(expression);
    }

    public static final /* synthetic */ List access$flattenOrExpression(LogcatFilterExpression expression) {
        return LogcatFilterParserKt.flattenOrExpression(expression);
    }

    public static final /* synthetic */ LogcatFilter access$toKeyFilter(LogcatFilterLiteralExpression $receiver, boolean matchCase, Clock clock, ProjectApplicationIdsProvider projectApplicationIdsProvider, AndroidProjectDetector androidProjectDetector) {
        return LogcatFilterParserKt.toKeyFilter($receiver, matchCase, clock, projectApplicationIdsProvider, androidProjectDetector);
    }

    public static final /* synthetic */ FilterType access$getFieldForImplicitOr(LogcatFilter $receiver, int index) {
        return LogcatFilterParserKt.getFieldForImplicitOr($receiver, index);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"crash", LogcatFilterParserKt::IS_FILTERS$lambda$0), TuplesKt.to((Object)"firebase", LogcatFilterParserKt::IS_FILTERS$lambda$1), TuplesKt.to((Object)"stacktrace", LogcatFilterParserKt::IS_FILTERS$lambda$2)};
        Map map2 = MapsKt.mapOf((Pair[])objectArray);
        objectArray = (Iterable)LogLevel.getEntries();
        Map map3 = map2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var3_4 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map4 = destination$iv$iv;
            LogLevel level = (LogLevel)((Object)element$iv$iv);
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)level.getStringValue(), arg_0 -> LogcatFilterParserKt.IS_FILTERS$lambda$4$lambda$3(level, arg_0));
            map4.put(pair.getFirst(), pair.getSecond());
        }
        IS_FILTERS = MapsKt.plus((Map)map3, (Map)destination$iv$iv);
        durationRegex = new Regex("\\d+[smhd]");
        objectArray = new String[]{"AppInstallOperation", "AppInviteActivity", "AppInviteAgent", "AppInviteAnalytics", "AppInviteLogger", "BackgroundTask", "ClassMapper", "Connection", "DataOperation", "EventRaiser", "FA", "FirebaseAppIndex", "FirebaseDatabase", "FirebaseInstanceId", "FirebaseMessaging", "FirebaseRemoteConfig", "NetworkRequest", "Persistence", "PersistentConnection", "RepoOperation", "RunLoop", "StorageTask", "SyncTree", "Transaction", "WebSocket"};
        firebaseTags = CollectionsKt.listOf((Object[])objectArray);
        firebaseRegex = "^(" + CollectionsKt.joinToString$default((Iterable)firebaseTags, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")$";
    }
}

